////
////  This design was downloaded from http://www.opencores.org
////
////  The design was synthesized with Cadence RTL Compiler in a
////  quick synthesis run.
////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// MC68HC11E based SPI interface                               ////
////                                                             ////
//// Authors: Rudolf Usselmann, Richard Herveille                ////
////          rudi@asics.ws     richard@asics.ws                 ////
////                                                             ////
//// Download from: http://www.opencores.org/projects/simple_spi ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2002 Rudolf Usselmann, Richard Herveille ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws, richard@asics.ws     ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

// Generated by Cadence RTL Compiler (RC) v05.10-b006_1

module simple_spi(clk_i, rst_i, cyc_i, stb_i, adr_i, we_i, dat_i,
     dat_o, ack_o, inta_o, sck_o, mosi_o, miso_i);
  input clk_i, rst_i, cyc_i, stb_i, we_i, miso_i;
  input [1:0] adr_i;
  input [7:0] dat_i;
  output [7:0] dat_o;
  output ack_o, inta_o, sck_o, mosi_o;
  wire clk_i, rst_i, cyc_i, stb_i, we_i, miso_i;
  wire [1:0] adr_i;
  wire [7:0] dat_i;
  wire [7:0] dat_o;
  wire ack_o, inta_o, sck_o, mosi_o;
  wire \bcnt[1] , \bcnt[2] , \clkcnt[0] , \clkcnt[1] , \clkcnt[2] ,
       \clkcnt[3] , \clkcnt[4] , \clkcnt[5] ;
  wire \clkcnt[6] , \clkcnt[7] , \clkcnt[8] , \clkcnt[9] , \clkcnt[10]
       , \clkcnt[11] , cpha, \espr[2] ;
  wire \espr[3] , n_3, n_4, n_5, n_7, n_8, n_9, n_10;
  wire n_11, n_12, n_15, n_16, n_18, n_21, n_22, n_23;
  wire n_26, n_29, n_32, n_34, n_37, n_38, n_39, n_41;
  wire n_42, n_45, n_46, n_47, n_49, n_50, n_52, n_55;
  wire n_58, n_61, n_62, n_63, n_64, n_65, n_66, n_67;
  wire n_70, n_71, n_72, n_75, n_77, n_79, n_80, n_81;
  wire n_83, n_86, n_87, n_88, n_95, n_96, n_101, n_102;
  wire n_105, n_106, n_107, n_111, n_112, n_117, n_118, n_119;
  wire n_120, n_124, n_126, n_129, n_135, n_136, n_137, n_138;
  wire n_139, n_140, n_141, n_142, n_143, n_144, n_148, n_149;
  wire n_151, n_156, n_158, n_159, n_161, n_165, n_166, n_167;
  wire n_168, n_169, n_170, n_171, n_172, n_173, n_174, n_175;
  wire n_176, n_177, n_178, n_181, n_182, n_183, n_184, n_185;
  wire n_186, n_187, n_189, n_190, n_193, n_196, n_202, n_203;
  wire n_204, n_205, n_206, n_209, n_210, n_213, n_215, n_216;
  wire n_217, n_218, n_219, n_220, n_221, n_222, n_223, n_224;
  wire n_225, n_226, n_227, n_228, n_229, n_230, n_231, n_232;
  wire n_233, n_234, n_235, n_236, n_237, n_238, n_239, n_240;
  wire n_241, n_242, n_243, n_244, n_245, n_249, n_250, n_251;
  wire n_252, n_253, n_254, n_255, n_256, n_257, n_258, n_259;
  wire n_260, n_261, n_263, n_264, n_265, n_268, n_269, n_270;
  wire n_271, n_273, n_274, n_275, n_276, n_277, n_278, n_279;
  wire n_280, n_281, n_282, n_283, n_284, n_285, n_286, n_287;
  wire n_288, n_289, n_290, n_291, n_293, n_294, n_295, n_296;
  wire n_297, n_301, n_302, n_303, n_304, n_305, n_306, n_307;
  wire n_308, n_309, n_310, n_311, n_312, n_314, n_315, n_316;
  wire n_317, n_318, n_319, n_320, n_321, n_322, n_323, n_324;
  wire n_325, n_326, n_327, n_328, n_329, n_330, n_331, n_332;
  wire n_333, n_334, n_335, n_336, n_337, n_338, n_339, n_340;
  wire n_342, n_343, n_344, n_345, n_346, n_347, n_349, n_350;
  wire n_352, n_354, n_355, n_357, n_358, n_359, n_360, n_361;
  wire n_362, n_363, n_364, n_365, n_368, n_370, n_371, n_373;
  wire n_375, n_376, n_377, n_378, n_379, n_380, n_381, n_382;
  wire n_383, n_384, n_385, n_386, n_387, n_388, n_389, n_390;
  wire n_391, n_392, n_393, n_394, n_395, n_396, n_397, n_398;
  wire n_399, n_400, n_402, n_403, n_404, n_405, n_406, n_407;
  wire n_408, n_409, n_410, n_411, n_413, n_414, n_415, n_416;
  wire n_417, n_418, n_419, n_423, n_424, n_425, n_426, n_428;
  wire n_429, n_430, n_431, n_432, n_433, n_434, n_436, n_437;
  wire n_438, n_439, n_440, n_442, n_444, n_445, n_446, n_447;
  wire n_448, n_449, n_450, n_451, n_452, n_453, n_454, n_455;
  wire n_456, n_457, n_458, n_459, n_460, n_461, n_462, n_463;
  wire n_464, n_465, n_466, n_467, n_468, n_469, n_470, n_471;
  wire n_473, n_474, n_475, n_476, n_477, n_478, n_480, n_481;
  wire n_482, n_483, n_485, n_486, n_488, n_490, n_491, n_492;
  wire n_493, n_494, n_495, n_496, n_497, n_498, n_499, n_500;
  wire n_501, n_502, n_503, n_504, n_505, n_506, n_507, n_508;
  wire n_509, n_510, n_511, n_512, n_513, n_514, n_515, n_516;
  wire n_517, n_519, n_520, n_521, n_522, n_523, n_524, n_525;
  wire n_526, n_527, n_528, n_529, n_530, n_531, n_532, n_533;
  wire n_534, n_535, n_536, n_537, n_538, n_540, n_541, n_542;
  wire n_543, n_545, n_546, n_548, n_550, n_551, n_552, n_553;
  wire n_554, n_555, n_556, n_558, n_559, n_561, n_562, n_563;
  wire n_564, n_565, n_566, n_567, n_568, n_569, n_570, n_571;
  wire n_572, n_573, n_575, n_577, n_579, n_580, n_582, n_583;
  wire n_584, n_585, n_587, n_588, n_589, n_590, n_591, n_593;
  wire n_594, n_601, n_603, n_604, n_605, n_606, n_607, n_608;
  wire n_609, n_610, n_611, n_612, n_613, n_615, n_617, n_618;
  wire n_619, n_620, n_621, n_622, n_623, n_627, n_628, n_630;
  wire n_631, n_632, n_633, n_634, n_635, n_636, n_637, n_638;
  wire n_639, n_640, n_641, n_642, n_643, n_644, n_645, n_646;
  wire n_648, n_649, n_650, n_651, n_653, n_654, n_656, n_658;
  wire n_659, n_660, n_661, n_662, n_663, n_664, n_665, n_666;
  wire n_667, n_668, n_669, n_670, n_671, n_672, n_673, n_675;
  wire n_676, n_678, n_679, n_680, n_681, n_682, n_683, n_684;
  wire n_685, n_686, n_687, n_688, n_689, n_690, n_691, n_692;
  wire n_700, n_702, n_703, n_706, n_707, n_708, n_710, n_711;
  wire n_715, n_716, n_717, n_718, n_719, n_720, n_721, n_722;
  wire n_723, n_725, n_726, n_727, n_728, n_729, n_730, n_731;
  wire n_732, n_733, n_734, n_735, n_736, n_737, n_738, n_743;
  wire n_744, n_745, n_746, n_747, n_748, n_749, n_750, n_752;
  wire n_753, n_754, n_755, n_756, n_757, n_758, n_760, n_761;
  wire n_762, n_763, n_764, n_765, n_766, n_768, n_769, n_770;
  wire n_771, n_773, n_774, n_775, n_776, n_777, n_778, n_780;
  wire n_781, n_783, n_784, n_785, n_787, n_788, n_790, n_792;
  wire n_793, n_795, n_796, n_797, n_798, n_799, n_800, n_801;
  wire n_802, n_803, n_804, n_811, n_814, n_819, n_829, n_830;
  wire n_831, n_835, n_842, n_843, n_844, n_845, n_849, n_850;
  wire n_871, n_887, n_888, n_889, n_890, n_896, n_897, n_899;
  wire n_900, n_901, n_902, n_903, n_905, n_906, n_911, n_912;
  wire n_913, n_914, n_924, n_925, n_926, n_927, n_928, n_929;
  wire n_930, n_931, n_932, n_933, n_935, n_936, n_937, n_939;
  wire n_940, n_942, n_943, n_944, n_945, n_946, n_947, n_948;
  wire n_949, n_950, n_951, n_952, n_953, n_954, n_955, n_956;
  wire n_957, n_958, n_959, n_960, n_961, n_962, n_964, n_966;
  wire n_969, n_970, n_971, n_972, n_974, n_975, n_976, n_977;
  wire n_981, n_982, n_984, n_1000, n_1001, n_1002, rfifo_gb,
       \rfifo_mem[0] ;
  wire \rfifo_mem[0]_17 , \rfifo_mem[0]_18 , \rfifo_mem[0]_19 ,
       \rfifo_mem[0]_20 , \rfifo_mem[0]_21 , \rfifo_mem[0]_22 ,
       \rfifo_mem[0]_23 , \rfifo_mem[1] ;
  wire \rfifo_mem[1]_10 , \rfifo_mem[1]_11 , \rfifo_mem[1]_12 ,
       \rfifo_mem[1]_13 , \rfifo_mem[1]_14 , \rfifo_mem[1]_15 ,
       \rfifo_mem[1]_16 , \rfifo_mem[2] ;
  wire \rfifo_mem[2]_3 , \rfifo_mem[2]_4 , \rfifo_mem[2]_5 ,
       \rfifo_mem[2]_6 , \rfifo_mem[2]_7 , \rfifo_mem[2]_8 ,
       \rfifo_mem[2]_9 , \rfifo_mem[3] ;
  wire \rfifo_mem[3]_24 , \rfifo_mem[3]_25 , \rfifo_mem[3]_26 ,
       \rfifo_mem[3]_27 , \rfifo_mem[3]_28 , \rfifo_mem[3]_29 ,
       \rfifo_mem[3]_30 , \rfifo_rp[0] ;
  wire \rfifo_rp[1] , \rfifo_wp[0] , \rfifo_wp[1] , rfwe, spcr_3,
       spcr_4, spcr_5, sper_9;
  wire sper_10, sper_11, sper_12, sper_13, sper_14, spie, spif,
       \state[0] ;
  wire \state[1] , \tcnt[0] , \tcnt[1] , \treg[0] , \treg[1] , \treg[2]
       , \treg[3] , \treg[4] ;
  wire \treg[5] , \treg[6] , wcol, wfifo_gb, \wfifo_mem[0] ,
       \wfifo_mem[0]_17 , \wfifo_mem[0]_18 , \wfifo_mem[0]_19 ;
  wire \wfifo_mem[0]_20 , \wfifo_mem[0]_21 , \wfifo_mem[0]_22 ,
       \wfifo_mem[0]_23 , \wfifo_mem[1] , \wfifo_mem[1]_10 ,
       \wfifo_mem[1]_11 , \wfifo_mem[1]_12 ;
  wire \wfifo_mem[1]_13 , \wfifo_mem[1]_14 , \wfifo_mem[1]_15 ,
       \wfifo_mem[1]_16 , \wfifo_mem[2] , \wfifo_mem[2]_3 ,
       \wfifo_mem[2]_4 , \wfifo_mem[2]_5 ;
  wire \wfifo_mem[2]_6 , \wfifo_mem[2]_7 , \wfifo_mem[2]_8 ,
       \wfifo_mem[2]_9 , \wfifo_mem[3] , \wfifo_mem[3]_24 ,
       \wfifo_mem[3]_25 , \wfifo_mem[3]_26 ;
  wire \wfifo_mem[3]_27 , \wfifo_mem[3]_28 , \wfifo_mem[3]_29 ,
       \wfifo_mem[3]_30 , \wfifo_rp[0] , \wfifo_rp[1] , \wfifo_wp[0] ,
       \wfifo_wp[1] ;
  wire wfre;
  DFFSRX1 \tcnt_reg[1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_804), .Q (\tcnt[1] ), .QN ());
  DFFX1 rfifo_gb_reg(.CK (clk_i), .D (n_803), .Q (rfifo_gb), .QN ());
  NAND2X1 g2572(.A (n_753), .B (n_801), .Y (n_804));
  DFFSRX1 \tcnt_reg[0] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_800), .Q (\tcnt[0] ), .QN ());
  DFFX1 spif_reg(.CK (clk_i), .D (n_802), .Q (spif), .QN ());
  AOI21X1 g2589(.A0 (n_440), .A1 (n_754), .B0 (n_635), .Y (n_803));
  DFFSRX1 \rfifo_wp_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_761), .Q (\rfifo_wp[1] ), .QN ());
  DFFSRX1 \rfifo_wp_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_760), .Q (\rfifo_wp[0] ), .QN ());
  DFFX1 \rfifo_mem_reg[1][4] (.CK (clk_i), .D (n_758), .Q
       (\rfifo_mem[1]_12 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][5] (.CK (clk_i), .D (n_757), .Q
       (\rfifo_mem[1]_13 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][6] (.CK (clk_i), .D (n_799), .Q
       (\rfifo_mem[1]_14 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][7] (.CK (clk_i), .D (n_798), .Q
       (\rfifo_mem[1]_15 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][8] (.CK (clk_i), .D (n_797), .Q
       (\rfifo_mem[1]_16 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][1] (.CK (clk_i), .D (n_796), .Q
       (\rfifo_mem[2] ), .QN ());
  DFFX1 \rfifo_mem_reg[2][2] (.CK (clk_i), .D (n_795), .Q
       (\rfifo_mem[2]_3 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][3] (.CK (clk_i), .D (n_792), .Q
       (\rfifo_mem[2]_4 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][4] (.CK (clk_i), .D (n_793), .Q
       (\rfifo_mem[2]_5 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][5] (.CK (clk_i), .D (n_790), .Q
       (\rfifo_mem[2]_6 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][6] (.CK (clk_i), .D (n_788), .Q
       (\rfifo_mem[2]_7 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][7] (.CK (clk_i), .D (n_787), .Q
       (\rfifo_mem[2]_8 ), .QN ());
  DFFX1 \rfifo_mem_reg[2][8] (.CK (clk_i), .D (n_785), .Q
       (\rfifo_mem[2]_9 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][1] (.CK (clk_i), .D (n_784), .Q
       (\rfifo_mem[1] ), .QN ());
  DFFX1 \rfifo_mem_reg[1][2] (.CK (clk_i), .D (n_783), .Q
       (\rfifo_mem[1]_10 ), .QN ());
  DFFX1 \rfifo_mem_reg[1][3] (.CK (clk_i), .D (n_781), .Q
       (\rfifo_mem[1]_11 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][1] (.CK (clk_i), .D (n_780), .Q
       (\rfifo_mem[3] ), .QN ());
  DFFX1 \rfifo_mem_reg[3][2] (.CK (clk_i), .D (n_778), .Q
       (\rfifo_mem[3]_24 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][3] (.CK (clk_i), .D (n_777), .Q
       (\rfifo_mem[3]_25 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][4] (.CK (clk_i), .D (n_776), .Q
       (\rfifo_mem[3]_26 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][5] (.CK (clk_i), .D (n_775), .Q
       (\rfifo_mem[3]_27 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][6] (.CK (clk_i), .D (n_774), .Q
       (\rfifo_mem[3]_28 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][7] (.CK (clk_i), .D (n_773), .Q
       (\rfifo_mem[3]_29 ), .QN ());
  DFFX1 \rfifo_mem_reg[3][8] (.CK (clk_i), .D (n_771), .Q
       (\rfifo_mem[3]_30 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][1] (.CK (clk_i), .D (n_770), .Q
       (\rfifo_mem[0] ), .QN ());
  DFFX1 \rfifo_mem_reg[0][2] (.CK (clk_i), .D (n_769), .Q
       (\rfifo_mem[0]_17 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][4] (.CK (clk_i), .D (n_766), .Q
       (\rfifo_mem[0]_19 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][5] (.CK (clk_i), .D (n_765), .Q
       (\rfifo_mem[0]_20 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][6] (.CK (clk_i), .D (n_764), .Q
       (\rfifo_mem[0]_21 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][8] (.CK (clk_i), .D (n_762), .Q
       (\rfifo_mem[0]_23 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][3] (.CK (clk_i), .D (n_768), .Q
       (\rfifo_mem[0]_18 ), .QN ());
  DFFX1 \rfifo_mem_reg[0][7] (.CK (clk_i), .D (n_763), .Q
       (\rfifo_mem[0]_22 ), .QN ());
  NAND2X1 g2635(.A (n_499), .B (n_756), .Y (n_802));
  NAND2X1 g2593(.A (n_755), .B (n_428), .Y (n_801));
  MX2X1 g2596(.A (sper_13), .B (n_752), .S0 (n_588), .Y (n_800));
  MX2X1 g2671(.A (n_347), .B (\rfifo_mem[1]_14 ), .S0 (n_736), .Y
       (n_799));
  MX2X1 g2672(.A (n_346), .B (\rfifo_mem[1]_15 ), .S0 (n_736), .Y
       (n_798));
  MX2X1 g2673(.A (n_333), .B (\rfifo_mem[1]_16 ), .S0 (n_736), .Y
       (n_797));
  MX2X1 g2674(.A (n_336), .B (\rfifo_mem[2] ), .S0 (n_736), .Y (n_796));
  MX2X1 g2675(.A (n_342), .B (\rfifo_mem[2]_3 ), .S0 (n_736), .Y
       (n_795));
  MX2X1 g2677(.A (n_337), .B (\rfifo_mem[2]_5 ), .S0 (n_736), .Y
       (n_793));
  MX2X1 g2676(.A (n_339), .B (\rfifo_mem[2]_4 ), .S0 (n_736), .Y
       (n_792));
  MX2X1 g2678(.A (n_340), .B (\rfifo_mem[2]_6 ), .S0 (n_736), .Y
       (n_790));
  MX2X1 g2679(.A (n_329), .B (\rfifo_mem[2]_7 ), .S0 (n_736), .Y
       (n_788));
  MX2X1 g2680(.A (n_343), .B (\rfifo_mem[2]_8 ), .S0 (n_736), .Y
       (n_787));
  MX2X1 g2681(.A (n_332), .B (\rfifo_mem[2]_9 ), .S0 (n_736), .Y
       (n_785));
  MX2X1 g2682(.A (n_335), .B (\rfifo_mem[1] ), .S0 (n_736), .Y (n_784));
  MX2X1 g2683(.A (n_330), .B (\rfifo_mem[1]_10 ), .S0 (n_736), .Y
       (n_783));
  MX2X1 g2684(.A (n_328), .B (\rfifo_mem[1]_11 ), .S0 (n_736), .Y
       (n_781));
  MX2X1 g2687(.A (n_270), .B (\rfifo_mem[3] ), .S0 (n_736), .Y (n_780));
  MX2X1 g2688(.A (n_279), .B (\rfifo_mem[3]_24 ), .S0 (n_736), .Y
       (n_778));
  MX2X1 g2689(.A (n_269), .B (\rfifo_mem[3]_25 ), .S0 (n_736), .Y
       (n_777));
  MX2X1 g2690(.A (n_280), .B (\rfifo_mem[3]_26 ), .S0 (n_736), .Y
       (n_776));
  MX2X1 g2691(.A (n_275), .B (\rfifo_mem[3]_27 ), .S0 (n_736), .Y
       (n_775));
  MX2X1 g2692(.A (n_277), .B (\rfifo_mem[3]_28 ), .S0 (n_736), .Y
       (n_774));
  MX2X1 g2693(.A (n_276), .B (\rfifo_mem[3]_29 ), .S0 (n_736), .Y
       (n_773));
  MX2X1 g2694(.A (n_274), .B (\rfifo_mem[3]_30 ), .S0 (n_736), .Y
       (n_771));
  MX2X1 g2695(.A (n_227), .B (\rfifo_mem[0] ), .S0 (n_736), .Y (n_770));
  MX2X1 g2696(.A (n_226), .B (\rfifo_mem[0]_17 ), .S0 (n_736), .Y
       (n_769));
  MX2X1 g2697(.A (n_225), .B (\rfifo_mem[0]_18 ), .S0 (n_736), .Y
       (n_768));
  MX2X1 g2698(.A (n_224), .B (\rfifo_mem[0]_19 ), .S0 (n_736), .Y
       (n_766));
  MX2X1 g2699(.A (n_235), .B (\rfifo_mem[0]_20 ), .S0 (n_736), .Y
       (n_765));
  MX2X1 g2700(.A (n_234), .B (\rfifo_mem[0]_21 ), .S0 (n_736), .Y
       (n_764));
  MX2X1 g2701(.A (n_223), .B (\rfifo_mem[0]_22 ), .S0 (n_736), .Y
       (n_763));
  MX2X1 g2702(.A (n_222), .B (\rfifo_mem[0]_23 ), .S0 (n_736), .Y
       (n_762));
  AOI21X1 g2631(.A0 (n_746), .A1 (n_743), .B0 (n_970), .Y (n_761));
  AOI21X1 g2634(.A0 (n_749), .A1 (n_748), .B0 (n_970), .Y (n_760));
  MX2X1 g2669(.A (n_331), .B (\rfifo_mem[1]_12 ), .S0 (n_736), .Y
       (n_758));
  MX2X1 g2670(.A (n_344), .B (\rfifo_mem[1]_13 ), .S0 (n_736), .Y
       (n_757));
  NAND3X1 g2685(.A (n_745), .B (n_498), .C (n_181), .Y (n_756));
  NAND2X1 g2637(.A (n_738), .B (n_750), .Y (n_755));
  NAND2X1 g2662(.A (n_744), .B (n_363), .Y (n_754));
  DFFSRX1 sck_o_reg(.RN (1'b1), .SN (1'b1), .CK (clk_i), .D (n_737), .Q
       (sck_o), .QN ());
  AOI22X1 g2667(.A0 (n_139), .A1 (n_736), .B0 (sper_14), .B1 (n_138),
       .Y (n_753));
  OAI21X1 g2666(.A0 (n_182), .A1 (n_736), .B0 (n_734), .Y (n_752));
  NAND3X1 g2686(.A (n_732), .B (n_107), .C (\tcnt[0] ), .Y (n_750));
  NAND2X1 g2717(.A (n_747), .B (n_736), .Y (n_749));
  OR2X1 g2718(.A (n_747), .B (n_736), .Y (n_748));
  NAND2X1 g2719(.A (\rfifo_wp[1] ), .B (n_736), .Y (n_746));
  NOR2X1 g2725(.A (n_736), .B (n_381), .Y (n_745));
  NOR2X1 g2735(.A (n_296), .B (n_736), .Y (n_744));
  DFFSRX1 \state_reg[0] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_731), .Q (\state[0] ), .QN ());
  OR2X1 g2733(.A (n_203), .B (n_736), .Y (n_743));
  NAND2X1 g2664(.A (n_733), .B (n_181), .Y (n_738));
  DFFSRX1 \bcnt_reg[0] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_976), .Q (n_962), .QN ());
  INVX2 g2559(.A (n_735), .Y (n_737));
  DFFSRX1 \bcnt_reg[2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_727), .Q (\bcnt[2] ), .QN ());
  DFFSRX1 \clkcnt_reg[8] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_729), .Q (\clkcnt[8] ), .QN ());
  DFFX1 \treg_reg[7] (.CK (clk_i), .D (n_716), .Q (mosi_o), .QN ());
  DFFSRX1 \bcnt_reg[1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_715), .Q (\bcnt[1] ), .QN ());
  DFFX1 \treg_reg[2] (.CK (clk_i), .D (n_725), .Q (\treg[2] ), .QN ());
  DFFX1 \treg_reg[3] (.CK (clk_i), .D (n_723), .Q (\treg[3] ), .QN ());
  DFFX1 \treg_reg[4] (.CK (clk_i), .D (n_720), .Q (\treg[4] ), .QN ());
  DFFX1 \treg_reg[5] (.CK (clk_i), .D (n_718), .Q (\treg[5] ), .QN ());
  DFFX1 \treg_reg[6] (.CK (clk_i), .D (n_717), .Q (\treg[6] ), .QN ());
  DFFX1 \treg_reg[0] (.CK (clk_i), .D (n_728), .Q (\treg[0] ), .QN ());
  DFFX1 \treg_reg[1] (.CK (clk_i), .D (n_726), .Q (\treg[1] ), .QN ());
  NAND2X1 g2560(.A (n_903), .B (n_721), .Y (n_735));
  NAND2X1 g2727(.A (\tcnt[0] ), .B (rfwe), .Y (n_734));
  NOR2X1 g2728(.A (rfwe), .B (n_5), .Y (n_733));
  NOR2X1 g2730(.A (rfwe), .B (n_7), .Y (n_732));
  INVX2 g2590(.A (n_722), .Y (n_731));
  INVX8 g2760(.A (n_730), .Y (n_736));
  NAND2X2 g2553(.A (n_711), .B (n_682), .Y (n_729));
  AOI21X1 g2638(.A0 (n_961), .A1 (n_960), .B0 (n_719), .Y (n_728));
  AOI21X1 g2592(.A0 (n_681), .A1 (n_977), .B0 (n_970), .Y (n_727));
  AOI21X1 g2639(.A0 (n_959), .A1 (n_958), .B0 (n_381), .Y (n_726));
  AOI21X1 g2640(.A0 (n_949), .A1 (n_948), .B0 (n_381), .Y (n_725));
  AOI21X1 g2641(.A0 (n_951), .A1 (n_950), .B0 (n_381), .Y (n_723));
  NAND2X1 g2591(.A (n_710), .B (n_721), .Y (n_722));
  AOI21X1 g2642(.A0 (n_953), .A1 (n_952), .B0 (n_719), .Y (n_720));
  AOI21X1 g2643(.A0 (n_955), .A1 (n_954), .B0 (n_719), .Y (n_718));
  AOI21X1 g2644(.A0 (n_957), .A1 (n_956), .B0 (n_381), .Y (n_717));
  AOI21X1 g2645(.A0 (n_692), .A1 (n_605), .B0 (n_719), .Y (n_716));
  AOI21X1 g2646(.A0 (n_702), .A1 (n_977), .B0 (n_970), .Y (n_715));
  INVX1 g2762(.A (rfwe), .Y (n_730));
  DFFSRX1 \clkcnt_reg[10] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_689), .Q (\clkcnt[10] ), .QN ());
  DFFSRX1 \clkcnt_reg[7] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_686), .Q (\clkcnt[7] ), .QN ());
  DFFSRX1 \clkcnt_reg[4] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_707), .Q (\clkcnt[4] ), .QN ());
  DFFSRX1 \clkcnt_reg[3] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_700), .Q (\clkcnt[3] ), .QN ());
  DFFSRX1 \clkcnt_reg[6] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_680), .Q (\clkcnt[6] ), .QN ());
  DFFSRX1 \clkcnt_reg[9] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_683), .Q (\clkcnt[9] ), .QN ());
  DFFSRX1 \clkcnt_reg[2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_703), .Q (\clkcnt[2] ), .QN ());
  DFFSRX1 \clkcnt_reg[0] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_706), .Q (\clkcnt[0] ), .QN ());
  DFFSRX1 \clkcnt_reg[1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_691), .Q (\clkcnt[1] ), .QN ());
  DFFSRX1 \clkcnt_reg[5] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_688), .Q (\clkcnt[5] ), .QN ());
  DFFSRX1 \state_reg[1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_685), .Q (\state[1] ), .QN ());
  DFFX1 rfwe_reg(.CK (clk_i), .D (n_708), .Q (), .QN (rfwe));
  AOI21X1 g2556(.A0 (n_492), .A1 (n_663), .B0 (n_679), .Y (n_711));
  NAND4X1 g2648(.A (n_684), .B (n_503), .C (n_630), .D (n_209), .Y
       (n_710));
  AOI22X1 g2739(.A0 (n_645), .A1 (n_982), .B0 (\treg[0] ), .B1 (n_971),
       .Y (n_960));
  INVX1 g2862(.A (n_678), .Y (n_708));
  NAND2X1 g2555(.A (n_660), .B (n_687), .Y (n_707));
  NAND2X1 g2724(.A (n_656), .B (n_690), .Y (n_706));
  NAND2X1 g2737(.A (n_658), .B (n_669), .Y (n_703));
  AOI22X1 g2738(.A0 (n_649), .A1 (n_982), .B0 (n_648), .B1 (n_971), .Y
       (n_702));
  DFFSRX1 \clkcnt_reg[11] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_654), .Q (\clkcnt[11] ), .QN ());
  NAND2X1 g2594(.A (n_665), .B (n_668), .Y (n_700));
  AOI22X1 g2740(.A0 (n_644), .A1 (n_982), .B0 (\treg[1] ), .B1 (n_971),
       .Y (n_958));
  AOI22X1 g2741(.A0 (n_643), .A1 (n_982), .B0 (\treg[2] ), .B1 (n_971),
       .Y (n_948));
  DFFX1 \dat_o_reg[6] (.CK (clk_i), .D (n_662), .Q (dat_o[6]), .QN ());
  AOI22X1 g2742(.A0 (n_642), .A1 (n_982), .B0 (\treg[3] ), .B1 (n_971),
       .Y (n_950));
  AOI22X1 g2743(.A0 (n_641), .A1 (n_982), .B0 (\treg[4] ), .B1 (n_971),
       .Y (n_952));
  AOI22X1 g2744(.A0 (n_640), .A1 (n_982), .B0 (\treg[5] ), .B1 (n_971),
       .Y (n_954));
  AOI22X1 g2745(.A0 (n_639), .A1 (n_982), .B0 (\treg[6] ), .B1 (n_971),
       .Y (n_956));
  AOI22X1 g2746(.A0 (n_646), .A1 (n_982), .B0 (n_971), .B1 (mosi_o), .Y
       (n_692));
  NAND2X1 g2770(.A (n_653), .B (n_690), .Y (n_691));
  NAND2X1 g2649(.A (n_659), .B (n_672), .Y (n_689));
  NAND2X1 g2771(.A (n_651), .B (n_687), .Y (n_688));
  NAND2X1 g2557(.A (n_673), .B (n_661), .Y (n_686));
  OAI21X1 g2778(.A0 (n_684), .A1 (n_593), .B0 (n_667), .Y (n_685));
  NAND2X1 g2663(.A (n_632), .B (n_682), .Y (n_683));
  AOI22X1 g2665(.A0 (n_628), .A1 (n_982), .B0 (n_627), .B1 (n_971), .Y
       (n_681));
  NAND2X1 g2668(.A (n_664), .B (n_676), .Y (n_680));
  AOI21X1 g2851(.A0 (n_591), .A1 (n_666), .B0 (n_86), .Y (n_679));
  NAND4X1 g2863(.A (n_631), .B (n_217), .C (n_966), .D (n_982), .Y
       (n_678));
  DFFSRX1 wfifo_gb_reg(.RN (1'b1), .SN (1'b1), .CK (clk_i), .D (n_636),
       .Q (wfifo_gb), .QN ());
  DFFX1 \dat_o_reg[3] (.CK (clk_i), .D (n_633), .Q (dat_o[3]), .QN ());
  DFFX1 \dat_o_reg[2] (.CK (clk_i), .D (n_634), .Q (dat_o[2]), .QN ());
  DFFX1 \dat_o_reg[1] (.CK (clk_i), .D (n_637), .Q (dat_o[1]), .QN ());
  DFFX1 \dat_o_reg[5] (.CK (clk_i), .D (n_617), .Q (dat_o[5]), .QN ());
  NAND2X1 g2837(.A (n_236), .B (n_675), .Y (n_676));
  NAND2X1 g2838(.A (n_143), .B (n_671), .Y (n_687));
  NAND2X2 g2839(.A (n_675), .B (n_670), .Y (n_682));
  NAND2X1 g2840(.A (n_144), .B (n_671), .Y (n_690));
  NAND2X1 g2849(.A (n_671), .B (\espr[3] ), .Y (n_673));
  NAND3X1 g2860(.A (n_671), .B (n_670), .C (n_111), .Y (n_672));
  NAND2X1 g2864(.A (n_187), .B (n_675), .Y (n_669));
  NAND2X1 g2865(.A (n_238), .B (n_611), .Y (n_668));
  NAND4X1 g2871(.A (n_666), .B (n_982), .C (\state[1] ), .D (n_966), .Y
       (n_667));
  NAND2X1 g2633(.A (n_373), .B (n_663), .Y (n_665));
  NAND2X1 g2721(.A (n_474), .B (n_663), .Y (n_664));
  NAND2X1 g2722(.A (n_615), .B (n_284), .Y (n_662));
  NAND2X1 g2563(.A (n_437), .B (n_663), .Y (n_661));
  DFFX1 \dat_o_reg[0] (.CK (clk_i), .D (n_621), .Q (dat_o[0]), .QN ());
  DFFX1 wcol_reg(.CK (clk_i), .D (n_620), .Q (), .QN (wcol));
  DFFX1 \dat_o_reg[7] (.CK (clk_i), .D (n_622), .Q (dat_o[7]), .QN ());
  DFFX1 \dat_o_reg[4] (.CK (clk_i), .D (n_619), .Q (dat_o[4]), .QN ());
  MX2X1 g2564(.A (n_119), .B (n_447), .S0 (n_663), .Y (n_660));
  NAND2X1 g2660(.A (n_516), .B (n_663), .Y (n_659));
  NAND2X1 g2772(.A (n_304), .B (n_663), .Y (n_658));
  MX2X1 g2783(.A (n_77), .B (n_136), .S0 (n_663), .Y (n_656));
  AOI21X1 g2552(.A0 (n_532), .A1 (n_496), .B0 (n_671), .Y (n_654));
  NAND2X1 g2844(.A (n_221), .B (n_663), .Y (n_653));
  NAND2X1 g2846(.A (n_493), .B (n_663), .Y (n_651));
  NAND2X1 g2847(.A (n_612), .B (n_623), .Y (n_650));
  MX2X1 g2868(.A (n_268), .B (n_648), .S0 (n_584), .Y (n_649));
  MX2X1 g2873(.A (\treg[6] ), .B (mosi_o), .S0 (n_610), .Y (n_646));
  MX2X1 g2874(.A (miso_i), .B (\treg[0] ), .S0 (n_580), .Y (n_645));
  MX2X1 g2875(.A (\treg[0] ), .B (\treg[1] ), .S0 (n_575), .Y (n_644));
  MX2X1 g2876(.A (\treg[1] ), .B (\treg[2] ), .S0 (n_580), .Y (n_643));
  MX2X1 g2877(.A (\treg[2] ), .B (\treg[3] ), .S0 (n_575), .Y (n_642));
  MX2X1 g2878(.A (\treg[3] ), .B (\treg[4] ), .S0 (n_577), .Y (n_641));
  MX2X1 g2879(.A (\treg[4] ), .B (\treg[5] ), .S0 (n_580), .Y (n_640));
  MX2X1 g2880(.A (\treg[5] ), .B (\treg[6] ), .S0 (n_577), .Y (n_639));
  NAND2X2 g2903(.A (n_618), .B (n_638), .Y (n_684));
  NAND3X1 g2713(.A (n_289), .B (n_478), .C (n_603), .Y (n_637));
  AOI21X1 g2714(.A0 (n_124), .A1 (n_604), .B0 (n_635), .Y (n_636));
  NAND2X1 g2715(.A (n_609), .B (n_287), .Y (n_634));
  NAND2X1 g2716(.A (n_606), .B (n_352), .Y (n_633));
  NAND2X1 g2726(.A (n_572), .B (n_663), .Y (n_632));
  INVX1 g2986(.A (n_666), .Y (n_631));
  NAND2X1 g2777(.A (n_613), .B (n_981), .Y (n_630));
  MX2X1 g2779(.A (n_303), .B (n_627), .S0 (n_582), .Y (n_628));
  INVX2 g2894(.A (n_663), .Y (n_675));
  INVX4 g2896(.A (n_663), .Y (n_671));
  NAND2X1 g2723(.A (n_573), .B (n_354), .Y (n_622));
  NAND2X1 g2729(.A (n_349), .B (n_571), .Y (n_621));
  AOI21X1 g2731(.A0 (n_295), .A1 (n_607), .B0 (n_589), .Y (n_620));
  DFFSRX1 \rfifo_rp_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_587), .Q (\rfifo_rp[1] ), .QN ());
  DFFSRX1 \wfifo_rp_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_594), .Q (\wfifo_rp[1] ), .QN ());
  OAI21X1 g2774(.A0 (n_567), .A1 (n_120), .B0 (n_286), .Y (n_619));
  INVX2 g2987(.A (n_618), .Y (n_666));
  OAI21X1 g2776(.A0 (n_566), .A1 (n_120), .B0 (n_285), .Y (n_617));
  AOI22X1 g2781(.A0 (n_564), .A1 (n_608), .B0 (n_290), .B1 (n_966), .Y
       (n_615));
  DFFSRX1 \rfifo_rp_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_542), .Q (\rfifo_rp[0] ), .QN ());
  MX2X1 g2870(.A (n_177), .B (n_502), .S0 (n_590), .Y (n_613));
  NAND2X1 g2891(.A (n_585), .B (n_45), .Y (n_612));
  INVX4 g2901(.A (n_611), .Y (n_663));
  DFFSRX1 \wfifo_mem_reg[2][5] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_553), .Q (\wfifo_mem[2]_6 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][7] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_556), .Q (\wfifo_mem[1]_15 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_543), .Q (\wfifo_mem[2] ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][5] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_559), .Q (\wfifo_mem[1]_13 ), .QN ());
  DFFSRX1 \wfifo_wp_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_568), .Q (\wfifo_wp[1] ), .QN ());
  DFFSRX1 \wfifo_wp_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_569), .Q (\wfifo_wp[0] ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_570), .Q (\wfifo_mem[1] ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_550), .Q (\wfifo_mem[1]_10 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][3] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_562), .Q (\wfifo_mem[1]_11 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][4] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_561), .Q (\wfifo_mem[1]_12 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][6] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_558), .Q (\wfifo_mem[1]_14 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[1][8] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_563), .Q (\wfifo_mem[1]_16 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_546), .Q (\wfifo_mem[2]_3 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][3] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_555), .Q (\wfifo_mem[2]_4 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][4] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_554), .Q (\wfifo_mem[2]_5 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][6] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_545), .Q (\wfifo_mem[2]_7 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][7] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_552), .Q (\wfifo_mem[2]_8 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[2][8] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_548), .Q (\wfifo_mem[2]_9 ), .QN ());
  INVX2 g2988(.A (n_610), .Y (n_618));
  AOI22X1 g2786(.A0 (n_528), .A1 (n_608), .B0 (n_371), .B1 (n_607), .Y
       (n_609));
  AOI22X1 g2787(.A0 (n_527), .A1 (n_608), .B0 (n_370), .B1 (n_607), .Y
       (n_606));
  DFFSRX1 \wfifo_mem_reg[0][5] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_531), .Q (\wfifo_mem[0]_20 ), .QN ());
  NAND2X1 g2841(.A (n_530), .B (n_601), .Y (n_605));
  NAND3X1 g2842(.A (n_185), .B (n_473), .C (n_293), .Y (n_604));
  NAND2X1 g2843(.A (n_529), .B (n_608), .Y (n_603));
  NAND2X1 g2853(.A (n_526), .B (n_601), .Y (n_961));
  NAND2X1 g2854(.A (n_525), .B (n_601), .Y (n_959));
  NAND2X1 g2855(.A (n_524), .B (n_601), .Y (n_949));
  NAND2X1 g2856(.A (n_523), .B (n_601), .Y (n_951));
  NAND2X1 g2858(.A (n_522), .B (n_601), .Y (n_953));
  NAND2X1 g2859(.A (n_521), .B (n_601), .Y (n_955));
  NAND2X1 g2861(.A (n_520), .B (n_601), .Y (n_957));
  DFFSRX1 \wfifo_mem_reg[3][5] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_507), .Q (\wfifo_mem[3]_27 ), .QN ());
  NOR2X1 g2886(.A (n_505), .B (n_593), .Y (n_594));
  NAND2X1 g2890(.A (n_541), .B (sck_o), .Y (n_623));
  NAND2X2 g2902(.A (n_591), .B (n_590), .Y (n_611));
  DFFSRX1 \wfifo_mem_reg[3][1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_512), .Q (\wfifo_mem[3] ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][8] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_517), .Q (\wfifo_mem[0]_23 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][1] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_540), .Q (\wfifo_mem[0] ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_504), .Q (\wfifo_mem[0]_17 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][3] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_533), .Q (\wfifo_mem[0]_18 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][4] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_514), .Q (\wfifo_mem[0]_19 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][7] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_513), .Q (\wfifo_mem[0]_22 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[0][6] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_536), .Q (\wfifo_mem[0]_21 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][2] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_511), .Q (\wfifo_mem[3]_24 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][3] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_515), .Q (\wfifo_mem[3]_25 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][4] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_519), .Q (\wfifo_mem[3]_26 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][6] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_510), .Q (\wfifo_mem[3]_28 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][7] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_509), .Q (\wfifo_mem[3]_29 ), .QN ());
  DFFSRX1 \wfifo_mem_reg[3][8] (.RN (1'b1), .SN (1'b1), .CK (clk_i), .D
       (n_508), .Q (\wfifo_mem[3]_30 ), .QN ());
  OAI21X1 g2766(.A0 (n_501), .A1 (n_12), .B0 (n_588), .Y (n_589));
  NOR2X1 g2767(.A (n_535), .B (n_593), .Y (n_587));
  INVX2 g2989(.A (n_585), .Y (n_610));
  INVX1 g2990(.A (n_585), .Y (n_584));
  INVX1 g2991(.A (n_585), .Y (n_583));
  INVX1 g2992(.A (n_585), .Y (n_582));
  INVX2 g2996(.A (n_579), .Y (n_580));
  INVX1 g2998(.A (n_579), .Y (n_577));
  INVX1 g3000(.A (n_579), .Y (n_575));
  AOI22X1 g2782(.A0 (n_495), .A1 (n_608), .B0 (n_350), .B1 (sper_14),
       .Y (n_573));
  OAI21X1 g2784(.A0 (n_537), .A1 (n_819), .B0 (n_538), .Y (n_572));
  AOI22X1 g2785(.A0 (n_494), .A1 (n_608), .B0 (n_210), .B1 (n_477), .Y
       (n_571));
  MX2X1 g2952(.A (\wfifo_mem[1] ), .B (n_465), .S0 (n_551), .Y (n_570));
  AND2X1 g2845(.A (n_480), .B (n_966), .Y (n_569));
  AOI21X1 g2850(.A0 (n_425), .A1 (n_424), .B0 (n_970), .Y (n_568));
  AOI21X1 g2914(.A0 (n_565), .A1 (\rfifo_mem[0]_20 ), .B0 (n_476), .Y
       (n_567));
  AOI21X1 g2915(.A0 (n_565), .A1 (\rfifo_mem[0]_21 ), .B0 (n_475), .Y
       (n_566));
  NAND3X1 g2916(.A (n_169), .B (n_263), .C (n_417), .Y (n_564));
  MX2X1 g2946(.A (\wfifo_mem[1]_16 ), .B (n_464), .S0 (n_551), .Y
       (n_563));
  DFFSRX1 \sper_reg[5] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_483), .Q (sper_12), .QN ());
  DFFX1 wfre_reg(.CK (clk_i), .D (n_497), .Q (wfre), .QN ());
  DFFSRX1 \sper_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_491), .Q (\espr[2] ), .QN ());
  DFFSRX1 \sper_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_490), .Q (\espr[3] ), .QN ());
  DFFSRX1 \sper_reg[2] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_488), .Q (sper_9), .QN ());
  DFFSRX1 \sper_reg[3] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_486), .Q (sper_10), .QN ());
  DFFSRX1 \sper_reg[4] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_485), .Q (sper_11), .QN ());
  DFFSRX1 \sper_reg[6] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_482), .Q (sper_13), .QN ());
  MX2X1 g2954(.A (\wfifo_mem[1]_11 ), .B (n_452), .S0 (n_551), .Y
       (n_562));
  MX2X1 g2955(.A (\wfifo_mem[1]_12 ), .B (n_468), .S0 (n_551), .Y
       (n_561));
  MX2X1 g2956(.A (\wfifo_mem[1]_13 ), .B (n_453), .S0 (n_551), .Y
       (n_559));
  MX2X1 g2957(.A (\wfifo_mem[1]_14 ), .B (n_467), .S0 (n_551), .Y
       (n_558));
  MX2X1 g2958(.A (\wfifo_mem[1]_15 ), .B (n_470), .S0 (n_551), .Y
       (n_556));
  MX2X1 g2960(.A (\wfifo_mem[2]_4 ), .B (n_456), .S0 (n_551), .Y
       (n_555));
  MX2X1 g2961(.A (\wfifo_mem[2]_5 ), .B (n_462), .S0 (n_551), .Y
       (n_554));
  DFFSRX1 \sper_reg[7] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_481), .Q (sper_14), .QN ());
  MX2X1 g2962(.A (\wfifo_mem[2]_6 ), .B (n_454), .S0 (n_551), .Y
       (n_553));
  MX2X1 g2963(.A (\wfifo_mem[2]_8 ), .B (n_455), .S0 (n_551), .Y
       (n_552));
  MX2X1 g2969(.A (\wfifo_mem[1]_10 ), .B (n_471), .S0 (n_551), .Y
       (n_550));
  MX2X1 g2970(.A (\wfifo_mem[2]_9 ), .B (n_459), .S0 (n_551), .Y
       (n_548));
  MX2X1 g2972(.A (\wfifo_mem[2]_3 ), .B (n_463), .S0 (n_551), .Y
       (n_546));
  MX2X1 g2973(.A (\wfifo_mem[2]_7 ), .B (n_460), .S0 (n_551), .Y
       (n_545));
  MX2X1 g2974(.A (\wfifo_mem[2] ), .B (n_457), .S0 (n_551), .Y (n_543));
  AOI21X1 g2773(.A0 (n_446), .A1 (n_444), .B0 (n_593), .Y (n_542));
  INVX4 g2993(.A (n_541), .Y (n_585));
  INVX2 g3002(.A (n_590), .Y (n_579));
  DFFSRX1 \spcr_reg[7] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_426), .Q (spie), .QN ());
  DFFSRX1 \spcr_reg[5] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_430), .Q (spcr_5), .QN ());
  DFFSRX1 \spcr_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_436), .Q (n_111), .QN ());
  MX2X1 g2943(.A (\wfifo_mem[0] ), .B (n_390), .S0 (n_551), .Y (n_540));
  DFFSRX1 \spcr_reg[2] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_432), .Q (cpha), .QN ());
  NAND2X1 g2852(.A (n_537), .B (n_819), .Y (n_538));
  MX2X1 g2949(.A (\wfifo_mem[0]_21 ), .B (n_403), .S0 (n_551), .Y
       (n_536));
  AOI21X1 g2866(.A0 (n_445), .A1 (n_148), .B0 (n_438), .Y (n_535));
  NAND2X1 g2872(.A (n_442), .B (n_375), .Y (n_534));
  MX2X1 g2945(.A (\wfifo_mem[0]_18 ), .B (n_395), .S0 (n_551), .Y
       (n_533));
  NAND2X1 g2561(.A (n_451), .B (n_29), .Y (n_532));
  MX2X1 g2948(.A (\wfifo_mem[0]_20 ), .B (n_394), .S0 (n_551), .Y
       (n_531));
  NAND3X1 g2911(.A (n_311), .B (n_384), .C (n_362), .Y (n_530));
  NAND3X1 g2912(.A (n_171), .B (n_314), .C (n_361), .Y (n_529));
  NAND3X1 g2913(.A (n_215), .B (n_308), .C (n_359), .Y (n_528));
  NAND3X1 g2918(.A (n_140), .B (n_216), .C (n_358), .Y (n_527));
  DFFSRX1 \spcr_reg[4] (.RN (1'b1), .SN (rst_i), .CK (clk_i), .D
       (n_419), .Q (spcr_4), .QN ());
  NAND3X1 g2919(.A (n_310), .B (n_252), .C (n_416), .Y (n_526));
  NAND3X1 g2920(.A (n_307), .B (n_380), .C (n_415), .Y (n_525));
  NAND3X1 g2921(.A (n_312), .B (n_237), .C (n_413), .Y (n_524));
  NAND3X1 g2922(.A (n_316), .B (n_379), .C (n_411), .Y (n_523));
  NAND3X1 g2924(.A (n_297), .B (n_378), .C (n_410), .Y (n_522));
  NAND3X1 g2925(.A (n_306), .B (n_386), .C (n_409), .Y (n_521));
  NAND3X1 g2926(.A (n_318), .B (n_377), .C (n_408), .Y (n_520));
  MX2X1 g2953(.A (\wfifo_mem[3]_26 ), .B (n_406), .S0 (n_551), .Y
       (n_519));
  MX2X1 g2951(.A (\wfifo_mem[0]_23 ), .B (n_398), .S0 (n_551), .Y
       (n_517));
  DFFSRX1 \spcr_reg[1] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_434), .Q (n_288), .QN ());
  DFFSRX1 \spcr_reg[3] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_431), .Q (spcr_3), .QN ());
  DFFSRX1 \spcr_reg[6] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_429), .Q (n_966), .QN ());
  DFFSRX1 \wfifo_rp_reg[0] (.RN (rst_i), .SN (1'b1), .CK (clk_i), .D
       (n_418), .Q (\wfifo_rp[0] ), .QN ());
  XOR2X1 g2747(.A (n_193), .B (n_385), .Y (n_516));
  MX2X1 g2959(.A (\wfifo_mem[3]_25 ), .B (n_400), .S0 (n_551), .Y
       (n_515));
  MX2X1 g2947(.A (\wfifo_mem[0]_19 ), .B (n_405), .S0 (n_551), .Y
       (n_514));
  MX2X1 g2950(.A (\wfifo_mem[0]_22 ), .B (n_402), .S0 (n_551), .Y
       (n_513));
  MX2X1 g2964(.A (\wfifo_mem[3] ), .B (n_393), .S0 (n_551), .Y (n_512));
  MX2X1 g2965(.A (\wfifo_mem[3]_24 ), .B (n_389), .S0 (n_551), .Y
       (n_511));
  MX2X1 g2966(.A (\wfifo_mem[3]_28 ), .B (n_391), .S0 (n_551), .Y
       (n_510));
  MX2X1 g2967(.A (\wfifo_mem[3]_29 ), .B (n_397), .S0 (n_551), .Y
       (n_509));
  MX2X1 g2968(.A (\wfifo_mem[3]_30 ), .B (n_392), .S0 (n_551), .Y
       (n_508));
  MX2X1 g2971(.A (\wfifo_mem[3]_27 ), .B (n_396), .S0 (n_551), .Y
       (n_507));
  INVX2 g2994(.A (n_506), .Y (n_541));
  INVX2 g3003(.A (n_506), .Y (n_590));
  AOI22X1 g3016(.A0 (n_376), .A1 (wfre), .B0 (n_3), .B1 (n_58), .Y
       (n_505));
  MX2X1 g2944(.A (\wfifo_mem[0]_17 ), .B (n_407), .S0 (n_551), .Y
       (n_504));
  OAI21X1 g2867(.A0 (n_932), .A1 (n_502), .B0 (n_196), .Y (n_503));
  AND2X1 g2883(.A (n_370), .B (n_293), .Y (n_501));
  NAND3X1 g2889(.A (n_240), .B (n_871), .C (n_887), .Y (n_500));
  NAND2X1 g2892(.A (n_156), .B (n_498), .Y (n_499));
  NOR2X1 g2907(.A (n_382), .B (n_371), .Y (n_497));
  NAND4X1 g2562(.A (n_927), .B (n_450), .C (n_448), .D (n_449), .Y
       (n_496));
  NAND3X1 g2917(.A (n_168), .B (n_317), .C (n_282), .Y (n_495));
  NAND3X1 g2923(.A (n_170), .B (n_309), .C (n_283), .Y (n_494));
  XOR2X1 g2927(.A (n_37), .B (n_439), .Y (n_493));
  MX2X1 g2574(.A (n_843), .B (n_814), .S0 (n_302), .Y (n_492));
  MX2X1 g2935(.A (n_327), .B (\espr[2] ), .S0 (n_433), .Y (n_491));
  MX2X1 g2936(.A (n_326), .B (\espr[3] ), .S0 (n_433), .Y (n_490));
  MX2X1 g2937(.A (n_325), .B (sper_9), .S0 (n_433), .Y (n_488));
  MX2X1 g2938(.A (n_324), .B (sper_10), .S0 (n_433), .Y (n_486));
  MX2X1 g2939(.A (n_323), .B (sper_11), .S0 (n_433), .Y (n_485));
  MX2X1 g2940(.A (n_322), .B (sper_12), .S0 (n_433), .Y (n_483));
  MX2X1 g2941(.A (n_321), .B (sper_13), .S0 (n_433), .Y (n_482));
  MX2X1 g2942(.A (n_320), .B (sper_14), .S0 (n_433), .Y (n_481));
  XOR2X1 g2975(.A (n_42), .B (n_293), .Y (n_480));
  NAND3X1 g2983(.A (n_477), .B (rfifo_gb), .C (n_607), .Y (n_478));
  INVX2 g3004(.A (n_911), .Y (n_506));
  NAND2X1 g3009(.A (n_219), .B (n_357), .Y (n_476));
  NAND2X1 g3010(.A (n_220), .B (n_355), .Y (n_475));
  OAI21X1 g2780(.A0 (n_387), .A1 (n_96), .B0 (n_388), .Y (n_474));
  OAI21X1 g3014(.A0 (n_423), .A1 (n_58), .B0 (n_364), .Y (n_473));
  MX2X1 g3069(.A (dat_i[1]), .B (\wfifo_mem[1]_10 ), .S0 (n_469), .Y
       (n_471));
  MX2X1 g3070(.A (dat_i[6]), .B (\wfifo_mem[1]_15 ), .S0 (n_469), .Y
       (n_470));
  MX2X1 g3071(.A (dat_i[3]), .B (\wfifo_mem[1]_12 ), .S0 (n_466), .Y
       (n_468));
  MX2X1 g3072(.A (dat_i[5]), .B (\wfifo_mem[1]_14 ), .S0 (n_466), .Y
       (n_467));
  MX2X1 g3074(.A (dat_i[0]), .B (\wfifo_mem[1] ), .S0 (n_469), .Y
       (n_465));
  MX2X1 g3075(.A (dat_i[7]), .B (\wfifo_mem[1]_16 ), .S0 (n_466), .Y
       (n_464));
  MX2X1 g3076(.A (dat_i[1]), .B (\wfifo_mem[2]_3 ), .S0 (n_461), .Y
       (n_463));
  MX2X1 g3078(.A (dat_i[3]), .B (\wfifo_mem[2]_5 ), .S0 (n_461), .Y
       (n_462));
  MX2X1 g3080(.A (dat_i[5]), .B (\wfifo_mem[2]_7 ), .S0 (n_458), .Y
       (n_460));
  MX2X1 g3082(.A (dat_i[7]), .B (\wfifo_mem[2]_9 ), .S0 (n_458), .Y
       (n_459));
  MX2X1 g3083(.A (dat_i[0]), .B (\wfifo_mem[2] ), .S0 (n_461), .Y
       (n_457));
  MX2X1 g3086(.A (dat_i[2]), .B (\wfifo_mem[2]_4 ), .S0 (n_458), .Y
       (n_456));
  MX2X1 g3087(.A (dat_i[6]), .B (\wfifo_mem[2]_8 ), .S0 (n_461), .Y
       (n_455));
  MX2X1 g3089(.A (dat_i[4]), .B (\wfifo_mem[2]_6 ), .S0 (n_458), .Y
       (n_454));
  MX2X1 g3091(.A (dat_i[4]), .B (\wfifo_mem[1]_13 ), .S0 (n_469), .Y
       (n_453));
  MX2X1 g3093(.A (dat_i[2]), .B (\wfifo_mem[1]_11 ), .S0 (n_466), .Y
       (n_452));
  NAND3X1 g2570(.A (n_450), .B (n_449), .C (n_448), .Y (n_451));
  XOR2X1 g2595(.A (n_23), .B (n_190), .Y (n_447));
  NAND2X1 g2884(.A (n_445), .B (n_55), .Y (n_446));
  OR2X1 g2885(.A (n_445), .B (n_55), .Y (n_444));
  NAND2X1 g2887(.A (n_932), .B (n_167), .Y (n_442));
  NAND2X1 g2893(.A (n_445), .B (rfifo_gb), .Y (n_440));
  NAND4X1 g2904(.A (n_439), .B (n_102), .C (n_50), .D (n_39), .Y
       (n_537));
  AOI21X1 g2910(.A0 (n_112), .A1 (n_165), .B0 (n_445), .Y (n_438));
  XOR2X1 g2573(.A (n_41), .B (n_448), .Y (n_437));
  MX2X1 g2928(.A (n_273), .B (n_111), .S0 (n_433), .Y (n_436));
  MX2X1 g2929(.A (n_232), .B (n_288), .S0 (n_433), .Y (n_434));
  MX2X1 g2930(.A (n_231), .B (cpha), .S0 (n_433), .Y (n_432));
  MX2X1 g2931(.A (n_230), .B (spcr_3), .S0 (n_433), .Y (n_431));
  MX2X1 g2932(.A (n_229), .B (spcr_5), .S0 (n_433), .Y (n_430));
  MX2X1 g2933(.A (n_271), .B (n_428), .S0 (n_433), .Y (n_429));
  MX2X1 g2934(.A (n_228), .B (spie), .S0 (n_433), .Y (n_426));
  NAND2X1 g2982(.A (n_365), .B (n_52), .Y (n_425));
  NAND2X1 g2984(.A (n_423), .B (n_293), .Y (n_424));
  OR2X1 g3011(.A (n_291), .B (spcr_4), .Y (n_419));
  AND2X1 g3035(.A (n_305), .B (n_588), .Y (n_418));
  AOI21X1 g3046(.A0 (n_360), .A1 (\rfifo_mem[3]_29 ), .B0 (n_319), .Y
       (n_417));
  AOI22X1 g3060(.A0 (n_414), .A1 (\wfifo_mem[3] ), .B0 (\wfifo_mem[1]
       ), .B1 (n_383), .Y (n_416));
  AOI21X1 g3061(.A0 (n_414), .A1 (\wfifo_mem[3]_24 ), .B0 (n_253), .Y
       (n_415));
  AOI22X1 g3062(.A0 (n_414), .A1 (\wfifo_mem[3]_25 ), .B0
       (\wfifo_mem[1]_11 ), .B1 (n_383), .Y (n_413));
  AOI21X1 g3063(.A0 (n_414), .A1 (\wfifo_mem[3]_26 ), .B0 (n_260), .Y
       (n_411));
  AOI21X1 g3064(.A0 (n_414), .A1 (\wfifo_mem[3]_27 ), .B0 (n_255), .Y
       (n_410));
  AOI21X1 g3065(.A0 (n_414), .A1 (\wfifo_mem[3]_28 ), .B0 (n_265), .Y
       (n_409));
  AOI21X1 g3066(.A0 (n_414), .A1 (\wfifo_mem[3]_29 ), .B0 (n_251), .Y
       (n_408));
  MX2X1 g3101(.A (\wfifo_mem[0]_17 ), .B (dat_i[1]), .S0 (n_404), .Y
       (n_407));
  MX2X1 g3102(.A (dat_i[3]), .B (\wfifo_mem[3]_26 ), .S0 (n_399), .Y
       (n_406));
  MX2X1 g3103(.A (\wfifo_mem[0]_19 ), .B (dat_i[3]), .S0 (n_404), .Y
       (n_405));
  MX2X1 g3104(.A (\wfifo_mem[0]_21 ), .B (dat_i[5]), .S0 (n_404), .Y
       (n_403));
  MX2X1 g3105(.A (\wfifo_mem[0]_22 ), .B (dat_i[6]), .S0 (n_404), .Y
       (n_402));
  MX2X1 g3106(.A (dat_i[2]), .B (\wfifo_mem[3]_25 ), .S0 (n_399), .Y
       (n_400));
  MX2X1 g3107(.A (\wfifo_mem[0]_23 ), .B (dat_i[7]), .S0 (n_404), .Y
       (n_398));
  MX2X1 g3108(.A (dat_i[6]), .B (\wfifo_mem[3]_29 ), .S0 (n_399), .Y
       (n_397));
  MX2X1 g3110(.A (dat_i[4]), .B (\wfifo_mem[3]_27 ), .S0 (n_399), .Y
       (n_396));
  MX2X1 g3112(.A (\wfifo_mem[0]_18 ), .B (dat_i[2]), .S0 (n_404), .Y
       (n_395));
  MX2X1 g3115(.A (\wfifo_mem[0]_20 ), .B (dat_i[4]), .S0 (n_404), .Y
       (n_394));
  MX2X1 g3118(.A (dat_i[0]), .B (\wfifo_mem[3] ), .S0 (n_399), .Y
       (n_393));
  MX2X1 g3119(.A (dat_i[7]), .B (\wfifo_mem[3]_30 ), .S0 (n_399), .Y
       (n_392));
  MX2X1 g3135(.A (dat_i[5]), .B (\wfifo_mem[3]_28 ), .S0 (n_399), .Y
       (n_391));
  MX2X1 g3137(.A (\wfifo_mem[0] ), .B (dat_i[0]), .S0 (n_404), .Y
       (n_390));
  MX2X1 g3145(.A (dat_i[1]), .B (\wfifo_mem[3]_24 ), .S0 (n_399), .Y
       (n_389));
  NAND2X1 g2848(.A (n_387), .B (n_96), .Y (n_388));
  NAND2X1 g3176(.A (\wfifo_mem[1]_14 ), .B (n_383), .Y (n_386));
  NOR2X1 g2857(.A (n_259), .B (n_387), .Y (n_385));
  NAND2X1 g3190(.A (\wfifo_mem[1]_16 ), .B (n_383), .Y (n_384));
  OR2X1 g3201(.A (n_381), .B (n_977), .Y (n_382));
  NAND2X1 g3212(.A (\wfifo_mem[1]_10 ), .B (n_383), .Y (n_380));
  NAND2X1 g3214(.A (\wfifo_mem[1]_12 ), .B (n_383), .Y (n_379));
  NAND2X1 g3216(.A (\wfifo_mem[1]_13 ), .B (n_383), .Y (n_378));
  NAND2X1 g3220(.A (\wfifo_mem[1]_15 ), .B (n_383), .Y (n_377));
  OR2X1 g3221(.A (n_264), .B (n_383), .Y (n_376));
  NAND4X1 g2888(.A (spcr_3), .B (n_928), .C (n_931), .D (n_933), .Y
       (n_375));
  INVX1 g2703(.A (n_301), .Y (n_373));
  INVX1 g2979(.A (n_932), .Y (n_371));
  INVX1 g3006(.A (n_368), .Y (n_370));
  NAND3X1 g3012(.A (n_607), .B (dat_i[7]), .C (n_294), .Y (n_498));
  INVX4 g3020(.A (n_365), .Y (n_551));
  NAND2X1 g3033(.A (n_423), .B (n_58), .Y (n_364));
  NOR2X1 g3038(.A (n_149), .B (n_363), .Y (n_477));
  AOI21X1 g3043(.A0 (n_414), .A1 (\wfifo_mem[3]_30 ), .B0 (n_241), .Y
       (n_362));
  AOI21X1 g3045(.A0 (n_360), .A1 (\rfifo_mem[3]_24 ), .B0 (n_254), .Y
       (n_361));
  AOI21X1 g3047(.A0 (n_565), .A1 (\rfifo_mem[0]_18 ), .B0 (n_242), .Y
       (n_359));
  AOI21X1 g3049(.A0 (\rfifo_mem[2]_5 ), .A1 (n_281), .B0 (n_258), .Y
       (n_358));
  AOI21X1 g3051(.A0 (\rfifo_mem[2]_6 ), .A1 (n_281), .B0 (n_256), .Y
       (n_357));
  AOI21X1 g3053(.A0 (\rfifo_mem[2]_7 ), .A1 (n_281), .B0 (n_261), .Y
       (n_355));
  AOI22X1 g3057(.A0 (n_290), .A1 (spie), .B0 (spif), .B1 (n_607), .Y
       (n_354));
  AOI22X1 g3058(.A0 (spcr_3), .A1 (n_290), .B0 (sper_10), .B1 (n_350),
       .Y (n_352));
  AOI22X1 g3059(.A0 (n_111), .A1 (n_290), .B0 (\espr[2] ), .B1 (n_350),
       .Y (n_349));
  MX2X1 g3067(.A (\treg[5] ), .B (\rfifo_mem[1]_14 ), .S0 (n_345), .Y
       (n_347));
  MX2X1 g3068(.A (\treg[6] ), .B (\rfifo_mem[1]_15 ), .S0 (n_345), .Y
       (n_346));
  MX2X1 g3073(.A (\treg[4] ), .B (\rfifo_mem[1]_13 ), .S0 (n_334), .Y
       (n_344));
  MX2X1 g3077(.A (\treg[6] ), .B (\rfifo_mem[2]_8 ), .S0 (n_338), .Y
       (n_343));
  MX2X1 g3079(.A (\treg[1] ), .B (\rfifo_mem[2]_3 ), .S0 (n_338), .Y
       (n_342));
  MX2X1 g3081(.A (\treg[4] ), .B (\rfifo_mem[2]_6 ), .S0 (n_338), .Y
       (n_340));
  MX2X1 g3084(.A (\treg[2] ), .B (\rfifo_mem[2]_4 ), .S0 (n_338), .Y
       (n_339));
  MX2X1 g3085(.A (\treg[3] ), .B (\rfifo_mem[2]_5 ), .S0 (n_338), .Y
       (n_337));
  MX2X1 g3088(.A (\treg[0] ), .B (\rfifo_mem[2] ), .S0 (n_338), .Y
       (n_336));
  MX2X1 g3090(.A (\treg[0] ), .B (\rfifo_mem[1] ), .S0 (n_334), .Y
       (n_335));
  MX2X1 g3092(.A (mosi_o), .B (\rfifo_mem[1]_16 ), .S0 (n_345), .Y
       (n_333));
  MX2X1 g3094(.A (mosi_o), .B (\rfifo_mem[2]_9 ), .S0 (n_338), .Y
       (n_332));
  MX2X1 g3095(.A (\treg[3] ), .B (\rfifo_mem[1]_12 ), .S0 (n_334), .Y
       (n_331));
  MX2X1 g3096(.A (\treg[1] ), .B (\rfifo_mem[1]_10 ), .S0 (n_345), .Y
       (n_330));
  MX2X1 g3097(.A (\treg[5] ), .B (\rfifo_mem[2]_7 ), .S0 (n_338), .Y
       (n_329));
  MX2X1 g3098(.A (\treg[2] ), .B (\rfifo_mem[1]_11 ), .S0 (n_334), .Y
       (n_328));
  MX2X1 g3127(.A (\espr[2] ), .B (dat_i[0]), .S0 (n_350), .Y (n_327));
  MX2X1 g3128(.A (\espr[3] ), .B (dat_i[1]), .S0 (n_350), .Y (n_326));
  MX2X1 g3129(.A (sper_9), .B (dat_i[2]), .S0 (n_350), .Y (n_325));
  MX2X1 g3130(.A (sper_10), .B (dat_i[3]), .S0 (n_350), .Y (n_324));
  MX2X1 g3131(.A (sper_11), .B (dat_i[4]), .S0 (n_350), .Y (n_323));
  MX2X1 g3132(.A (sper_12), .B (dat_i[5]), .S0 (n_350), .Y (n_322));
  MX2X1 g3133(.A (sper_13), .B (dat_i[6]), .S0 (n_350), .Y (n_321));
  MX2X1 g3134(.A (sper_14), .B (dat_i[7]), .S0 (n_350), .Y (n_320));
  NOR2X1 g3169(.A (n_9), .B (n_112), .Y (n_319));
  NAND2X1 g3170(.A (n_315), .B (\wfifo_mem[0]_22 ), .Y (n_318));
  NAND2X1 g3172(.A (\rfifo_mem[1]_16 ), .B (n_257), .Y (n_317));
  NAND2X1 g3175(.A (n_315), .B (\wfifo_mem[0]_19 ), .Y (n_316));
  NAND2X1 g3184(.A (\rfifo_mem[1]_10 ), .B (n_257), .Y (n_314));
  NAND2X1 g3186(.A (n_315), .B (\wfifo_mem[0]_18 ), .Y (n_312));
  NAND2X1 g3187(.A (n_315), .B (\wfifo_mem[0]_23 ), .Y (n_311));
  NAND2X1 g3196(.A (n_315), .B (\wfifo_mem[0] ), .Y (n_310));
  NAND2X1 g3197(.A (\rfifo_mem[1] ), .B (n_257), .Y (n_309));
  NAND2X1 g3211(.A (\rfifo_mem[1]_11 ), .B (n_257), .Y (n_308));
  NAND2X1 g3213(.A (n_315), .B (\wfifo_mem[0]_17 ), .Y (n_307));
  NAND2X1 g3219(.A (n_315), .B (\wfifo_mem[0]_21 ), .Y (n_306));
  DFFSRX1 ack_o_reg(.RN (rst_i), .SN (1'b1), .CK (clk_i), .D (n_213),
       .Q (ack_o), .QN ());
  XOR2X1 g3233(.A (wfre), .B (n_101), .Y (n_305));
  INVX1 g2881(.A (n_245), .Y (n_304));
  INVX1 g2908(.A (n_243), .Y (n_303));
  NAND2X1 g2636(.A (n_912), .B (n_184), .Y (n_302));
  AOI21X1 g2732(.A0 (n_244), .A1 (n_811), .B0 (n_184), .Y (n_301));
  NAND3X1 g2985(.A (n_178), .B (n_8), .C (n_239), .Y (n_445));
  NAND2X1 g3218(.A (n_315), .B (\wfifo_mem[0]_20 ), .Y (n_297));
  NAND3X1 g3008(.A (n_928), .B (n_933), .C (wfifo_gb), .Y (n_368));
  MX2X1 g3015(.A (n_148), .B (n_64), .S0 (n_202), .Y (n_296));
  AND2X1 g3018(.A (dat_i[6]), .B (n_294), .Y (n_295));
  INVX2 g3031(.A (n_293), .Y (n_365));
  NOR2X1 g3036(.A (n_70), .B (n_831), .Y (n_439));
  AND2X1 g3037(.A (n_290), .B (n_294), .Y (n_291));
  AOI22X1 g3044(.A0 (n_288), .A1 (n_290), .B0 (\espr[3] ), .B1 (n_350),
       .Y (n_289));
  AOI22X1 g3048(.A0 (cpha), .A1 (n_290), .B0 (sper_9), .B1 (n_350), .Y
       (n_287));
  AOI22X1 g3050(.A0 (spcr_4), .A1 (n_290), .B0 (sper_11), .B1 (n_350),
       .Y (n_286));
  AOI22X1 g3052(.A0 (spcr_5), .A1 (n_290), .B0 (sper_12), .B1 (n_350),
       .Y (n_285));
  AOI22X1 g3054(.A0 (n_350), .A1 (sper_13), .B0 (n_12), .B1 (n_607), .Y
       (n_284));
  AOI22X1 g3055(.A0 (n_360), .A1 (\rfifo_mem[3] ), .B0 (\rfifo_mem[2]
       ), .B1 (n_281), .Y (n_283));
  AOI22X1 g3056(.A0 (n_360), .A1 (\rfifo_mem[3]_30 ), .B0
       (\rfifo_mem[2]_9 ), .B1 (n_281), .Y (n_282));
  MX2X1 g3100(.A (\treg[3] ), .B (\rfifo_mem[3]_26 ), .S0 (n_278), .Y
       (n_280));
  MX2X1 g3109(.A (\treg[1] ), .B (\rfifo_mem[3]_24 ), .S0 (n_278), .Y
       (n_279));
  MX2X1 g3113(.A (\treg[5] ), .B (\rfifo_mem[3]_28 ), .S0 (n_278), .Y
       (n_277));
  MX2X1 g3114(.A (\treg[6] ), .B (\rfifo_mem[3]_29 ), .S0 (n_278), .Y
       (n_276));
  MX2X1 g3116(.A (\treg[4] ), .B (\rfifo_mem[3]_27 ), .S0 (n_278), .Y
       (n_275));
  MX2X1 g3117(.A (mosi_o), .B (\rfifo_mem[3]_30 ), .S0 (n_278), .Y
       (n_274));
  OAI21X1 g3120(.A0 (n_77), .A1 (n_290), .B0 (n_172), .Y (n_273));
  OAI21X1 g3125(.A0 (n_290), .A1 (n_138), .B0 (n_174), .Y (n_271));
  MX2X1 g3136(.A (\treg[0] ), .B (\rfifo_mem[3] ), .S0 (n_278), .Y
       (n_270));
  MX2X1 g3142(.A (\treg[2] ), .B (\rfifo_mem[3]_25 ), .S0 (n_278), .Y
       (n_269));
  INVX1 g3146(.A (n_206), .Y (n_268));
  INVX1 g3155(.A (n_294), .Y (n_433));
  AND2X1 g3173(.A (\wfifo_mem[2]_7 ), .B (n_264), .Y (n_265));
  NAND2X1 g3174(.A (\rfifo_mem[2]_8 ), .B (n_281), .Y (n_263));
  AND2X1 g3178(.A (\rfifo_mem[1]_14 ), .B (n_257), .Y (n_261));
  AND2X1 g3180(.A (\wfifo_mem[2]_5 ), .B (n_264), .Y (n_260));
  NAND2X1 g3181(.A (n_449), .B (n_151), .Y (n_259));
  AND2X1 g3183(.A (\rfifo_mem[1]_12 ), .B (n_257), .Y (n_258));
  AND2X1 g3191(.A (\rfifo_mem[1]_13 ), .B (n_257), .Y (n_256));
  AND2X1 g3203(.A (\wfifo_mem[2]_6 ), .B (n_264), .Y (n_255));
  AND2X1 g3206(.A (\rfifo_mem[2]_3 ), .B (n_281), .Y (n_254));
  AND2X1 g3210(.A (\wfifo_mem[2]_3 ), .B (n_264), .Y (n_253));
  NAND2X1 g3215(.A (\wfifo_mem[2] ), .B (n_264), .Y (n_252));
  AND2X1 g3217(.A (\wfifo_mem[2]_8 ), .B (n_264), .Y (n_251));
  NAND2X1 g3227(.A (n_458), .B (n_466), .Y (n_423));
  AOI21X1 g3230(.A0 (n_55), .A1 (n_747), .B0 (n_141), .Y (n_363));
  INVX1 g3238(.A (n_250), .Y (n_469));
  INVX1 g3251(.A (n_249), .Y (n_461));
  NAND3X1 g2905(.A (n_175), .B (n_135), .C (n_829), .Y (n_387));
  AND2X1 g2906(.A (n_129), .B (n_244), .Y (n_245));
  NOR2X1 g2632(.A (n_176), .B (n_190), .Y (n_448));
  AOI21X1 g2909(.A0 (n_105), .A1 (n_627), .B0 (n_217), .Y (n_243));
  AND2X1 g3198(.A (\rfifo_mem[2]_4 ), .B (n_281), .Y (n_242));
  AND2X1 g3185(.A (\wfifo_mem[2]_9 ), .B (n_264), .Y (n_241));
  MX2X1 g3013(.A (spcr_3), .B (n_45), .S0 (n_177), .Y (n_240));
  AND2X1 g3032(.A (n_218), .B (n_239), .Y (n_293));
  NAND2X1 g3034(.A (n_173), .B (n_186), .Y (n_238));
  NAND2X1 g3179(.A (\wfifo_mem[2]_4 ), .B (n_264), .Y (n_237));
  INVX1 g3040(.A (n_183), .Y (n_236));
  MX2X1 g3099(.A (\rfifo_mem[0]_20 ), .B (\treg[4] ), .S0 (n_233), .Y
       (n_235));
  MX2X1 g3111(.A (\rfifo_mem[0]_21 ), .B (\treg[5] ), .S0 (n_233), .Y
       (n_234));
  MX2X1 g3121(.A (n_288), .B (dat_i[1]), .S0 (n_290), .Y (n_232));
  MX2X1 g3122(.A (cpha), .B (dat_i[2]), .S0 (n_290), .Y (n_231));
  MX2X1 g3123(.A (spcr_3), .B (dat_i[3]), .S0 (n_290), .Y (n_230));
  MX2X1 g3124(.A (spcr_5), .B (dat_i[5]), .S0 (n_290), .Y (n_229));
  MX2X1 g3126(.A (spie), .B (dat_i[7]), .S0 (n_290), .Y (n_228));
  MX2X1 g3138(.A (\rfifo_mem[0] ), .B (\treg[0] ), .S0 (n_233), .Y
       (n_227));
  MX2X1 g3139(.A (\rfifo_mem[0]_17 ), .B (\treg[1] ), .S0 (n_233), .Y
       (n_226));
  MX2X1 g3140(.A (\rfifo_mem[0]_18 ), .B (\treg[2] ), .S0 (n_233), .Y
       (n_225));
  MX2X1 g3141(.A (\rfifo_mem[0]_19 ), .B (\treg[3] ), .S0 (n_233), .Y
       (n_224));
  MX2X1 g3143(.A (\rfifo_mem[0]_22 ), .B (\treg[6] ), .S0 (n_233), .Y
       (n_223));
  MX2X1 g3144(.A (\rfifo_mem[0]_23 ), .B (mosi_o), .S0 (n_233), .Y
       (n_222));
  INVX1 g3147(.A (n_137), .Y (n_221));
  NAND2X1 g3149(.A (n_360), .B (\rfifo_mem[3]_28 ), .Y (n_220));
  NAND2X1 g3150(.A (n_360), .B (\rfifo_mem[3]_27 ), .Y (n_219));
  CLKBUFX1 g3156(.A (n_218), .Y (n_294));
  NOR2X1 g3163(.A (n_138), .B (n_196), .Y (n_591));
  NAND2X1 g3166(.A (n_360), .B (\rfifo_mem[3]_26 ), .Y (n_216));
  NAND2X1 g3167(.A (n_360), .B (\rfifo_mem[3]_25 ), .Y (n_215));
  NOR2X1 g3193(.A (n_38), .B (ack_o), .Y (n_213));
  NOR2X1 g3199(.A (rfifo_gb), .B (n_159), .Y (n_210));
  OR2X1 g3207(.A (n_204), .B (n_126), .Y (n_209));
  AOI21X1 g3222(.A0 (n_962), .A1 (n_648), .B0 (n_106), .Y (n_206));
  INVX1 g3225(.A (n_202), .Y (n_203));
  INVX1 g3239(.A (n_466), .Y (n_250));
  INVX1 g3252(.A (n_458), .Y (n_249));
  INVX2 g3265(.A (n_161), .Y (n_383));
  CLKBUFX1 g3284(.A (n_158), .Y (n_414));
  INVX2 g3289(.A (n_972), .Y (n_196));
  NOR2X1 g3300(.A (n_41), .B (n_193), .Y (n_450));
  NAND2X1 g3311(.A (rst_i), .B (n_966), .Y (n_635));
  NAND2X1 g3303(.A (n_42), .B (n_52), .Y (n_399));
  INVX1 g3313(.A (n_189), .Y (n_404));
  AND2X1 g3339(.A (n_72), .B (n_62), .Y (n_315));
  INVX1 g3478(.A (n_719), .Y (n_721));
  NAND2X1 g3204(.A (n_88), .B (n_186), .Y (n_187));
  INVX1 g3228(.A (n_933), .Y (n_185));
  INVX1 g2768(.A (n_190), .Y (n_184));
  AOI21X1 g3041(.A0 (n_142), .A1 (n_111), .B0 (\espr[3] ), .Y (n_183));
  AOI21X1 g3042(.A0 (sper_13), .A1 (n_181), .B0 (n_95), .Y (n_182));
  AND2X1 g3157(.A (n_178), .B (we_i), .Y (n_218));
  INVX1 g3161(.A (n_177), .Y (n_217));
  NAND2X1 g3165(.A (n_175), .B (n_50), .Y (n_176));
  NAND2X1 g3171(.A (n_290), .B (dat_i[6]), .Y (n_174));
  NOR2X1 g3177(.A (n_118), .B (\espr[3] ), .Y (n_173));
  NAND2X1 g3182(.A (n_290), .B (dat_i[0]), .Y (n_172));
  NAND2X1 g3189(.A (n_565), .B (\rfifo_mem[0]_17 ), .Y (n_171));
  NAND2X1 g3194(.A (n_565), .B (\rfifo_mem[0] ), .Y (n_170));
  NAND2X1 g3200(.A (n_565), .B (\rfifo_mem[0]_22 ), .Y (n_169));
  NAND2X1 g3202(.A (n_565), .B (\rfifo_mem[0]_23 ), .Y (n_168));
  NAND2X1 g3226(.A (n_338), .B (n_345), .Y (n_202));
  NAND2X1 g3232(.A (n_46), .B (n_79), .Y (n_167));
  INVX1 g3235(.A (n_117), .Y (n_264));
  NAND2X2 g3240(.A (n_42), .B (n_61), .Y (n_466));
  INVX1 g3241(.A (n_166), .Y (n_334));
  INVX1 g3247(.A (n_165), .Y (n_281));
  NAND2X2 g3253(.A (n_71), .B (n_52), .Y (n_458));
  INVX2 g3256(.A (n_204), .Y (n_638));
  INVX1 g3258(.A (n_120), .Y (n_608));
  NAND2X1 g3266(.A (n_101), .B (n_62), .Y (n_161));
  INVX1 g3278(.A (n_112), .Y (n_257));
  INVX1 g3280(.A (n_159), .Y (n_607));
  NOR2X1 g3285(.A (n_72), .B (n_62), .Y (n_158));
  NAND2X1 g3315(.A (n_71), .B (n_61), .Y (n_189));
  NOR2X1 g3316(.A (n_4), .B (n_381), .Y (n_156));
  NOR2X1 g3346(.A (n_41), .B (n_96), .Y (n_151));
  XOR2X1 g3234(.A (n_148), .B (\rfifo_wp[1] ), .Y (n_149));
  NOR2X1 g3205(.A (n_120), .B (n_22), .Y (n_239));
  OR2X1 g3164(.A (n_87), .B (n_288), .Y (n_144));
  OR2X1 g3151(.A (n_142), .B (\espr[3] ), .Y (n_143));
  AND2X1 g3304(.A (n_65), .B (n_80), .Y (n_141));
  NAND2X1 g3188(.A (n_565), .B (\rfifo_mem[0]_19 ), .Y (n_140));
  NOR2X1 g3338(.A (n_7), .B (n_138), .Y (n_139));
  AOI21X1 g3224(.A0 (n_16), .A1 (n_136), .B0 (n_135), .Y (n_137));
  NAND4X1 g2769(.A (n_944), .B (n_937), .C (n_75), .D (n_830), .Y
       (n_190));
  NAND2X1 g2977(.A (n_135), .B (n_937), .Y (n_244));
  OR2X1 g2981(.A (n_135), .B (n_937), .Y (n_129));
  INVX1 g3480(.A (n_428), .Y (n_719));
  NAND2X1 g3274(.A (n_126), .B (\state[1] ), .Y (n_205));
  OR2X1 g3282(.A (n_67), .B (adr_i[1]), .Y (n_159));
  NAND2X1 g3273(.A (n_3), .B (wfifo_gb), .Y (n_124));
  INVX1 g3254(.A (n_118), .Y (n_119));
  NAND2X1 g3236(.A (n_72), .B (n_58), .Y (n_117));
  NAND2X1 g3249(.A (n_65), .B (\rfifo_rp[1] ), .Y (n_165));
  NAND2X1 g3257(.A (\state[0] ), .B (n_34), .Y (n_204));
  NAND2X1 g3279(.A (n_55), .B (n_64), .Y (n_112));
  INVX1 g3297(.A (n_835), .Y (n_449));
  NAND2X1 g3305(.A (n_111), .B (n_288), .Y (n_186));
  NAND2X1 g3308(.A (n_747), .B (\rfifo_wp[1] ), .Y (n_278));
  AND2X1 g3319(.A (adr_i[0]), .B (adr_i[1]), .Y (n_350));
  INVX1 g3327(.A (n_66), .Y (n_360));
  AND2X1 g3329(.A (n_288), .B (\espr[3] ), .Y (n_670));
  INVX1 g3340(.A (n_105), .Y (n_106));
  INVX1 g3472(.A (n_966), .Y (n_593));
  INVX1 g3474(.A (n_138), .Y (n_588));
  NAND3X1 g3162(.A (n_984), .B (n_83), .C (n_32), .Y (n_177));
  DFFX1 inta_o_reg(.CK (clk_i), .D (n_21), .Q (inta_o), .QN ());
  NOR2X1 g3192(.A (n_181), .B (\tcnt[0] ), .Y (n_95));
  INVX1 g3243(.A (n_345), .Y (n_166));
  INVX1 g3481(.A (n_970), .Y (n_428));
  INVX1 g3309(.A (n_87), .Y (n_88));
  OR2X1 g3301(.A (n_77), .B (n_15), .Y (n_86));
  NAND2X1 g3341(.A (n_984), .B (n_83), .Y (n_105));
  NAND2X1 g3283(.A (n_62), .B (n_61), .Y (n_81));
  NAND2X2 g3272(.A (n_80), .B (\rfifo_wp[1] ), .Y (n_338));
  NAND2X1 g3268(.A (n_10), .B (spcr_3), .Y (n_79));
  AND2X1 g3255(.A (n_77), .B (\espr[2] ), .Y (n_118));
  INVX2 g3475(.A (n_966), .Y (n_138));
  NAND2X2 g3244(.A (\rfifo_wp[0] ), .B (n_49), .Y (n_345));
  AND2X1 g3296(.A (n_830), .B (n_75), .Y (n_135));
  NAND2X1 g3307(.A (n_849), .B (n_75), .Y (n_70));
  AND2X1 g3317(.A (n_850), .B (n_849), .Y (n_175));
  AND2X1 g3325(.A (n_67), .B (n_18), .Y (n_290));
  OR2X1 g3328(.A (n_65), .B (n_64), .Y (n_66));
  OR2X1 g3330(.A (n_62), .B (n_61), .Y (n_63));
  NOR2X1 g3331(.A (n_26), .B (n_47), .Y (n_142));
  INVX1 g3336(.A (n_181), .Y (n_107));
  INVX1 g3454(.A (n_50), .Y (n_96));
  INVX1 g3427(.A (n_72), .Y (n_101));
  AND2X1 g3347(.A (n_80), .B (n_49), .Y (n_233));
  NAND2X1 g3310(.A (n_47), .B (n_15), .Y (n_87));
  INVX1 g3294(.A (n_38), .Y (n_178));
  INVX1 g3470(.A (n_966), .Y (n_381));
  NAND2X2 g3263(.A (n_67), .B (adr_i[1]), .Y (n_120));
  NAND2X1 g3267(.A (cpha), .B (n_45), .Y (n_46));
  INVX1 g3422(.A (n_41), .Y (n_102));
  AND2X1 g3326(.A (n_850), .B (n_843), .Y (n_39));
  AND2X1 g3342(.A (n_65), .B (n_64), .Y (n_565));
  NAND2X1 g3295(.A (cyc_i), .B (stb_i), .Y (n_38));
  INVX1 g3464(.A (n_126), .Y (n_502));
  INVX1 g3404(.A (n_850), .Y (n_37));
  CLKBUFX1 g3455(.A (n_845), .Y (n_50));
  INVX1 g3352(.A (n_32), .Y (n_627));
  INVX1 g3397(.A (n_927), .Y (n_29));
  INVX1 g3409(.A (n_925), .Y (n_193));
  INVX1 g3446(.A (n_61), .Y (n_52));
  INVX1 g3430(.A (n_83), .Y (n_648));
  INVX1 g3390(.A (n_849), .Y (n_23));
  AND2X1 g3348(.A (spie), .B (spif), .Y (n_21));
  NOR2X1 g3337(.A (\tcnt[0] ), .B (\tcnt[1] ), .Y (n_181));
  INVX1 g3384(.A (n_75), .Y (n_136));
  INVX1 g3423(.A (n_939), .Y (n_41));
  INVX1 g3374(.A (n_62), .Y (n_58));
  INVX1 g3415(.A (n_64), .Y (n_148));
  INVX1 g3367(.A (n_71), .Y (n_42));
  INVX1 g3380(.A (n_80), .Y (n_747));
  INVX1 g3418(.A (n_830), .Y (n_16));
  INVX2 g3356(.A (n_65), .Y (n_55));
  INVX2 g3465(.A (\state[0] ), .Y (n_126));
  INVX1 g3385(.A (\clkcnt[0] ), .Y (n_75));
  INVX1 g3412(.A (adr_i[1]), .Y (n_18));
  INVX1 g3407(.A (\espr[3] ), .Y (n_15));
  INVX1 g3389(.A (\rfifo_wp[1] ), .Y (n_49));
  INVX1 g3429(.A (\wfifo_rp[0] ), .Y (n_72));
  INVX1 g3436(.A (wcol), .Y (n_12));
  INVX1 g3433(.A (ack_o), .Y (n_22));
  INVX2 g3375(.A (\wfifo_rp[1] ), .Y (n_62));
  INVX1 g3362(.A (n_111), .Y (n_77));
  INVX1 g3381(.A (\rfifo_wp[0] ), .Y (n_80));
  INVX1 g3396(.A (\state[1] ), .Y (n_11));
  INVX1 g3461(.A (sck_o), .Y (n_45));
  INVX1 g3358(.A (cpha), .Y (n_10));
  INVX1 g3450(.A (\rfifo_mem[1]_15 ), .Y (n_9));
  INVX1 g3370(.A (\espr[2] ), .Y (n_47));
  INVX1 g3351(.A (we_i), .Y (n_8));
  INVX1 g3387(.A (\tcnt[1] ), .Y (n_7));
  INVX1 g3457(.A (sper_14), .Y (n_5));
  INVX2 g3357(.A (\rfifo_rp[0] ), .Y (n_65));
  INVX1 g3435(.A (n_288), .Y (n_26));
  INVX1 g3363(.A (spif), .Y (n_4));
  INVX1 g3376(.A (wfre), .Y (n_3));
  INVX1 g3447(.A (\wfifo_wp[1] ), .Y (n_61));
  INVX1 g3431(.A (\bcnt[1] ), .Y (n_83));
  INVX1 g3439(.A (adr_i[0]), .Y (n_67));
  INVX1 g3353(.A (\bcnt[2] ), .Y (n_32));
  INVX2 g3368(.A (\wfifo_wp[0] ), .Y (n_71));
  INVX1 g3417(.A (\rfifo_rp[1] ), .Y (n_64));
  INVX1 g3395(.A (\state[1] ), .Y (n_34));
  INVX1 g3620(.A (n_944), .Y (n_811));
  INVX1 g3623(.A (n_843), .Y (n_814));
  INVX1 g3628(.A (n_842), .Y (n_819));
  NAND2X1 g16(.A (n_829), .B (n_830), .Y (n_831));
  INVX1 g18(.A (n_913), .Y (n_829));
  NAND2X1 g30(.A (n_842), .B (n_843), .Y (n_835));
  INVX1 g39(.A (\clkcnt[9] ), .Y (n_842));
  INVX1 g38(.A (\clkcnt[8] ), .Y (n_843));
  INVX1 g3632(.A (\clkcnt[5] ), .Y (n_844));
  INVX1 g3633(.A (\clkcnt[6] ), .Y (n_845));
  CLKBUFX1 g3636(.A (n_940), .Y (n_849));
  CLKBUFX1 g23(.A (n_844), .Y (n_850));
  NOR2X1 g3642(.A (n_888), .B (n_889), .Y (n_871));
  NOR2X1 g3655(.A (n_914), .B (n_913), .Y (n_887));
  INVX1 g3656(.A (n_906), .Y (n_888));
  INVX1 g3657(.A (n_912), .Y (n_889));
  NOR2X1 g45(.A (\clkcnt[8] ), .B (\clkcnt[9] ), .Y (n_890));
  NAND3X1 g3660(.A (n_896), .B (n_901), .C (n_902), .Y (n_903));
  NAND2X1 g3661(.A (n_650), .B (n_638), .Y (n_896));
  NOR2X1 g33(.A (n_897), .B (n_900), .Y (n_901));
  NOR2X1 g3662(.A (n_45), .B (n_205), .Y (n_897));
  AOI21X1 g3663(.A0 (n_623), .A1 (n_500), .B0 (n_899), .Y (n_900));
  INVX1 g36(.A (n_981), .Y (n_899));
  NAND2X1 g3664(.A (n_534), .B (n_601), .Y (n_902));
  NAND3X1 g3665(.A (n_906), .B (n_946), .C (n_936), .Y (n_911));
  NOR2X1 g3666(.A (n_926), .B (n_905), .Y (n_906));
  INVX1 g48(.A (n_890), .Y (n_905));
  NOR2X1 g3671(.A (n_935), .B (n_947), .Y (n_912));
  NAND2X1 g46(.A (n_944), .B (n_937), .Y (n_913));
  NAND2X1 g3672(.A (n_943), .B (n_830), .Y (n_914));
  NAND2X1 g8(.A (n_924), .B (n_925), .Y (n_926));
  INVX1 g11(.A (\clkcnt[11] ), .Y (n_924));
  INVX1 g9(.A (\clkcnt[10] ), .Y (n_925));
  CLKBUFX1 g10(.A (n_924), .Y (n_927));
  NAND3X1 g21(.A (n_928), .B (n_930), .C (n_931), .Y (n_932));
  NAND2X1 g3679(.A (n_63), .B (n_81), .Y (n_928));
  OAI21X1 g3680(.A0 (n_71), .A1 (n_72), .B0 (n_929), .Y (n_930));
  NAND2X1 g3681(.A (n_71), .B (n_72), .Y (n_929));
  INVX1 g27(.A (wfifo_gb), .Y (n_931));
  CLKBUFX1 g3682(.A (n_930), .Y (n_933));
  NOR2X1 g14(.A (n_1002), .B (n_935), .Y (n_936));
  NAND2X2 g15(.A (n_845), .B (n_844), .Y (n_935));
  INVX1 g17(.A (\clkcnt[2] ), .Y (n_937));
  INVX1 g3684(.A (\clkcnt[1] ), .Y (n_830));
  INVX1 g3686(.A (\clkcnt[7] ), .Y (n_939));
  INVX1 g3687(.A (\clkcnt[4] ), .Y (n_940));
  NOR2X1 g3688(.A (n_942), .B (n_945), .Y (n_946));
  NAND2X1 g15_dup(.A (n_940), .B (n_939), .Y (n_942));
  NAND2X2 g3689(.A (n_943), .B (n_944), .Y (n_945));
  INVX1 g19(.A (\clkcnt[0] ), .Y (n_943));
  INVX2 g3690(.A (\clkcnt[3] ), .Y (n_944));
  NAND2X1 g3691(.A (n_940), .B (n_939), .Y (n_947));
  OAI21X1 g47(.A0 (n_964), .A1 (n_969), .B0 (n_975), .Y (n_976));
  MX2X1 g51(.A (n_962), .B (n_984), .S0 (n_583), .Y (n_964));
  NAND3X1 g50(.A (\state[1] ), .B (n_966), .C (\state[0] ), .Y (n_969));
  OR2X1 g3692(.A (n_970), .B (n_974), .Y (n_975));
  INVX1 g61(.A (n_966), .Y (n_970));
  AOI21X1 g49(.A0 (n_971), .A1 (n_962), .B0 (n_196), .Y (n_974));
  NAND2X2 g52(.A (n_204), .B (n_205), .Y (n_971));
  NAND2X1 g58(.A (n_11), .B (n_126), .Y (n_972));
  INVX1 g53(.A (n_196), .Y (n_977));
  INVX1 g55(.A (n_972), .Y (n_601));
  CLKBUFX1 g59(.A (n_981), .Y (n_982));
  NOR2X1 g60(.A (n_126), .B (n_34), .Y (n_981));
  INVX1 g71(.A (n_962), .Y (n_984));
  NAND2X1 g4(.A (n_1000), .B (n_1001), .Y (n_1002));
  INVX1 g6(.A (\clkcnt[2] ), .Y (n_1000));
  INVX1 g5(.A (\clkcnt[1] ), .Y (n_1001));
endmodule

