--  
--  ITC99 Benchmark
--  Downloaded from http://www.cad.polito.it/tools/itc99.html
--  
--  Copyright (C) 1999
--  Fulvio Corno, Matteo Sonze Reorda, Giovanni Squillero
--  Politecnico di Torino
--  
--  This source file may be used and distributed without restriction
--  provided that this copyright statement is not removed from the
--  file and that any derivative work contains the original copyright
--  notice and the associated disclaimer.
--  
--  This source file is free software; you can redistribute it and/or
--  modify it under the terms of the GNU General Public License as
--  published by the Free Software Foundation.
--  
--  This source is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  General Public License for more details.
--  
--  You should have received a copy of the GNU General Public License
--  along with this source; if not, download it from
--  http://www.gnu.org/copyleft/gpl.html
--  
--  
--
-- Component : uni_types
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 28, 1996
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

PACKAGE uni_types IS

constant A_BUS_NUMBER: integer := 6;
constant D_BUS_NUMBER: integer := 16;
constant INJ_NUMBER: integer := 6;
constant BANKS_NUMBER: integer := 2;
constant REG_BITS : integer := 12;
constant REG_NUMBER: integer := 9;
constant SPLIT_NUMBER: integer := 3;
constant INT_REG_NUM: integer := 7;
constant STATE_VAR_NUM: integer := 4;
constant ST_REG_NUM: integer := 11;
constant GLOB_STATE_BITS: integer := 7;
constant TWENTYONE_BIT: integer := 21;
constant TWO_BIT: integer := 2;
constant THREE_BIT: integer := 3;
constant FOUR_BIT: integer := 4;
constant FIVE_BIT: integer := 5;
constant SEVEN_BIT: integer := 7;
constant EIGHT_BIT: integer := 8;
constant NINE_BIT: integer := 9;
constant TEN_BIT: integer := 10;
constant THIRTEEN_BIT: integer := 13;
constant S: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "00";
constant CH: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "01";
constant R: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "10";
constant N: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "11";
constant A: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "00";
constant B: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "01";
constant C: std_logic_vector(BANKS_NUMBER - 1 downto 0) := "10";

SubType A_BUS_TYPE is std_logic_vector (A_BUS_NUMBER - 1 downto 0);
SubType D_BUS_TYPE is std_logic_vector (D_BUS_NUMBER - 1 downto 0);
SubType INJ_TYPE is std_logic_vector (INJ_NUMBER - 1 downto 0);
SubType INJ_T3_TYPE is std_logic_vector (BANKS_NUMBER - 1 downto 0);
SubType A_DEC_TYPE is std_logic_vector (REG_NUMBER - 1 downto 0);
SubType REG_TYPE is std_logic_vector (REG_BITS - 1 downto 0);
SubType SPLIT_INJ_CMD_TYPE is std_logic_vector ( SPLIT_NUMBER - 1 downto 0);
SubType INT_REG_TYPE is std_logic_vector (SPLIT_NUMBER - 1 downto 0);
SubType STATE_VAR_TYPE is std_logic_vector (STATE_VAR_NUM - 1 downto 0);
SubType BYTE is std_logic_vector (7 downto 0);
SubType ST_REG_TYPE is std_logic_vector (ST_REG_NUM - 1 downto 0);
SubType GLOB_STATE_REG_TYPE is std_logic_vector (GLOB_STATE_BITS - 1 downto 0);
SubType TWENTYONE_BIT_VECTOR is std_logic_vector (TWENTYONE_BIT -1 downto 0);
SubType TWO_BIT_VECTOR is std_logic_vector (TWO_BIT -1 downto 0);
SubType THREE_BIT_VECTOR is std_logic_vector (THREE_BIT -1 downto 0);
SubType FOUR_BIT_VECTOR is std_logic_vector (FOUR_BIT -1 downto 0);
SubType FIVE_BIT_VECTOR is std_logic_vector (FIVE_BIT -1 downto 0);
SubType SEVEN_BIT_VECTOR is std_logic_vector (SEVEN_BIT -1 downto 0);
SubType EIGHT_BIT_VECTOR is std_logic_vector (EIGHT_BIT -1 downto 0);
SubType NINE_BIT_VECTOR is std_logic_vector (NINE_BIT -1 downto 0);
SubType TEN_BIT_VECTOR is std_logic_vector (TEN_BIT -1 downto 0);
SubType THIRTEEN_BIT_VECTOR is std_logic_vector (THIRTEEN_BIT -1 downto 0);



--constant ADD_T1 : A_DEC_TYPE := "000000001";
--constant ADD_T2 : A_DEC_TYPE := "000000010";
--constant ADD_TAB : A_DEC_TYPE := "000000100";
--constant ADD_TAH : A_DEC_TYPE := "000001000";
--constant ADD_TBB : A_DEC_TYPE := "000010000";
--constant ADD_TBH : A_DEC_TYPE := "000100000";
--constant ADD_TONH : A_DEC_TYPE := "001000000";
--constant ADD_TONL : A_DEC_TYPE := "010000000";
--constant ADD_TP : A_DEC_TYPE := "100000000";
--constant ADD_FR1 : SPLIT_INJ_CMD_TYPE := "001";
--constant ADD_FR2 : SPLIT_INJ_CMD_TYPE := "010";

attribute timespec: string;
attribute ts: string;

END uni_types ; 

------------------------------------------------------------------------------
--  ____  _                 _ 
-- | __ )| |_   _  ___  ___| |
-- |  _ \| | | | |/ _ \/ __| |
-- | |_) | | |_| |  __/\__ \_|
-- |____/|_|\__,_|\___||___(_)                           
------------------------------------------------------------------------------
-- component that make some noise between input and outputs
-- now it put on output what is on input
LIBRARY ieee ;
USE ieee.std_logic_1164.all;

ENTITY dwand IS
PORT (i0, i1, i2, i3, i4: in std_logic; o: out std_logic );
END dwand;

ARCHITECTURE behav OF dwand IS
begin
	o <= (i0 AND i1 AND i2 AND i3 AND i4);
end behav;

-- component do nothing
LIBRARY ieee ;
USE ieee.std_logic_1164.all;

ENTITY startup IS
PORT (gsr: in std_logic);
END startup;

ARCHITECTURE behav OF startup IS
begin
	-- do nothing !
end behav;
------------------------------------------------------------------------------
------------------------------------------------------------------------------

LIBRARY ieee ;
USE ieee.std_logic_1164.all;

--
-- Component : filter
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY filter IS
   PORT ( 
      clock : IN std_logic;
      new_value : IN std_logic;
      rst : IN std_logic;
      filtered_value : OUT std_logic
   );
END filter ;
--
-- Component : filter
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/filtering/filter/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF filter IS
   TYPE filter_state_type is (
      start_state,
      zero_1,
      zero_2,
      zero_3,
      one_0,
      one_1,
      one_2,
      one_3
   );


   -- SDS Defined State Signals
   SIGNAL current_state : filter_state_type := start_state ;
   SIGNAL next_state : filter_state_type := start_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      new_value,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= start_state;
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;
      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      new_value,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN start_state =>
         IF ( new_value = '0' ) THEN
            next_state <= start_state;
         ELSIF ( new_value = '1' ) THEN
            next_state <= zero_1;
         END IF;

      WHEN zero_1 =>
         IF ( new_value = '1' ) THEN
            next_state <= zero_2;
         ELSIF ( new_value = '0' ) THEN
            next_state <= start_state;
         END IF;

      WHEN zero_2 =>
         IF ( new_value = '1' ) THEN
            next_state <= zero_3;
         ELSIF ( new_value = '0' ) THEN
            next_state <= zero_1;
         END IF;

      WHEN zero_3 =>
         IF ( new_value = '1' ) THEN
            next_state <= one_0;
         ELSIF ( new_value = '0' ) THEN
            next_state <= zero_2;
         END IF;

      WHEN one_0 =>
         IF ( new_value = '1' ) THEN
            next_state <= one_0;
         ELSIF ( new_value = '0' ) THEN
            next_state <= one_1;
         END IF;

      WHEN one_1 =>
         IF ( new_value = '1' ) THEN
            next_state <= one_0;
         ELSIF ( new_value = '0' ) THEN
            next_state <= one_2;
         END IF;

      WHEN one_2 =>
         IF ( new_value = '1' ) THEN
            next_state <= one_1;
         ELSIF ( new_value = '0' ) THEN
            next_state <= one_3;
         END IF;

      WHEN one_3 =>
         IF ( new_value = '1' ) THEN
            next_state <= one_2;
         ELSIF ( new_value = '0' ) THEN
            next_state <= start_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;

   -------------------------------------------------------------------
   unclocked : PROCESS (
      current_state
   )
   -------------------------------------------------------------------
   BEGIN

      -- State Actions
      CASE current_state IS
      WHEN start_state =>
         filtered_value<='0';
      WHEN zero_1 =>
         filtered_value <= '0';
      WHEN zero_2 =>
         filtered_value <= '0';
      WHEN zero_3 =>
         filtered_value <= '0';
      WHEN one_0 =>
         filtered_value <= '1';
      WHEN one_1 =>
         filtered_value <= '1';
      WHEN one_2 =>
         filtered_value <= '1';
      WHEN one_3 =>
         filtered_value <= '1';
      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS unclocked ;
END behav ;
 
--
-- Component : filtering
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY filtering IS
   PORT ( 
      clock : IN std_logic;
      new_value : IN std_logic;
      rst : IN std_logic;
      filtered_value : OUT std_logic
   );
END filtering ;
--
-- Component : filtering
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 15, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/filtering/behav
--

ARCHITECTURE behav OF filtering IS
   COMPONENT filter
      PORT ( 
         clock : IN std_logic;
         new_value : IN std_logic;
         rst : IN std_logic;
         filtered_value : OUT std_logic
      );
   END COMPONENT ;

   FOR ALL : filter USE ENTITY work.filter(behav) ;

BEGIN

   instance_filter : filter
      PORT MAP ( 
         clock,
         new_value,
         rst,
         filtered_value
      );


END behav ;
 
--
-- Component : uni_types
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 28, 1996
--

--
-- Component : internal_register
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY internal_register IS
   PORT ( 
      clock : IN std_logic;
      cs0 : IN four_bit_vector;
      cs2 : IN std_logic;
      rst : IN std_logic;
      r_t1 : IN eight_bit_vector;
      r_t2 : IN seven_bit_vector;
      r_t3 : IN eight_bit_vector;
      r_t4 : IN seven_bit_vector;
      r_tb : IN ten_bit_vector;
      r_th : IN reg_type;
      r_tonh : IN seven_bit_vector;
      r_tonl : IN seven_bit_vector;
      r_tp : IN seven_bit_vector;
      sh_mode : OUT std_logic;
      stop_count_bus : OUT reg_type;
      t4_0 : OUT std_logic;
      th_0 : OUT std_logic;
      ton_reg : OUT seven_bit_vector;
      tp_reg : OUT seven_bit_vector
   );
END internal_register ;
--
-- Component : internal_register
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF internal_register IS

   signal th: reg_type;
   signal tb: ten_bit_vector;
   signal tonh, tonl: seven_bit_vector;

BEGIN

   -------------------------------------------------------------------
   vhdl_internal_register : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
         tb <= (others => '0');
         th <= (others => '0');
         tonh <= (others => '0');
         tonl <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         if (cs2 = '1') then
            tb <= r_tb;
            th <= r_th;
            tonh <= r_tonh;
            tonl <= r_tonl;
         end if;
      END IF;
   END PROCESS vhdl_internal_register ;



   tp_reg <= r_tp;
   sh_mode <= tb (9);
   th_0 <= not(th(0) or th(1) or th(2) or th(3) or th(4) or th(5) or th(6) or th(7) or th(8) or th(9) or th(10) or th(11));
   t4_0 <= not(r_t4(6) or r_t4(5) or r_t4(4) or r_t4(3));

stop_count_bus <= "00000" & r_t1(7 downto 1) when cs0 = "0000" else "ZZZZZZZZZZZZ";   -- Conta per t1/2
ton_reg <= tonh when cs0 = "0000" else "ZZZZZZZ";

stop_count_bus <= "00000" & r_t1(7 downto 1) when cs0 = "0001" else "ZZZZZZZZZZZZ";   -- Conta per t1/2
ton_reg <= tonh when cs0 = "0001" else "ZZZZZZZ";

stop_count_bus <= "000" & tb(8 downto 0) when cs0 = "0010" else "ZZZZZZZZZZZZ";
ton_reg <= tonh when cs0 = "0010" else "ZZZZZZZ";

stop_count_bus <= "00000" & r_t2 when cs0 = "0011" else "ZZZZZZZZZZZZ";
ton_reg <= tonl when cs0 = "0011" else "ZZZZZZZ";

stop_count_bus <= th when cs0 = "0100" else "ZZZZZZZZZZZZ";
ton_reg <= tonl when cs0 = "0100" else "ZZZZZZZ";

stop_count_bus <= "00000" & r_t1(7 downto 1) when cs0 = "0101" else "ZZZZZZZZZZZZ";   -- Conta per t1/2
ton_reg <= tonl when cs0 = "0101" else "ZZZZZZZ";

stop_count_bus <= "0000" & r_t3 when cs0 = "0110" else "ZZZZZZZZZZZZ";
ton_reg <= tonl when cs0 = "0110" else "ZZZZZZZ";

stop_count_bus <= "000" & r_t1 & '0' when cs0 = "0111" else "ZZZZZZZZZZZZ";   -- Conta per 2*t1
ton_reg <= tonl when cs0 = "0111" else "ZZZZZZZ";

stop_count_bus <= "00000" & r_t4 when cs0 = "1100" else "ZZZZZZZZZZZZ";
ton_reg <= tonl when cs0 = "1100" else "ZZZZZZZ";

stop_count_bus <= "0000" & r_t1 when cs0(3 downto 1) = "111" else "ZZZZZZZZZZZZ";
ton_reg <= tonl when cs0(3 downto 1) = "111" else "ZZZZZZZ";


END behav ;
 
--
-- Component : state_progression
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY state_progression IS
   PORT ( 
      clock : IN std_logic;
      cmd_stored : IN split_inj_cmd_type;
      comp : IN std_logic;
      enable_check : IN std_logic;
      end_t0 : IN std_logic;
      global_state : IN glob_state_reg_type;
      inj_cmd : IN split_inj_cmd_type;
      i_fbk : IN std_logic;
      rst : IN std_logic;
      sh_mode : IN std_logic;
      status_reg : IN st_reg_type;
      t4_0 : IN std_logic;
      th_0 : IN std_logic;
      v_fbk_cur : IN std_logic;
      v_fbk_mask : IN split_inj_cmd_type;
      cur_state : OUT five_bit_vector
   );
END state_progression ;
--
-- Component : state_progression
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/state_progression/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF state_progression IS
   TYPE state_progression_state_type is (
      start_state,
      ph1bis_state,
      ph2_state,
      ph3_state,
      ph4_state,
      ph5_state,
      ph1_state,
      cc_vcc_state,
      cc_gnd_state,
      int1_state,
      int_2_state,
      int3_state,
      int4_state,
      int5_state,
      int6_state,
      ph6_state,
      int7_state,
      ph7_state,
      int8_state,
      ph8_state,
      int9_state,
      ph9_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : state_progression_state_type := start_state ;
   SIGNAL next_state : state_progression_state_type := start_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      cmd_stored,
      comp,
      enable_check,
      end_t0,
      global_state,
      inj_cmd,
      i_fbk,
      rst,
      sh_mode,
      status_reg,
      t4_0,
      th_0,
      v_fbk_cur,
      v_fbk_mask
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= start_state;
         -- Start State Actions
         cur_state <= "00000";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN start_state =>
            cur_state <= "00000";
         WHEN ph1bis_state =>
            cur_state <= "00011";
         WHEN ph2_state =>
            cur_state <= "00101";
         WHEN ph3_state =>
            cur_state <= "00111";
         WHEN ph4_state =>
            cur_state <= "01001";
         WHEN ph5_state =>
            cur_state <= "01011";
         WHEN ph1_state =>
            cur_state <= "00001";
         WHEN cc_vcc_state =>
            cur_state <= "11100";
         WHEN cc_gnd_state =>
            cur_state <= "11101";
         WHEN int1_state =>
            cur_state <= "00010";
         WHEN int_2_state =>
            cur_state <= "00100";
         WHEN int3_state =>
            cur_state <= "00110";
         WHEN int4_state =>
            cur_state <= "01000";
         WHEN int5_state =>
            cur_state <= "01010";
         WHEN int6_state =>
            cur_state <= "01100";
         WHEN ph6_state =>
            cur_state <= "01101";
         WHEN int7_state =>
            cur_state <= "01110";
         WHEN ph7_state =>
            cur_state <= "01111";
         WHEN int8_state =>
            cur_state <= "11000";
         WHEN ph8_state =>
            cur_state <= "11001";
         WHEN int9_state =>
            cur_state <= "01010";
         WHEN ph9_state =>
            cur_state <= "01011";
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      cmd_stored,
      comp,
      enable_check,
      end_t0,
      global_state,
      inj_cmd,
      i_fbk,
      rst,
      sh_mode,
      status_reg,
      t4_0,
      th_0,
      v_fbk_cur,
      v_fbk_mask
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN start_state =>
         IF ( inj_cmd /= "000" and v_fbk_mask = "000" ) THEN
            next_state <= ph1_state;
         ELSIF ( inj_cmd /= "000" and v_fbk_mask /= "000" and enable_check = '0' ) THEN
            next_state <= ph1_state;
         ELSIF ( inj_cmd /= "000" and v_fbk_mask /= "000" and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         END IF;

      WHEN ph1bis_state =>
         IF ( comp = '1' and v_fbk_cur = '1' ) THEN
            next_state <= int_2_state;
         ELSIF ( v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         ELSIF ( comp = '1' and v_fbk_cur = '0' and enable_check = '0' ) THEN
            next_state <= int_2_state;
         END IF;

      WHEN ph2_state =>
         IF ( comp = '1' and ((v_fbk_cur = '0' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '1') or (global_state(1 downto 0) = "00")) ) THEN
            next_state <= int3_state;
         ELSIF ( global_state(1 downto 0) = "01" and v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         ELSIF ( global_state(1 downto 0) = "11" and v_fbk_cur = '1' and enable_check = '1' ) THEN
            next_state <= cc_vcc_state;
         ELSIF ( comp = '1' and ((v_fbk_cur = '1' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '0') or (global_state(1 downto 0) = "00")) and enable_check = '0' ) THEN
            next_state <= int3_state;
         END IF;

      WHEN ph3_state =>
         IF ( v_fbk_cur = '0' and comp = '1' and th_0 = '0' ) THEN
            next_state <= int4_state;
         ELSIF ( v_fbk_cur = '1' and enable_check = '1' ) THEN
            next_state <= cc_vcc_state;
         ELSIF ( v_fbk_cur = '0' and th_0 = '1' and comp = '1' ) THEN
            next_state <= int5_state;
         ELSIF ( v_fbk_cur = '1' and comp = '1' and th_0 = '0' and enable_check = '0' ) THEN
            next_state <= int4_state;
         ELSIF ( v_fbk_cur = '1' and th_0 = '1' and comp = '1' and enable_check = '0' ) THEN
            next_state <= int5_state;
         END IF;

      WHEN ph4_state =>
         IF ( comp = '1' and ((v_fbk_cur = '0' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '1') or (global_state(1 downto 0) = "00")) ) THEN
            next_state <= int5_state;
         ELSIF ( global_state(1 downto 0) = "11" and v_fbk_cur = '1' and enable_check = '1' ) THEN
            next_state <= cc_vcc_state;
         ELSIF ( global_state(1 downto 0) = "01" and v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         ELSIF ( comp = '1' and ((v_fbk_cur = '1' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '0') or (global_state(1 downto 0) = "00")) and enable_check = '0' ) THEN
            next_state <= int5_state;
         END IF;

      WHEN ph5_state =>
         IF ( comp = '1' and t4_0 = '1' ) THEN
            next_state <= start_state;
         ELSIF ( comp = '1' and t4_0 = '0' ) THEN
            next_state <= int6_state;
         END IF;

      WHEN ph1_state =>
         IF ( comp = '1' and v_fbk_cur = '1' and ((i_fbk = '1' and sh_mode = '1') or (sh_mode = '0')) ) THEN
            next_state <= int1_state;
         ELSIF ( v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         ELSIF ( global_state(0) = '1' and comp = '1' and v_fbk_cur = '1' and i_fbk = '0' and sh_mode = '1' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         ELSIF ( inj_cmd /= cmd_stored and global_state(0) = '0' ) THEN
            next_state <= start_state;
         ELSIF ( comp = '1' and (v_fbk_cur = '0' or ((i_fbk = '0' and sh_mode = '1') or (sh_mode = '0'))) and enable_check = '0' ) THEN
            next_state <= int1_state;
         END IF;

      WHEN cc_vcc_state =>
         IF ( status_reg = "00000000000" ) THEN
            next_state <= start_state;
         END IF;

      WHEN cc_gnd_state =>
         IF ( status_reg = "00000000000" ) THEN
            next_state <= start_state;
         END IF;

      WHEN int1_state =>
         IF ( TRUE ) THEN
            next_state <= ph1bis_state;
         END IF;

      WHEN int_2_state =>
         IF ( TRUE ) THEN
            next_state <= ph2_state;
         END IF;

      WHEN int3_state =>
         IF ( TRUE ) THEN
            next_state <= ph3_state;
         END IF;

      WHEN int4_state =>
         IF ( TRUE ) THEN
            next_state <= ph4_state;
         END IF;

      WHEN int5_state =>
         IF ( TRUE ) THEN
            next_state <= ph5_state;
         END IF;

      WHEN int6_state =>
         IF ( TRUE ) THEN
            next_state <= ph6_state;
         END IF;

      WHEN ph6_state =>
         IF ( comp = '1' ) THEN
            next_state <= int7_state;
         END IF;

      WHEN int7_state =>
         IF ( TRUE ) THEN
            next_state <= ph7_state;
         END IF;

      WHEN ph7_state =>
         IF ( comp = '1' and v_fbk_cur = '0' and enable_check = '0' ) THEN
            next_state <= int8_state;
         ELSIF ( comp = '1' and v_fbk_cur = '1' ) THEN
            next_state <= int8_state;
         ELSIF ( v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         END IF;

      WHEN int8_state =>
         IF ( TRUE ) THEN
            next_state <= ph8_state;
         END IF;

      WHEN ph8_state =>
         IF ( comp = '1' and ((v_fbk_cur = '1' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '0') or (global_state(1 downto 0) = "00")) and enable_check = '0' ) THEN
            next_state <= int9_state;
         ELSIF ( comp = '1' and ((v_fbk_cur = '0' and global_state(1 downto 0) = "11") or (global_state(1 downto 0) = "10") or (global_state(1 downto 0) = "01" and v_fbk_cur = '1') or (global_state(1 downto 0) = "00")) ) THEN
            next_state <= int9_state;
         ELSIF ( global_state(1 downto 0) = "11" and v_fbk_cur = '1' and enable_check = '1' ) THEN
            next_state <= cc_vcc_state;
         ELSIF ( global_state(1 downto 0) = "01" and v_fbk_cur = '0' and enable_check = '1' ) THEN
            next_state <= cc_gnd_state;
         END IF;

      WHEN int9_state =>
         IF ( TRUE ) THEN
            next_state <= ph9_state;
         END IF;

      WHEN ph9_state =>
         IF ( comp = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : ph1_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph1_handle IS
   PORT ( 
      clock : IN std_logic;
      cmd_stored : IN split_inj_cmd_type;
      cur_state : IN five_bit_vector;
      end_t0 : IN std_logic;
      inj_cmd : IN split_inj_cmd_type;
      rst : IN std_logic;
      global1_state : OUT std_logic
   );
END ph1_handle ;
--
-- Component : ph1_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/ph1_handle/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF ph1_handle IS
   TYPE ph1_handle_state_type is (
      ph1_1_state,
      ph1_2_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : ph1_handle_state_type := ph1_1_state ;
   SIGNAL next_state : ph1_handle_state_type := ph1_1_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      cmd_stored,
      cur_state,
      end_t0,
      inj_cmd,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= ph1_1_state;
         -- Start State Actions
         global1_state <= '0';
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN ph1_1_state =>
            global1_state <= '0';
         WHEN ph1_2_state =>
            global1_state <= '1';
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      cmd_stored,
      cur_state,
      end_t0,
      inj_cmd,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN ph1_1_state =>
         IF ( end_t0 = '1' and (inj_cmd = cmd_stored) and cur_state = "00001" ) THEN
            next_state <= ph1_2_state;
         ELSIF ( cur_state /= "00001" ) THEN
            next_state <= ph1_1_state;
         END IF;

      WHEN ph1_2_state =>
         IF ( cur_state /= "00001" ) THEN
            next_state <= ph1_1_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : sel_global_state
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY sel_global_state IS
   PORT ( 
      cur_state : IN five_bit_vector;
      global1_state : IN std_logic;
      global2_state : IN two_bit_vector;
      global4_state : IN two_bit_vector;
      global_state : OUT glob_state_reg_type
   );
END sel_global_state ;
--
-- Component : sel_global_state
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 26, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF sel_global_state IS

BEGIN

process (cur_state, global1_state, global2_state, global4_state)
begin

	global_state (6 downto 2) <= cur_state;
	
   case cur_state is
      when "00001" => global_state(1 downto 0) <= '0' & global1_state;
      when "00101" => global_state(1 downto 0) <= global2_state;
      when "01001" => global_state(1 downto 0) <= global4_state;
      when "11001" => global_state(1 downto 0) <= global4_state;
      when others => global_state(1 downto 0) <= "00";
   end case;

end process;

END behav ;
 
--
-- Component : sel_actuator
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY sel_actuator IS
   PORT ( 
      cur_state : IN five_bit_vector;
      t12 : IN std_logic;
      t14 : IN std_logic;
      t31 : IN std_logic;
      hl : OUT std_logic;
      t1 : OUT std_logic;
      t2 : OUT std_logic;
      t3 : OUT std_logic
   );
END sel_actuator ;
--
-- Component : sel_actuator
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF sel_actuator IS

BEGIN

vhdl_sel_actuator: process (t31, t12, t14, cur_state)

begin

   case cur_state is
      when "00000" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "00001" => 
                     hl <= '0';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= t31;              
      when "00010" => 
                     hl <= '1';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '1';              
      when "00011" => 
                     hl <= '1';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '1';              
      when "00100" => 
                     hl <= '1';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '0';              
      when "00101" => 
                     hl <= '1';
                     t1 <= t12;
                     t2 <= '1';
                     t3 <= '0';              
      when "00110" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "00111" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "01000" => 
                     hl <= '0';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '0';              
      when "01001" => 
                     hl <= '0';
                     t1 <= t14;
                     t2 <= '1';
                     t3 <= '0';              
      when "01010" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "01011" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "01100" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "01101" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';              
      when "01110" => 
                     hl <= '0';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '0';              
      when "01111" => 
                     hl <= '0';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '0';
      when "11000" => 
                     hl <= '0';
                     t1 <= '1';
                     t2 <= '1';
                     t3 <= '0';              
      when "11001" => 
                     hl <= '0';
                     t1 <= t14;
                     t2 <= '1';
                     t3 <= '0';              
      when "11100" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';
      when "11101" => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';
      when others => 
                     hl <= '0';
                     t1 <= '0';
                     t2 <= '0';
                     t3 <= '0';
   end case;

end process;

END behav ;
 
--
-- Component : ph2_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph2_handle IS
   PORT ( 
      clock : IN std_logic;
      cur_state : IN five_bit_vector;
      end_on : IN std_logic;
      end_period : IN std_logic;
      i_fbk : IN std_logic;
      rst : IN std_logic;
      sh_mode : IN std_logic;
      global2_state : OUT two_bit_vector
   );
END ph2_handle ;
--
-- Component : ph2_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/ph2_handle/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF ph2_handle IS
   TYPE ph2_handle_state_type is (
      ph2_1_state,
      ph2_2_state,
      ph2_3_state,
      ph2_4_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : ph2_handle_state_type := ph2_1_state ;
   SIGNAL next_state : ph2_handle_state_type := ph2_1_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      cur_state,
      end_on,
      end_period,
      i_fbk,
      rst,
      sh_mode
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= ph2_1_state;
         -- Start State Actions
         global2_state <= "01";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN ph2_1_state =>
            global2_state <= "01";
         WHEN ph2_2_state =>
            global2_state <= "10";
         WHEN ph2_3_state =>
            global2_state <= "11";
         WHEN ph2_4_state =>
            global2_state <= "00";
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      cur_state,
      end_on,
      end_period,
      i_fbk,
      rst,
      sh_mode
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN ph2_1_state =>
         IF ( cur_state = "00101" and ((sh_mode = '1' and i_fbk = '1') or (sh_mode = '0' and end_on = '1')) ) THEN
            next_state <= ph2_2_state;
         ELSIF ( cur_state /= "00101" ) THEN
            next_state <= ph2_1_state;
         END IF;

      WHEN ph2_2_state =>
         IF ( cur_state = "00101" ) THEN
            next_state <= ph2_3_state;
         ELSIF ( cur_state /= "00101" ) THEN
            next_state <= ph2_1_state;
         END IF;

      WHEN ph2_3_state =>
         IF ( cur_state = "00101" and ((sh_mode = '1' and i_fbk = '0') or (sh_mode = '0' and end_period = '1')) ) THEN
            next_state <= ph2_4_state;
         ELSIF ( cur_state /= "00101" ) THEN
            next_state <= ph2_1_state;
         END IF;

      WHEN ph2_4_state =>
         IF ( TRUE ) THEN
            next_state <= ph2_1_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : ph4_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph4_handle IS
   PORT ( 
      clock : IN std_logic;
      cur_state : IN five_bit_vector;
      end_on : IN std_logic;
      end_period : IN std_logic;
      i_fbk : IN std_logic;
      rst : IN std_logic;
      sh_mode : IN std_logic;
      global4_state : OUT two_bit_vector
   );
END ph4_handle ;
--
-- Component : ph4_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/ph4_handle/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF ph4_handle IS
   TYPE ph4_handle_state_type is (
      ph4_1_state,
      ph4_2_state,
      ph4_3_state,
      ph4_4_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : ph4_handle_state_type := ph4_1_state ;
   SIGNAL next_state : ph4_handle_state_type := ph4_1_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      cur_state,
      end_on,
      end_period,
      i_fbk,
      rst,
      sh_mode
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= ph4_1_state;
         -- Start State Actions
         global4_state <= "01";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN ph4_1_state =>
            global4_state <= "01";
         WHEN ph4_2_state =>
            global4_state <= "10";
         WHEN ph4_3_state =>
            global4_state <= "11";
         WHEN ph4_4_state =>
            global4_state <= "00";
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      cur_state,
      end_on,
      end_period,
      i_fbk,
      rst,
      sh_mode
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN ph4_1_state =>
         IF ( cur_state = "01001" and ((sh_mode = '1' and i_fbk = '1') or (sh_mode = '0' and end_on = '1')) ) THEN
            next_state <= ph4_2_state;
         ELSIF ( cur_state /= "01001" and cur_state /= "11001" ) THEN
            next_state <= ph4_1_state;
         ELSIF ( cur_state = "11001" and ((sh_mode = '1' and i_fbk = '1') or (sh_mode = '0' and end_on = '1')) ) THEN
            next_state <= ph4_2_state;
         END IF;

      WHEN ph4_2_state =>
         IF ( cur_state = "01001" or cur_state = "11001" ) THEN
            next_state <= ph4_3_state;
         ELSIF ( cur_state /= "01001" and cur_state /= "11001" ) THEN
            next_state <= ph4_1_state;
         END IF;

      WHEN ph4_3_state =>
         IF ( cur_state = "01001" and ((sh_mode = '1' and i_fbk = '0') or (sh_mode = '0' and end_period = '1')) ) THEN
            next_state <= ph4_4_state;
         ELSIF ( cur_state /= "01001" and cur_state /= "11001" ) THEN
            next_state <= ph4_1_state;
         ELSIF ( cur_state = "11001" and ((sh_mode = '1' and i_fbk = '0') or (sh_mode = '0' and end_period = '1')) ) THEN
            next_state <= ph4_4_state;
         END IF;

      WHEN ph4_4_state =>
         IF ( TRUE ) THEN
            next_state <= ph4_1_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : sel_chop_control
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY sel_chop_control IS
   PORT ( 
      cs42 : IN std_logic;
      cs44 : IN std_logic;
      cur_state : IN five_bit_vector;
      cs4 : OUT std_logic
   );
END sel_chop_control ;
--
-- Component : sel_chop_control
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF sel_chop_control IS

BEGIN

vhdl_sel_chop_control: process (cs42, cs44, cur_state)
begin
   
   case cur_state is
      when "00101" => cs4 <= cs42;
      when "01001" => cs4 <= cs44;
      when "11001" => cs4 <= cs44;
      when others => cs4 <= '1';
   end case;

end process;

END behav ;
 
--
-- Component : sel_glob_count_cs
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY sel_glob_count_cs IS
   PORT ( 
      cs11 : IN std_logic;
      cs111 : IN std_logic;
      cur_state : IN five_bit_vector;
      global1_state : IN std_logic;
      cs1 : OUT std_logic;
      cs2 : OUT std_logic;
      cs8 : OUT std_logic
   );
END sel_glob_count_cs ;
--
-- Component : sel_glob_count_cs
--
-- Generated by System Architect version v8.4_3.7 by filu on Nov 13, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF sel_glob_count_cs IS
BEGIN

   -------------------------------------------------------------------
   vhdl_sel_glob_count_cs : PROCESS (
      cs11,
      cs111,
      cur_state,
      global1_state
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (cur_state = "00001") then
         cs1 <= cs111;
         if (global1_state = '0') then
            cs2 <= '1';
         else
            cs2 <= '0';
         end if;
         cs8 <= '0';
      elsif (cur_state = "00000") then
         cs1 <= cs11;
         cs2 <= '1';
         cs8 <= '1';
      else
         cs1 <= cs11;
         cs2 <= '0';
         cs8 <= '1';
      end if;
   END PROCESS vhdl_sel_glob_count_cs ;
END behav ;
 
--
-- Component : fsm_output_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY fsm_output_handle IS
   PORT ( 
      cur_state : IN five_bit_vector;
      en_fbk_store : IN std_logic;
      cs0 : OUT four_bit_vector;
      cs11 : OUT std_logic;
      error : OUT std_logic;
      relpot : OUT std_logic
   );
END fsm_output_handle ;
--
-- Component : cs0_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 18, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF fsm_output_handle IS
BEGIN

   relpot <= cur_state(4) and cur_state(3) and cur_state(2) and cur_state(0);
   cs0 <= cur_state(4 downto 1);
   error <= cur_state(4) and cur_state(3) and cur_state(2) and not(en_fbk_store);
   
   process(cur_state)
   begin
   case cur_state is
      when "00000" => cs11 <= '1';
      when "00010" => cs11 <= '1';
      when "00100" => cs11 <= '1';
      when "00110" => cs11 <= '1';
      when "01000" => cs11 <= '1';
      when "01010" => cs11 <= '1';
      when "01100" => cs11 <= '1';
      when "01110" => cs11 <= '1';
      when "11000" => cs11 <= '1';
      when others => cs11 <= '0';
   end case;
   end process;


END behav ;
 
--
-- Component : ph4_output_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph4_output_handle IS
   PORT ( 
      global4_state : IN two_bit_vector;
      cs44 : OUT std_logic;
      t14 : OUT std_logic
   );
END ph4_output_handle ;
--
-- Component : ph4_output_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 19, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF ph4_output_handle IS
BEGIN

--   t14 <= not(not(global4_state(2)) and global4_state(1));
--   cs44 <= not (global4_state(1)) and not(global4_state(0));
process(global4_state)
BEGIN
   if (global4_state = "00") then
      cs44 <= '1';
   else
      cs44 <= '0';
   end if;

   if (global4_state(1) = '1') then
      t14 <= '0';
   else
      t14 <= '1';
   end if;
END process;

END behav ;
 
--
-- Component : ph2_output_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph2_output_handle IS
   PORT ( 
      global2_state : IN two_bit_vector;
      cs42 : OUT std_logic;
      t12 : OUT std_logic
   );
END ph2_output_handle ;
--
-- Component : ph2_output_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 19, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF ph2_output_handle IS
BEGIN

process(global2_state)
BEGIN
   if (global2_state = "00") then
      cs42 <= '1';
   else
      cs42 <= '0';
   end if;

   if (global2_state(1) = '1') then
      t12 <= '0';
   else
      t12 <= '1';
   end if;
END process;

END behav ;
 
--
-- Component : ph1_output_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ph1_output_handle IS
   PORT ( 
      global1_state : IN std_logic;
      cs111 : OUT std_logic;
      t31 : OUT std_logic
   );
END ph1_output_handle ;
--
-- Component : ph1_output_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 19, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF ph1_output_handle IS
BEGIN


process (global1_state)
BEGIN
   if (global1_state = '1') then
      t31 <= '1';
      cs111 <= '0';
   else
      t31 <= '0';
      cs111 <= '1';
   end if;
END process;
END behav ;
 
--
-- Component : enable_fbk_chk
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY enable_fbk_chk IS
   PORT ( 
      clock : IN std_logic;
      global_state : IN glob_state_reg_type;
      rst : IN std_logic;
      test_en_cur : IN std_logic;
      enable_check : OUT std_logic;
      en_fbk_store : OUT std_logic;
      en_state_store : OUT std_logic;
      global_state_store : OUT glob_state_reg_type
   );
END enable_fbk_chk ;
--
-- Component : enable_fbk_chk
--
-- Generated by System Architect version v8.4_3.7 by manzone on Jul 21, 1997
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF enable_fbk_chk IS

signal global_state_store_int : std_logic_vector(6 downto 0);
signal delay_counter : three_bit_vector;

BEGIN

process (clock, rst)
begin
   if (rst = '0') then
      global_state_store_int <= "0000000";
   elsif (clock'event and clock = '1') then
      global_state_store_int <= global_state;
   end if;
end process;


process (clock, rst)
begin
   if (rst = '0') then
      delay_counter <= "000";
   elsif (clock'event and clock = '1') then
      if (global_state_store_int /= global_state) then
         delay_counter <= "000";
      elsif (delay_counter(2) = '0') then
         delay_counter <= delay_counter + "001";
      end if;
   end if;
end process;



process (delay_counter(2), test_en_cur, global_state, global_state_store_int)
begin
   if ((delay_counter(2) = '1') and (test_en_cur = '1') and (global_state = global_state_store_int)) then
      enable_check <= '1';
   else
      enable_check <= '0';
   end if;

   if (global_state_store_int /= global_state) then
      if (global_state(6 downto 5) /= "11") then
         en_state_store <= '1';
         en_fbk_store <= '1';
      else
         en_state_store <= '0';
         en_fbk_store <= '1';
      end if;
   else
      en_state_store <= '0';
      en_fbk_store <= '0';
   end if;

end process;

global_state_store <= global_state;


END behav ;
 
--
-- Component : fsm
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY fsm IS
   PORT ( 
      clock : IN std_logic;
      cmd_stored : IN split_inj_cmd_type;
      comp : IN std_logic;
      end_on : IN std_logic;
      end_period : IN std_logic;
      end_t0 : IN std_logic;
      inj_cmd : IN split_inj_cmd_type;
      i_fbk : IN std_logic;
      rst : IN std_logic;
      sh_mode : IN std_logic;
      status_reg : IN st_reg_type;
      t4_0 : IN std_logic;
      test_en_cur : IN std_logic;
      th_0 : IN std_logic;
      v_fbk_cur : IN std_logic;
      v_fbk_mask : IN split_inj_cmd_type;
      cs0 : OUT four_bit_vector;
      cs1 : OUT std_logic;
      cs2 : OUT std_logic;
      cs4 : OUT std_logic;
      cs8 : OUT std_logic;
      en_fbk_store : OUT std_logic;
      en_state_store : OUT std_logic;
      error : OUT std_logic;
      global_state_store : OUT glob_state_reg_type;
      hl : OUT std_logic;
      relpot : OUT std_logic;
      t1 : OUT std_logic;
      t2 : OUT std_logic;
      t3 : OUT std_logic
   );
END fsm ;
--
-- Component : fsm
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/fsm/behav
--

ARCHITECTURE behav OF fsm IS
   COMPONENT enable_fbk_chk
      PORT ( 
         clock : IN std_logic;
         global_state : IN glob_state_reg_type;
         rst : IN std_logic;
         test_en_cur : IN std_logic;
         enable_check : OUT std_logic;
         en_fbk_store : OUT std_logic;
         en_state_store : OUT std_logic;
         global_state_store : OUT glob_state_reg_type
      );
   END COMPONENT ;

   COMPONENT fsm_output_handle
      PORT ( 
         cur_state : IN five_bit_vector;
         en_fbk_store : IN std_logic;
         cs0 : OUT four_bit_vector;
         cs11 : OUT std_logic;
         error : OUT std_logic;
         relpot : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT ph1_handle
      PORT ( 
         clock : IN std_logic;
         cmd_stored : IN split_inj_cmd_type;
         cur_state : IN five_bit_vector;
         end_t0 : IN std_logic;
         inj_cmd : IN split_inj_cmd_type;
         rst : IN std_logic;
         global1_state : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT ph1_output_handle
      PORT ( 
         global1_state : IN std_logic;
         cs111 : OUT std_logic;
         t31 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT ph2_handle
      PORT ( 
         clock : IN std_logic;
         cur_state : IN five_bit_vector;
         end_on : IN std_logic;
         end_period : IN std_logic;
         i_fbk : IN std_logic;
         rst : IN std_logic;
         sh_mode : IN std_logic;
         global2_state : OUT two_bit_vector
      );
   END COMPONENT ;

   COMPONENT ph2_output_handle
      PORT ( 
         global2_state : IN two_bit_vector;
         cs42 : OUT std_logic;
         t12 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT ph4_handle
      PORT ( 
         clock : IN std_logic;
         cur_state : IN five_bit_vector;
         end_on : IN std_logic;
         end_period : IN std_logic;
         i_fbk : IN std_logic;
         rst : IN std_logic;
         sh_mode : IN std_logic;
         global4_state : OUT two_bit_vector
      );
   END COMPONENT ;

   COMPONENT ph4_output_handle
      PORT ( 
         global4_state : IN two_bit_vector;
         cs44 : OUT std_logic;
         t14 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT sel_actuator
      PORT ( 
         cur_state : IN five_bit_vector;
         t12 : IN std_logic;
         t14 : IN std_logic;
         t31 : IN std_logic;
         hl : OUT std_logic;
         t1 : OUT std_logic;
         t2 : OUT std_logic;
         t3 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT sel_chop_control
      PORT ( 
         cs42 : IN std_logic;
         cs44 : IN std_logic;
         cur_state : IN five_bit_vector;
         cs4 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT sel_glob_count_cs
      PORT ( 
         cs11 : IN std_logic;
         cs111 : IN std_logic;
         cur_state : IN five_bit_vector;
         global1_state : IN std_logic;
         cs1 : OUT std_logic;
         cs2 : OUT std_logic;
         cs8 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT sel_global_state
      PORT ( 
         cur_state : IN five_bit_vector;
         global1_state : IN std_logic;
         global2_state : IN two_bit_vector;
         global4_state : IN two_bit_vector;
         global_state : OUT glob_state_reg_type
      );
   END COMPONENT ;

   COMPONENT state_progression
      PORT ( 
         clock : IN std_logic;
         cmd_stored : IN split_inj_cmd_type;
         comp : IN std_logic;
         enable_check : IN std_logic;
         end_t0 : IN std_logic;
         global_state : IN glob_state_reg_type;
         inj_cmd : IN split_inj_cmd_type;
         i_fbk : IN std_logic;
         rst : IN std_logic;
         sh_mode : IN std_logic;
         status_reg : IN st_reg_type;
         t4_0 : IN std_logic;
         th_0 : IN std_logic;
         v_fbk_cur : IN std_logic;
         v_fbk_mask : IN split_inj_cmd_type;
         cur_state : OUT five_bit_vector
      );
   END COMPONENT ;

   FOR ALL : enable_fbk_chk USE ENTITY work.enable_fbk_chk(behav) ;
   FOR ALL : fsm_output_handle USE ENTITY work.fsm_output_handle(behav) ;
   FOR ALL : ph1_handle USE ENTITY work.ph1_handle(behav) ;
   FOR ALL : ph1_output_handle USE ENTITY work.ph1_output_handle(behav) ;
   FOR ALL : ph2_handle USE ENTITY work.ph2_handle(behav) ;
   FOR ALL : ph2_output_handle USE ENTITY work.ph2_output_handle(behav) ;
   FOR ALL : ph4_handle USE ENTITY work.ph4_handle(behav) ;
   FOR ALL : ph4_output_handle USE ENTITY work.ph4_output_handle(behav) ;
   FOR ALL : sel_actuator USE ENTITY work.sel_actuator(behav) ;
   FOR ALL : sel_chop_control USE ENTITY work.sel_chop_control(behav) ;
   FOR ALL : sel_glob_count_cs USE ENTITY work.sel_glob_count_cs(behav) ;
   FOR ALL : sel_global_state USE ENTITY work.sel_global_state(behav) ;
   FOR ALL : state_progression USE ENTITY work.state_progression(behav) ;

   -- Internal Signals
   SIGNAL global_state : glob_state_reg_type ;
   SIGNAL enable_check : std_logic ;
   SIGNAL cur_state : five_bit_vector ;
   SIGNAL cs11 : std_logic ;
   SIGNAL global1_state : std_logic ;
   SIGNAL cs111 : std_logic ;
   SIGNAL t31 : std_logic ;
   SIGNAL global2_state : two_bit_vector ;
   SIGNAL cs42 : std_logic ;
   SIGNAL t12 : std_logic ;
   SIGNAL global4_state : two_bit_vector ;
   SIGNAL cs44 : std_logic ;
   SIGNAL t14 : std_logic ;

   -- Internal Buffered Signals
   SIGNAL en_fbk_store_internal : std_logic ;
BEGIN

   instance_enable_fbk_chk : enable_fbk_chk
      PORT MAP ( 
         clock,
         global_state,
         rst,
         test_en_cur,
         enable_check,
         en_fbk_store_internal,
         en_state_store,
         global_state_store
      );

   instance_fsm_output_handle : fsm_output_handle
      PORT MAP ( 
         cur_state,
         en_fbk_store_internal,
         cs0,
         cs11,
         error,
         relpot
      );

   instance_ph1_handle : ph1_handle
      PORT MAP ( 
         clock,
         cmd_stored,
         cur_state,
         end_t0,
         inj_cmd,
         rst,
         global1_state
      );

   instance_ph1_output_handle : ph1_output_handle
      PORT MAP ( 
         global1_state,
         cs111,
         t31
      );

   instance_ph2_handle : ph2_handle
      PORT MAP ( 
         clock,
         cur_state,
         end_on,
         end_period,
         i_fbk,
         rst,
         sh_mode,
         global2_state
      );

   instance_ph2_output_handle : ph2_output_handle
      PORT MAP ( 
         global2_state,
         cs42,
         t12
      );

   instance_ph4_handle : ph4_handle
      PORT MAP ( 
         clock,
         cur_state,
         end_on,
         end_period,
         i_fbk,
         rst,
         sh_mode,
         global4_state
      );

   instance_ph4_output_handle : ph4_output_handle
      PORT MAP ( 
         global4_state,
         cs44,
         t14
      );

   instance_sel_actuator : sel_actuator
      PORT MAP ( 
         cur_state,
         t12,
         t14,
         t31,
         hl,
         t1,
         t2,
         t3
      );

   instance_sel_chop_control : sel_chop_control
      PORT MAP ( 
         cs42,
         cs44,
         cur_state,
         cs4
      );

   instance_sel_glob_count_cs : sel_glob_count_cs
      PORT MAP ( 
         cs11,
         cs111,
         cur_state,
         global1_state,
         cs1,
         cs2,
         cs8
      );

   instance_sel_global_state : sel_global_state
      PORT MAP ( 
         cur_state,
         global1_state,
         global2_state,
         global4_state,
         global_state
      );

   instance_state_progression : state_progression
      PORT MAP ( 
         clock,
         cmd_stored,
         comp,
         enable_check,
         end_t0,
         global_state,
         inj_cmd,
         i_fbk,
         rst,
         sh_mode,
         status_reg,
         t4_0,
         th_0,
         v_fbk_cur,
         v_fbk_mask,
         cur_state
      );

   -- Internal Buffered Signal Mappings
   en_fbk_store <= en_fbk_store_internal ;

END behav ;
 
--
-- Component : comparator
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY comparator IS
   PORT ( 
      count : IN reg_type;
      stop_count_bus : IN reg_type;
      comp : OUT std_logic
   );
END comparator ;
--
-- Component : comparator
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF comparator IS
BEGIN

   -------------------------------------------------------------------
   vhdl_comparator : PROCESS (
      count,
      stop_count_bus
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (count = stop_count_bus) then 
         comp <= '1';
      else
         comp <= '0';
      end if;
   END PROCESS vhdl_comparator ;
END behav ;
 
--
-- Component : counter
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY counter IS
   PORT ( 
      clock : IN std_logic;
      cs1 : IN std_logic;
      rst : IN std_logic;
      count : OUT reg_type
   );
END counter ;
--
-- Component : counter
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF counter IS
 
   signal int_counter : REG_TYPE;

BEGIN

   -------------------------------------------------------------------
   vhdl_counter : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF (rst = '0') then
         int_counter <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         IF ( cs1 = '1' ) THEN
            int_counter <= (others => '0');
         ELSE
            int_counter <= int_counter + "00000000001";
         END IF;
      END IF;
   END PROCESS vhdl_counter ;

   count <= int_counter;

END behav ;
 
--
-- Component : sel_cmd
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY sel_cmd IS
   PORT ( 
      clock : IN std_logic;
      cs2 : IN std_logic;
      inj_cmd : IN split_inj_cmd_type;
      rst : IN std_logic;
      test_en : IN three_bit_vector;
      v_fbk : IN split_inj_cmd_type;
      cmd_stored : OUT split_inj_cmd_type;
      test_en_cur : OUT std_logic;
      v_fbk_cur : OUT std_logic;
      v_fbk_mask : OUT split_inj_cmd_type
   );
END sel_cmd ;
--
-- Component : sel_cmd
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF sel_cmd IS

   signal cmd_stored_int: std_logic_vector(2 downto 0);

BEGIN

   -------------------------------------------------------------------
   vhdl_sel_cmd : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         cmd_stored_int <= "000";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         if (cs2 = '1') then
            cmd_stored_int <= inj_cmd;
         end if;
      END IF;

   END PROCESS vhdl_sel_cmd ;

   process (v_fbk, cmd_stored_int, test_en)
   BEGIN
      case cmd_stored_int is
         when "001" => v_fbk_cur <= v_fbk(0);
                       test_en_cur <= test_en(0);
         when "010" => v_fbk_cur <= v_fbk(1);
                       test_en_cur <= test_en(1);
         when "100" => v_fbk_cur <= v_fbk(2);
                       test_en_cur <= test_en(2);
         when others => v_fbk_cur <= '0';
                        test_en_cur <= '1';
      end case;
   end process;

   v_fbk_mask(0) <= v_fbk(0) and test_en(0);
   v_fbk_mask(1) <= v_fbk(1) and test_en(1);
   v_fbk_mask(2) <= v_fbk(2) and test_en(2);
   cmd_stored <= cmd_stored_int;

END behav ;
 
--
-- Component : output_decoder
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY output_decoder IS
   PORT ( 
      cmd_stored : IN split_inj_cmd_type;
      t1 : IN std_logic;
      t2 : IN std_logic;
      t1a : OUT std_logic;
      t1b : OUT std_logic;
      t1c : OUT std_logic;
      t2a : OUT std_logic;
      t2b : OUT std_logic;
      t2c : OUT std_logic
   );
END output_decoder ;
--
-- Component : output_decoder
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF output_decoder IS
BEGIN

   -------------------------------------------------------------------
   vhdl_output_decoder : PROCESS (
      cmd_stored,
      t1,
      t2
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      
      case cmd_stored is
         when "001" => t1a <= t1;
                       t2a <= t2;
                       t1b <= '0';
                       t2b <= '0';
                       t1c <= '0';
                       t2c <= '0';
         when "010" => t1b <= t1;
                       t2b <= t2;
                       t1a <= '0';
                       t2a <= '0';
                       t1c <= '0';
                       t2c <= '0';
         when "100" => t1c <= t1;
                       t2c <= t2;
                       t1b <= '0';
                       t2b <= '0';
                       t1a <= '0';
                       t2a <= '0';
         when others => t1a <= '0';
                       t2a <= '0';
                       t1b <= '0';
                       t2b <= '0';
                       t1c <= '0';
                       t2c <= '0';
      end case;
   END PROCESS vhdl_output_decoder ;
END behav ;
 
--
-- Component : chopper_count
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY chopper_count IS
   PORT ( 
      clock : IN std_logic;
      cs4 : IN std_logic;
      rst : IN std_logic;
      chop_count : OUT seven_bit_vector
   );
END chopper_count ;
--
-- Component : chopper_count
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF chopper_count IS

   signal int_counter : seven_bit_vector;

BEGIN

   -------------------------------------------------------------------
   vhdl_chopper_count : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;

   BEGIN
      IF (rst = '0') then
         int_counter <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         IF ( cs4 = '1' ) THEN
            int_counter <= (others => '0');
         ELSE
            int_counter <= int_counter + "0000001";
         END IF;
      END IF;

   END PROCESS vhdl_chopper_count ;

   chop_count <= int_counter;
END behav ;
 
--
-- Component : on_comp
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY on_comp IS
   PORT ( 
      chop_count : IN seven_bit_vector;
      ton_reg : IN seven_bit_vector;
      end_on : OUT std_logic
   );
END on_comp ;
--
-- Component : on_comp
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF on_comp IS
BEGIN

   -------------------------------------------------------------------
   vhdl_on_comp : PROCESS (
      chop_count,
      ton_reg
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (chop_count = ton_reg) then
         end_on <= '1';
      else
         end_on <= '0';
      end if;
   END PROCESS vhdl_on_comp ;
END behav ;
 
--
-- Component : period_comp
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY period_comp IS
   PORT ( 
      chop_count : IN seven_bit_vector;
      tp_reg : IN seven_bit_vector;
      end_period : OUT std_logic
   );
END period_comp ;
--
-- Component : period_comp
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF period_comp IS
BEGIN

   -------------------------------------------------------------------
   vhdl_period_comp : PROCESS (
      chop_count,
      tp_reg
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (chop_count = tp_reg) then
         end_period <= '1';
      else
         end_period <= '0';
      end if;
   END PROCESS vhdl_period_comp ;
END behav ;
 
--
-- Component : anti_glitch
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY anti_glitch IS
   PORT ( 
      clock : IN std_logic;
      cs8 : IN std_logic;
      rst : IN std_logic;
      end_t0 : OUT std_logic
   );
END anti_glitch ;
--
-- Component : anti_glitch
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF anti_glitch IS
   
   signal counter : std_logic_vector (2 downto 0);

BEGIN

   -------------------------------------------------------------------
   vhdl_count : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF (rst = '0') then
         counter <= "000";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         IF ( cs8 = '1' ) THEN
            counter <= "000";
         ELSE
            counter <= counter + "001";
         END IF;
      END IF;
   END PROCESS vhdl_count ;

   end_t0 <= counter(0) and counter(1) and counter(2);

END behav ;
 
--
-- Component : inj_block
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY inj_block IS
   PORT ( 
      clock : IN std_logic;
      inj_cmd : IN split_inj_cmd_type;
      i_fbk : IN std_logic;
      rst : IN std_logic;
      r_t1 : IN eight_bit_vector;
      r_t2 : IN seven_bit_vector;
      r_t3 : IN eight_bit_vector;
      r_t4 : IN seven_bit_vector;
      r_tb : IN ten_bit_vector;
      r_th : IN reg_type;
      r_tonh : IN seven_bit_vector;
      r_tonl : IN seven_bit_vector;
      r_tp : IN seven_bit_vector;
      status_reg : IN st_reg_type;
      test_en : IN three_bit_vector;
      v_fbk : IN split_inj_cmd_type;
      en_fbk_store : OUT std_logic;
      en_state_store : OUT std_logic;
      error : OUT std_logic;
      global_state_store : OUT glob_state_reg_type;
      hl : OUT std_logic;
      relpot : OUT std_logic;
      t1a : OUT std_logic;
      t1b : OUT std_logic;
      t1c : OUT std_logic;
      t2a : OUT std_logic;
      t2b : OUT std_logic;
      t2c : OUT std_logic;
      t3 : OUT std_logic
   );
END inj_block ;
--
-- Component : inj_block
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_block/behav
--

ARCHITECTURE behav OF inj_block IS
   COMPONENT anti_glitch
      PORT ( 
         clock : IN std_logic;
         cs8 : IN std_logic;
         rst : IN std_logic;
         end_t0 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT chopper_count
      PORT ( 
         clock : IN std_logic;
         cs4 : IN std_logic;
         rst : IN std_logic;
         chop_count : OUT seven_bit_vector
      );
   END COMPONENT ;

   COMPONENT comparator
      PORT ( 
         count : IN reg_type;
         stop_count_bus : IN reg_type;
         comp : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT counter
      PORT ( 
         clock : IN std_logic;
         cs1 : IN std_logic;
         rst : IN std_logic;
         count : OUT reg_type
      );
   END COMPONENT ;

   COMPONENT fsm
      PORT ( 
         clock : IN std_logic;
         cmd_stored : IN split_inj_cmd_type;
         comp : IN std_logic;
         end_on : IN std_logic;
         end_period : IN std_logic;
         end_t0 : IN std_logic;
         inj_cmd : IN split_inj_cmd_type;
         i_fbk : IN std_logic;
         rst : IN std_logic;
         sh_mode : IN std_logic;
         status_reg : IN st_reg_type;
         t4_0 : IN std_logic;
         test_en_cur : IN std_logic;
         th_0 : IN std_logic;
         v_fbk_cur : IN std_logic;
         v_fbk_mask : IN split_inj_cmd_type;
         cs0 : OUT four_bit_vector;
         cs1 : OUT std_logic;
         cs2 : OUT std_logic;
         cs4 : OUT std_logic;
         cs8 : OUT std_logic;
         en_fbk_store : OUT std_logic;
         en_state_store : OUT std_logic;
         error : OUT std_logic;
         global_state_store : OUT glob_state_reg_type;
         hl : OUT std_logic;
         relpot : OUT std_logic;
         t1 : OUT std_logic;
         t2 : OUT std_logic;
         t3 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT internal_register
      PORT ( 
         clock : IN std_logic;
         cs0 : IN four_bit_vector;
         cs2 : IN std_logic;
         rst : IN std_logic;
         r_t1 : IN eight_bit_vector;
         r_t2 : IN seven_bit_vector;
         r_t3 : IN eight_bit_vector;
         r_t4 : IN seven_bit_vector;
         r_tb : IN ten_bit_vector;
         r_th : IN reg_type;
         r_tonh : IN seven_bit_vector;
         r_tonl : IN seven_bit_vector;
         r_tp : IN seven_bit_vector;
         sh_mode : OUT std_logic;
         stop_count_bus : OUT reg_type;
         t4_0 : OUT std_logic;
         th_0 : OUT std_logic;
         ton_reg : OUT seven_bit_vector;
         tp_reg : OUT seven_bit_vector
      );
   END COMPONENT ;

   COMPONENT on_comp
      PORT ( 
         chop_count : IN seven_bit_vector;
         ton_reg : IN seven_bit_vector;
         end_on : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT output_decoder
      PORT ( 
         cmd_stored : IN split_inj_cmd_type;
         t1 : IN std_logic;
         t2 : IN std_logic;
         t1a : OUT std_logic;
         t1b : OUT std_logic;
         t1c : OUT std_logic;
         t2a : OUT std_logic;
         t2b : OUT std_logic;
         t2c : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT period_comp
      PORT ( 
         chop_count : IN seven_bit_vector;
         tp_reg : IN seven_bit_vector;
         end_period : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT sel_cmd
      PORT ( 
         clock : IN std_logic;
         cs2 : IN std_logic;
         inj_cmd : IN split_inj_cmd_type;
         rst : IN std_logic;
         test_en : IN three_bit_vector;
         v_fbk : IN split_inj_cmd_type;
         cmd_stored : OUT split_inj_cmd_type;
         test_en_cur : OUT std_logic;
         v_fbk_cur : OUT std_logic;
         v_fbk_mask : OUT split_inj_cmd_type
      );
   END COMPONENT ;

   FOR ALL : anti_glitch USE ENTITY work.anti_glitch(behav) ;
   FOR ALL : chopper_count USE ENTITY work.chopper_count(behav) ;
   FOR ALL : comparator USE ENTITY work.comparator(behav) ;
   FOR ALL : counter USE ENTITY work.counter(behav) ;
   FOR ALL : fsm USE ENTITY work.fsm(behav) ;
   FOR ALL : internal_register USE ENTITY work.internal_register(behav) ;
   FOR ALL : on_comp USE ENTITY work.on_comp(behav) ;
   FOR ALL : output_decoder USE ENTITY work.output_decoder(behav) ;
   FOR ALL : period_comp USE ENTITY work.period_comp(behav) ;
   FOR ALL : sel_cmd USE ENTITY work.sel_cmd(behav) ;

   -- Internal Signals
   SIGNAL cs8 : std_logic ;
   SIGNAL end_t0 : std_logic ;
   SIGNAL cs4 : std_logic ;
   SIGNAL chop_count : seven_bit_vector ;
   SIGNAL count : reg_type ;
   SIGNAL stop_count_bus : reg_type ;
   SIGNAL comp : std_logic ;
   SIGNAL cs1 : std_logic ;
   SIGNAL cmd_stored : split_inj_cmd_type ;
   SIGNAL end_on : std_logic ;
   SIGNAL end_period : std_logic ;
   SIGNAL sh_mode : std_logic ;
   SIGNAL t4_0 : std_logic ;
   SIGNAL test_en_cur : std_logic ;
   SIGNAL th_0 : std_logic ;
   SIGNAL v_fbk_cur : std_logic ;
   SIGNAL v_fbk_mask : split_inj_cmd_type ;
   SIGNAL cs0 : four_bit_vector ;
   SIGNAL cs2 : std_logic ;
   SIGNAL t1 : std_logic ;
   SIGNAL t2 : std_logic ;
   SIGNAL ton_reg : seven_bit_vector ;
   SIGNAL tp_reg : seven_bit_vector ;

BEGIN

   instance_anti_glitch : anti_glitch
      PORT MAP ( 
         clock,
         cs8,
         rst,
         end_t0
      );

   instance_chopper_count : chopper_count
      PORT MAP ( 
         clock,
         cs4,
         rst,
         chop_count
      );

   instance_comparator : comparator
      PORT MAP ( 
         count,
         stop_count_bus,
         comp
      );

   instance_counter : counter
      PORT MAP ( 
         clock,
         cs1,
         rst,
         count
      );

   instance_fsm : fsm
      PORT MAP ( 
         clock,
         cmd_stored,
         comp,
         end_on,
         end_period,
         end_t0,
         inj_cmd,
         i_fbk,
         rst,
         sh_mode,
         status_reg,
         t4_0,
         test_en_cur,
         th_0,
         v_fbk_cur,
         v_fbk_mask,
         cs0,
         cs1,
         cs2,
         cs4,
         cs8,
         en_fbk_store,
         en_state_store,
         error,
         global_state_store,
         hl,
         relpot,
         t1,
         t2,
         t3
      );

   instance_internal_register : internal_register
      PORT MAP ( 
         clock,
         cs0,
         cs2,
         rst,
         r_t1,
         r_t2,
         r_t3,
         r_t4,
         r_tb,
         r_th,
         r_tonh,
         r_tonl,
         r_tp,
         sh_mode,
         stop_count_bus,
         t4_0,
         th_0,
         ton_reg,
         tp_reg
      );

   instance_on_comp : on_comp
      PORT MAP ( 
         chop_count,
         ton_reg,
         end_on
      );

   instance_output_decoder : output_decoder
      PORT MAP ( 
         cmd_stored,
         t1,
         t2,
         t1a,
         t1b,
         t1c,
         t2a,
         t2b,
         t2c
      );

   instance_period_comp : period_comp
      PORT MAP ( 
         chop_count,
         tp_reg,
         end_period
      );

   instance_sel_cmd : sel_cmd
      PORT MAP ( 
         clock,
         cs2,
         inj_cmd,
         rst,
         test_en,
         v_fbk,
         cmd_stored,
         test_en_cur,
         v_fbk_cur,
         v_fbk_mask
      );


END behav ;
 
--
-- Component : uni_types
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 28, 1996
--


-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY clock_gen IS
   PORT ( 
      clock_i : INOUT std_logic;
      rst : IN std_logic;
      clock_o : OUT std_logic
   );
END clock_gen ;
--
-- Component : clock_gen
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 26, 1997
--
-- clock :: ck4 rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--


ARCHITECTURE behav OF clock_gen IS

   signal counter: std_logic_vector(3 downto 0);
   signal clock_int: std_logic;

BEGIN

   -------------------------------------------------------------------
   vhdl_clock_gen : PROCESS (
      clock_i,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
			counter <= (others => '0');
         clock_int <= '0';
      ELSIF ( clock_i'EVENT AND clock_i = '1' ) THEN
         if (counter = "1001") then
            counter <= "0000";
            clock_int <= not clock_int;
         else
            counter <= counter + "0001";
         end if;
      END IF;

   END PROCESS vhdl_clock_gen ;

   clock_o <= clock_int;

END behav ;
 
--
-- Component : split
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY split IS
   PORT ( 
      clock: IN std_logic;
      rst: IN std_logic;
      inj_cmd : IN inj_type;
      i_fbk_f : IN inj_t3_type;
      v_fbk_f : IN inj_type;
      inj_cmd_034 : OUT split_inj_cmd_type;
      inj_cmd_125 : OUT split_inj_cmd_type;
      i_fbk_034 : OUT std_logic;
      i_fbk_125 : OUT std_logic;
      v_fbk_034 : OUT split_inj_cmd_type;
      v_fbk_125 : OUT split_inj_cmd_type
   );
END split ;
--
-- Component : split
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF split IS

   signal inj_cmd_int: std_logic_vector(5 downto 0);

BEGIN

   process(clock, rst)
   begin

      if (rst = '0') then
         inj_cmd_int <= (others => '0');
      elsif (clock'event and clock = '1') then
         inj_cmd_int <= inj_cmd;
      end if;

   end process;
   
   -------------------------------------------------------------------
   vhdl_split : PROCESS (
      i_fbk_f,
      inj_cmd_int,
      v_fbk_f
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      i_fbk_034 <= i_fbk_f(0);
      i_fbk_125 <= i_fbk_f(1);
      inj_cmd_034(0) <= inj_cmd_int (0);
      inj_cmd_034(1) <= inj_cmd_int (3);
      inj_cmd_034(2) <= inj_cmd_int (4);
      inj_cmd_125(0) <= inj_cmd_int (1);
      inj_cmd_125(1) <= inj_cmd_int (2);
      inj_cmd_125(2) <= inj_cmd_int (5);
      v_fbk_034(0) <= v_fbk_f(0);
      v_fbk_034(1) <= v_fbk_f(3);
      v_fbk_034(2) <= v_fbk_f(4);
      v_fbk_125(0) <= v_fbk_f(1);
      v_fbk_125(1) <= v_fbk_f(2);
      v_fbk_125(2) <= v_fbk_f(5);
   END PROCESS vhdl_split ;
END behav ;
 
--
-- Component : merge
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY merge IS
   PORT ( 
      error1 : IN std_logic;
      error2 : IN std_logic;
      hl_034 : IN std_logic;
      hl_125 : IN std_logic;
      relpot1 : IN std_logic;
      relpot2 : IN std_logic;
      hlo : OUT inj_t3_type;
      irq : OUT std_logic;
      rel_pot_en : OUT std_logic
   );
END merge ;
--
-- Component : merge
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF merge IS
BEGIN

   rel_pot_en <= relpot2 or relpot1;

   hlo(0) <= not (hl_034);
   hlo(1) <= not (hl_125);
  
   irq <= not (error1 or error2);

END behav ;
 
--
-- Component : interface
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY interface IS
   PORT ( 
      i_fbk : IN inj_t3_type;
      i_fbk_f0 : IN std_logic;
      i_fbk_f1 : IN std_logic;
      v_fbk : IN inj_type;
      v_fbk_f0 : IN std_logic;
      v_fbk_f1 : IN std_logic;
      v_fbk_f2 : IN std_logic;
      v_fbk_f3 : IN std_logic;
      v_fbk_f4 : IN std_logic;
      v_fbk_f5 : IN std_logic;
      i_fbk_0 : OUT std_logic;
      i_fbk_1 : OUT std_logic;
      i_fbk_f : OUT inj_t3_type;
      v_fbk_0 : OUT std_logic;
      v_fbk_1 : OUT std_logic;
      v_fbk_2 : OUT std_logic;
      v_fbk_3 : OUT std_logic;
      v_fbk_4 : OUT std_logic;
      v_fbk_5 : OUT std_logic;
      v_fbk_f : OUT inj_type
   );
END interface ;
--
-- Component : interface
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 30, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF interface IS
BEGIN
   v_fbk_0 <= v_fbk(0);
   v_fbk_1 <= v_fbk(1);
   v_fbk_2 <= v_fbk(2);
   v_fbk_3 <= v_fbk(3);
   v_fbk_4 <= v_fbk(4);
   v_fbk_5 <= v_fbk(5);

   v_fbk_f(0) <= v_fbk_f0;
   v_fbk_f(1) <= v_fbk_f1;
   v_fbk_f(2) <= v_fbk_f2;
   v_fbk_f(3) <= v_fbk_f3;
   v_fbk_f(4) <= v_fbk_f4;
   v_fbk_f(5) <= v_fbk_f5;

   i_fbk_0 <= not(i_fbk(0));
   i_fbk_1 <= not(i_fbk(1));
   
   i_fbk_f(0) <= i_fbk_f0;
   i_fbk_f(1) <= i_fbk_f1;

END behav ;
 
--
-- Component : filter_feedback
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY filter_feedback IS
   PORT ( 
      clock : IN std_logic;
      i_fbk : IN inj_t3_type;
      rst : IN std_logic;
      v_fbk : IN inj_type;
      i_fbk_f : OUT inj_t3_type;
      v_fbk_f : OUT inj_type
   );
END filter_feedback ;
--
-- Component : filter_feedback
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 15, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/filter_feedback/behav
--

-- System/Foreign Instance Libraries

ARCHITECTURE behav OF filter_feedback IS
   COMPONENT filtering
      PORT ( 
         clock : IN std_logic;
         new_value : IN std_logic;
         rst : IN std_logic;
         filtered_value : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT interface
      PORT ( 
         i_fbk : IN inj_t3_type;
         i_fbk_f0 : IN std_logic;
         i_fbk_f1 : IN std_logic;
         v_fbk : IN inj_type;
         v_fbk_f0 : IN std_logic;
         v_fbk_f1 : IN std_logic;
         v_fbk_f2 : IN std_logic;
         v_fbk_f3 : IN std_logic;
         v_fbk_f4 : IN std_logic;
         v_fbk_f5 : IN std_logic;
         i_fbk_0 : OUT std_logic;
         i_fbk_1 : OUT std_logic;
         i_fbk_f : OUT inj_t3_type;
         v_fbk_0 : OUT std_logic;
         v_fbk_1 : OUT std_logic;
         v_fbk_2 : OUT std_logic;
         v_fbk_3 : OUT std_logic;
         v_fbk_4 : OUT std_logic;
         v_fbk_5 : OUT std_logic;
         v_fbk_f : OUT inj_type
      );
   END COMPONENT ;

   FOR ALL : filtering USE ENTITY work.filtering ( behav );
   FOR ALL : interface USE ENTITY work.interface(behav) ;

   -- Internal Signals
   SIGNAL v_fbk_0 : std_logic ;
   SIGNAL v_fbk_f0 : std_logic ;
   SIGNAL v_fbk_1 : std_logic ;
   SIGNAL v_fbk_f1 : std_logic ;
   SIGNAL v_fbk_2 : std_logic ;
   SIGNAL v_fbk_f2 : std_logic ;
   SIGNAL v_fbk_3 : std_logic ;
   SIGNAL v_fbk_f3 : std_logic ;
   SIGNAL v_fbk_4 : std_logic ;
   SIGNAL v_fbk_f4 : std_logic ;
   SIGNAL v_fbk_5 : std_logic ;
   SIGNAL v_fbk_f5 : std_logic ;
   SIGNAL i_fbk_0 : std_logic ;
   SIGNAL i_fbk_f0 : std_logic ;
   SIGNAL i_fbk_1 : std_logic ;
   SIGNAL i_fbk_f1 : std_logic ;

BEGIN

   instance_filt0 : filtering
      PORT MAP ( 
         clock,
         v_fbk_0,
         rst,
         v_fbk_f0
      );

   instance_filt1 : filtering
      PORT MAP ( 
         clock,
         v_fbk_1,
         rst,
         v_fbk_f1
      );

   instance_filt2 : filtering
      PORT MAP ( 
         clock,
         v_fbk_2,
         rst,
         v_fbk_f2
      );

   instance_filt3 : filtering
      PORT MAP ( 
         clock,
         v_fbk_3,
         rst,
         v_fbk_f3
      );

   instance_filt4 : filtering
      PORT MAP ( 
         clock,
         v_fbk_4,
         rst,
         v_fbk_f4
      );

   instance_filt5 : filtering
      PORT MAP ( 
         clock,
         v_fbk_5,
         rst,
         v_fbk_f5
      );

   instance_filt6 : filtering
      PORT MAP ( 
         clock,
         i_fbk_0,
         rst,
         i_fbk_f0
      );

   instance_filt7 : filtering
      PORT MAP ( 
         clock,
         i_fbk_1,
         rst,
         i_fbk_f1
      );

   instance_interface : interface
      PORT MAP ( 
         i_fbk,
         i_fbk_f0,
         i_fbk_f1,
         v_fbk,
         v_fbk_f0,
         v_fbk_f1,
         v_fbk_f2,
         v_fbk_f3,
         v_fbk_f4,
         v_fbk_f5,
         i_fbk_0,
         i_fbk_1,
         i_fbk_f,
         v_fbk_0,
         v_fbk_1,
         v_fbk_2,
         v_fbk_3,
         v_fbk_4,
         v_fbk_5,
         v_fbk_f
      );


END behav ;
 
--
-- Component : turbo_vehicle_speed
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY turbo_vehicle_speed IS
   PORT ( 
      rpm_in : IN std_logic;
      turbo_speed : IN std_logic;
      vehicle_speed : IN std_logic;
      rpm_out : OUT std_logic;
      turbo : OUT std_logic;
      vehicle : OUT std_logic
   );
END turbo_vehicle_speed ;
--
-- Component : turbo_vehicle_speed
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 2, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF turbo_vehicle_speed IS
BEGIN
   turbo <= turbo_speed;
   vehicle <= vehicle_speed;
   rpm_out <= rpm_in;
END behav ;
 
--
-- Component : in_reg
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY in_reg IS
   PORT ( 
      add_decoded : IN thirteen_bit_vector;
      add_decoded_r : IN thirteen_bit_vector;
      clock : IN std_logic;
      rd_en : IN std_logic;
      rst : IN std_logic;
      wr_en : IN std_logic;
      r_t1 : OUT eight_bit_vector;
      r_t2 : OUT seven_bit_vector;
      r_t3_034 : OUT eight_bit_vector;
      r_t3_125 : OUT eight_bit_vector;
      r_t4_034 : OUT seven_bit_vector;
      r_t4_125 : OUT seven_bit_vector;
      r_tb_034 : OUT ten_bit_vector;
      r_tb_125 : OUT ten_bit_vector;
      r_th_034 : OUT reg_type;
      r_th_125 : OUT reg_type;
      r_tonh : OUT seven_bit_vector;
      r_tonl : OUT seven_bit_vector;
      r_tp : OUT seven_bit_vector;
      d_bus : INOUT d_bus_type
   );
END in_reg ;
--
-- Component : in_reg
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 30, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_resetzombie
-- compatible :: AutoLogic I
-- Source views :
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF in_reg IS

   signal th_034, th_125: REG_TYPE;
   signal t2, tp, t4_034, t4_125, tonh, tonl: seven_bit_vector;
   signal t1, t3_034, t3_125: eight_bit_vector;
   signal tb_034, tb_125: ten_bit_vector;


BEGIN

   r_t1 <= t1;
   r_t2 <= t2;
   r_tb_034 <= tb_034;
   r_th_034 <= th_034;
   r_tb_125 <= tb_125;
   r_th_125 <= th_125;
   r_tonh <= tonh;
   r_tonl <= tonl;
   r_tp <= tp;
   r_t3_034 <= t3_034;
   r_t3_125 <= t3_125;
   r_t4_034 <= t4_034;
   r_t4_125 <= t4_125;

   -------------------------------------------------------------------
   vhdl_in_reg : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN

         t1 <= (others => '0');
         t2 <= (others => '0');
         tb_034 <= (others => '0');
         th_034 <= (others => '0');
         tb_125 <= (others => '0');
         th_125 <= (others => '0');
         tonh <= (others => '0');
         tonl <= (others => '0');
         tp <= (others => '0');
         t3_034 <= (others => '0');
         t3_125 <= (others => '0');
         t4_034 <= (others => '0');
         t4_125 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         if (wr_en = '1') then
   			if (add_decoded(0) = '1') then
					t1 <= d_bus(7 downto 0);
				end if;
				if (add_decoded(1) = '1') then
					t2 <= d_bus(6 downto 0);
				end if;
				if (add_decoded(2) = '1') then
					tb_034 <= d_bus(9 downto 0);
				end if;
				if (add_decoded(3) = '1') then
					th_034 <= d_bus(11 downto 0);
				end if;
				if (add_decoded(4) = '1') then
					tb_125 <= d_bus(9 downto 0);
				end if;
				if (add_decoded(5) = '1') then
					th_125 <= d_bus(11 downto 0);
				end if;
				if (add_decoded(6) = '1') then
					tonh <= d_bus(6 downto 0);
				end if;
				if (add_decoded(7) = '1') then
					tonl <= d_bus(6 downto 0);
				end if;
				if (add_decoded(8) = '1') then
					tp <= d_bus(6 downto 0);
				end if;
				if (add_decoded(9) = '1') then
					t3_034 <= d_bus(7 downto 0);
				end if;
				if (add_decoded(10) = '1') then
					t3_125 <= d_bus(7 downto 0);
				end if;
				if (add_decoded(11) = '1') then
					t4_034 <= d_bus(6 downto 0);
				end if;
				if (add_decoded(12) = '1') then
					t4_125 <= d_bus(6 downto 0);
				end if;
         end if;
      END IF;

   END PROCESS vhdl_in_reg ;

	d_bus <= "00000000" & t1 when (add_decoded_r(0) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & t2 when (add_decoded_r(1) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000" & tb_034 when (add_decoded_r(2) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "0000" & th_034 when (add_decoded_r(3) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000" & tb_125 when (add_decoded_r(4) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "0000" & th_125 when (add_decoded_r(5) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & tonh when (add_decoded_r(6) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & tonl when (add_decoded_r(7) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & tp when (add_decoded_r(8) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "00000000" & t3_034 when (add_decoded_r(9) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "00000000" & t3_125 when (add_decoded_r(10) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & t4_034 when (add_decoded_r(11) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

	d_bus <= "000000000" & t4_125 when (add_decoded_r(12) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";


END behav ;
 
--
-- Component : add_dec
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY add_dec IS
   PORT ( 
      a_bus : IN a_bus_type;
      clock : IN std_logic;
      rst : IN std_logic;
      add_decoded : OUT thirteen_bit_vector;
      add_decoded_r : OUT thirteen_bit_vector;
      add_test_en : OUT std_logic;
      a_dig_in : OUT inj_t3_type;
      a_dig_out : OUT std_logic;
      a_fault_dec : OUT two_bit_vector;
      a_fault_dec_r : OUT two_bit_vector
   );
END add_dec ;
--
-- Component : add_dec
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 12, 1997
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF add_dec IS

   component dwand 
     port (i0, i1, i2, i3, i4: in std_logic; o: out std_logic );
   end component;

-- Commentare le linee seguenti per la sintesi
   FOR ALL : dwand USE ENTITY work.dwand(behav) ;

	signal add_decoded_int: thirteen_bit_vector;
	signal a_fault_dec_int: two_bit_vector;
	signal a_dig_in_int: inj_t3_type;
	signal a_dig_out_int: std_logic;
	signal add_test_en_int: std_logic;

	signal not_a_bus: std_logic_vector(4 downto 0);

BEGIN

   -------------------------------------------------------------------
   vhdl_add_dec : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
			add_decoded <= (others => '0');
			a_fault_dec <= (others => '0');
			a_dig_out <= '0';
			add_test_en <= '0';
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
			add_decoded <= add_decoded_int and "1111111111111";
			a_fault_dec <= a_fault_dec_int and "11";
			a_dig_out <= a_dig_out_int and '1';
			add_test_en <= add_test_en_int and '1';
      END IF;

   END PROCESS vhdl_add_dec ;

   
   a_dig_in <= a_dig_in_int and "11";
	add_decoded_r <= add_decoded_int and "1111111111111";
   a_fault_dec_r <= a_fault_dec_int and "11";

   not_a_bus(0) <= not(a_bus(0));
   not_a_bus(1) <= not(a_bus(1));
   not_a_bus(2) <= not(a_bus(2));
   not_a_bus(3) <= not(a_bus(3));
   not_a_bus(4) <= not(a_bus(4));

   dwand_add_t1: dwand port map (not_a_bus(4),
				 not_a_bus(3),
				 not_a_bus(2),
				 not_a_bus(1),
				 not_a_bus(0));
   
   dwand_add_t2: dwand port map (not_a_bus(4),
				 not_a_bus(3),
				 not_a_bus(2),
				 not_a_bus(1),
				 a_bus(0));
   
   dwand_add_tab: dwand port map (not_a_bus(4),
				  not_a_bus(3),
				  not_a_bus(2),
				  a_bus(1),
				  not_a_bus(0));
   
   dwand_add_tah: dwand port map (not_a_bus(4),
				  not_a_bus(3),
				  not_a_bus(2),
				  a_bus(1),
				  a_bus(0));
   
   dwand_add_tbb: dwand port map (not_a_bus(4),
				  not_a_bus(3),
				  a_bus(2),
				  not_a_bus(1),
				  not_a_bus(0));
   
   dwand_add_tbh: dwand port map (not_a_bus(4),
				  not_a_bus(3),
				  a_bus(2),
				  not_a_bus(1),
				  a_bus(0));

   dwand_add_tonh: dwand port map (not_a_bus(4),
				   not_a_bus(3),
				   a_bus(2),
				   a_bus(1),
				   not_a_bus(0));
   
   dwand_add_tonl: dwand port map (not_a_bus(4),
				   not_a_bus(3),
				   a_bus(2),
				   a_bus(1),
				   a_bus(0));
   
   dwand_add_tp: dwand port map (not_a_bus(4),
				 a_bus(3),
				 not_a_bus(2),
				 not_a_bus(1),
				 not_a_bus(0));
   
   dwand_add_t3_034: dwand port map (not_a_bus(4),
				     a_bus(3),
				     not_a_bus(2),
				     not_a_bus(1),
				     a_bus(0));
   
   dwand_add_t3_125: dwand port map (not_a_bus(4),
				     a_bus(3),
				     not_a_bus(2),
				     a_bus(1),
				     not_a_bus(0));
   
   dwand_add_t4_034: dwand port map (not_a_bus(4),
				     a_bus(3),
				     not_a_bus(2),
				     a_bus(1),
				       a_bus(0));
   
   dwand_add_t4_125: dwand port map (not_a_bus(4),
				     a_bus(3),
				     a_bus(2),
				     not_a_bus(1),
				     not_a_bus(0));
   
   dwand_add_fr1: dwand port map (not_a_bus(4),
				  a_bus(3),
				  a_bus(2),
				  not_a_bus(1),
				  a_bus(0));
   
   dwand_add_fr2: dwand port map (not_a_bus(4),
				  a_bus(3),
				  a_bus(2),
				  a_bus(1),
				  not_a_bus(0));
   
   dwand_a_dig_in_int: dwand port map (not_a_bus(4),
				       a_bus(3),
				       a_bus(2),
				       a_bus(1),
				       a_bus(0));
   
   dwand_a_dig_in_int1: dwand port map (a_bus(4),
					not_a_bus(3),
					not_a_bus(2),
					not_a_bus(1),
					not_a_bus(0));
   
   dwand_a_dig_out: dwand port map (a_bus(4),
				    not_a_bus(3),
				    not_a_bus(2),
				    not_a_bus(1),
				    a_bus(0));
   
   dwand_add_test_en_int: dwand port map (a_bus(4),
					  not_a_bus(3),
					  not_a_bus(2),
					  a_bus(1),
					  not_a_bus(0));

END behav ;

 
--
-- Component : error_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY error_handle IS
   PORT ( 
      a_fault_dec : IN two_bit_vector;
      a_fault_dec_r : IN two_bit_vector;
      clock : IN std_logic;
      en_fbk_store_034 : IN std_logic;
      en_fbk_store_125 : IN std_logic;
      en_state_store_034 : IN std_logic;
      en_state_store_125 : IN std_logic;
      global_state_034 : IN glob_state_reg_type;
      global_state_125 : IN glob_state_reg_type;
      i_fbk_f : IN inj_t3_type;
      rd_en : IN std_logic;
      rel_pot_en : IN std_logic;
      rst : IN std_logic;
      v_fbk_f : IN inj_type;
      wr_en : IN std_logic;
      relpot : OUT std_logic;
      status_reg_034 : OUT st_reg_type;
      status_reg_125 : OUT st_reg_type;
      d_bus : INOUT d_bus_type
   );
END error_handle ;
--
-- Component : error_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF error_handle IS

   signal sr_034, sr_125 : std_logic_vector(10 downto 0);
  
BEGIN

   status_reg_034 <= sr_034 (10 downto 0);
   status_reg_125 <= sr_125 (10 downto 0);
   relpot <= rel_pot_en;


   -------------------------------------------------------------------
   vhdl_st_reg_wr_034 : PROCESS (
      clock,
      rst,
      a_fault_dec(0),
      wr_en

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF (( rst = '0' ) or (a_fault_dec(0) = '1' and wr_en = '1')) THEN
            sr_034 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         if (en_state_store_034 = '1') then
            sr_034 (6 downto 0) <= global_state_034;
         end if;
         if (en_fbk_store_034 = '1') then
            sr_034 (7) <= i_fbk_f(0);
            sr_034 (8) <= v_fbk_f (0);
            sr_034 (9) <= v_fbk_f (3);
            sr_034 (10) <= v_fbk_f (4);
--            sr_034 (11) <= rel_pot_en;
         end if;

      END IF;

   END PROCESS vhdl_st_reg_wr_034 ;

   vhdl_st_reg_wr_125 : PROCESS (
      clock,
      rst,
      a_fault_dec(1),
      wr_en

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF (( rst = '0' ) or (a_fault_dec(1) = '1' and wr_en = '1')) THEN
            sr_125 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         if (en_state_store_125 = '1') then
            sr_125 (6 downto 0) <= global_state_125;
         end if;
         if (en_fbk_store_125 = '1') then
            sr_125 (7) <= i_fbk_f(1);
            sr_125 (8) <= v_fbk_f (1);
            sr_125 (9) <= v_fbk_f (2);
            sr_125 (10) <= v_fbk_f (5);
--            sr_125 (11) <= rel_pot_en;
         end if;			
      END IF;

   END PROCESS vhdl_st_reg_wr_125 ;

   d_bus <= "00000" & sr_034 when (a_fault_dec_r(0) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

   d_bus <= "00000" & sr_125 when (a_fault_dec_r(1) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

END behav ;
 
--
-- Component : digital_inputs_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY digital_inputs_handle IS
   PORT ( 
      a_dig_in : IN inj_t3_type;
      clock : IN std_logic;
      digital_input : IN twentyone_bit_vector;
      fbk_pwm : IN split_inj_cmd_type;
      nssm_in : IN seven_bit_vector;
      rd_en : IN std_logic;
      rst : IN std_logic;
      d_bus : OUT d_bus_type
   );
END digital_inputs_handle ;
--
-- Component : digital_inputs_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Nov 26, 1996
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF digital_inputs_handle IS

   SIGNAL store_digital_input: std_logic_vector(31 downto 0);


BEGIN

   -------------------------------------------------------------------
   vhdl_digital_inputs_handle : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         store_digital_input <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         store_digital_input(20 downto 0) <= digital_input;
         store_digital_input(23 downto 21) <= fbk_pwm;
         store_digital_input(30 downto 24) <= nssm_in;
      END IF;

   END PROCESS vhdl_digital_inputs_handle ;

	d_bus <= store_digital_input(15 downto 0) when (a_dig_in(0) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";
	d_bus <= '0' & store_digital_input(30 downto 16) when (a_dig_in(1) = '1' and rd_en = '1') else "ZZZZZZZZZZZZZZZZ";


END behav ;
 
--
-- Component : digital_outputs_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY digital_outputs_handle IS
   PORT ( 
      a_dig_out : IN std_logic;
      clock : IN std_logic;
      d_bus : IN d_bus_type;
      rst : IN std_logic;
      wr_en : IN std_logic;
      digital_output : OUT byte;
      in_speed_lev : OUT std_logic;
      knock1u : OUT std_logic;
      knock2u : OUT std_logic;
      pickup_hall : OUT std_logic;
      seg_speed_lev : OUT std_logic;
      smot_camme_en : OUT std_logic;
      trg_knock_en : OUT std_logic;
      turbo_speed_lev : OUT std_logic
   );
END digital_outputs_handle ;
--
-- Component : digital_outputs_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 2, 1996
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF digital_outputs_handle IS

   SIGNAL digital_output_store: byte;
   SIGNAL smot_camme_store, trg_knock_store, knock1_store, knock2_store : std_logic;
   SIGNAL in_speed_lev_store, seg_speed_lev_store, turbo_speed_lev_store, pickup_hall_store: std_logic;

BEGIN
   digital_output <= digital_output_store;
   smot_camme_en <= smot_camme_store;
   trg_knock_en <= trg_knock_store;
   pickup_hall <= pickup_hall_store;
   in_speed_lev <= in_speed_lev_store;
   seg_speed_lev <= seg_speed_lev_store;
   turbo_speed_lev <= turbo_speed_lev_store;
   knock1u <= knock1_store;
   knock2u <= knock2_store;
   -------------------------------------------------------------------
   vhdl_digital_outputs_handle : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         digital_output_store <= (others => '0');
         smot_camme_store <= '0';
         trg_knock_store <= '0';
         pickup_hall_store <= '0';
         in_speed_lev_store <= '0';
         seg_speed_lev_store <= '0';
         turbo_speed_lev_store <= '0';
         knock1_store <= '0';
         knock2_store <= '0';
 
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
               if (a_dig_out = '1' and wr_en = '1') then
                  digital_output_store <= d_bus(7 downto 0);
                  smot_camme_store <= d_bus(8);
                  trg_knock_store <= d_bus(9);
                  pickup_hall_store <= d_bus(10);
                  in_speed_lev_store <= d_bus(11);
                  seg_speed_lev_store <= d_bus(12);
                  turbo_speed_lev_store <= d_bus(13);
                  knock1_store <= d_bus(14);
                  knock2_store <= d_bus(15);
               end if;
      END IF;

   END PROCESS vhdl_digital_outputs_handle ;
END behav ;
 
--
-- Component : test_en
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY test_en IS
   PORT ( 
      add_test_en : IN std_logic;
      clock : IN std_logic;
      d_bus : IN d_bus_type;
      rd_en : IN std_logic;
      rst : IN std_logic;
      wr_en : IN std_logic;
      test_en_034 : OUT three_bit_vector;
      test_en_125 : OUT three_bit_vector
   );
END test_en ;
--
-- Component : en_fsm_registers
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 5, 1996
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF test_en IS


BEGIN

   -------------------------------------------------------------------
   vhdl_test_en : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         test_en_034 <= (others => '0');
         test_en_125 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         if (add_test_en = '1' and wr_en = '1') then
            test_en_034(0) <= d_bus(0);
            test_en_034(1) <= d_bus(3);
            test_en_034(2) <= d_bus(4);
            test_en_125(0) <= d_bus(1);
            test_en_125(1) <= d_bus(2);
            test_en_125(2) <= d_bus(5);
         end if;
      END IF;

   END PROCESS vhdl_test_en ;

END behav ;
 
--
-- Component : registers
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY registers IS
   PORT ( 
      a_bus : IN a_bus_type;
      clock : IN std_logic;
      clock : IN std_logic;
      digital_input : IN twentyone_bit_vector;
      en_fbk_store_034 : IN std_logic;
      en_fbk_store_125 : IN std_logic;
      en_state_store_034 : IN std_logic;
      en_state_store_125 : IN std_logic;
      fbk_pwm : IN split_inj_cmd_type;
      global_state_034 : IN glob_state_reg_type;
      global_state_125 : IN glob_state_reg_type;
      i_fbk_f : IN inj_t3_type;
      nssm_in : IN seven_bit_vector;
      rd_en : IN std_logic;
      rel_pot_en : IN std_logic;
      rst : IN std_logic;
      v_fbk_f : IN inj_type;
      wr_en : IN std_logic;
      digital_output : OUT byte;
      in_speed_lev : OUT std_logic;
      knock1u : OUT std_logic;
      knock2u : OUT std_logic;
      pickup_hall : OUT std_logic;
      relpot : OUT std_logic;
      r_t1 : OUT eight_bit_vector;
      r_t2 : OUT seven_bit_vector;
      r_t3_034 : OUT eight_bit_vector;
      r_t3_125 : OUT eight_bit_vector;
      r_t4_034 : OUT seven_bit_vector;
      r_t4_125 : OUT seven_bit_vector;
      r_tb_034 : OUT ten_bit_vector;
      r_tb_125 : OUT ten_bit_vector;
      r_th_034 : OUT reg_type;
      r_th_125 : OUT reg_type;
      r_tonh : OUT seven_bit_vector;
      r_tonl : OUT seven_bit_vector;
      r_tp : OUT seven_bit_vector;
      seg_speed_lev : OUT std_logic;
      smot_camme_en : OUT std_logic;
      status_reg_034 : OUT st_reg_type;
      status_reg_125 : OUT st_reg_type;
      test_en_034 : OUT three_bit_vector;
      test_en_125 : OUT three_bit_vector;
      trg_knock_en : OUT std_logic;
      turbo_speed_lev : OUT std_logic;
      d_bus : INOUT d_bus_type  
   );
END registers ;
--
-- Component : registers
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_ctrl/registers/behav
--

ARCHITECTURE behav OF registers IS
   COMPONENT add_dec
      PORT ( 
         a_bus : IN a_bus_type;
         clock : IN std_logic;
         rst : IN std_logic;
         add_decoded : OUT thirteen_bit_vector;
         add_decoded_r : OUT thirteen_bit_vector;
         add_test_en : OUT std_logic;
         a_dig_in : OUT inj_t3_type;
         a_dig_out : OUT std_logic;
         a_fault_dec : OUT two_bit_vector;
         a_fault_dec_r : OUT two_bit_vector
      );
   END COMPONENT ;

   COMPONENT digital_inputs_handle
      PORT ( 
         a_dig_in : IN inj_t3_type;
         clock : IN std_logic;
         digital_input : IN twentyone_bit_vector;
         fbk_pwm : IN split_inj_cmd_type;
         nssm_in : IN seven_bit_vector;
         rd_en : IN std_logic;
         rst : IN std_logic;
         d_bus : OUT d_bus_type
      );
   END COMPONENT ;

   COMPONENT digital_outputs_handle
      PORT ( 
         a_dig_out : IN std_logic;
         clock : IN std_logic;
         d_bus : IN d_bus_type;
         rst : IN std_logic;
         wr_en : IN std_logic;
         digital_output : OUT byte;
         in_speed_lev : OUT std_logic;
         knock1u : OUT std_logic;
         knock2u : OUT std_logic;
         pickup_hall : OUT std_logic;
         seg_speed_lev : OUT std_logic;
         smot_camme_en : OUT std_logic;
         trg_knock_en : OUT std_logic;
         turbo_speed_lev : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT error_handle
      PORT ( 
         a_fault_dec : IN two_bit_vector;
         a_fault_dec_r : IN two_bit_vector;
         clock : IN std_logic;
         en_fbk_store_034 : IN std_logic;
         en_fbk_store_125 : IN std_logic;
         en_state_store_034 : IN std_logic;
         en_state_store_125 : IN std_logic;
         global_state_034 : IN glob_state_reg_type;
         global_state_125 : IN glob_state_reg_type;
         i_fbk_f : IN inj_t3_type;
         rd_en : IN std_logic;
         rel_pot_en : IN std_logic;
         rst : IN std_logic;
         v_fbk_f : IN inj_type;
         wr_en : IN std_logic;
         relpot : OUT std_logic;
         status_reg_034 : OUT st_reg_type;
         status_reg_125 : OUT st_reg_type;
         d_bus : INOUT d_bus_type
      );
   END COMPONENT ;

   COMPONENT in_reg
      PORT ( 
         add_decoded : IN thirteen_bit_vector;
         add_decoded_r : IN thirteen_bit_vector;
         clock : IN std_logic;
         rd_en : IN std_logic;
         rst : IN std_logic;
         wr_en : IN std_logic;
         r_t1 : OUT eight_bit_vector;
         r_t2 : OUT seven_bit_vector;
         r_t3_034 : OUT eight_bit_vector;
         r_t3_125 : OUT eight_bit_vector;
         r_t4_034 : OUT seven_bit_vector;
         r_t4_125 : OUT seven_bit_vector;
         r_tb_034 : OUT ten_bit_vector;
         r_tb_125 : OUT ten_bit_vector;
         r_th_034 : OUT reg_type;
         r_th_125 : OUT reg_type;
         r_tonh : OUT seven_bit_vector;
         r_tonl : OUT seven_bit_vector;
         r_tp : OUT seven_bit_vector;
         d_bus : INOUT d_bus_type 
      );
   END COMPONENT ;

   COMPONENT test_en
      PORT ( 
         add_test_en : IN std_logic;
         clock : IN std_logic;
         d_bus : IN d_bus_type;
         rd_en : IN std_logic;
         rst : IN std_logic;
         wr_en : IN std_logic;
         test_en_034 : OUT three_bit_vector;
         test_en_125 : OUT three_bit_vector
      );
   END COMPONENT ;

   FOR ALL : add_dec USE ENTITY work.add_dec(behav) ;
   FOR ALL : digital_inputs_handle USE ENTITY work.digital_inputs_handle(behav) ;
   FOR ALL : digital_outputs_handle USE ENTITY work.digital_outputs_handle(behav) ;
   FOR ALL : error_handle USE ENTITY work.error_handle(behav) ;
   FOR ALL : in_reg USE ENTITY work.in_reg(behav) ;
   FOR ALL : test_en USE ENTITY work.test_en(behav) ;

   -- Internal Signals
   SIGNAL add_decoded : thirteen_bit_vector ;
   SIGNAL add_decoded_r : thirteen_bit_vector ;
   SIGNAL add_test_en : std_logic ;
   SIGNAL a_dig_in : inj_t3_type ;
   SIGNAL a_dig_out : std_logic ;
   SIGNAL a_fault_dec : two_bit_vector ;
   SIGNAL a_fault_dec_r : two_bit_vector ;

BEGIN

   instance_add_dec : add_dec
      PORT MAP ( 
         a_bus,
         clock,
         rst,
         add_decoded,
         add_decoded_r,
         add_test_en,
         a_dig_in,
         a_dig_out,
         a_fault_dec,
         a_fault_dec_r
      );

   instance_digital_inputs_handle : digital_inputs_handle
      PORT MAP ( 
         a_dig_in,
         clock,
         digital_input,
         fbk_pwm,
         nssm_in,
         rd_en,
         rst,
         d_bus
      );

   instance_digital_outputs_handle : digital_outputs_handle
      PORT MAP ( 
         a_dig_out,
         clock,
         d_bus,
         rst,
         wr_en,
         digital_output,
         in_speed_lev,
         knock1u,
         knock2u,
         pickup_hall,
         seg_speed_lev,
         smot_camme_en,
         trg_knock_en,
         turbo_speed_lev
      );

   instance_error_handle : error_handle
      PORT MAP ( 
         a_fault_dec,
         a_fault_dec_r,
         clock,
         en_fbk_store_034,
         en_fbk_store_125,
         en_state_store_034,
         en_state_store_125,
         global_state_034,
         global_state_125,
         i_fbk_f,
         rd_en,
         rel_pot_en,
         rst,
         v_fbk_f,
         wr_en,
         relpot,
         status_reg_034,
         status_reg_125,
         d_bus
      );

   instance_in_reg : in_reg
      PORT MAP ( 
         add_decoded,
         add_decoded_r,
         clock,
         rd_en,
         rst,
         wr_en,
         r_t1,
         r_t2,
         r_t3_034,
         r_t3_125,
         r_t4_034,
         r_t4_125,
         r_tb_034,
         r_tb_125,
         r_th_034,
         r_th_125,
         r_tonh,
         r_tonl,
         r_tp,
         d_bus
      );

   instance_test_en : test_en
      PORT MAP ( 
         add_test_en,
         clock,
         d_bus,
         rd_en,
         rst,
         wr_en,
         test_en_034,
         test_en_125
      );


END behav ;
 
--
-- Component : d_bus_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY d_bus_handle IS
   PORT ( 
      clock : IN std_logic;
      rd_en : IN std_logic;
      rst : IN std_logic;
      wr_en : IN std_logic;
      d_bus : INOUT d_bus_type ;
      d_bus_ext : INOUT d_bus_type  
   );
END d_bus_handle ;
--
-- Component : d_bus_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 12, 1997
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF d_bus_handle IS

   signal d_bus_int: d_bus_type;

BEGIN

d_bus <= d_bus_int when (wr_en = '1') else "ZZZZZZZZZZZZZZZZ";

d_bus_ext <= d_bus when (rd_en = '1') else "ZZZZZZZZZZZZZZZZ";

   -------------------------------------------------------------------
   vhdl_d_bus_handle : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         d_bus_int <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         d_bus_int <= d_bus_ext;
      END IF;

   END PROCESS vhdl_d_bus_handle ;
END behav ;

 
--
-- Component : ds_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY ds_handle IS
   PORT ( 
      clock : IN std_logic;
      cs : IN std_logic;
      ds : IN std_logic;
      rst : IN std_logic;
      r_w : IN std_logic;
      rd_en : OUT std_logic;
      wr_en : OUT std_logic
   );
END ds_handle ;
--
-- Component : ds_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Feb 12, 1997
--
-- clock :: clock falling
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF ds_handle IS

   signal wr_en_int: std_logic;

BEGIN

	rd_en <= not(cs) and r_w;
	wr_en_int <= not(cs) and not(ds) and not(r_w);

--   wr_handle : PROCESS (
--      clock,
--      wr_en_int
--
--   )
--      VARIABLE prop_delay : TIME := 1 ns;
--   BEGIN
--      IF ( wr_en_int = '1' ) THEN
--         wr_en_tmp <= '1';
--      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--	 if (r_w = '1') then
--	    wr_en_tmp <= '0';
--         else
--	    wr_en_tmp <= wr_en_tmp;
--	 end if;
--      END IF;
--   END PROCESS wr_handle ;

   -------------------------------------------------------------------
   vhdl_ds_handle : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
         wr_en <= '0';
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
	      wr_en <= wr_en_int;
      END IF;
   END PROCESS vhdl_ds_handle ;

END behav ;
 
--
-- Component : d_bus_interface
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY d_bus_interface IS
   PORT ( 
      clock : IN std_logic;
      cs : IN std_logic;
      ds : IN std_logic;
      rst : IN std_logic;
      r_w : IN std_logic;
      rd_en : OUT std_logic;
      wr_en : OUT std_logic;
      d_bus : INOUT d_bus_type  ;
      d_bus_ext : INOUT d_bus_type  
   );
END d_bus_interface ;
--
-- Component : d_bus_interface
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 27, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/d_bus_interface/behav
--

ARCHITECTURE behav OF d_bus_interface IS
   COMPONENT d_bus_handle
      PORT ( 
         clock : IN std_logic;
         rd_en : IN std_logic;
         rst : IN std_logic;
         wr_en : IN std_logic;
         d_bus : INOUT d_bus_type ;
         d_bus_ext : INOUT d_bus_type
      );
   END COMPONENT ;

   COMPONENT ds_handle
      PORT ( 
         clock : IN std_logic;
         cs : IN std_logic;
         ds : IN std_logic;
         rst : IN std_logic;
         r_w : IN std_logic;
         rd_en : OUT std_logic;
         wr_en : OUT std_logic
      );
   END COMPONENT ;

   FOR ALL : d_bus_handle USE ENTITY work.d_bus_handle(behav) ;
   FOR ALL : ds_handle USE ENTITY work.ds_handle(behav) ;


   -- Internal Buffered Signals
   SIGNAL rd_en_internal : std_logic ;
   SIGNAL wr_en_internal : std_logic ;
BEGIN

   instance_d_bus_handle : d_bus_handle
      PORT MAP ( 
         clock,
         rd_en_internal,
         rst,
         wr_en_internal,
         d_bus,
         d_bus_ext
      );

   instance_ds_handle : ds_handle
      PORT MAP ( 
         clock,
         cs,
         ds,
         rst,
         r_w,
         rd_en_internal,
         wr_en_internal
      );

   -- Internal Buffered Signal Mappings
   rd_en <= rd_en_internal ;
   wr_en <= wr_en_internal ;

END behav ;
 
--
-- Component : merge_t1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY merge_t1 IS
   PORT ( 
      t1_0 : IN std_logic;
      t1_1 : IN std_logic;
      t1_2 : IN std_logic;
      t1_3 : IN std_logic;
      t1_4 : IN std_logic;
      t1_5 : IN std_logic;
      t1 : OUT inj_type
   );
END merge_t1 ;
--
-- Component : merge_t1
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF merge_t1 IS
BEGIN

   -------------------------------------------------------------------
   vhdl_merge_t1 : PROCESS (
      t1_0,
      t1_1,
      t1_2,
      t1_3,
      t1_4,
      t1_5
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      t1(0) <= not (t1_0);
      t1(1) <= not (t1_1);
      t1(2) <= not (t1_2);
      t1(3) <= not (t1_3);
      t1(4) <= not (t1_4);
      t1(5) <= not (t1_5);
      
   END PROCESS vhdl_merge_t1 ;
END behav ;
 
--
-- Component : merge_t2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY merge_t2 IS
   PORT ( 
      t2_0 : IN std_logic;
      t2_1 : IN std_logic;
      t2_2 : IN std_logic;
      t2_3 : IN std_logic;
      t2_4 : IN std_logic;
      t2_5 : IN std_logic;
      t2 : OUT inj_type
   );
END merge_t2 ;
--
-- Component : merge_t2
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF merge_t2 IS
BEGIN

   -------------------------------------------------------------------
   vhdl_merge_t2 : PROCESS (
      t2_0,
      t2_1,
      t2_2,
      t2_3,
      t2_4,
      t2_5
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      t2(0) <= t2_0;
      t2(1) <= t2_1;
      t2(2) <= t2_2;
      t2(3) <= t2_3;
      t2(4) <= t2_4;
      t2(5) <= t2_5;
   END PROCESS vhdl_merge_t2 ;
END behav ;
 
--
-- Component : merge_t3
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY merge_t3 IS
   PORT ( 
      t3_034 : IN std_logic;
      t3_125 : IN std_logic;
      t3 : OUT inj_t3_type
   );
END merge_t3 ;
--
-- Component : merge_t3
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 25, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $TSTB10/uni_types/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF merge_t3 IS
BEGIN

   -------------------------------------------------------------------
   vhdl_merge_t3 : PROCESS (
      t3_034,
      t3_125
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      t3(0) <= not (t3_034);
      t3(1) <= not (t3_125);

   END PROCESS vhdl_merge_t3 ;
END behav ;
 
--
-- Component : merge_actuators
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY merge_actuators IS
   PORT ( 
      t1_0 : IN std_logic;
      t1_1 : IN std_logic;
      t1_2 : IN std_logic;
      t1_3 : IN std_logic;
      t1_4 : IN std_logic;
      t1_5 : IN std_logic;
      t2_0 : IN std_logic;
      t2_1 : IN std_logic;
      t2_2 : IN std_logic;
      t2_3 : IN std_logic;
      t2_4 : IN std_logic;
      t2_5 : IN std_logic;
      t3_034 : IN std_logic;
      t3_125 : IN std_logic;
      t1 : OUT inj_type;
      t2 : OUT inj_type;
      t3 : OUT inj_t3_type
   );
END merge_actuators ;
--
-- Component : merge_actuators
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 27, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/merge_actuators/behav
--

ARCHITECTURE behav OF merge_actuators IS
   COMPONENT merge_t1
      PORT ( 
         t1_0 : IN std_logic;
         t1_1 : IN std_logic;
         t1_2 : IN std_logic;
         t1_3 : IN std_logic;
         t1_4 : IN std_logic;
         t1_5 : IN std_logic;
         t1 : OUT inj_type
      );
   END COMPONENT ;

   COMPONENT merge_t2
      PORT ( 
         t2_0 : IN std_logic;
         t2_1 : IN std_logic;
         t2_2 : IN std_logic;
         t2_3 : IN std_logic;
         t2_4 : IN std_logic;
         t2_5 : IN std_logic;
         t2 : OUT inj_type
      );
   END COMPONENT ;

   COMPONENT merge_t3
      PORT ( 
         t3_034 : IN std_logic;
         t3_125 : IN std_logic;
         t3 : OUT inj_t3_type
      );
   END COMPONENT ;

   FOR ALL : merge_t1 USE ENTITY work.merge_t1(behav) ;
   FOR ALL : merge_t2 USE ENTITY work.merge_t2(behav) ;
   FOR ALL : merge_t3 USE ENTITY work.merge_t3(behav) ;


BEGIN

   instance_merge_t1 : merge_t1
      PORT MAP ( 
         t1_0,
         t1_1,
         t1_2,
         t1_3,
         t1_4,
         t1_5,
         t1
      );

   instance_merge_t2 : merge_t2
      PORT MAP ( 
         t2_0,
         t2_1,
         t2_2,
         t2_3,
         t2_4,
         t2_5,
         t2
      );

   instance_merge_t3 : merge_t3
      PORT MAP ( 
         t3_034,
         t3_125,
         t3
      );


END behav ;
 
--
-- Component : smot_camme_mux
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY smot_camme_mux IS
   PORT ( 
      in_speed : IN std_logic;
      pickup_hall : IN std_logic;
      seg_speed_hall : IN std_logic;
      seg_speed_pickup : IN std_logic;
      smot_camme_en : IN std_logic;
      cam_smot : OUT std_logic
   );
END smot_camme_mux ;
--
-- Component : smot_camme_mux
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 2, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF smot_camme_mux IS
BEGIN

   -------------------------------------------------------------------
   vhdl_smot_camme_mux : PROCESS (
      seg_speed_pickup,
      seg_speed_hall,
      pickup_hall,
      in_speed,
      smot_camme_en
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (smot_camme_en = '0') then
         cam_smot <= in_speed;
      else
         if (pickup_hall = '1') then
            cam_smot <= seg_speed_pickup;
         else
            cam_smot <= seg_speed_hall;
         end if;
      end if;
   END PROCESS vhdl_smot_camme_mux ;
END behav ;
 
--
-- Component : trg_knock1_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY trg_knock1_handle IS
   PORT ( 
      in_speed : IN std_logic;
      trg_knock1 : IN std_logic;
      trg_knock_en : IN std_logic;
      internal_trg_knock1 : OUT std_logic;
      smot60 : OUT std_logic
   );
END trg_knock1_handle ;
--
-- Component : trg_knock2_handle
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 2, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF trg_knock1_handle IS
BEGIN

   -------------------------------------------------------------------
   vhdl_trg_knock1_handle : PROCESS (
      in_speed,
      trg_knock1,
      trg_knock_en
   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      if (trg_knock_en = '0') then
         smot60 <= in_speed or trg_knock1;
         internal_trg_knock1 <= '0';
      else
         smot60 <= in_speed;
         internal_trg_knock1 <= trg_knock1;
      end if;
   END PROCESS vhdl_trg_knock1_handle ;
END behav ;
 
--
-- Component : knock_count1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_count1 IS
   PORT ( 
      clock : IN std_logic;
      internal_trg_knock1 : IN std_logic;
      rst : IN std_logic;
      count1 : OUT inj_type;
      en_comp1 : OUT std_logic
   );
END knock_count1 ;
--
-- Component : knock_count1
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 6, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF knock_count1 IS

   signal store_trg_knock1, store_reset_trg, rst_int: std_logic;
   signal int_counter1: inj_type;
BEGIN

   -------------------------------------------------------------------
   vhdl_knock_store : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         store_trg_knock1 <= '0';    
         store_reset_trg <= '0';
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         store_trg_knock1 <= internal_trg_knock1;    
         store_reset_trg <= not(store_trg_knock1);
      END IF;
   END PROCESS vhdl_knock_store ;

   rst_int <= rst and not(store_reset_trg);
   en_comp1 <= store_trg_knock1;

   process (clock, rst_int)
   begin
      IF ( rst_int = '0' ) THEN
--          Enter RESET condition code here.
         int_counter1 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         if (store_trg_knock1 = '1') then
            int_counter1 <= int_counter1 + "000001";
         end if;
      END IF;
   end process;
 
   count1 <= int_counter1;

END behav ;
 
--
-- Component : knock_comp1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_comp1 IS
   PORT ( 
      count1 : IN inj_type;
      en_comp1 : IN std_logic;
      impulse : OUT std_logic;
      long : OUT std_logic
   );
END knock_comp1 ;
--
-- Component : knock_comp1
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 6, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF knock_comp1 IS
BEGIN

   impulse <= (count1(5) or count1(4) or count1(3)) and not(en_comp1);
   long <= count1(0) and count1(1) and count1(2) and count1(3) and count1(4) and count1(5);

END behav ;
 
--
-- Component : knock_fsm1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_fsm1 IS
   PORT ( 
      clock : IN std_logic;
      impulse : IN std_logic;
      long : IN std_logic;
      rst : IN std_logic;
      knock1 : OUT inj_t3_type
   );
END knock_fsm1 ;
--
-- Component : knock_fsm1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_ctrl/knock_fsm1/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF knock_fsm1 IS
   TYPE knock_fsm1_state_type is (
      start_state,
      off1_state,
      sample_state,
      off2_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : knock_fsm1_state_type := start_state ;
   SIGNAL next_state : knock_fsm1_state_type := start_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      impulse,
      long,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= start_state;
         -- Start State Actions
         knock1 <= "01";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN start_state =>
            knock1 <= "01";
         WHEN off1_state =>
            knock1 <= "00";
         WHEN sample_state =>
            knock1 <= "10";
         WHEN off2_state =>
            knock1 <= "00";
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      impulse,
      long,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN start_state =>
         IF ( long = '1' ) THEN
            next_state <= start_state;
         ELSIF ( impulse = '1' ) THEN
            next_state <= off1_state;
         END IF;

      WHEN off1_state =>
         IF ( impulse = '1' ) THEN
            next_state <= sample_state;
         ELSIF ( long = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN sample_state =>
         IF ( impulse = '1' ) THEN
            next_state <= off2_state;
         ELSIF ( long = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN off2_state =>
         IF ( long = '1' ) THEN
            next_state <= start_state;
         ELSIF ( impulse = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : knock_detection_fsm1
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_detection_fsm1 IS
   PORT ( 
      clock : IN std_logic;
      internal_trg_knock1 : IN std_logic;
      rst : IN std_logic;
      knock1 : OUT inj_t3_type
   );
END knock_detection_fsm1 ;
--
-- Component : knock_detection_fsm1
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 27, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/knock_detection_fsm1/behav
--

ARCHITECTURE behav OF knock_detection_fsm1 IS
   COMPONENT knock_comp1
      PORT ( 
         count1 : IN inj_type;
         en_comp1 : IN std_logic;
         impulse : OUT std_logic;
         long : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT knock_count1
      PORT ( 
         clock : IN std_logic;
         internal_trg_knock1 : IN std_logic;
         rst : IN std_logic;
         count1 : OUT inj_type;
         en_comp1 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT knock_fsm1
      PORT ( 
         clock : IN std_logic;
         impulse : IN std_logic;
         long : IN std_logic;
         rst : IN std_logic;
         knock1 : OUT inj_t3_type
      );
   END COMPONENT ;

   FOR ALL : knock_comp1 USE ENTITY work.knock_comp1(behav) ;
   FOR ALL : knock_count1 USE ENTITY work.knock_count1(behav) ;
   FOR ALL : knock_fsm1 USE ENTITY work.knock_fsm1(behav) ;

   -- Internal Signals
   SIGNAL count1 : inj_type ;
   SIGNAL en_comp1 : std_logic ;
   SIGNAL impulse : std_logic ;
   SIGNAL long : std_logic ;

BEGIN

   instance_knock_comp1 : knock_comp1
      PORT MAP ( 
         count1,
         en_comp1,
         impulse,
         long
      );

   instance_knock_count1 : knock_count1
      PORT MAP ( 
         clock,
         internal_trg_knock1,
         rst,
         count1,
         en_comp1
      );

   instance_knock_fsm1 : knock_fsm1
      PORT MAP ( 
         clock,
         impulse,
         long,
         rst,
         knock1
      );


END behav ;
 
--
-- Component : knock_count2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_count2 IS
   PORT ( 
      clock : IN std_logic;
      rst : IN std_logic;
      trg_knock2 : IN std_logic;
      count2 : OUT inj_type;
      en_comp2 : OUT std_logic
   );
END knock_count2 ;
--
-- Component : knock_count1
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 6, 1996
--
-- clock :: clock rising
-- reset :: rst active_high asynchronous_reset
-- compatible :: AutoLogic I
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF knock_count2 IS

   signal store_trg_knock2, store_reset_trg, rst_int: std_logic;
   signal int_counter2: inj_type;

BEGIN

   -------------------------------------------------------------------
   vhdl_knock_store : PROCESS (
      clock,
      rst

   )
   -------------------------------------------------------------------
      VARIABLE prop_delay : TIME := 1 ns;
   BEGIN
      IF ( rst = '0' ) THEN
--          Enter RESET condition code here.
         store_trg_knock2 <= '0';    
         store_reset_trg <= '0';
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         store_trg_knock2 <= trg_knock2;    
         store_reset_trg <= not(store_trg_knock2);
      END IF;
   END PROCESS vhdl_knock_store ;

   rst_int <= rst and not(store_reset_trg);
   en_comp2 <= store_trg_knock2;

   process (clock, rst_int)
   begin
      IF ( rst_int = '0' ) THEN
--          Enter RESET condition code here.
         int_counter2 <= (others => '0');
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
--          Enter code here.
         if (store_trg_knock2 = '1') then
            int_counter2 <= int_counter2 + "000001";
         end if;
      END IF;
   end process;

   count2 <= int_counter2;

END behav ;
 
--
-- Component : knock_comp2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_comp2 IS
   PORT ( 
      count2 : IN inj_type;
      en_comp2 : IN std_logic;
      impulse : OUT std_logic;
      long : OUT std_logic
   );
END knock_comp2 ;
--
-- Component : knock_comp1
--
-- Generated by System Architect version v8.4_3.7 by filu on Dec 6, 1996
--
-- sensitivity_attr :: 
-- Source views :-
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_ARITHMETIC/std_logic_arith/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF knock_comp2 IS
BEGIN

   impulse <= (count2(5) or count2(4) or count2(3)) and not(en_comp2);
   long <= count2(0) and count2(1) and count2(2) and count2(3) and count2(4) and count2(5);

END behav ;
 
--
-- Component : knock_fsm2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_fsm2 IS
   PORT ( 
      clock : IN std_logic;
      impulse : IN std_logic;
      long : IN std_logic;
      rst : IN std_logic;
      knock2 : OUT inj_t3_type
   );
END knock_fsm2 ;
--
-- Component : knock_fsm2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock rising
-- reset :: rst active_low asynchronous_reset
-- animation_mode :: noanimate
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_ctrl/knock_fsm2/state_machine
-- $WORK/uni_types/types
--

ARCHITECTURE behav OF knock_fsm2 IS
   TYPE knock_fsm2_state_type is (
      start_state,
      off1_state,
      sample_state,
      off2_state
   );


   -- SDS Defined State Signals
   SIGNAL current_state : knock_fsm2_state_type := start_state ;
   SIGNAL next_state : knock_fsm2_state_type := start_state ;
BEGIN

   -------------------------------------------------------------------
   clocked : PROCESS (
      clock,
      impulse,
      long,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      IF ( rst = '0' ) THEN
         current_state <= start_state;
         -- Start State Actions
         knock2 <= "01";
      ELSIF ( clock'EVENT AND clock = '1' ) THEN
         current_state <= next_state;

         -- State Actions
         CASE next_state IS
         WHEN start_state =>
            knock2 <= "01";
         WHEN off1_state =>
            knock2 <= "00";
         WHEN sample_state =>
            knock2 <= "10";
         WHEN off2_state =>
            knock2 <= "00";
         WHEN OTHERS =>
            NULL;
         END CASE;

      END IF;

   END PROCESS clocked ;

   -------------------------------------------------------------------
   set_next_state : PROCESS (
      current_state,
      clock,
      impulse,
      long,
      rst
   )
   -------------------------------------------------------------------
   BEGIN
      next_state <= current_state;
      CASE current_state IS
      WHEN start_state =>
         IF ( long = '1' ) THEN
            next_state <= start_state;
         ELSIF ( impulse = '1' ) THEN
            next_state <= off1_state;
         END IF;

      WHEN off1_state =>
         IF ( impulse = '1' ) THEN
            next_state <= sample_state;
         ELSIF ( long = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN sample_state =>
         IF ( impulse = '1' ) THEN
            next_state <= off2_state;
         ELSIF ( long = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN off2_state =>
         IF ( long = '1' ) THEN
            next_state <= start_state;
         ELSIF ( impulse = '1' ) THEN
            next_state <= start_state;
         END IF;

      WHEN OTHERS =>
         NULL;
      END CASE;

   END PROCESS set_next_state ;
END behav ;
 
--
-- Component : knock_detection_fsm2
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY knock_detection_fsm2 IS
   PORT ( 
      clock : IN std_logic;
      rst : IN std_logic;
      trg_knock2 : IN std_logic;
      knock2 : OUT inj_t3_type
   );
END knock_detection_fsm2 ;
--
-- Component : knock_detection_fsm2
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 27, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/knock_detection_fsm2/behav
--

ARCHITECTURE behav OF knock_detection_fsm2 IS
   COMPONENT knock_comp2
      PORT ( 
         count2 : IN inj_type;
         en_comp2 : IN std_logic;
         impulse : OUT std_logic;
         long : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT knock_count2
      PORT ( 
         clock : IN std_logic;
         rst : IN std_logic;
         trg_knock2 : IN std_logic;
         count2 : OUT inj_type;
         en_comp2 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT knock_fsm2
      PORT ( 
         clock : IN std_logic;
         impulse : IN std_logic;
         long : IN std_logic;
         rst : IN std_logic;
         knock2 : OUT inj_t3_type
      );
   END COMPONENT ;

   FOR ALL : knock_comp2 USE ENTITY work.knock_comp2(behav) ;
   FOR ALL : knock_count2 USE ENTITY work.knock_count2(behav) ;
   FOR ALL : knock_fsm2 USE ENTITY work.knock_fsm2(behav) ;

   -- Internal Signals
   SIGNAL count2 : inj_type ;
   SIGNAL en_comp2 : std_logic ;
   SIGNAL impulse : std_logic ;
   SIGNAL long : std_logic ;

BEGIN

   instance_knock_comp2 : knock_comp2
      PORT MAP ( 
         count2,
         en_comp2,
         impulse,
         long
      );

   instance_knock_count2 : knock_count2
      PORT MAP ( 
         clock,
         rst,
         trg_knock2,
         count2,
         en_comp2
      );

   instance_knock_fsm2 : knock_fsm2
      PORT MAP ( 
         clock,
         impulse,
         long,
         rst,
         knock2
      );


END behav ;
 
--
-- Component : smot_knock_handle
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY smot_knock_handle IS
   PORT ( 
      clock : IN std_logic;
      in_speed : IN std_logic;
      pickup_hall : IN std_logic;
      rst : IN std_logic;
      seg_speed_hall : IN std_logic;
      seg_speed_pickup : IN std_logic;
      smot_camme_en : IN std_logic;
      trg_knock1 : IN std_logic;
      trg_knock2 : IN std_logic;
      trg_knock_en : IN std_logic;
      cam_smot : OUT std_logic;
      knock1 : OUT inj_t3_type;
      knock2 : OUT inj_t3_type;
      smot60 : OUT std_logic
   );
END smot_knock_handle ;
--
-- Component : smot_knock_handle
--
-- Generated by System Architect version v8.5_3.3 by unijet on Oct 27, 97
--
-- compatible :: AutoLogic II
-- Source views :-
-- $UNI_SDS/inj_ctrl/smot_knock_handle/behav
--

ARCHITECTURE behav OF smot_knock_handle IS
   COMPONENT knock_detection_fsm1
      PORT ( 
         clock : IN std_logic;
         internal_trg_knock1 : IN std_logic;
         rst : IN std_logic;
         knock1 : OUT inj_t3_type
      );
   END COMPONENT ;

   COMPONENT knock_detection_fsm2
      PORT ( 
         clock : IN std_logic;
         rst : IN std_logic;
         trg_knock2 : IN std_logic;
         knock2 : OUT inj_t3_type
      );
   END COMPONENT ;

   COMPONENT smot_camme_mux
      PORT ( 
         in_speed : IN std_logic;
         pickup_hall : IN std_logic;
         seg_speed_hall : IN std_logic;
         seg_speed_pickup : IN std_logic;
         smot_camme_en : IN std_logic;
         cam_smot : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT trg_knock1_handle
      PORT ( 
         in_speed : IN std_logic;
         trg_knock1 : IN std_logic;
         trg_knock_en : IN std_logic;
         internal_trg_knock1 : OUT std_logic;
         smot60 : OUT std_logic
      );
   END COMPONENT ;

   FOR ALL : knock_detection_fsm1 USE ENTITY work.knock_detection_fsm1(behav) ;
   FOR ALL : knock_detection_fsm2 USE ENTITY work.knock_detection_fsm2(behav) ;
   FOR ALL : smot_camme_mux USE ENTITY work.smot_camme_mux(behav) ;
   FOR ALL : trg_knock1_handle USE ENTITY work.trg_knock1_handle(behav) ;

   -- Internal Signals
   SIGNAL internal_trg_knock1 : std_logic ;

BEGIN

   instance_knock_detection_fsm1 : knock_detection_fsm1
      PORT MAP ( 
         clock,
         internal_trg_knock1,
         rst,
         knock1
      );

   instance_knock_detection_fsm2 : knock_detection_fsm2
      PORT MAP ( 
         clock,
         rst,
         trg_knock2,
         knock2
      );

   instance_smot_camme_mux : smot_camme_mux
      PORT MAP ( 
         in_speed,
         pickup_hall,
         seg_speed_hall,
         seg_speed_pickup,
         smot_camme_en,
         cam_smot
      );

   instance_trg_knock1_handle : trg_knock1_handle
      PORT MAP ( 
         in_speed,
         trg_knock1,
         trg_knock_en,
         internal_trg_knock1,
         smot60
      );


END behav ;
 
--
-- Component : inj_ctrl
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- clock :: clock
-- reset :: rst
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY inj_ctrl IS
   PORT ( 
      a_bus : IN a_bus_type;
      clock : IN std_logic;
      cs : IN std_logic;
      digital_input : IN twentyone_bit_vector;
      ds : IN std_logic;
      fbk_pwm : IN split_inj_cmd_type;
      inj_cmd : IN inj_type;
      in_speed : IN std_logic;
      i_fbk : IN inj_t3_type;
      nssm_in : IN seven_bit_vector;
      rpm_in : IN std_logic;
      rst : IN std_logic;
      r_w : IN std_logic;
      seg_speed_hall : IN std_logic;
      seg_speed_pickup : IN std_logic;
      trg_knock1 : IN std_logic;
      trg_knock2 : IN std_logic;
      turbo_speed : IN std_logic;
      vehicle_speed : IN std_logic;
      v_fbk : IN inj_type;
      cam_smot : OUT std_logic;
      clock : OUT std_logic;
      digital_output : OUT byte;
      hlo : OUT inj_t3_type;
      in_speed_lev : OUT std_logic;
      irq : OUT std_logic;
      knock1 : OUT inj_t3_type;
      knock1u : OUT std_logic;
      knock2 : OUT inj_t3_type;
      knock2u : OUT std_logic;
      relpot : OUT std_logic;
      rpm_out : OUT std_logic;
      seg_speed_lev : OUT std_logic;
      smot60 : OUT std_logic;
      t1 : OUT inj_type;
      t2 : OUT inj_type;
      t3 : OUT inj_t3_type;
      turbo : OUT std_logic;
      turbo_speed_lev : OUT std_logic;
      vehicle : OUT std_logic;
      d_bus_ext : INOUT d_bus_type
   );
END inj_ctrl ;
--
-- Component : inj_ctrl
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/inj_ctrl/behav
--

-- System/Foreign Instance Libraries

ARCHITECTURE behav OF inj_ctrl IS
   COMPONENT inj_block
      PORT ( 
         clock : IN std_logic;
         inj_cmd : IN split_inj_cmd_type;
         i_fbk : IN std_logic;
         rst : IN std_logic;
         r_t1 : IN eight_bit_vector;
         r_t2 : IN seven_bit_vector;
         r_t3 : IN eight_bit_vector;
         r_t4 : IN seven_bit_vector;
         r_tb : IN ten_bit_vector;
         r_th : IN reg_type;
         r_tonh : IN seven_bit_vector;
         r_tonl : IN seven_bit_vector;
         r_tp : IN seven_bit_vector;
         status_reg : IN st_reg_type;
         test_en : IN three_bit_vector;
         v_fbk : IN split_inj_cmd_type;
         en_fbk_store : OUT std_logic;
         en_state_store : OUT std_logic;
         error : OUT std_logic;
         global_state_store : OUT glob_state_reg_type;
         hl : OUT std_logic;
         relpot : OUT std_logic;
         t1a : OUT std_logic;
         t1b : OUT std_logic;
         t1c : OUT std_logic;
         t2a : OUT std_logic;
         t2b : OUT std_logic;
         t2c : OUT std_logic;
         t3 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT clock_gen
      PORT ( 
         clock_i : IN std_logic;
         rst : IN std_logic;
         clock_o : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT d_bus_interface
      PORT ( 
         clock : IN std_logic;
         cs : IN std_logic;
         ds : IN std_logic;
         rst : IN std_logic;
         r_w : IN std_logic;
         rd_en : OUT std_logic;
         wr_en : OUT std_logic;
         d_bus : INOUT d_bus_type ;
         d_bus_ext : INOUT d_bus_type 
      );
   END COMPONENT ;

   COMPONENT filter_feedback
      PORT ( 
         clock : IN std_logic;
         i_fbk : IN inj_t3_type;
         rst : IN std_logic;
         v_fbk : IN inj_type;
         i_fbk_f : OUT inj_t3_type;
         v_fbk_f : OUT inj_type
      );
   END COMPONENT ;

   COMPONENT merge
      PORT ( 
         error1 : IN std_logic;
         error2 : IN std_logic;
         hl_034 : IN std_logic;
         hl_125 : IN std_logic;
         relpot1 : IN std_logic;
         relpot2 : IN std_logic;
         hlo : OUT inj_t3_type;
         irq : OUT std_logic;
         rel_pot_en : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT merge_actuators
      PORT ( 
         t1_0 : IN std_logic;
         t1_1 : IN std_logic;
         t1_2 : IN std_logic;
         t1_3 : IN std_logic;
         t1_4 : IN std_logic;
         t1_5 : IN std_logic;
         t2_0 : IN std_logic;
         t2_1 : IN std_logic;
         t2_2 : IN std_logic;
         t2_3 : IN std_logic;
         t2_4 : IN std_logic;
         t2_5 : IN std_logic;
         t3_034 : IN std_logic;
         t3_125 : IN std_logic;
         t1 : OUT inj_type;
         t2 : OUT inj_type;
         t3 : OUT inj_t3_type
      );
   END COMPONENT ;

   COMPONENT registers
      PORT ( 
         a_bus : IN a_bus_type;
         clock : IN std_logic;
         clock : IN std_logic;
         digital_input : IN twentyone_bit_vector;
         en_fbk_store_034 : IN std_logic;
         en_fbk_store_125 : IN std_logic;
         en_state_store_034 : IN std_logic;
         en_state_store_125 : IN std_logic;
         fbk_pwm : IN split_inj_cmd_type;
         global_state_034 : IN glob_state_reg_type;
         global_state_125 : IN glob_state_reg_type;
         i_fbk_f : IN inj_t3_type;
         nssm_in : IN seven_bit_vector;
         rd_en : IN std_logic;
         rel_pot_en : IN std_logic;
         rst : IN std_logic;
         v_fbk_f : IN inj_type;
         wr_en : IN std_logic;
         digital_output : OUT byte;
         in_speed_lev : OUT std_logic;
         knock1u : OUT std_logic;
         knock2u : OUT std_logic;
         pickup_hall : OUT std_logic;
         relpot : OUT std_logic;
         r_t1 : OUT eight_bit_vector;
         r_t2 : OUT seven_bit_vector;
         r_t3_034 : OUT eight_bit_vector;
         r_t3_125 : OUT eight_bit_vector;
         r_t4_034 : OUT seven_bit_vector;
         r_t4_125 : OUT seven_bit_vector;
         r_tb_034 : OUT ten_bit_vector;
         r_tb_125 : OUT ten_bit_vector;
         r_th_034 : OUT reg_type;
         r_th_125 : OUT reg_type;
         r_tonh : OUT seven_bit_vector;
         r_tonl : OUT seven_bit_vector;
         r_tp : OUT seven_bit_vector;
         seg_speed_lev : OUT std_logic;
         smot_camme_en : OUT std_logic;
         status_reg_034 : OUT st_reg_type;
         status_reg_125 : OUT st_reg_type;
         test_en_034 : OUT three_bit_vector;
         test_en_125 : OUT three_bit_vector;
         trg_knock_en : OUT std_logic;
         turbo_speed_lev : OUT std_logic;
         d_bus : INOUT d_bus_type 
      );
   END COMPONENT ;

   COMPONENT smot_knock_handle
      PORT ( 
         clock : IN std_logic;
         in_speed : IN std_logic;
         pickup_hall : IN std_logic;
         rst : IN std_logic;
         seg_speed_hall : IN std_logic;
         seg_speed_pickup : IN std_logic;
         smot_camme_en : IN std_logic;
         trg_knock1 : IN std_logic;
         trg_knock2 : IN std_logic;
         trg_knock_en : IN std_logic;
         cam_smot : OUT std_logic;
         knock1 : OUT inj_t3_type;
         knock2 : OUT inj_t3_type;
         smot60 : OUT std_logic
      );
   END COMPONENT ;

   COMPONENT split
      PORT ( 
         clock : IN std_logic;
         rst : IN std_logic;
         inj_cmd : IN inj_type;
         i_fbk_f : IN inj_t3_type;
         v_fbk_f : IN inj_type;
         inj_cmd_034 : OUT split_inj_cmd_type;
         inj_cmd_125 : OUT split_inj_cmd_type;
         i_fbk_034 : OUT std_logic;
         i_fbk_125 : OUT std_logic;
         v_fbk_034 : OUT split_inj_cmd_type;
         v_fbk_125 : OUT split_inj_cmd_type
      );
   END COMPONENT ;

   COMPONENT turbo_vehicle_speed
      PORT ( 
         rpm_in : IN std_logic;
         turbo_speed : IN std_logic;
         vehicle_speed : IN std_logic;
         rpm_out : OUT std_logic;
         turbo : OUT std_logic;
         vehicle : OUT std_logic
      );
   END COMPONENT ;

   FOR ALL : inj_block USE ENTITY work.inj_block ( behav );
   FOR ALL : clock_gen USE ENTITY work.clock_gen(behav) ;
   FOR ALL : d_bus_interface USE ENTITY work.d_bus_interface(behav) ;
   FOR ALL : filter_feedback USE ENTITY work.filter_feedback(behav) ;
   FOR ALL : merge USE ENTITY work.merge(behav) ;
   FOR ALL : merge_actuators USE ENTITY work.merge_actuators(behav) ;
   FOR ALL : registers USE ENTITY work.registers(behav) ;
   FOR ALL : smot_knock_handle USE ENTITY work.smot_knock_handle(behav) ;
   FOR ALL : split USE ENTITY work.split(behav) ;
   FOR ALL : turbo_vehicle_speed USE ENTITY work.turbo_vehicle_speed(behav) ;

   -- Internal Signals
   SIGNAL inj_cmd_034 : split_inj_cmd_type ;
   SIGNAL i_fbk_034 : std_logic ;
   SIGNAL r_t1 : eight_bit_vector ;
   SIGNAL r_t2 : seven_bit_vector ;
   SIGNAL r_t3_034 : eight_bit_vector ;
   SIGNAL r_t4_034 : seven_bit_vector ;
   SIGNAL r_tb_034 : ten_bit_vector ;
   SIGNAL r_th_034 : reg_type ;
   SIGNAL r_tonh : seven_bit_vector ;
   SIGNAL r_tonl : seven_bit_vector ;
   SIGNAL r_tp : seven_bit_vector ;
   SIGNAL status_reg_034 : st_reg_type ;
   SIGNAL test_en_034 : three_bit_vector ;
   SIGNAL v_fbk_034 : split_inj_cmd_type ;
   SIGNAL en_fbk_store_034 : std_logic ;
   SIGNAL en_state_store_034 : std_logic ;
   SIGNAL error1 : std_logic ;
   SIGNAL global_state_034 : glob_state_reg_type ;
   SIGNAL hl_034 : std_logic ;
   SIGNAL relpot1 : std_logic ;
   SIGNAL t1_0 : std_logic ;
   SIGNAL t1_3 : std_logic ;
   SIGNAL t1_4 : std_logic ;
   SIGNAL t2_0 : std_logic ;
   SIGNAL t2_3 : std_logic ;
   SIGNAL t2_4 : std_logic ;
   SIGNAL t3_034 : std_logic ;
   SIGNAL inj_cmd_125 : split_inj_cmd_type ;
   SIGNAL i_fbk_125 : std_logic ;
   SIGNAL r_t3_125 : eight_bit_vector ;
   SIGNAL r_t4_125 : seven_bit_vector ;
   SIGNAL r_tb_125 : ten_bit_vector ;
   SIGNAL r_th_125 : reg_type ;
   SIGNAL status_reg_125 : st_reg_type ;
   SIGNAL test_en_125 : three_bit_vector ;
   SIGNAL v_fbk_125 : split_inj_cmd_type ;
   SIGNAL en_fbk_store_125 : std_logic ;
   SIGNAL en_state_store_125 : std_logic ;
   SIGNAL error2 : std_logic ;
   SIGNAL global_state_125 : glob_state_reg_type ;
   SIGNAL hl_125 : std_logic ;
   SIGNAL relpot2 : std_logic ;
   SIGNAL t1_1 : std_logic ;
   SIGNAL t1_2 : std_logic ;
   SIGNAL t1_5 : std_logic ;
   SIGNAL t2_1 : std_logic ;
   SIGNAL t2_2 : std_logic ;
   SIGNAL t2_5 : std_logic ;
   SIGNAL t3_125 : std_logic ;
   SIGNAL rd_en : std_logic ;
   SIGNAL wr_en : std_logic ;
   SIGNAL d_bus : d_bus_type ;
   SIGNAL i_fbk_f : inj_t3_type ;
   SIGNAL v_fbk_f : inj_type ;
   SIGNAL rel_pot_en : std_logic ;
   SIGNAL pickup_hall : std_logic ;
   SIGNAL smot_camme_en : std_logic ;
   SIGNAL trg_knock_en : std_logic ;

   -- Internal Buffered Signals
   SIGNAL clock_internal : std_logic ;
BEGIN

   instance_block_034 : inj_block
      PORT MAP ( 
         clock_internal,
         inj_cmd_034,
         i_fbk_034,
         rst,
         r_t1,
         r_t2,
         r_t3_034,
         r_t4_034,
         r_tb_034,
         r_th_034,
         r_tonh,
         r_tonl,
         r_tp,
         status_reg_034,
         test_en_034,
         v_fbk_034,
         en_fbk_store_034,
         en_state_store_034,
         error1,
         global_state_034,
         hl_034,
         relpot1,
         t1_0,
         t1_3,
         t1_4,
         t2_0,
         t2_3,
         t2_4,
         t3_034
      );

   instance_block_125 : inj_block
      PORT MAP ( 
         clock_internal,
         inj_cmd_125,
         i_fbk_125,
         rst,
         r_t1,
         r_t2,
         r_t3_125,
         r_t4_125,
         r_tb_125,
         r_th_125,
         r_tonh,
         r_tonl,
         r_tp,
         status_reg_125,
         test_en_125,
         v_fbk_125,
         en_fbk_store_125,
         en_state_store_125,
         error2,
         global_state_125,
         hl_125,
         relpot2,
         t1_1,
         t1_2,
         t1_5,
         t2_1,
         t2_2,
         t2_5,
         t3_125
      );

   instance_clock_gen : clock_gen
      PORT MAP ( 
         clock,
         rst,
         clock_internal
      );

   instance_d_bus_interface : d_bus_interface
      PORT MAP ( 
         clock,
         cs,
         ds,
         rst,
         r_w,
         rd_en,
         wr_en,
         d_bus,
         d_bus_ext
      );

   instance_filter_feedback : filter_feedback
      PORT MAP ( 
         clock_internal,
         i_fbk,
         rst,
         v_fbk,
         i_fbk_f,
         v_fbk_f
      );

   instance_merge : merge
      PORT MAP ( 
         error1,
         error2,
         hl_034,
         hl_125,
         relpot1,
         relpot2,
         hlo,
         irq,
         rel_pot_en
      );

   instance_merge_actuators : merge_actuators
      PORT MAP ( 
         t1_0,
         t1_1,
         t1_2,
         t1_3,
         t1_4,
         t1_5,
         t2_0,
         t2_1,
         t2_2,
         t2_3,
         t2_4,
         t2_5,
         t3_034,
         t3_125,
         t1,
         t2,
         t3
      );

   instance_registers : registers
      PORT MAP ( 
         a_bus,
         clock_internal,
         clock,
         digital_input,
         en_fbk_store_034,
         en_fbk_store_125,
         en_state_store_034,
         en_state_store_125,
         fbk_pwm,
         global_state_034,
         global_state_125,
         i_fbk_f,
         nssm_in,
         rd_en,
         rel_pot_en,
         rst,
         v_fbk_f,
         wr_en,
         digital_output,
         in_speed_lev,
         knock1u,
         knock2u,
         pickup_hall,
         relpot,
         r_t1,
         r_t2,
         r_t3_034,
         r_t3_125,
         r_t4_034,
         r_t4_125,
         r_tb_034,
         r_tb_125,
         r_th_034,
         r_th_125,
         r_tonh,
         r_tonl,
         r_tp,
         seg_speed_lev,
         smot_camme_en,
         status_reg_034,
         status_reg_125,
         test_en_034,
         test_en_125,
         trg_knock_en,
         turbo_speed_lev,
         d_bus
      );

   instance_smot_knock_handle : smot_knock_handle
      PORT MAP ( 
         clock_internal,
         in_speed,
         pickup_hall,
         rst,
         seg_speed_hall,
         seg_speed_pickup,
         smot_camme_en,
         trg_knock1,
         trg_knock2,
         trg_knock_en,
         cam_smot,
         knock1,
         knock2,
         smot60
      );

   instance_split : split
      PORT MAP ( 
         clock_internal,
         rst,
         inj_cmd,
         i_fbk_f,
         v_fbk_f,
         inj_cmd_034,
         inj_cmd_125,
         i_fbk_034,
         i_fbk_125,
         v_fbk_034,
         v_fbk_125
      );

   instance_turbo_vehicle_speed : turbo_vehicle_speed
      PORT MAP ( 
         rpm_in,
         turbo_speed,
         vehicle_speed,
         rpm_out,
         turbo,
         vehicle
      );

   -- Internal Buffered Signal Mappings
   clock <= clock_internal ;

END behav ;
 
--
-- Component : uni_types
--
-- Generated by System Architect version v8.4_3.7 by filu on Oct 28, 1996
--

-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY rst_inv IS
   PORT ( 
      reset : IN std_logic
   );
END rst_inv ;
--
-- Component : rst_inv
--
-- Generated by System Architect version v8.4_3.7 by filu on Mar 17, 1997
--
-- sensitivity_attr :: 
-- Source views :-
-- $UNI_SDS/typepe/header
-- $MGC_SYS1076_IEEE/std_logic_1164/header
-- $UNI_SDS/uni_types/header
-- $MGC_SYS1076_STD/standard/header
--

ARCHITECTURE behav OF rst_inv IS
   
   component startup
      port (gsr: in std_logic );
   end component;

   signal rst_neg: std_logic;

   FOR ALL : startup USE ENTITY work.startup(behav);   

BEGIN

   rst_neg <= not(reset);
   u0: startup port map(gsr => rst_neg);

END behav ;
 
--
-- Component : b30
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- Source views :-
-- $WORK/uni_types/types
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;
LIBRARY work;
USE work.uni_types.all;

ENTITY b30 IS
   PORT ( 
      a_bus : IN a_bus_type;
      clock : IN std_logic;
      cs : IN std_logic;
      digital_input : IN twentyone_bit_vector;
      ds : IN std_logic;
      fbk_pwm : IN split_inj_cmd_type;
      inj_cmd : IN inj_type;
      in_speed : IN std_logic;
      i_fbk : IN inj_t3_type;
      nssm_in : IN seven_bit_vector;
      reset : IN std_logic;
      rpm_in : IN std_logic;
      r_w : IN std_logic;
      seg_speed_hall : IN std_logic;
      seg_speed_pickup : IN std_logic;
      trg_knock1 : IN std_logic;
      trg_knock2 : IN std_logic;
      turbo_speed : IN std_logic;
      vehicle_speed : IN std_logic;
      v_fbk : IN inj_type;
      cam_smot : OUT std_logic;
      clock : OUT std_logic;
      digital_output : OUT byte;
      hlo : OUT inj_t3_type;
      in_speed_lev : OUT std_logic;
      irq : OUT std_logic;
      knock1 : OUT inj_t3_type;
      knock1u : OUT std_logic;
      knock2 : OUT inj_t3_type;
      knock2u : OUT std_logic;
      relpot : OUT std_logic;
      rpm_out : OUT std_logic;
      seg_speed_lev : OUT std_logic;
      smot60 : OUT std_logic;
      t1 : OUT inj_type;
      t2 : OUT inj_type;
      t3 : OUT inj_t3_type;
      turbo : OUT std_logic;
      turbo_speed_lev : OUT std_logic;
      vehicle : OUT std_logic;
      d_bus_ext : INOUT d_bus_type
   );
END b30 ;
--
-- Component : b30
--
-- Generated by System Architect version v8.5_3.3 by uni2000 on Mar 11, 98
--
-- compatible :: AutoLogic II
-- Source views :-
-- $WORK/b30/behav
--

-- System/Foreign Instance Libraries

ARCHITECTURE behav OF b30 IS
   COMPONENT inj_ctrl
      PORT ( 
         a_bus : IN a_bus_type;
         clock : IN std_logic;
         cs : IN std_logic;
         digital_input : IN twentyone_bit_vector;
         ds : IN std_logic;
         fbk_pwm : IN split_inj_cmd_type;
         inj_cmd : IN inj_type;
         in_speed : IN std_logic;
         i_fbk : IN inj_t3_type;
         nssm_in : IN seven_bit_vector;
         rpm_in : IN std_logic;
         rst : IN std_logic;
         r_w : IN std_logic;
         seg_speed_hall : IN std_logic;
         seg_speed_pickup : IN std_logic;
         trg_knock1 : IN std_logic;
         trg_knock2 : IN std_logic;
         turbo_speed : IN std_logic;
         vehicle_speed : IN std_logic;
         v_fbk : IN inj_type;
         cam_smot : OUT std_logic;
         clock : OUT std_logic;
         digital_output : OUT byte;
         hlo : OUT inj_t3_type;
         in_speed_lev : OUT std_logic;
         irq : OUT std_logic;
         knock1 : OUT inj_t3_type;
         knock1u : OUT std_logic;
         knock2 : OUT inj_t3_type;
         knock2u : OUT std_logic;
         relpot : OUT std_logic;
         rpm_out : OUT std_logic;
         seg_speed_lev : OUT std_logic;
         smot60 : OUT std_logic;
         t1 : OUT inj_type;
         t2 : OUT inj_type;
         t3 : OUT inj_t3_type;
         turbo : OUT std_logic;
         turbo_speed_lev : OUT std_logic;
         vehicle : OUT std_logic;
         d_bus_ext : INOUT d_bus_type
      );
   END COMPONENT ;

   COMPONENT rst_inv
      PORT ( 
         reset : IN std_logic
      );
   END COMPONENT ;

   FOR ALL : inj_ctrl USE ENTITY work.inj_ctrl ( behav );
   FOR ALL : rst_inv USE ENTITY work.rst_inv(behav) ;


BEGIN

   instance_inj_ctrl : inj_ctrl
      PORT MAP ( 
         a_bus,
         clock,
         cs,
         digital_input,
         ds,
         fbk_pwm,
         inj_cmd,
         in_speed,
         i_fbk,
         nssm_in,
         rpm_in,
         reset,
         r_w,
         seg_speed_hall,
         seg_speed_pickup,
         trg_knock1,
         trg_knock2,
         turbo_speed,
         vehicle_speed,
         v_fbk,
         cam_smot,
         clock,
         digital_output,
         hlo,
         in_speed_lev,
         irq,
         knock1,
         knock1u,
         knock2,
         knock2u,
         relpot,
         rpm_out,
         seg_speed_lev,
         smot60,
         t1,
         t2,
         t3,
         turbo,
         turbo_speed_lev,
         vehicle,
         d_bus_ext
      );

   instance_rst_inv : rst_inv
      PORT MAP ( 
         reset
      );


END behav ;
 
