-------------------------------------------------------------------------------
--
-- ROM core VHDL template. See the macro description included
-- behind this frame.
--
-- Copyright (C) 2000 Rudolf Matousek <matousek@utia.cas.cz>
--
-- Modified by Jiri Gaisler <jgais@ws.estec.esa.nl> for LEON boot prom.
--
-- This code may be used under the terms of Version 2 of the GPL,
-- read the file COPYING for details.
--
--
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity gen_bprom is
    port(
      clk : in std_logic;
      csn : in std_logic;
      addr : in std_logic_vector (29 downto 0);
      data : out std_logic_vector (31 downto 0)
      );
end;

architecture rtl of gen_bprom is
  signal raddr : std_logic_vector(9 downto 0);
  signal d : std_logic_vector(31 downto 0);
  attribute syn_romstyle : string;
  attribute syn_romstyle of d : signal is "select_rom";
  
begin

  p : process(raddr)
  begin
    case raddr is
    when "0000000000" => d <= "10000001100010000010000011100000";
    when "0000000001" => d <= "10000001100100000010000000000010";
    when "0000000010" => d <= "10000001110110000010000000000000";
    when "0000000011" => d <= "00000011000000000000000001000000";
    when "0000000100" => d <= "10000010000100000110000000001111";
    when "0000000101" => d <= "00010001001000000000000000000000";
    when "0000000110" => d <= "10001000001000100010000000010000";
    when "0000000111" => d <= "11000010001000100010000000010100";
    when "0000001000" => d <= "11010010000000100010000000100100";
    when "0000001001" => d <= "10010010000010100110000000010000";
    when "0000001010" => d <= "10010011001010100110000000001000";
    when "0000001011" => d <= "10000001100010100110000011100000";
    when "0000001100" => d <= "00010011000000000000000000101010";
    when "0000001101" => d <= "10010010000100100110001000000000";
    when "0000001110" => d <= "11010010001000100010000010100100";
    when "0000001111" => d <= "11000000001000100010000001110100";
    when "0000010000" => d <= "11000000001000100010000010000100";
    when "0000010001" => d <= "10010010000100000010000000000011";
    when "0000010010" => d <= "11010010001000100010000001111000";
    when "0000010011" => d <= "11010010001000100010000010001000";
    when "0000010100" => d <= "10010010000100000011111111111111";
    when "0000010101" => d <= "11010010001000100010000001000100";
    when "0000010110" => d <= "10010010000100000010000000000111";
    when "0000010111" => d <= "11010010001000100010000001001000";
    when "0000011000" => d <= "00010011000100000000000000000000";
    when "0000011001" => d <= "11010100000000100010000000000100";
    when "0000011010" => d <= "10010100000010101010000000001111";
    when "0000011011" => d <= "00010111000000000000000000000111";
    when "0000011100" => d <= "10010110000100101110001000100000";
    when "0000011101" => d <= "10010100000100101100000000001010";
    when "0000011110" => d <= "11010100001000100010000000000100";
    when "0000011111" => d <= "00010111000000000100100011010001";
    when "0000100000" => d <= "10010110000100101110000101100111";
    when "0000100001" => d <= "11010110001000100100000000000000";
    when "0000100010" => d <= "11000000001000100110000000000100";
    when "0000100011" => d <= "11011000100000100100000000000000";
    when "0000100100" => d <= "10000000101000101100000000001100";
    when "0000100101" => d <= "00000010100000000000000000001101";
    when "0000100110" => d <= "11000000001000100100000000000000";
    when "0000100111" => d <= "10010100001000101010000000010000";
    when "0000101000" => d <= "11010100001000100010000000000100";
    when "0000101001" => d <= "11010110001000100100000000000000";
    when "0000101010" => d <= "11000000001000100110000000000100";
    when "0000101011" => d <= "11011000100000100100000000000000";
    when "0000101100" => d <= "10000000101000101100000000001100";
    when "0000101101" => d <= "00000010100000000000000000000101";
    when "0000101110" => d <= "00000001000000000000000000000000";
    when "0000101111" => d <= "10010100001000101010000000010000";
    when "0000110000" => d <= "00010000100000000000000000001010";
    when "0000110001" => d <= "11010100001000100010000000000100";
    when "0000110010" => d <= "11010110001000100100000000000000";
    when "0000110011" => d <= "11000000001010100110000000000011";
    when "0000110100" => d <= "11011000100000100100000000000000";
    when "0000110101" => d <= "10000000101000101100000000001100";
    when "0000110110" => d <= "00010010100000000000000000000100";
    when "0000110111" => d <= "00000001000000000000000000000000";
    when "0000111000" => d <= "10010100000100101010000001000000";
    when "0000111001" => d <= "11010100001000100010000000000100";
    when "0000111010" => d <= "00000101000001000000000000000000";
    when "0000111011" => d <= "11010110001000010000000000000000";
    when "0000111100" => d <= "11000000001000010011111111111100";
    when "0000111101" => d <= "11011010100000010000000000000000";
    when "0000111110" => d <= "10000000101000110100000000001011";
    when "0000111111" => d <= "00110010101111111111111111111100";
    when "0001000000" => d <= "10001000101000010000000000000010";
    when "0001000001" => d <= "10001011001100010010000000011100";
    when "0001000010" => d <= "10001010001000010110000000000100";
    when "0001000011" => d <= "10010010000000001000000000001001";
    when "0001000100" => d <= "10010010001000100110000000010000";
    when "0001000101" => d <= "11010110001000100100000000000000";
    when "0001000110" => d <= "10000101001100001010000000000001";
    when "0001000111" => d <= "10010100001000101010001000000000";
    when "0001001000" => d <= "11010100001000100010000000000100";
    when "0001001001" => d <= "10010010001000100100000000000010";
    when "0001001010" => d <= "11011010100000100100000000000000";
    when "0001001011" => d <= "10000000101000110100000000001011";
    when "0001001100" => d <= "00000010101111111111111111111010";
    when "0001001101" => d <= "00000001000000000000000000000000";
    when "0001001110" => d <= "10010100000000101010001000000000";
    when "0001001111" => d <= "11010100001000100010000000000100";
    when "0001010000" => d <= "00001001000100000000000000000000";
    when "0001010001" => d <= "10010010000000100100000000000010";
    when "0001010010" => d <= "10010010001010100100000000000100";
    when "0001010011" => d <= "10010011001010100100000000000101";
    when "0001010100" => d <= "10011100000100100100000000000100";
    when "0001010101" => d <= "10010111001010010110000000000001";
    when "0001010110" => d <= "01000000000000000000000000011011";
    when "0001010111" => d <= "10010000000100000010001101110100";
    when "0001011000" => d <= "10010010000100000010001101101100";
    when "0001011001" => d <= "01000000000000000000000000011000";
    when "0001011010" => d <= "10010000000000101100000000001001";
    when "0001011011" => d <= "10010010000100000010001100111100";
    when "0001011100" => d <= "10001011001100101010000000000110";
    when "0001011101" => d <= "10001010001000010110000000100000";
    when "0001011110" => d <= "10001010001010010110000000000001";
    when "0001011111" => d <= "01000000000000000000000000010010";
    when "0001100000" => d <= "10010000000000100100000000000101";
    when "0001100001" => d <= "10010010000100000010001100110000";
    when "0001100010" => d <= "10001011001100101010000000000010";
    when "0001100011" => d <= "10001010000010010110000000001100";
    when "0001100100" => d <= "01000000000000000000000000001101";
    when "0001100101" => d <= "10010000000000100100000000000101";
    when "0001100110" => d <= "01000000000000000000000000001011";
    when "0001100111" => d <= "10010000000100000010001101111101";
    when "0001101000" => d <= "10000000100010101010000001000000";
    when "0001101001" => d <= "00000010100000000000000000000100";
    when "0001101010" => d <= "00000001000000000000000000000000";
    when "0001101011" => d <= "01000000000000000000000000000110";
    when "0001101100" => d <= "10010000000100000010001110001000";
    when "0001101101" => d <= "01000000000000000000000000000100";
    when "0001101110" => d <= "10010000000100000010001110001110";
    when "0001101111" => d <= "01000000000000000000000000100101";
    when "0001110000" => d <= "00000001000000000000000000000000";
    when "0001110001" => d <= "11000100000010100000000000000000";
    when "0001110010" => d <= "10000000101000001010000000000000";
    when "0001110011" => d <= "00000010100000000000000000001101";
    when "0001110100" => d <= "00010011001000000000000000000000";
    when "0001110101" => d <= "11000110000010100000000000000000";
    when "0001110110" => d <= "10010000000000100010000000000001";
    when "0001110111" => d <= "11000100000000100110000001110100";
    when "0001111000" => d <= "10000000100010001010000000000100";
    when "0001111001" => d <= "00000010101111111111111111111110";
    when "0001111010" => d <= "10000100000010001110000011111111";
    when "0001111011" => d <= "11000100001000100110000001110000";
    when "0001111100" => d <= "11000100000010100000000000000000";
    when "0001111101" => d <= "10000000101000001010000000000000";
    when "0001111110" => d <= "00110010101111111111111111111000";
    when "0001111111" => d <= "11000110000010100000000000000000";
    when "0010000000" => d <= "10000001110000111110000000001000";
    when "0010000001" => d <= "00000001000000000000000000000000";
    when "0010000010" => d <= "10010110000100000000000000001000";
    when "0010000011" => d <= "10010000000100000010000000000000";
    when "0010000100" => d <= "10000000101000100000000000001011";
    when "0010000101" => d <= "00011010100000000000000000001101";
    when "0010000110" => d <= "10010100000100000010000000000000";
    when "0010000111" => d <= "11000100000010100100000000001010";
    when "0010001000" => d <= "10000000101000001010000001000000";
    when "0010001001" => d <= "00101000100000000000000000000011";
    when "0010001010" => d <= "10000100000000001011111111010000";
    when "0010001011" => d <= "10000100000000001011111111001001";
    when "0010001100" => d <= "10000111001010100010000000000100";
    when "0010001101" => d <= "10000100000010001010000011111111";
    when "0010001110" => d <= "10010100000000101010000000000001";
    when "0010001111" => d <= "10000000101000101000000000001011";
    when "0010010000" => d <= "00001010101111111111111111110111";
    when "0010010001" => d <= "10010000000100001100000000000010";
    when "0010010010" => d <= "10000001110000111110000000001000";
    when "0010010011" => d <= "00000001000000000000000000000000";
    when "0010010100" => d <= "10011101111000111011111010011000";
    when "0010010101" => d <= "00101001001000000000000000000000";
    when "0010010110" => d <= "10101100000001111011111011111100";
    when "0010010111" => d <= "10101010000001111011111100000100";
    when "0010011000" => d <= "10010100000001111011111011111000";
    when "0010011001" => d <= "11010000000001010010000001110100";
    when "0010011010" => d <= "10000000100010100010000000000001";
    when "0010011011" => d <= "00000010101111111111111111111110";
    when "0010011100" => d <= "00000001000000000000000000000000";
    when "0010011101" => d <= "11010000000001010010000001110000";
    when "0010011110" => d <= "10010010000010100010000011111111";
    when "0010011111" => d <= "10000000101000100110000000001101";
    when "0010100000" => d <= "00000010100000000000000000000101";
    when "0010100001" => d <= "11010000001010101000000000000000";
    when "0010100010" => d <= "10000000101000100110000000001010";
    when "0010100011" => d <= "00010010101111111111111111110110";
    when "0010100100" => d <= "10010100000000101010000000000001";
    when "0010100101" => d <= "11010000000011111011111011111000";
    when "0010100110" => d <= "10000000101000100010000001010011";
    when "0010100111" => d <= "00010010101111111111111111110010";
    when "0010101000" => d <= "10010100000001111011111011111000";
    when "0010101001" => d <= "10010000000100000010000000001000";
    when "0010101010" => d <= "01111111111111111111111111011000";
    when "0010101011" => d <= "10010010000100000000000000010110";
    when "0010101100" => d <= "10100110000100000000000000001000";
    when "0010101101" => d <= "11010000000011111011111011111001";
    when "0010101110" => d <= "10000000101000100010000000110011";
    when "0010101111" => d <= "00010010100000000000000000010111";
    when "0010110000" => d <= "10000000101000100010000000110111";
    when "0010110001" => d <= "10010000000100000010000000000010";
    when "0010110010" => d <= "01111111111111111111111111010000";
    when "0010110011" => d <= "10010010000001111011111011111010";
    when "0010110100" => d <= "10010001001010100010000000000001";
    when "0010110101" => d <= "10010000000000100011111111110110";
    when "0010110110" => d <= "10100101001100100010000000000001";
    when "0010110111" => d <= "10100010000100000010000000000000";
    when "0010111000" => d <= "10000000101001000100000000010010";
    when "0010111001" => d <= "00010110101111111111111111100000";
    when "0010111010" => d <= "10010100000001111011111011111000";
    when "0010111011" => d <= "10100000000100000000000000010101";
    when "0010111100" => d <= "10010010000100000000000000010000";
    when "0010111101" => d <= "01111111111111111111111111000101";
    when "0010111110" => d <= "10010000000100000010000000000010";
    when "0010111111" => d <= "11010000001011001100000000010001";
    when "0011000000" => d <= "10100010000001000110000000000001";
    when "0011000001" => d <= "10000000101001000100000000010010";
    when "0011000010" => d <= "00000110101111111111111111111010";
    when "0011000011" => d <= "10100000000001000010000000000010";
    when "0011000100" => d <= "00010000101111111111111111010101";
    when "0011000101" => d <= "10010100000001111011111011111000";
    when "0011000110" => d <= "00010010101111111111111111010011";
    when "0011000111" => d <= "10010100000001111011111011111000";
    when "0011001000" => d <= "10011111110001001100000000000000";
    when "0011001001" => d <= "00000001000000000000000000000000";
    when "0011001010" => d <= "00010000101111111111111111001111";
    when "0011001011" => d <= "10010100000001111011111011111000";
    when "0011001100" => d <= "00100000001110000010110100000000";
    when "0011001101" => d <= "00110001001101100010110100000000";
    when "0011001110" => d <= "00110011001100100010110100000000";
    when "0011001111" => d <= "00101010001100010011001000111000";
    when "0011010000" => d <= "01001011001000000000000000000000";
    when "0011010001" => d <= "00101010001100100011010100110110";
    when "0011010010" => d <= "01001011001000000000000000000000";
    when "0011010011" => d <= "00101010001101010011000100110010";
    when "0011010100" => d <= "01001011001000000000000000000000";
    when "0011010101" => d <= "00101010001100010011000000110010";
    when "0011010110" => d <= "00110100010010110010000000000000";
    when "0011010111" => d <= "00101010001100100011000000110100";
    when "0011011000" => d <= "00111000010010110010000000000000";
    when "0011011001" => d <= "00101010001101000011000000111001";
    when "0011011010" => d <= "00110110010010110010000000000000";
    when "0011011011" => d <= "00110001000000000011001000000000";
    when "0011011100" => d <= "00110011000000000011010000000000";
    when "0011011101" => d <= "01001100010001010100111101001110";
    when "0011011110" => d <= "00101101001100010011101000100000";
    when "0011011111" => d <= "00000000011000100110100101110100";
    when "0011100000" => d <= "00100000011011010110010101101101";
    when "0011100001" => d <= "01101111011100100111100100000000";
    when "0011100010" => d <= "00101100001000000111001001101101";
    when "0011100011" => d <= "01110111000000000000101000001010";
    when "0011100100" => d <= "00001101001111100010000000000000";
    when "0011100101" => d <= "00000000000000000000000000000000";

    when others => d <= (others => '-');
    end case;
  end process;

  r : process (clk)
  begin
    if rising_edge(clk) then
      if csn = '0' then raddr <= addr(9 downto 0); end if;
    end if;
  end process;

  data <= d;
end rtl;
