--------------------------------------------------------------------
--       Actel Axcelerator VITAL Library
--       NAME: axcelerator.vhd
--       DATE: July 20, 2004
---------------------------------------------------------------------/

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;

package COMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn : Boolean := False;
constant DefaultXon : Boolean := False;
constant DefaultMsgOn : Boolean := True;



------ Component ADD1 ------
 component ADD1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		FCI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 end component;


------ Component AND2 ------
 component AND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2A ------
 component AND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND2B ------
 component AND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3 ------
 component AND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3A ------
 component AND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3B ------
 component AND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND3C ------
 component AND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4 ------
 component AND4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4A ------
 component AND4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4B ------
 component AND4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4C ------
 component AND4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND4D ------
 component AND4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5A ------
 component AND5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5B ------
 component AND5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AND5C ------
 component AND5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1 ------
 component AO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO10 ------
 component AO10
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO11 ------
 component AO11
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO12 ------
 component AO12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO13 ------
 component AO13
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO14 ------
 component AO14
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO15 ------
 component AO15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO16 ------
 component AO16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO17 ------
 component AO17
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO18 ------
 component AO18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1A ------
 component AO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1B ------
 component AO1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1C ------
 component AO1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1D ------
 component AO1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO1E ------
 component AO1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2 ------
 component AO2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2A ------
 component AO2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2B ------
 component AO2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2C ------
 component AO2C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2D ------
 component AO2D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO2E ------
 component AO2E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3 ------
 component AO3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3A ------
 component AO3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3B ------
 component AO3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO3C ------
 component AO3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO4A ------
 component AO4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO5A ------
 component AO5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO6 ------
 component AO6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO6A ------
 component AO6A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO7 ------
 component AO7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO8 ------
 component AO8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AO9 ------
 component AO9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1 ------
 component AOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1A ------
 component AOI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1B ------
 component AOI1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1C ------
 component AOI1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI1D ------
 component AOI1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI2A ------
 component AOI2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI2B ------
 component AOI2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI3A ------
 component AOI3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI4 ------
 component AOI4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI4A ------
 component AOI4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AOI5 ------
 component AOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AFCNTECP1 ------
 component AFCNTECP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component ARCNTECP1 ------
 component ARCNTECP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component AFCNTELDCP1 ------
 component AFCNTELDCP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component ARCNTELDCP1 ------
 component ARCNTELDCP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component AX1 ------
 component AX1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1A ------
 component AX1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1B ------
 component AX1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1C ------
 component AX1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1D ------
 component AX1D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AX1E ------
 component AX1E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO1 ------
 component AXO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO2 ------
 component AXO2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO3 ------
 component AXO3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO5 ------
 component AXO5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO6 ------
 component AXO6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXO7 ------
 component AXO7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI1 ------
 component AXOI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI2 ------
 component AXOI2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI3 ------
 component AXOI3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI4 ------
 component AXOI4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI5 ------
 component AXOI5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component AXOI7 ------
 component AXOI7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF ------
 component BIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8 ------
 component BIBUF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8D ------
 component BIBUF_S_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_8U ------
 component BIBUF_S_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12 ------
 component BIBUF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12D ------
 component BIBUF_S_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_12U ------
 component BIBUF_S_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16 ------
 component BIBUF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16D ------
 component BIBUF_S_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_16U ------
 component BIBUF_S_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24 ------
 component BIBUF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24D ------
 component BIBUF_S_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_S_24U ------
 component BIBUF_S_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8 ------
 component BIBUF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8D ------
 component BIBUF_F_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_8U ------
 component BIBUF_F_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12 ------
 component BIBUF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12D ------
 component BIBUF_F_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_12U ------
 component BIBUF_F_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16 ------
 component BIBUF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16D ------
 component BIBUF_F_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_16U ------
 component BIBUF_F_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24 ------
 component BIBUF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24D ------
 component BIBUF_F_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_F_24U ------
 component BIBUF_F_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25 ------
 component BIBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25D ------
 component BIBUF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS25U ------
 component BIBUF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18 ------
 component BIBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18D ------
 component BIBUF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS18U ------
 component BIBUF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15 ------
 component BIBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15D ------
 component BIBUF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_LVCMOS15U ------
 component BIBUF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_PCI ------
 component BIBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_PCIX ------
 component BIBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTLP33 ------
 component BIBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_GTLP25 ------
 component BIBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFA ------
 component BUFA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFD ------
 component BUFD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBIBUF ------
 component CLKBIBUF
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D                  : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E                  : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : inout  STD_ULOGIC;
                D               : in     STD_ULOGIC;
                E               : in     STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component CLKBUF ------
 component CLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS25 ------
 component CLKBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS18 ------
 component CLKBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_LVCMOS15 ------
 component CLKBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_PCI ------
 component CLKBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_PCIX ------
 component CLKBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTLP33 ------
 component CLKBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_GTLP25 ------
 component CLKBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_HSTL_I ------
 component CLKBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL3_I ------
 component CLKBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL3_II ------
 component CLKBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL2_I ------
 component CLKBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKBUF_SSTL2_II ------
 component CLKBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM7 ------
 component CM7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM8 ------
 component CM8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM8BUFF ------
 component CM8BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
                tpw_A_posedge   : VitalDelayType := 0.000 ns;
                tpw_A_negedge   : VitalDelayType := 0.000 ns;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CM8INV ------
 component CM8INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMA9 ------
 component CMA9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMAF ------
 component CMAF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMB3 ------
 component CMB3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMB7 ------
 component CMB7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMBB ------
 component CMBB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMBF ------
 component CMBF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEA ------
 component CMEA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEB ------
 component CMEB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEE ------
 component CMEE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMEF ------
 component CMEF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF1 ------
 component CMF1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF2 ------
 component CMF2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF3 ------
 component CMF3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF4 ------
 component CMF4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF5 ------
 component CMF5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF6 ------
 component CMF6
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF7 ------
 component CMF7
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF8 ------
 component CMF8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMF9 ------
 component CMF9
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFA ------
 component CMFA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFB ------
 component CMFB
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFC ------
 component CMFC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFD ------
 component CMFD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		DB		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CMFE ------
 component CMFE
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_DB_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_DB		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		DB		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CS1 ------
 component CS1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CS2 ------
 component CS2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CY2A ------
 component CY2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CY2B ------
 component CY2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B0		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A1		: in    STD_ULOGIC;
		B1		: in    STD_ULOGIC;
		A0		: in    STD_ULOGIC;
		B0		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DF1 ------
 component DF1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DF1_CC ------
 component DF1_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DF1B ------
 component DF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1B ------
 component DFC1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1B_CC ------
 component DFC1B_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFC1D ------
 component DFC1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE1C ------
 component DFE1C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE1B ------
 component DFE1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE3C ------
 component DFE3C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE3D ------
 component DFE3D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE4F ------
 component DFE4F
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFE4G ------
 component DFE4G
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFEG ------
 component DFEG
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFEH ------
 component DFEH
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1 ------
 component DFP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1A ------
 component DFP1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1B ------
 component DFP1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1B_CC ------
 component DFP1B_CC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFP1D ------
 component DFP1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPC ------
 component DFPC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPCB ------
 component DFPCB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFPCC ------
 component DFPCC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL1 ------
 component DL1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL1A ------
 component DL1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DL1B ------
 component DL1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL1C ------
 component DL1C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DL2A ------
 component DL2A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DL2C ------
 component DL2C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC ------
 component DLC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC1 ------
 component DLC1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC1A ------
 component DLC1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLC1F ------
 component DLC1F
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLC1G ------
 component DLC1G
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLCA ------
 component DLCA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE ------
 component DLE
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_E_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE1D ------
 component DLE1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLE2B ------
 component DLE2B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE2C ------
 component DLE2C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE3B ------
 component DLE3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLE3C ------
 component DLE3C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLEA ------
 component DLEA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLEB ------
 component DLEB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLEC ------
 component DLEC
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM ------
 component DLM
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_A_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		A		:  in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM2 ------
 component DLM2
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_A_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		A		:  in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM2B ------
 component DLM2B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		A		:  in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		CLR		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM3 ------
 component DLM3
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D0		:  in    STD_ULOGIC;
		S0		:  in    STD_ULOGIC;
		D1		:  in    STD_ULOGIC;
		S1		:  in    STD_ULOGIC;
		D2		:  in    STD_ULOGIC;
		D3		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM3A ------
 component DLM3A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D0		:  in    STD_ULOGIC;
		S0		:  in    STD_ULOGIC;
		D1		:  in    STD_ULOGIC;
		S1		:  in    STD_ULOGIC;
		D2		:  in    STD_ULOGIC;
		D3		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM4 ------
 component DLM4
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S10_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S10_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S10_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S10_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S11_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S11_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S11_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S11_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		S10		:  in    STD_ULOGIC;
		S11		:  in    STD_ULOGIC;
		S0		:  in    STD_ULOGIC;
		D0		:  in    STD_ULOGIC;
		D1		:  in    STD_ULOGIC;
		D2		:  in    STD_ULOGIC;
		D3		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLM4A ------
 component DLM4A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D0_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S10_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S10_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S10_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S10_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S11_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S11_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S11_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S11_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D0_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D1_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D2_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D2_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D3_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D3_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D0		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		S10		:  in    STD_ULOGIC;
		S11		:  in    STD_ULOGIC;
		S0		:  in    STD_ULOGIC;
		D0		:  in    STD_ULOGIC;
		D1		:  in    STD_ULOGIC;
		D2		:  in    STD_ULOGIC;
		D3		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLMA ------
 component DLMA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		A		:  in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLME1A ------
 component DLME1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_E_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_E_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_E_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		A		:  in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		E		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1 ------
 component DLP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1A ------
 component DLP1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_posedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1B ------
 component DLP1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1C ------
 component DLP1C
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DLP1D ------
 component DLP1D
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_negedge		:VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_posedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component DLP1E ------
 component DLP1E
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_QN		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_G_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_G_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tperiod_G_posedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_G_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		D		:  in    STD_ULOGIC;
		PRE		:  in    STD_ULOGIC;
		G		:  in    STD_ULOGIC;
		QN		:  out    STD_ULOGIC);

 end component;


------ Component FA1 ------
 component FA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CI_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		CI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component FCEND_BUFF ------
 component FCEND_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_FCI_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		FCI		: in    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component FCEND_INV ------
 component FCEND_INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_FCI_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		FCI		: in    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component FCINIT_BUFF ------
 component FCINIT_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 end component;


------ Component FCINIT_GND ------
 component FCINIT_GND
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		FCO		: out    STD_ULOGIC);
 end component;


------ Component FCINIT_INV ------
 component FCINIT_INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 end component;


------ Component FCINIT_VCC ------
 component FCINIT_VCC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		FCO		: out    STD_ULOGIC);
 end component;


------ Component GAND2 ------
 component GAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GMX4 ------
 component GMX4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GNAND2 ------
 component GNAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GND ------
 component GND
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component GNOR2 ------
 component GNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GOR2 ------
 component GOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component GXOR2 ------
 component GXOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_G_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_G		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		G		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HA1 ------
 component HA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1A ------
 component HA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1B ------
 component HA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HA1C ------
 component HA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_CO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		CO		: out    STD_ULOGIC);
 end component;


------ Component HCLKBIBUF ------
 component HCLKBIBUF
    generic(
                TimingChecksOn:Boolean := True;
                Xon: Boolean := False;
                InstancePath: STRING :="*";
                MsgOn: Boolean := True;
                tpd_D_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_PAD               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_PAD_Y               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_D_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_E_Y                 : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_D                  : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_E                  : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_PAD                : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                PAD             : inout  STD_ULOGIC;
                D               : in     STD_ULOGIC;
                E               : in     STD_ULOGIC;
                Y               : out    STD_ULOGIC);
 end component;


------ Component HCLKBUF ------
 component HCLKBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_LVCMOS25 ------
 component HCLKBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_LVCMOS18 ------
 component HCLKBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_LVCMOS15 ------
 component HCLKBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_PCI ------
 component HCLKBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_PCIX ------
 component HCLKBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_GTLP33 ------
 component HCLKBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_GTLP25 ------
 component HCLKBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_HSTL_I ------
 component HCLKBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_SSTL3_I ------
 component HCLKBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_SSTL3_II ------
 component HCLKBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_SSTL2_I ------
 component HCLKBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKBUF_SSTL2_II ------
 component HCLKBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component HCLKINT ------
 component HCLKINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF ------
 component INBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25 ------
 component INBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25D ------
 component INBUF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS25U ------
 component INBUF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18 ------
 component INBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18D ------
 component INBUF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS18U ------
 component INBUF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15 ------
 component INBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15D ------
 component INBUF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_LVCMOS15U ------
 component INBUF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_PCI ------
 component INBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_PCIX ------
 component INBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_GTLP33 ------
 component INBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_GTLP25 ------
 component INBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_HSTL_I ------
 component INBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL3_I ------
 component INBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL3_II ------
 component INBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL2_I ------
 component INBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INBUF_SSTL2_II ------
 component INBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INV ------
 component INV
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INVA ------
 component INVA
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component INVD ------
 component INVD
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOI_DFEG ------
 component IOI_DFEG
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component IOI_DFEH ------
 component IOI_DFEH
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component IOI_BUFF ------
 component IOI_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOOE_BUFF ------
 component IOOE_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOOE_DFEG ------
 component IOOE_DFEG
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		tperiod_CLK_negedge        :  VitalDelayType := 0.000 ns;
		tpw_CLK_posedge        :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge        :  VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                CLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                Q                : out    STD_ULOGIC;
                YOUT                : out    STD_ULOGIC);
 end component;


------ Component IOOE_DFEH ------
 component IOOE_DFEH
	generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PRE_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_YOUT	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_D_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge       :   VitalDelayType := 0.000 ns;
		tperiod_CLK_negedge        :  VitalDelayType := 0.000 ns;
		tpw_CLK_posedge        :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge        :  VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge       :   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		tpw_PRE_negedge	:  VitalDelayType := 0.000 ns;
		tipd_D :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PRE :   VitalDelayType01 := (0.000 ns, 0.000 ns));
    port(
                D         : in    STD_ULOGIC;
                CLK         : in    STD_ULOGIC;
                CLR         : in    STD_ULOGIC;
                E         : in    STD_ULOGIC;
                PRE         : in    STD_ULOGIC;
                Q                : out    STD_ULOGIC;
                YOUT                : out    STD_ULOGIC);
 end component;


------ Component IOPAD_IN ------
 component IOPAD_IN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
-- DNW: Add the following 2 lines
		tpw_PAD_posedge		: VitalDelayType := 0.000 ns;
		tpw_PAD_negedge		: VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_TRI ------
 component IOPAD_TRI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
		tpw_D_negedge	: VitalDelayType := 0.000 ns;
		tpw_E_posedge   : VitalDelayType := 0.000 ns;
		tpw_E_negedge	: VitalDelayType := 0.000 ns;

		tpd_D_PAD       : VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD	: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_BI ------
 component IOPAD_BI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		
                tpw_D_posedge           : VitalDelayType := 0.000 ns;
                tpw_D_negedge           : VitalDelayType := 0.000 ns;
                tpw_E_posedge           : VitalDelayType := 0.000 ns;
                tpw_E_negedge           : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
                tpw_PAD_posedge         : VitalDelayType := 0.000 ns;
  
                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component JKF ------
 component JKF
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF1B ------
 component JKF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF2A ------
 component JKF2A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF2B ------
 component JKF2B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge           :   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF3A ------
 component JKF3A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_posedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_posedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component JKF3B ------
 component JKF3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_J_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_J_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_J_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_J_CLK_negedge_negedge   :   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_K_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_K_CLK_negedge_negedge           :   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge   	:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge		:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge		:  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_J      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_K      :   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		J	:  in    STD_ULOGIC;
		K	:  in    STD_ULOGIC;
	        PRE	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component MAJ3 ------
 component MAJ3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3X ------
 component MAJ3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MAJ3XI ------
 component MAJ3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3 ------
 component MIN3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3X ------
 component MIN3X
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MIN3XI ------
 component MIN3XI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MULT1 ------
 component MULT1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_PO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_PO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PI_PO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_PO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PI_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PI		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		PI		: in    STD_ULOGIC;
		FCI		: in    STD_ULOGIC;
		PO		: out    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 end component;


------ Component MX2 ------
 component MX2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2A ------
 component MX2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2B ------
 component MX2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX2C ------
 component MX2C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		S		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component MX4 ------
 component MX4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S1		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2 ------
 component NAND2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2A ------
 component NAND2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND2B ------
 component NAND2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3 ------
 component NAND3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3A ------
 component NAND3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3B ------
 component NAND3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND3C ------
 component NAND3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4 ------
 component NAND4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4A ------
 component NAND4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4B ------
 component NAND4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4C ------
 component NAND4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND4D ------
 component NAND4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND5B ------
 component NAND5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NAND5C ------
 component NAND5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2 ------
 component NOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2A ------
 component NOR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR2B ------
 component NOR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3 ------
 component NOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3A ------
 component NOR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3B ------
 component NOR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR3C ------
 component NOR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4 ------
 component NOR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4A ------
 component NOR4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4B ------
 component NOR4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4C ------
 component NOR4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR4D ------
 component NOR4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR5B ------
 component NOR5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component NOR5C ------
 component NOR5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1 ------
 component OA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1A ------
 component OA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1B ------
 component OA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		C		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA1C ------
 component OA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		C		: in    STD_ULOGIC;
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA2 ------
 component OA2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA2A ------
 component OA2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3 ------
 component OA3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3A ------
 component OA3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA3B ------
 component OA3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA4 ------
 component OA4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA4A ------
 component OA4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OA5 ------
 component OA5
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI1 ------
 component OAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI2A ------
 component OAI2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI3 ------
 component OAI3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OAI3A ------
 component OAI3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2 ------
 component OR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2A ------
 component OR2A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR2B ------
 component OR2B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3 ------
 component OR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3A ------
 component OR3A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3B ------
 component OR3B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR3C ------
 component OR3C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4 ------
 component OR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4A ------
 component OR4A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4B ------
 component OR4B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4C ------
 component OR4C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR4D ------
 component OR4D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5A ------
 component OR5A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5B ------
 component OR5B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OR5C ------
 component OR5C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF ------
 component OUTBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_8 ------
 component OUTBUF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_12 ------
 component OUTBUF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_16 ------
 component OUTBUF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_S_24 ------
 component OUTBUF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_8 ------
 component OUTBUF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_12 ------
 component OUTBUF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_16 ------
 component OUTBUF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_F_24 ------
 component OUTBUF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS25 ------
 component OUTBUF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS18 ------
 component OUTBUF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_LVCMOS15 ------
 component OUTBUF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_PCI ------
 component OUTBUF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_PCIX ------
 component OUTBUF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTLP33 ------
 component OUTBUF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_GTLP25 ------
 component OUTBUF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_HSTL_I ------
 component OUTBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL3_I ------
 component OUTBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL3_II ------
 component OUTBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL2_I ------
 component OUTBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component OUTBUF_SSTL2_II ------
 component OUTBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component PLLHCLK ------
 component PLLHCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component PLLRCLK ------
 component PLLRCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component SFCNTECP1 ------
 component SFCNTECP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component SRCNTECP1 ------
 component SRCNTECP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component SFCNTELDCP1 ------
 component SFCNTELDCP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component SRCNTELDCP1 ------
 component SRCNTELDCP1
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 end component;


------ Component SUB1 ------
 component SUB1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		FCI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 end component;


------ Component TF1A ------
 component TF1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_T_CLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		thold_T_CLK_negedge_posedge	:   VitalDelayType := 0.000 ns;
		tsetup_T_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_T_CLK_posedge_posedge   :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge	:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge	:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLK	:  VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_T	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		T	:  in    STD_ULOGIC;
		CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component TF1B ------
 component TF1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q	:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_T_CLK_negedge_negedge	:   VitalDelayType := 0.000 ns;
		thold_T_CLK_negedge_negedge	:   VitalDelayType := 0.000 ns;
		tsetup_T_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_T_CLK_posedge_negedge   :   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge	:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge	:  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge	:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge	:  VitalDelayType := 0.000 ns;
		tipd_CLK	:  VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR	:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_T	:   VitalDelayType01 := (0.000 ns, 0.000 ns));


     port(
		T	:  in    STD_ULOGIC;
		CLR	:  in    STD_ULOGIC;
	        CLK	:  in    STD_ULOGIC;
		Q	:  out    STD_ULOGIC);

 end component;


------ Component TRIBUFF ------
 component TRIBUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8 ------
 component TRIBUFF_S_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8D ------
 component TRIBUFF_S_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_8U ------
 component TRIBUFF_S_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12 ------
 component TRIBUFF_S_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12D ------
 component TRIBUFF_S_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_12U ------
 component TRIBUFF_S_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16 ------
 component TRIBUFF_S_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16D ------
 component TRIBUFF_S_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_16U ------
 component TRIBUFF_S_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24 ------
 component TRIBUFF_S_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24D ------
 component TRIBUFF_S_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_S_24U ------
 component TRIBUFF_S_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8 ------
 component TRIBUFF_F_8
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8D ------
 component TRIBUFF_F_8D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_8U ------
 component TRIBUFF_F_8U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12 ------
 component TRIBUFF_F_12
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12D ------
 component TRIBUFF_F_12D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_12U ------
 component TRIBUFF_F_12U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16 ------
 component TRIBUFF_F_16
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16D ------
 component TRIBUFF_F_16D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_16U ------
 component TRIBUFF_F_16U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24 ------
 component TRIBUFF_F_24
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24D ------
 component TRIBUFF_F_24D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_F_24U ------
 component TRIBUFF_F_24U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25 ------
 component TRIBUFF_LVCMOS25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25D ------
 component TRIBUFF_LVCMOS25D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS25U ------
 component TRIBUFF_LVCMOS25U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18 ------
 component TRIBUFF_LVCMOS18
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18D ------
 component TRIBUFF_LVCMOS18D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS18U ------
 component TRIBUFF_LVCMOS18U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15 ------
 component TRIBUFF_LVCMOS15
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15D ------
 component TRIBUFF_LVCMOS15D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_LVCMOS15U ------
 component TRIBUFF_LVCMOS15U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_PCI ------
 component TRIBUFF_PCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_PCIX ------
 component TRIBUFF_PCIX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTLP33 ------
 component TRIBUFF_GTLP33
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_GTLP25 ------
 component TRIBUFF_GTLP25
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component VCC ------
 component VCC
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True		);
    port(
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1 ------
 component XA1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1A ------
 component XA1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1B ------
 component XA1B
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XA1C ------
 component XA1C
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1 ------
 component XAI1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XAI1A ------
 component XAI1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR2 ------
 component XNOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR3 ------
 component XNOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XNOR4 ------
 component XNOR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1 ------
 component XO1
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XO1A ------
 component XO1A
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR2 ------
 component XOR2
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR3 ------
 component XOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR4 ------
 component XOR4
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component XOR4_FCI ------
 component XOR4_FCI
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		FCI		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3 ------
 component ZOR3
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component ZOR3I ------
 component ZOR3I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOFIFO_BIBUF ------
 component IOFIFO_BIBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_AIN_YIN		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_AOUT_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_AIN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_AOUT		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		AIN		: in    STD_ULOGIC;
		AOUT		: in    STD_ULOGIC;
		YIN		: out    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC);
 end component;


------ Component IOI_FCLK_EN_BUFF ------
 component IOI_FCLK_EN_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOI_FCLK_BUFF ------
 component IOI_FCLK_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOI_RCLK_EN_BUFF ------
 component IOI_RCLK_EN_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOI_RCLK_BUFF ------
 component IOI_RCLK_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_FCLK_EN_BUFF ------
 component IOOE_FCLK_EN_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_FCLK ------
 component IOOE_FCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		: in    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_RCLK_EN_BUFF ------
 component IOOE_RCLK_EN_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_RCLK_CLR_EN ------
 component IOOE_RCLK_CLR_EN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_CLR_CLROUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_CLR		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		CLROUT		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_RCLK_BUFF ------
 component IOOE_RCLK_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_RCLK ------
 component IOOE_RCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		: in    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component PLLINT ------
 component PLLINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component PLLOUT ------
 component PLLOUT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_HSTL_I ------
 component BIBUF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL3_I ------
 component BIBUF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL3_II ------
 component BIBUF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL2_I ------
 component BIBUF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BIBUF_SSTL2_II ------
 component BIBUF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component BUFF ------
 component BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKINT ------
 component CLKINT
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKINT_W ------
 component CLKINT_W
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKOUT_E ------
 component CLKOUT_E
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component CLKOUT_W ------
 component CLKOUT_W
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component DFM ------
 component DFM
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFM3B ------
 component DFM3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFM4A ------
 component DFM4A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFM4B ------
 component DFM4B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMA ------
 component DFMA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMB ------
 component DFMB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME1A ------
 component DFME1A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME1B ------
 component DFME1B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME2A ------
 component DFME2A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME2B ------
 component DFME2B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME3A ------
 component DFME3A
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFME3B ------
 component DFME3B
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMEG ------
 component DFMEG
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMEH ------
 component DFMEH
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMPCA ------
 component DFMPCA
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component DFMPCB ------
 component DFMPCB
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_S_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_A_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_B_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_A		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		S		:  in    STD_ULOGIC;
		A		:  in    STD_ULOGIC;
		B		:  in    STD_ULOGIC;
		Q		:  out    STD_ULOGIC);

 end component;


------ Component HCLKMUX ------
 component HCLKMUX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		
                tpw_A_posedge   : VitalDelayType := 0.000 ns;
                tpw_A_negedge   : VitalDelayType := 0.000 ns;    
                tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOFIFO_INBUF ------
 component IOFIFO_INBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOFIFO_OUTBUF ------
 component IOFIFO_OUTBUF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOOE_FCLK_BUFF ------
 component IOOE_FCLK_BUFF
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_OUT_FCLK ------
 component IOOE_OUT_FCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_OUT_FCLK_CLR_EN ------
 component IOOE_OUT_FCLK_CLR_EN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_CLROUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLR		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLROUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_OUT_RCLK ------
 component IOOE_OUT_RCLK
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_OUT_RCLK_CLR_EN ------
 component IOOE_OUT_RCLK_CLR_EN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_YOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_CLROUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		EN		: in    STD_ULOGIC;
		CLR		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		YOUT		: out    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLROUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOOE_FCLK_CLR_EN ------
 component IOOE_FCLK_CLR_EN
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_EN_ENOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_CLROUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_CLKOUT		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_EN		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		EN		: in    STD_ULOGIC;
		CLR		: in    STD_ULOGIC;
		CLK		: in    STD_ULOGIC;
		ENOUT		: out    STD_ULOGIC;
		CLROUT		: out    STD_ULOGIC;
		CLKOUT		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_IN_U ------
 component IOPAD_IN_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_PAD_posedge		: VitalDelayType := 0.000 ns;
		tpw_PAD_negedge		: VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_IN_D ------
 component IOPAD_IN_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_PAD_posedge		: VitalDelayType := 0.000 ns;
		tpw_PAD_negedge         : VitalDelayType := 0.000 ns;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_TRI_U ------
 component IOPAD_TRI_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
		tpw_D_negedge	: VitalDelayType := 0.000 ns;
		tpw_E_posedge	: VitalDelayType := 0.000 ns;
		tpw_E_negedge       : VitalDelayType := 0.000 ns;
		
                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_TRI_D ------
 component IOPAD_TRI_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpw_D_posedge	: VitalDelayType := 0.000 ns;
	        tpw_D_negedge   : VitalDelayType := 0.000 ns;
		tpw_E_posedge   : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	: VitalDelayType := 0.000 ns;

                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_BI_U ------
 component IOPAD_BI_U
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;

		tpw_D_posedge	    : VitalDelayType := 0.000 ns;
	        tpw_D_negedge       : VitalDelayType := 0.000 ns;
		tpw_E_posedge       : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_PAD_posedge     : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge     : VitalDelayType := 0.000 ns;

                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);

		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD	: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component IOPAD_BI_D ------
 component IOPAD_BI_D
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
	
		tpw_E_posedge       : VitalDelayType := 0.000 ns;
                tpw_E_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_D_posedge       : VitalDelayType := 0.000 ns;
                tpw_D_negedge 	    : VitalDelayType := 0.000 ns;
		tpw_PAD_posedge     : VitalDelayType := 0.000 ns;
                tpw_PAD_negedge     : VitalDelayType := 0.000 ns;

        	tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component RCLKMUX ------
 component RCLKMUX
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
	   
                tpw_A_posedge   : VitalDelayType := 0.000 ns;
                tpw_A_negedge   : VitalDelayType := 0.000 ns;
         	tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_HSTL_I ------
 component TRIBUFF_HSTL_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		
                tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL3_I ------
 component TRIBUFF_SSTL3_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL3_II ------
 component TRIBUFF_SSTL3_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL2_I ------
 component TRIBUFF_SSTL2_I
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;


------ Component TRIBUFF_SSTL2_II ------
 component TRIBUFF_SSTL2_II
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: out    STD_ULOGIC);
 end component;

component BIOFIFO_BIDIRINFIFO 
  GENERIC (
        tipd_A       : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_D       : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_WENB       : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_WCLK     : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_RENB       : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_RCLK     : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tipd_CLRB      : VitalDelayType01 := (0.00 ns, 0.00 ns);
        tpd_A_Y   : VitalDelayType01 := (0.1000 ns, 0.1000 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.1000 ns, 0.1000 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.1000 ns, 0.1000 ns);
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        A     : IN STD_ULOGIC ;
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC ;
        Y     : OUT STD_ULOGIC
        );

  
end component;


component BIOFIFO_BIDIROUTFIFO 
  GENERIC (
        tipd_A       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_A_Y   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        A     : IN STD_ULOGIC ;
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC ;
        Y     : OUT STD_ULOGIC
        );

  
end component;


component BIOFIFO_INFIFO 
  GENERIC (
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC
        );

  
end component;

component BIOFIFO_OUTFIFO 
  GENERIC (
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC
        );


end component;


component IOFIFO_BIDIRINFIFO 
  GENERIC (
        tipd_A       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_A_Y   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        A     : IN STD_ULOGIC ;
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC ;
        Y     : OUT STD_ULOGIC
        );


  
end component;


component IOFIFO_BIDIROUTFIFO 
  GENERIC (
        tipd_A       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_A_Y   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        A     : IN STD_ULOGIC ;
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC ;
        Y     : OUT STD_ULOGIC
        );

  
end component;


component IOFIFO_INFIFO 
  GENERIC (
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC
        );

  
end component;

component IOFIFO_OUTFIFO 
  GENERIC (
        tipd_D       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RENB       : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLRB      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_RCLK_Q   : VitalDelayType01 := (0.1000 ns, 0.100 ns);
        tpd_CLRB_Q    : VitalDelayType01 := (0.1000 ns, 0.1000 ns);
        tsetup_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_D_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RENB_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WENB_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RENB_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WENB_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_negedge_posedge     :   VitalDelayType := 0.000 ns;
        thold_CLRB_RCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLRB_WCLK_posedge_posedge     :   VitalDelayType := 0.000 ns;
        trecovery_CLRB_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLRB_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        D     : IN STD_ULOGIC ;
        WENB     : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RENB     : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        CLRB    : IN STD_ULOGIC ;
        Q     : OUT STD_ULOGIC
        );

  
end component;

component IOPADP_IN
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_PAD_posedge 		: VitalDelayType := 0.000 ns;
      tpw_PAD_negedge           : VitalDelayType := 0.000 ns;
      tpw_N2PIN_posedge 	: VitalDelayType := 0.000 ns;
      tpw_N2PIN_negedge         : VitalDelayType := 0.000 ns;   

      tpd_PAD_Y                 :        VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_N2PIN_Y               :        VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PAD         	     :        VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_N2PIN       	     :        VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :        in    STD_ULOGIC;
      N2PIN                          :        in    STD_ULOGIC;
      Y                              :        out   STD_ULOGIC);

end component;


component IOPADN_IN 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_PAD_posedge 		: VitalDelayType := 0.000 ns;
      tpw_PAD_negedge           : VitalDelayType := 0.000 ns;
 
      tpd_PAD_N2POUT                 :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PAD                       	     :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PAD                            :	in    STD_ULOGIC;
      N2POUT                         :	out   STD_ULOGIC);

end component;

component IOPADP_TRI 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpw_E_posedge           : VitalDelayType := 0.000 ns;
      tpw_E_negedge           : VitalDelayType := 0.000 ns;
      tpw_D_posedge           : VitalDelayType := 0.000 ns;
      tpw_D_negedge           : VitalDelayType := 0.000 ns;
      
tpd_E_PAD                      :	VitalDelayType01z := 
               (0.100 ns, 0.100 ns, 0.100 ns, 0.000 ns, 0.100 ns, 0.100 ns);
      tpd_D_PAD                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);

end component;

component IOPADN_TRI 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      
      tpw_DB_posedge 	    :   VitalDelayType := 0.000 ns;
      tpw_DB_negedge            :   VitalDelayType := 0.000 ns;
      tpw_E_posedge 		: VitalDelayType := 0.000 ns;
      tpw_E_negedge           : VitalDelayType := 0.000 ns;

      tpd_E_PAD                     :	VitalDelayType01z := 
               (0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns, 0.100 ns);
      tpd_DB_PAD                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_DB                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_E                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      DB                             :	in    STD_ULOGIC;
      E                              :	in    STD_ULOGIC;
      PAD                            :	out   STD_ULOGIC);

end component;


component CLKBUF_LVDS 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component CLKBUF_LVPECL 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component HCLKBUF_LVDS 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component HCLKBUF_LVPECL 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component INBUF_LVDS 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component INBUF_LVPECL 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_PADP_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_PADN_Y                    :  VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_PADP                             :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_PADN                             :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PADP                           :  in    STD_ULOGIC;
      PADN                           :  in    STD_ULOGIC;
      Y                              :  out   STD_ULOGIC);

end component;

component OUTBUF_LVDS 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_PADP                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D_PADN                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                                 :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      PADP                           :	out   STD_ULOGIC;
      PADN                           :	out   STD_ULOGIC);

end component;

component OUTBUF_LVPECL 
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_D_PADP                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D_PADN                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D                         :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D                              :	in    STD_ULOGIC;
      PADP                           :	out   STD_ULOGIC;
      PADN                           :	out   STD_ULOGIC);

end component;


component CM8F
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;
      tpd_S11_Y                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S10_Y                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S01_Y                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S00_Y                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D3_Y                       :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D2_Y                       :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D1_Y                       :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D0_Y                       :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S11_FY                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S10_FY                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S01_FY                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_S00_FY                     :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D3_FY                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D2_FY                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D1_FY                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tpd_D0_FY                      :	VitalDelayType01 := (0.100 ns, 0.100 ns);
      tipd_D0                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D1                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D2                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_D3                        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S00                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S01                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S10                       :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_S11                       :	VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      D0                             :	in    STD_ULOGIC;
      D1                             :	in    STD_ULOGIC;
      D2                             :	in    STD_ULOGIC;
      D3                             :	in    STD_ULOGIC;
      S00                            :	in    STD_ULOGIC;
      S01                            :	in    STD_ULOGIC;
      S10                            :	in    STD_ULOGIC;
      S11                            :	in    STD_ULOGIC;
      FY                             :	out   STD_ULOGIC;
      Y                              :	out   STD_ULOGIC);
end component; 

component FIFO64K36 
  GENERIC (
        tipd_DEPTH3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WIDTH2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WIDTH1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WIDTH0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL7   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL6   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL5   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL4   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AEVAL0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL7   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL6   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL5   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL4   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_AFVAL0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_REN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD35     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD34     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD33     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD32     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD31     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD30     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD29     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD28     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD27     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD26     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD25     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD24     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD23     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD22     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD21     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD20     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD19     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD18     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD17     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD16     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD15     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD14     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD13     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD12     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WEN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_CLR      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tpd_RCLK_RD0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD9  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD10 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD11 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD12 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD13 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD14 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD15 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD16 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD17 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD18 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD19 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD20 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD21 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD22 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD23 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD24 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD25 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD26 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD27 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD28 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD29 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD30 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD31 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD32 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD33 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD34 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD35 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_FULL   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_AFULL  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_EMPTY  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_AEMPTY : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD9  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD10 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD11 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD12 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD13 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD14 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD15 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD16 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD17 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD18 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD19 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD20 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD21 : VitalDelayType01 := (0.100 ns, 0.10 ns);
        tpd_CLR_RD22 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD23 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD24 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD25 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD26 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD27 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD28 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD29 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD30 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD31 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD32 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD33 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_RD34 : VitalDelayType01 := (0.1000 ns, 0.100 ns);
        tpd_CLR_RD35 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_FULL   : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_AFULL  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_EMPTY  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_CLR_AEMPTY : VitalDelayType01 := (0.100 ns, 0.100 ns);


        tsetup_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;

        tsetup_WEN_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_WEN_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        tsetup_DEPTH3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        tsetup_WIDTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_AEVAL7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_AFVAL7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_DEPTH3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        tsetup_WIDTH2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WIDTH0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        tsetup_AEVAL7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AEVAL0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_AFVAL7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_AFVAL0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_REN_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_REN_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        thold_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        thold_WEN_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WEN_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        thold_DEPTH3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_WIDTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        thold_AEVAL7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        thold_AFVAL7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;



        thold_DEPTH3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_WIDTH2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WIDTH0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_AEVAL7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AEVAL0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        thold_AFVAL7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_AFVAL0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        thold_REN_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_REN_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        trecovery_CLR_RCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLR_RCLK_posedge_posedge      :  VitalDelayType := 0.000 ns;

        trecovery_CLR_WCLK_posedge_posedge :  VitalDelayType := 0.000 ns;
        thold_CLR_WCLK_posedge_posedge      :  VitalDelayType := 0.000 ns;
        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_CLR_negedge     : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        DEPTH3 : IN STD_ULOGIC ;
        DEPTH2 : IN STD_ULOGIC ;
        DEPTH1 : IN STD_ULOGIC ;
        DEPTH0 : IN STD_ULOGIC ;
        WIDTH2 : IN STD_ULOGIC ;
        WIDTH1 : IN STD_ULOGIC ;
        WIDTH0 : IN STD_ULOGIC ;
        AEVAL7 : IN STD_ULOGIC ;
        AEVAL6 : IN STD_ULOGIC ;
        AEVAL5 : IN STD_ULOGIC ;
        AEVAL4 : IN STD_ULOGIC ;
        AEVAL3 : IN STD_ULOGIC ;
        AEVAL2 : IN STD_ULOGIC ;
        AEVAL1 : IN STD_ULOGIC ;
        AEVAL0 : IN STD_ULOGIC ;
        AFVAL7 : IN STD_ULOGIC ;
        AFVAL6 : IN STD_ULOGIC ;
        AFVAL5 : IN STD_ULOGIC ;
        AFVAL4 : IN STD_ULOGIC ;
        AFVAL3 : IN STD_ULOGIC ;
        AFVAL2 : IN STD_ULOGIC ;
        AFVAL1 : IN STD_ULOGIC ;
        AFVAL0 : IN STD_ULOGIC ;
        REN    : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        WD35   : IN STD_ULOGIC ;
        WD34   : IN STD_ULOGIC ;
        WD33   : IN STD_ULOGIC ;
        WD32   : IN STD_ULOGIC ;
        WD31   : IN STD_ULOGIC ;
        WD30   : IN STD_ULOGIC ;
        WD29   : IN STD_ULOGIC ;
        WD28   : IN STD_ULOGIC ;
        WD27   : IN STD_ULOGIC ;
        WD26   : IN STD_ULOGIC ;
        WD25   : IN STD_ULOGIC ;
        WD24   : IN STD_ULOGIC ;
        WD23   : IN STD_ULOGIC ;
        WD22   : IN STD_ULOGIC ;
        WD21   : IN STD_ULOGIC ;
        WD20   : IN STD_ULOGIC ;
        WD19   : IN STD_ULOGIC ;
        WD18   : IN STD_ULOGIC ;
        WD17   : IN STD_ULOGIC ;
        WD16   : IN STD_ULOGIC ;
        WD15   : IN STD_ULOGIC ;
        WD14   : IN STD_ULOGIC ;
        WD13   : IN STD_ULOGIC ;
        WD12   : IN STD_ULOGIC ;
        WD11   : IN STD_ULOGIC ;
        WD10   : IN STD_ULOGIC ;
        WD9    : IN STD_ULOGIC ;
        WD8    : IN STD_ULOGIC ;
        WD7    : IN STD_ULOGIC ;
        WD6    : IN STD_ULOGIC ;
        WD5    : IN STD_ULOGIC ;
        WD4    : IN STD_ULOGIC ;
        WD3    : IN STD_ULOGIC ;
        WD2    : IN STD_ULOGIC ;
        WD1    : IN STD_ULOGIC ;
        WD0    : IN STD_ULOGIC ;
        WEN    : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        CLR    : IN STD_ULOGIC ;
        RD35   : OUT STD_ULOGIC ;
        RD34   : OUT STD_ULOGIC ;
        RD33   : OUT STD_ULOGIC ;
        RD32   : OUT STD_ULOGIC ;
        RD31   : OUT STD_ULOGIC ;
        RD30   : OUT STD_ULOGIC ;
        RD29   : OUT STD_ULOGIC ;
        RD28   : OUT STD_ULOGIC ;
        RD27   : OUT STD_ULOGIC ;
        RD26   : OUT STD_ULOGIC ;
        RD25   : OUT STD_ULOGIC ;
        RD24   : OUT STD_ULOGIC ;
        RD23   : OUT STD_ULOGIC ;
        RD22   : OUT STD_ULOGIC ;
        RD21   : OUT STD_ULOGIC ;
        RD20   : OUT STD_ULOGIC ;
        RD19   : OUT STD_ULOGIC ;
        RD18   : OUT STD_ULOGIC ;
        RD17   : OUT STD_ULOGIC ;
        RD16   : OUT STD_ULOGIC ;
        RD15   : OUT STD_ULOGIC ;
        RD14   : OUT STD_ULOGIC ;
        RD13   : OUT STD_ULOGIC ;
        RD12   : OUT STD_ULOGIC ;
        RD11   : OUT STD_ULOGIC ;
        RD10   : OUT STD_ULOGIC ;
        RD9    : OUT STD_ULOGIC ;
        RD8    : OUT STD_ULOGIC ;
        RD7    : OUT STD_ULOGIC ;
        RD6    : OUT STD_ULOGIC ;
        RD5    : OUT STD_ULOGIC ;
        RD4    : OUT STD_ULOGIC ;
        RD3    : OUT STD_ULOGIC ;
        RD2    : OUT STD_ULOGIC ;
        RD1    : OUT STD_ULOGIC ;
        RD0    : OUT STD_ULOGIC ;
        FULL   : OUT STD_ULOGIC ;
        AFULL  : OUT STD_ULOGIC ;
        EMPTY  : OUT STD_ULOGIC ;
        AEMPTY : OUT STD_ULOGIC
        );


  
end component;

component RAM64K36 
  GENERIC (
        tipd_DEPTH3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD15   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD14   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD13   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD12   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD11   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD10   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD9    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD35     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD34     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD33     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD32     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD31     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD30     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD29     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD28     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD27     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD26     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD25     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD24     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD23     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD22     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD21     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD20     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD19     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD18     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD17     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD16     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD15     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD14     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD13     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD12     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WEN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD15   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD14   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD13   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD12   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD11   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD10   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD9    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_REN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);


        tpd_RCLK_RD0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD9  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD10 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD11 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD12 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD13 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD14 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD15 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD16 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD17 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD18 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD19 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD20 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD21 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD22 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD23 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD24 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD25 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD26 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD27 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD28 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD29 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD30 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD31 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD32 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD33 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD34 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD35 : VitalDelayType01 := (0.100 ns, 0.100 ns);


        tsetup_RDAD15_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD14_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD13_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD12_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD11_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD10_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD9_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD8_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_RDAD15_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD14_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD13_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD12_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD11_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD10_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD9_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD8_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        tsetup_RW2_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW1_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW0_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW2_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW1_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW0_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        tsetup_DEPTH3_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH3_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;



        tsetup_WRAD15_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD14_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD13_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD12_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD11_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD10_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD9_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD8_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_WRAD15_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD14_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD13_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD12_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD11_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD10_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD9_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD8_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        tsetup_WW2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        thold_RDAD15_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD14_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD13_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD12_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD11_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD10_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD9_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD8_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD7_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD6_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD5_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD4_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD3_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD2_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD1_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD0_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;

        thold_RDAD15_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD14_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD13_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD12_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD11_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD10_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD9_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD8_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD7_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD6_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD5_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD4_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD3_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD2_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD1_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD0_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;



        thold_RW2_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW1_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW0_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW2_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW1_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW0_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        thold_DEPTH3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;

        thold_WRAD15_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD14_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD13_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD12_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD11_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD10_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD9_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD8_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        thold_WRAD15_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD14_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD13_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD12_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD11_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD10_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD9_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD8_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        thold_WW2_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW1_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW0_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW2_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW1_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW0_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        tsetup_REN_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WEN_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_REN_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WEN_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_REN_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WEN_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_REN_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WEN_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        DEPTH3 : IN STD_ULOGIC ;
        DEPTH2 : IN STD_ULOGIC ;
        DEPTH1 : IN STD_ULOGIC ;
        DEPTH0 : IN STD_ULOGIC ;
        WRAD15 : IN STD_ULOGIC ;
        WRAD14 : IN STD_ULOGIC ;
        WRAD13 : IN STD_ULOGIC ;
        WRAD12 : IN STD_ULOGIC ;
        WRAD11 : IN STD_ULOGIC ;
        WRAD10 : IN STD_ULOGIC ;
        WRAD9  : IN STD_ULOGIC ;
        WRAD8  : IN STD_ULOGIC ;
        WRAD7  : IN STD_ULOGIC ;
        WRAD6  : IN STD_ULOGIC ;
        WRAD5  : IN STD_ULOGIC ;
        WRAD4  : IN STD_ULOGIC ;
        WRAD3  : IN STD_ULOGIC ;
        WRAD2  : IN STD_ULOGIC ;
        WRAD1  : IN STD_ULOGIC ;
        WRAD0  : IN STD_ULOGIC ;
        WD35   : IN STD_ULOGIC ;
        WD34   : IN STD_ULOGIC ;
        WD33   : IN STD_ULOGIC ;
        WD32   : IN STD_ULOGIC ;
        WD31   : IN STD_ULOGIC ;
        WD30   : IN STD_ULOGIC ;
        WD29   : IN STD_ULOGIC ;
        WD28   : IN STD_ULOGIC ;
        WD27   : IN STD_ULOGIC ;
        WD26   : IN STD_ULOGIC ;
        WD25   : IN STD_ULOGIC ;
        WD24   : IN STD_ULOGIC ;
        WD23   : IN STD_ULOGIC ;
        WD22   : IN STD_ULOGIC ;
        WD21   : IN STD_ULOGIC ;
        WD20   : IN STD_ULOGIC ;
        WD19   : IN STD_ULOGIC ;
        WD18   : IN STD_ULOGIC ;
        WD17   : IN STD_ULOGIC ;
        WD16   : IN STD_ULOGIC ;
        WD15   : IN STD_ULOGIC ;
        WD14   : IN STD_ULOGIC ;
        WD13   : IN STD_ULOGIC ;
        WD12   : IN STD_ULOGIC ;
        WD11   : IN STD_ULOGIC ;
        WD10   : IN STD_ULOGIC ;
        WD9    : IN STD_ULOGIC ;
        WD8    : IN STD_ULOGIC ;
        WD7    : IN STD_ULOGIC ;
        WD6    : IN STD_ULOGIC ;
        WD5    : IN STD_ULOGIC ;
        WD4    : IN STD_ULOGIC ;
        WD3    : IN STD_ULOGIC ;
        WD2    : IN STD_ULOGIC ;
        WD1    : IN STD_ULOGIC ;
        WD0    : IN STD_ULOGIC ;
        WW2    : IN STD_ULOGIC ;
        WW1    : IN STD_ULOGIC ;
        WW0    : IN STD_ULOGIC ;
        WEN    : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RDAD15 : IN STD_ULOGIC ;
        RDAD14 : IN STD_ULOGIC ;
        RDAD13 : IN STD_ULOGIC ;
        RDAD12 : IN STD_ULOGIC ;
        RDAD11 : IN STD_ULOGIC ;
        RDAD10 : IN STD_ULOGIC ;
        RDAD9  : IN STD_ULOGIC ;
        RDAD8  : IN STD_ULOGIC ;
        RDAD7  : IN STD_ULOGIC ;
        RDAD6  : IN STD_ULOGIC ;
        RDAD5  : IN STD_ULOGIC ;
        RDAD4  : IN STD_ULOGIC ;
        RDAD3  : IN STD_ULOGIC ;
        RDAD2  : IN STD_ULOGIC ;
        RDAD1  : IN STD_ULOGIC ;
        RDAD0  : IN STD_ULOGIC ;
        RW2    : IN STD_ULOGIC ;
        RW1    : IN STD_ULOGIC ;
        RW0    : IN STD_ULOGIC ;
        REN    : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        RD35   : OUT STD_ULOGIC ;
        RD34   : OUT STD_ULOGIC ;
        RD33   : OUT STD_ULOGIC ;
        RD32   : OUT STD_ULOGIC ;
        RD31   : OUT STD_ULOGIC ;
        RD30   : OUT STD_ULOGIC ;
        RD29   : OUT STD_ULOGIC ;
        RD28   : OUT STD_ULOGIC ;
        RD27   : OUT STD_ULOGIC ;
        RD26   : OUT STD_ULOGIC ;
        RD25   : OUT STD_ULOGIC ;
        RD24   : OUT STD_ULOGIC ;
        RD23   : OUT STD_ULOGIC ;
        RD22   : OUT STD_ULOGIC ;
        RD21   : OUT STD_ULOGIC ;
        RD20   : OUT STD_ULOGIC ;
        RD19   : OUT STD_ULOGIC ;
        RD18   : OUT STD_ULOGIC ;
        RD17   : OUT STD_ULOGIC ;
        RD16   : OUT STD_ULOGIC ;
        RD15   : OUT STD_ULOGIC ;
        RD14   : OUT STD_ULOGIC ;
        RD13   : OUT STD_ULOGIC ;
        RD12   : OUT STD_ULOGIC ;
        RD11   : OUT STD_ULOGIC ;
        RD10   : OUT STD_ULOGIC ;
        RD9    : OUT STD_ULOGIC ;
        RD8    : OUT STD_ULOGIC ;
        RD7    : OUT STD_ULOGIC ;
        RD6    : OUT STD_ULOGIC ;
        RD5    : OUT STD_ULOGIC ;
        RD4    : OUT STD_ULOGIC ;
        RD3    : OUT STD_ULOGIC ;
        RD2    : OUT STD_ULOGIC ;
        RD1    : OUT STD_ULOGIC ;
        RD0    : OUT STD_ULOGIC
        );


end component;


component RAM64K36P 
  GENERIC (
        tipd_DEPTH3   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH2   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH1   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_DEPTH0   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD15   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD14   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD13   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD12   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD11   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD10   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD9    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WRAD0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD35     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD34     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD33     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD32     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD31     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD30     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD29     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD28     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD27     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD26     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD25     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD24     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD23     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD22     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD21     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD20     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD19     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD18     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD17     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD16     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD15     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD14     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD13     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD12     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD11     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD10     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD9      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD8      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD7      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD6      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD5      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD4      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD3      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WD0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WEN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_WCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD15   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD14   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD13   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD12   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD11   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD10   : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD9    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD8    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD7    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD6    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD5    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD4    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD3    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD2    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD1    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RDAD0    : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW2      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW1      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RW0      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_REN      : VitalDelayType01 := (0.000 ns, 0.000 ns);
        tipd_RCLK     : VitalDelayType01 := (0.000 ns, 0.000 ns);


        tpd_RCLK_RD0  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD1  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD2  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD3  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD4  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD5  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD6  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD7  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD8  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD9  : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD10 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD11 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD12 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD13 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD14 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD15 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD16 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD17 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD18 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD19 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD20 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD21 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD22 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD23 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD24 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD25 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD26 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD27 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD28 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD29 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD30 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD31 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD32 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD33 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD34 : VitalDelayType01 := (0.100 ns, 0.100 ns);
        tpd_RCLK_RD35 : VitalDelayType01 := (0.100 ns, 0.100 ns);


        tsetup_RDAD15_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD14_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD13_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD12_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD11_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD10_RCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD9_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD8_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD7_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD6_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD5_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD4_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD3_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD2_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD1_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD0_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_RDAD15_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD14_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD13_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD12_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD11_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD10_RCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_RDAD9_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD8_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD7_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD6_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD5_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD4_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD3_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD2_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD1_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_RDAD0_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;



        tsetup_RW2_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW1_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW0_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW2_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW1_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_RW0_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        tsetup_DEPTH3_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH3_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH2_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH1_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_DEPTH0_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;



        tsetup_WRAD15_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD14_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD13_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD12_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD11_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD10_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD9_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD8_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        tsetup_WRAD15_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD14_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD13_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD12_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD11_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD10_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        tsetup_WRAD9_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD8_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        tsetup_WRAD0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        tsetup_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        tsetup_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;



        tsetup_WW2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WW0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        thold_RDAD15_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD14_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD13_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD12_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD11_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD10_RCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD9_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD8_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD7_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD6_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD5_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD4_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD3_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD2_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD1_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD0_RCLK_posedge_posedge    : VitalDelayType := 0.000 ns;

        thold_RDAD15_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD14_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD13_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD12_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD11_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD10_RCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_RDAD9_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD8_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD7_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD6_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD5_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD4_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD3_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD2_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD1_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_RDAD0_RCLK_negedge_posedge    : VitalDelayType := 0.000 ns;

        thold_RW2_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW1_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW0_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW2_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW1_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_RW0_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        thold_DEPTH3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_DEPTH0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_WRAD15_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD14_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD13_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD12_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD11_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD10_WCLK_posedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD9_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD8_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD7_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD6_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD5_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD4_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD3_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD2_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD1_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD0_WCLK_posedge_posedge   : VitalDelayType := 0.000 ns;

        thold_WRAD15_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD14_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD13_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD12_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD11_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD10_WCLK_negedge_posedge  : VitalDelayType := 0.000 ns;
        thold_WRAD9_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD8_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD7_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD6_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD5_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD4_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD3_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD2_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD1_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;
        thold_WRAD0_WCLK_negedge_posedge   : VitalDelayType := 0.000 ns;


        thold_WD35_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_posedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD35_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD34_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD33_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD32_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD31_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD30_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD29_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD28_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD27_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD26_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD25_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD24_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD23_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD22_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD21_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD20_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD19_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD18_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD17_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD16_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD15_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD14_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD13_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD12_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD11_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD10_WCLK_negedge_posedge    : VitalDelayType := 0.000 ns;
        thold_WD9_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD8_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD7_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD6_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD5_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD4_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD3_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD2_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD1_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_WD0_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;


        thold_WW2_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW1_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW0_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW2_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW1_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WW0_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;

        tsetup_REN_RCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WEN_WCLK_posedge_posedge     : VitalDelayType := 0.000 ns;
        thold_REN_RCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WEN_WCLK_posedge_posedge      : VitalDelayType := 0.000 ns;
        tsetup_REN_RCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        tsetup_WEN_WCLK_negedge_posedge     : VitalDelayType := 0.000 ns;
        thold_REN_RCLK_negedge_posedge      : VitalDelayType := 0.000 ns;
        thold_WEN_WCLK_negedge_posedge      : VitalDelayType := 0.000 ns;



        tpw_RCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_RCLK_negedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_posedge    : VitalDelayType := 0.000 ns;
        tpw_WCLK_negedge    : VitalDelayType := 0.000 ns;
        TimingCheckOn : BOOLEAN := TRUE;
        InstancePath  : STRING := "*";
        Xon: Boolean := False;
        MsgOn: Boolean := True
        );
  PORT (
        DEPTH3 : IN STD_ULOGIC ;
        DEPTH2 : IN STD_ULOGIC ;
        DEPTH1 : IN STD_ULOGIC ;
        DEPTH0 : IN STD_ULOGIC ;
        WRAD15 : IN STD_ULOGIC ;
        WRAD14 : IN STD_ULOGIC ;
        WRAD13 : IN STD_ULOGIC ;
        WRAD12 : IN STD_ULOGIC ;
        WRAD11 : IN STD_ULOGIC ;
        WRAD10 : IN STD_ULOGIC ;
        WRAD9  : IN STD_ULOGIC ;
        WRAD8  : IN STD_ULOGIC ;
        WRAD7  : IN STD_ULOGIC ;
        WRAD6  : IN STD_ULOGIC ;
        WRAD5  : IN STD_ULOGIC ;
        WRAD4  : IN STD_ULOGIC ;
        WRAD3  : IN STD_ULOGIC ;
        WRAD2  : IN STD_ULOGIC ;
        WRAD1  : IN STD_ULOGIC ;
        WRAD0  : IN STD_ULOGIC ;
        WD35   : IN STD_ULOGIC ;
        WD34   : IN STD_ULOGIC ;
        WD33   : IN STD_ULOGIC ;
        WD32   : IN STD_ULOGIC ;
        WD31   : IN STD_ULOGIC ;
        WD30   : IN STD_ULOGIC ;
        WD29   : IN STD_ULOGIC ;
        WD28   : IN STD_ULOGIC ;
        WD27   : IN STD_ULOGIC ;
        WD26   : IN STD_ULOGIC ;
        WD25   : IN STD_ULOGIC ;
        WD24   : IN STD_ULOGIC ;
        WD23   : IN STD_ULOGIC ;
        WD22   : IN STD_ULOGIC ;
        WD21   : IN STD_ULOGIC ;
        WD20   : IN STD_ULOGIC ;
        WD19   : IN STD_ULOGIC ;
        WD18   : IN STD_ULOGIC ;
        WD17   : IN STD_ULOGIC ;
        WD16   : IN STD_ULOGIC ;
        WD15   : IN STD_ULOGIC ;
        WD14   : IN STD_ULOGIC ;
        WD13   : IN STD_ULOGIC ;
        WD12   : IN STD_ULOGIC ;
        WD11   : IN STD_ULOGIC ;
        WD10   : IN STD_ULOGIC ;
        WD9    : IN STD_ULOGIC ;
        WD8    : IN STD_ULOGIC ;
        WD7    : IN STD_ULOGIC ;
        WD6    : IN STD_ULOGIC ;
        WD5    : IN STD_ULOGIC ;
        WD4    : IN STD_ULOGIC ;
        WD3    : IN STD_ULOGIC ;
        WD2    : IN STD_ULOGIC ;
        WD1    : IN STD_ULOGIC ;
        WD0    : IN STD_ULOGIC ;
        WW2    : IN STD_ULOGIC ;
        WW1    : IN STD_ULOGIC ;
        WW0    : IN STD_ULOGIC ;
        WEN    : IN STD_ULOGIC ;
        WCLK   : IN STD_ULOGIC ;
        RDAD15 : IN STD_ULOGIC ;
        RDAD14 : IN STD_ULOGIC ;
        RDAD13 : IN STD_ULOGIC ;
        RDAD12 : IN STD_ULOGIC ;
        RDAD11 : IN STD_ULOGIC ;
        RDAD10 : IN STD_ULOGIC ;
        RDAD9  : IN STD_ULOGIC ;
        RDAD8  : IN STD_ULOGIC ;
        RDAD7  : IN STD_ULOGIC ;
        RDAD6  : IN STD_ULOGIC ;
        RDAD5  : IN STD_ULOGIC ;
        RDAD4  : IN STD_ULOGIC ;
        RDAD3  : IN STD_ULOGIC ;
        RDAD2  : IN STD_ULOGIC ;
        RDAD1  : IN STD_ULOGIC ;
        RDAD0  : IN STD_ULOGIC ;
        RW2    : IN STD_ULOGIC ;
        RW1    : IN STD_ULOGIC ;
        RW0    : IN STD_ULOGIC ;
        REN    : IN STD_ULOGIC ;
        RCLK   : IN STD_ULOGIC ;
        RD35   : OUT STD_ULOGIC ;
        RD34   : OUT STD_ULOGIC ;
        RD33   : OUT STD_ULOGIC ;
        RD32   : OUT STD_ULOGIC ;
        RD31   : OUT STD_ULOGIC ;
        RD30   : OUT STD_ULOGIC ;
        RD29   : OUT STD_ULOGIC ;
        RD28   : OUT STD_ULOGIC ;
        RD27   : OUT STD_ULOGIC ;
        RD26   : OUT STD_ULOGIC ;
        RD25   : OUT STD_ULOGIC ;
        RD24   : OUT STD_ULOGIC ;
        RD23   : OUT STD_ULOGIC ;
        RD22   : OUT STD_ULOGIC ;
        RD21   : OUT STD_ULOGIC ;
        RD20   : OUT STD_ULOGIC ;
        RD19   : OUT STD_ULOGIC ;
        RD18   : OUT STD_ULOGIC ;
        RD17   : OUT STD_ULOGIC ;
        RD16   : OUT STD_ULOGIC ;
        RD15   : OUT STD_ULOGIC ;
        RD14   : OUT STD_ULOGIC ;
        RD13   : OUT STD_ULOGIC ;
        RD12   : OUT STD_ULOGIC ;
        RD11   : OUT STD_ULOGIC ;
        RD10   : OUT STD_ULOGIC ;
        RD9    : OUT STD_ULOGIC ;
        RD8    : OUT STD_ULOGIC ;
        RD7    : OUT STD_ULOGIC ;
        RD6    : OUT STD_ULOGIC ;
        RD5    : OUT STD_ULOGIC ;
        RD4    : OUT STD_ULOGIC ;
        RD3    : OUT STD_ULOGIC ;
        RD2    : OUT STD_ULOGIC ;
        RD1    : OUT STD_ULOGIC ;
        RD0    : OUT STD_ULOGIC
        );

 
  
end component;

component DDR_OUT
    port(DR, DF, E, CLK, PRE, CLR : in std_logic;  Q : out std_logic) ;
end component; 

component DDR_REG
    port(D, E, CLK, CLR, PRE : in std_logic;  QR, QF : out std_logic) ;
end component; 

component PLL
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

      f_REFCLK_LOCK          :	Integer := 3; -- Number of REFCLK pulses after which LOCK is raised

      tipd_PWRDWN            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_REFCLK            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOWFREQ           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC2              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC1              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC0              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI5             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI4             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI3             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI2             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI1             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI0             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ5             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ4             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ3             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ2             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ1             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ0             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE4        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE3        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE2        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE1        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE0        :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tpd_REFCLK_CLK1        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_REFCLK_CLK2        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_REFCLK_LOCK        :  VitalDelayType01 := (0.000 ns, 0.000 ns));

   port(
      PWRDWN                  :	in    STD_ULOGIC; -- Active high
      REFCLK                  :	in    STD_ULOGIC;
      LOWFREQ                 : in    STD_ULOGIC; 
      OSC2                    : in    STD_ULOGIC; 
      OSC1                    : in    STD_ULOGIC; 
      OSC0                    : in    STD_ULOGIC; 
      DIVI5                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI4                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI3                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI2                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI1                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI0                   : in    STD_ULOGIC; -- Clock multiplier
      DIVJ5                   : in    STD_ULOGIC; -- Clock divider
      DIVJ4                   : in    STD_ULOGIC; -- Clock divider
      DIVJ3                   : in    STD_ULOGIC; -- Clock divider
      DIVJ2                   : in    STD_ULOGIC; -- Clock divider
      DIVJ1                   : in    STD_ULOGIC; -- Clock divider
      DIVJ0                   : in    STD_ULOGIC; -- Clock divider
      DELAYLINE4              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE3              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE2              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE1              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE0              : in    STD_ULOGIC; -- Delay Value
      LOCK                    :	out   STD_ULOGIC;
      CLK1                    :	out   STD_ULOGIC;
      CLK2                    :	out   STD_ULOGIC);

end component; 

component PLLFB
   generic(
      TimingChecksOn: Boolean := True;
      InstancePath: STRING := "*";
      Xon: Boolean := False;
      MsgOn: Boolean := True;

      f_REFCLK_LOCK          :	Integer := 3; -- Number of REFCLK pulses after which LOCK is raised

      tipd_PWRDWN            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_REFCLK            :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_FB                :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_LOWFREQ           :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC2              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC1              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_OSC0              :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI5             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI4             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI3             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI2             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI1             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVI0             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ5             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ4             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ3             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ2             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ1             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DIVJ0             :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE4        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE3        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE2        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE1        :	VitalDelayType01 := (0.000 ns, 0.000 ns);
      tipd_DELAYLINE0        :	VitalDelayType01 := (0.000 ns, 0.000 ns);

      tpd_REFCLK_CLK1        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_REFCLK_CLK2        :  VitalDelayType01 := (0.000 ns, 0.000 ns);
      tpd_REFCLK_LOCK        :  VitalDelayType01 := (0.000 ns, 0.000 ns));


   port(
      PWRDWN                  :	in    STD_ULOGIC; -- Active high
      REFCLK                  :	in    STD_ULOGIC;
      FB                      :	in    STD_ULOGIC;
      LOWFREQ                 : in    STD_ULOGIC; 
      OSC2                    : in    STD_ULOGIC; 
      OSC1                    : in    STD_ULOGIC; 
      OSC0                    : in    STD_ULOGIC; 
      DIVI5                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI4                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI3                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI2                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI1                   : in    STD_ULOGIC; -- Clock multiplier
      DIVI0                   : in    STD_ULOGIC; -- Clock multiplier
      DIVJ5                   : in    STD_ULOGIC; -- Clock divider
      DIVJ4                   : in    STD_ULOGIC; -- Clock divider
      DIVJ3                   : in    STD_ULOGIC; -- Clock divider
      DIVJ2                   : in    STD_ULOGIC; -- Clock divider
      DIVJ1                   : in    STD_ULOGIC; -- Clock divider
      DIVJ0                   : in    STD_ULOGIC; -- Clock divider
      DELAYLINE4              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE3              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE2              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE1              : in    STD_ULOGIC; -- Delay Value
      DELAYLINE0              : in    STD_ULOGIC; -- Delay Value
      LOCK                    :	out   STD_ULOGIC;
      CLK1                    :	out   STD_ULOGIC;
      CLK2                    :	out   STD_ULOGIC);

end component; 


---------------- CELL:NOR5D ---------------

COMPONENT NOR5D
   port(
          A     : in std_logic;
          B     : in std_logic;
          C     : in std_logic;
          D     : in std_logic;
          E     : in std_logic;
          Y             : out std_logic);
END COMPONENT;




------ Component ADDSUB1 ------
 component ADDSUB1
    generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_A_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_FCI_S               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_FCO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_FCO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_AS_FCO              : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_FCI_FCO             : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_FCI                : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_AS         : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                A               : in    STD_ULOGIC;
                FCI             : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                AS              : in    STD_ULOGIC;
                S               : out    STD_ULOGIC;
                FCO             : out    STD_ULOGIC);
 end component;



---------------- CELL:NAND5D ---------------

COMPONENT NAND5D
   port(
          A     : in std_logic;
          B     : in std_logic;
          C     : in std_logic;
          D     : in std_logic;
          E     : in std_logic;
          Y             : out std_logic);
END COMPONENT;



------ Component FA1A ------
 component FA1A
    generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                CI              : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                A               : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
 end component;



------ Component FA1B ------
 component FA1B
    generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_A_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_A          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                A               : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                CI              : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
 end component;



------ Component FA2A ------
 component FA2A
    generic(
                TimingChecksOn:Boolean :=True;
                Xon: Boolean :=False;
                InstancePath: STRING :="*";
                MsgOn: Boolean :=True;
                tpd_CI_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_CO                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A0_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A1_CO               : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A0_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_A1_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_B_S         : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tpd_CI_S                : VitalDelayType01 := (0.100 ns, 0.100 ns);
                tipd_CI         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_B          : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A0         : VitalDelayType01 := (0.000 ns, 0.000 ns);
                tipd_A1         : VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
                CI              : in    STD_ULOGIC;
                B               : in    STD_ULOGIC;
                A0              : in    STD_ULOGIC;
                A1              : in    STD_ULOGIC;
                CO              : out    STD_ULOGIC;
                S               : out    STD_ULOGIC);
 end component;

 END COMPONENTS;
--------------------- END OF COMPONENTS PACKAGE SECTION  ----------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

-- CLR_ipd, CLK_delayed, Q_zd, D, E_delayed, PRE_ipd, CLK_ipd
CONSTANT DFEG_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  H,  H,  x,  x,  H,  x,  H ),
( H,  L,  H,  x,  H,  x,  H,  x,  H ),
( H,  L,  x,  H,  L,  x,  H,  x,  H ),
( H,  H,  x,  x,  x,  H,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  x,  H ),
( H,  x,  x,  x,  x,  H,  L,  x,  S ),
( x,  L,  L,  L,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  H,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  H,  x,  L ),
( U,  x,  L,  x,  x,  H,  x,  x,  L ),
( H,  x,  H,  x,  x,  U,  x,  x,  H )); 

-- CLR_ipd, CLK_delayed, T_delayed, Q_zd, CLK_ipd
CONSTANT tflipflop_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  H,  x,  H ),
( H,  L,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  L,  x,  S ),
( x,  L,  L,  L,  H,  x,  L ),
( x,  L,  H,  H,  H,  x,  L ));

-- CLR_ipd, CLK_delayed, PRE_delayed,K_delayed,J_delayed, Q_zd, CLK_ipd
CONSTANT jkflipflop_Q_tab : VitalStateTableType := (
( L,  x,  H,  x,  x,  x,  x,  x,  U ),
( L,  x,  L,  x,  x,  x,  x,  x,  L ),
( H,  L,  x,  L,  H,  x,  H,  x,  H ),
( H,  L,  x,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  x,  H,  L,  H,  x,  H ),
( H,  H,  L,  x,  x,  x,  x,  x,  S ),
( H,  x,  L,  x,  x,  x,  L,  x,  S ),
( H,  x,  H,  x,  x,  x,  x,  x,  H ),
( x,  L,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  L,  x,  x,  L,  x,  x,  L ),
( H,  x,  U,  x,  x,  H,  x,  x,  H ));

CONSTANT JKF2A_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  x,  x,  L ),
( H,  L,  L,  H,  x,  H,  x,  H ),
( H,  L,  L,  x,  H,  H,  x,  H ),
( H,  L,  x,  H,  L,  H,  x,  H ),
( H,  H,  x,  x,  x,  x,  x,  S ),
( H,  x,  x,  x,  x,  L,  x,  S ),
( x,  L,  H,  L,  x,  H,  x,  L ),
( x,  L,  H,  x,  H,  H,  x,  L ),
( x,  L,  x,  L,  L,  H,  x,  L ),
( U,  x,  x,  x,  L,  x,  x,  L ));

CONSTANT JKF3A_Q_tab : VitalStateTableType := (
( L,  H,  L,  x,  H,  H,  x,  L ),
( L,  H,  x,  H,  H,  H,  x,  L ),
( L,  L,  H,  x,  x,  H,  x,  H ),
( L,  L,  x,  H,  x,  H,  x,  H ),
( L,  x,  L,  L,  H,  H,  x,  L ),
( L,  x,  H,  L,  x,  H,  x,  H ),
( H,  x,  x,  x,  H,  x,  x,  S ),
( x,  x,  x,  x,  L,  x,  x,  H ),
( x,  x,  x,  x,  H,  L,  x,  S ),
( x,  x,  x,  H,  U,  x,  x,  H ));

CONSTANT dlatch_DLE3B_Q_tab : VitalStateTableType := (
( x,  x,  x,  H,  x,  H ),   --active high preset

( H,  x,  x,  L,  x,  S ),   --latch
( x,  H,  x,  L,  x,  S ),   --latch

( L,  L,  H,  L,  x,  H ),   --transparent
( L,  L,  L,  L,  x,  L ),   --transparent

( U,  x,  H,  L,  H,  H ),   --o/p mux pessimism
( x,  U,  H,  L,  H,  H ),   --o/p mux pessimism
( U,  x,  L,  L,  L,  L ),   --o/p mux pessimism
( x,  U,  L,  L,  L,  L ),   --o/p mux pessimism

( L,  L,  H,  U,  x,  H ),   --PRE==X
( H,  x,  x,  U,  H,  H ),   --PRE==X
( x,  H,  x,  U,  H,  H ),   --PRE==X
( L,  U,  H,  U,  H,  H ),   --PRE==X
( U,  L,  H,  U,  H,  H ),   --PRE==X
( U,  U,  H,  U,  H,  H ));  --PRE==X
--G, E, D, P, Qn, Qn+1

CONSTANT dlatch_DLE2B_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear

( H,  H,  x,  x,  x,  S ),   --latch
( H,  x,  H,  x,  x,  S ),   --latch

( H,  L,  L,  H,  x,  H ),   --transparent
( H,  L,  L,  L,  x,  L ),   --transparent

( H,  x,  x,  L,  L,  L ),   --o/p mux pessimism
( H,  x,  x,  H,  H,  H ),   --o/p mux pessimism

( U,  x,  x,  L,  L,  L ),   --CLR==X, o/p mux pessimism
( U,  H,  x,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  x,  H,  x,  L,  L ),   --CLR==X, o/p mux pessimism, latch
( U,  L,  L,  L,  x,  L ));  --CLR==X, i/p mux pessimism
--C, G, E, D, Qn, Qn+1


CONSTANT dlatch_DL2C_Q_tab : VitalStateTableType := (
( L,  x,  x,  x,  x,  L ),   --active low clear
( H,  x,  x,  H,  x,  H ),   --active high preset

( H,  H,  x,  L,  x,  S ),   --latch
( H,  L,  L,  L,  x,  L ),   --transparent

( U,  L,  L,  L,  x,  L ),   --CLR==U
( U,  H,  x,  L,  L,  L ),   --CLR==U
( x,  U,  L,  L,  L,  L ),   --CLR,G==U

( H,  U,  H,  x,  H,  H ),   --PRE==U/x,G==U
( H,  L,  H,  x,  x,  H ),   --PRE==U/x
( H,  H,  x,  U,  H,  H ));  --PRE==U
--CLR, G, D, PRE, Qn, Qn+1

end VTABLES;



--------------------- END OF VITABLE TABLE SECTION  ----------------



 ---- CELL ADD1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity ADD1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_S		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_A_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		FCI		: in    STD_ULOGIC;
		S		: out    STD_ULOGIC;
		FCO		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of ADD1 :  entity is TRUE;
 end ADD1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of ADD1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL FCI_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (FCI_ipd, FCI, tipd_FCI);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, FCI_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS S_zd : STD_LOGIC is Results(1);
	ALIAS FCO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE S_GlitchData  : VitalGlitchDataType;
	VARIABLE FCO_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       S_zd := ( VitalMUX2( B_ipd , (NOT B_ipd) , (NOT A_ipd) ) XOR  FCI_ipd );
       FCO_zd := ((( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  FCI_ipd )) OR ( B_ipd  AND  FCI_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => S,
	   GlitchData => S_GlitchData,
	   OutSignalName => "S",
	   OutTemp => S_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_S, true),
	             1 => (B_ipd'last_event,tpd_B_S, true),
	             2 => (FCI_ipd'last_event,tpd_FCI_S, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

     VitalPathDelay01 (
	   OutSignal => FCO,
	   GlitchData => FCO_GlitchData,
	   OutSignalName => "FCO",
	   OutTemp => FCO_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_FCO, true),
	             1 => (B_ipd'last_event,tpd_B_FCO, true),
	             2 => (FCI_ipd'last_event,tpd_FCI_FCO, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_ADD1_VITAL of ADD1 is 
    for VITAL_ACT
    end for;
 end CFG_ADD1_VITAL;



 ---- CELL AND2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2 :  entity is TRUE;
 end AND2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( A_ipd  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2_VITAL of AND2 is 
    for VITAL_ACT
    end for;
 end CFG_AND2_VITAL;



 ---- CELL AND2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2A :  entity is TRUE;
 end AND2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  B_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2A_VITAL of AND2A is 
    for VITAL_ACT
    end for;
 end CFG_AND2A_VITAL;



 ---- CELL AND2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND2B :  entity is TRUE;
 end AND2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( (NOT A_ipd)  AND  (NOT B_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND2B_VITAL of AND2B is 
    for VITAL_ACT
    end for;
 end CFG_AND2B_VITAL;



 ---- CELL AND3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3 :  entity is TRUE;
 end AND3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3_VITAL of AND3 is 
    for VITAL_ACT
    end for;
 end CFG_AND3_VITAL;



 ---- CELL AND3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3A :  entity is TRUE;
 end AND3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3A_VITAL of AND3A is 
    for VITAL_ACT
    end for;
 end CFG_AND3A_VITAL;



 ---- CELL AND3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3B :  entity is TRUE;
 end AND3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3B_VITAL of AND3B is 
    for VITAL_ACT
    end for;
 end CFG_AND3B_VITAL;



 ---- CELL AND3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND3C :  entity is TRUE;
 end AND3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND3C_VITAL of AND3C is 
    for VITAL_ACT
    end for;
 end CFG_AND3C_VITAL;



 ---- CELL AND4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4 :  entity is TRUE;
 end AND4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4_VITAL of AND4 is 
    for VITAL_ACT
    end for;
 end CFG_AND4_VITAL;



 ---- CELL AND4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4A :  entity is TRUE;
 end AND4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4A_VITAL of AND4A is 
    for VITAL_ACT
    end for;
 end CFG_AND4A_VITAL;



 ---- CELL AND4B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4B :  entity is TRUE;
 end AND4B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND4B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4B_VITAL of AND4B is 
    for VITAL_ACT
    end for;
 end CFG_AND4B_VITAL;



 ---- CELL AND4C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4C :  entity is TRUE;
 end AND4C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND4C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4C_VITAL of AND4C is 
    for VITAL_ACT
    end for;
 end CFG_AND4C_VITAL;



 ---- CELL AND4D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND4D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND4D :  entity is TRUE;
 end AND4D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND4D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND4D_VITAL of AND4D is 
    for VITAL_ACT
    end for;
 end CFG_AND4D_VITAL;



 ---- CELL AND5A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5A :  entity is TRUE;
 end AND5A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND5A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5A_VITAL of AND5A is 
    for VITAL_ACT
    end for;
 end CFG_AND5A_VITAL;



 ---- CELL AND5B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5B :  entity is TRUE;
 end AND5B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND5B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5B_VITAL of AND5B is 
    for VITAL_ACT
    end for;
 end CFG_AND5B_VITAL;



 ---- CELL AND5C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AND5C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AND5C :  entity is TRUE;
 end AND5C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AND5C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) AND  D_ipd ) AND  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AND5C_VITAL of AND5C is 
    for VITAL_ACT
    end for;
 end CFG_AND5C_VITAL;



 ---- CELL AO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1 :  entity is TRUE;
 end AO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1_VITAL of AO1 is 
    for VITAL_ACT
    end for;
 end CFG_AO1_VITAL;



 ---- CELL AO10 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO10 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO10 :  entity is TRUE;
 end AO10;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO10 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR  C_ipd ) AND ( D_ipd  OR  E_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO10_VITAL of AO10 is 
    for VITAL_ACT
    end for;
 end CFG_AO10_VITAL;



 ---- CELL AO11 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO11 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO11 :  entity is TRUE;
 end AO11;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO11 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR (( A_ipd  OR  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO11_VITAL of AO11 is 
    for VITAL_ACT
    end for;
 end CFG_AO11_VITAL;



 ---- CELL AO12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO12 :  entity is TRUE;
 end AO12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2( B_ipd ,( A_ipd  AND  (NOT B_ipd) ), (NOT C_ipd) ) OR (( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO12_VITAL of AO12 is 
    for VITAL_ACT
    end for;
 end CFG_AO12_VITAL;



 ---- CELL AO13 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO13 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO13 :  entity is TRUE;
 end AO13;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO13 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO13_VITAL of AO13 is 
    for VITAL_ACT
    end for;
 end CFG_AO13_VITAL;



 ---- CELL AO14 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO14 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO14 :  entity is TRUE;
 end AO14;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO14 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ), B_ipd , C_ipd ) OR (( A_ipd  AND  B_ipd ) OR ( A_ipd  AND  (NOT C_ipd) )));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO14_VITAL of AO14 is 
    for VITAL_ACT
    end for;
 end CFG_AO14_VITAL;



 ---- CELL AO15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO15 :  entity is TRUE;
 end AO15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( A_ipd  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  (NOT B_ipd) ), C_ipd ) OR (( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO15_VITAL of AO15 is 
    for VITAL_ACT
    end for;
 end CFG_AO15_VITAL;



 ---- CELL AO16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO16 :  entity is TRUE;
 end AO16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2(( A_ipd  AND  B_ipd ),( (NOT A_ipd)  AND  (NOT B_ipd) ), (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO16_VITAL of AO16 is 
    for VITAL_ACT
    end for;
 end CFG_AO16_VITAL;



 ---- CELL AO17 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO17 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO17 :  entity is TRUE;
 end AO17;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO17 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2(( (NOT A_ipd)  AND  (NOT B_ipd) ),( (NOT A_ipd)  AND  B_ipd ), C_ipd ) OR (( A_ipd  AND  B_ipd ) AND  C_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO17_VITAL of AO17 is 
    for VITAL_ACT
    end for;
 end CFG_AO17_VITAL;



 ---- CELL AO18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO18 :  entity is TRUE;
 end AO18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR ( (NOT A_ipd)  AND  (NOT C_ipd) )) OR ( B_ipd  AND  (NOT C_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO18_VITAL of AO18 is 
    for VITAL_ACT
    end for;
 end CFG_AO18_VITAL;



 ---- CELL AO1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1A :  entity is TRUE;
 end AO1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1A_VITAL of AO1A is 
    for VITAL_ACT
    end for;
 end CFG_AO1A_VITAL;



 ---- CELL AO1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1B :  entity is TRUE;
 end AO1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1B_VITAL of AO1B is 
    for VITAL_ACT
    end for;
 end CFG_AO1B_VITAL;



 ---- CELL AO1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1C :  entity is TRUE;
 end AO1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1C_VITAL of AO1C is 
    for VITAL_ACT
    end for;
 end CFG_AO1C_VITAL;



 ---- CELL AO1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1D :  entity is TRUE;
 end AO1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1D_VITAL of AO1D is 
    for VITAL_ACT
    end for;
 end CFG_AO1D_VITAL;



 ---- CELL AO1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO1E :  entity is TRUE;
 end AO1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO1E_VITAL of AO1E is 
    for VITAL_ACT
    end for;
 end CFG_AO1E_VITAL;



 ---- CELL AO2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2 :  entity is TRUE;
 end AO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2_VITAL of AO2 is 
    for VITAL_ACT
    end for;
 end CFG_AO2_VITAL;



 ---- CELL AO2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2A :  entity is TRUE;
 end AO2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2A_VITAL of AO2A is 
    for VITAL_ACT
    end for;
 end CFG_AO2A_VITAL;



 ---- CELL AO2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2B :  entity is TRUE;
 end AO2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2B_VITAL of AO2B is 
    for VITAL_ACT
    end for;
 end CFG_AO2B_VITAL;



 ---- CELL AO2C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2C :  entity is TRUE;
 end AO2C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2C_VITAL of AO2C is 
    for VITAL_ACT
    end for;
 end CFG_AO2C_VITAL;



 ---- CELL AO2D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2D :  entity is TRUE;
 end AO2D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2D_VITAL of AO2D is 
    for VITAL_ACT
    end for;
 end CFG_AO2D_VITAL;



 ---- CELL AO2E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO2E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO2E :  entity is TRUE;
 end AO2E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO2E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) ) OR  (NOT D_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO2E_VITAL of AO2E is 
    for VITAL_ACT
    end for;
 end CFG_AO2E_VITAL;



 ---- CELL AO3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3 :  entity is TRUE;
 end AO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  B_ipd ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3_VITAL of AO3 is 
    for VITAL_ACT
    end for;
 end CFG_AO3_VITAL;



 ---- CELL AO3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3A :  entity is TRUE;
 end AO3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3A_VITAL of AO3A is 
    for VITAL_ACT
    end for;
 end CFG_AO3A_VITAL;



 ---- CELL AO3B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3B :  entity is TRUE;
 end AO3B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO3B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3B_VITAL of AO3B is 
    for VITAL_ACT
    end for;
 end CFG_AO3B_VITAL;



 ---- CELL AO3C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO3C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO3C :  entity is TRUE;
 end AO3C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO3C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( (NOT A_ipd)  AND  (NOT B_ipd) ) AND  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO3C_VITAL of AO3C is 
    for VITAL_ACT
    end for;
 end CFG_AO3C_VITAL;



 ---- CELL AO4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO4A :  entity is TRUE;
 end AO4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2(( B_ipd  AND  C_ipd ),( C_ipd  AND  D_ipd ), (NOT A_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO4A_VITAL of AO4A is 
    for VITAL_ACT
    end for;
 end CFG_AO4A_VITAL;



 ---- CELL AO5A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO5A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO5A :  entity is TRUE;
 end AO5A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO5A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ( VitalMUX2( B_ipd , C_ipd , (NOT A_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO5A_VITAL of AO5A is 
    for VITAL_ACT
    end for;
 end CFG_AO5A_VITAL;



 ---- CELL AO6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO6 :  entity is TRUE;
 end AO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO6_VITAL of AO6 is 
    for VITAL_ACT
    end for;
 end CFG_AO6_VITAL;



 ---- CELL AO6A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO6A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO6A :  entity is TRUE;
 end AO6A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO6A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  (NOT D_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO6A_VITAL of AO6A is 
    for VITAL_ACT
    end for;
 end CFG_AO6A_VITAL;



 ---- CELL AO7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO7 :  entity is TRUE;
 end AO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( A_ipd  AND  B_ipd ) AND  C_ipd ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO7_VITAL of AO7 is 
    for VITAL_ACT
    end for;
 end CFG_AO7_VITAL;



 ---- CELL AO8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO8 :  entity is TRUE;
 end AO8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  AND  B_ipd ) OR ( (NOT C_ipd)  AND  (NOT D_ipd) )) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO8_VITAL of AO8 is 
    for VITAL_ACT
    end for;
 end CFG_AO8_VITAL;



 ---- CELL AO9 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AO9 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AO9 :  entity is TRUE;
 end AO9;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AO9 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd, E_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (((( A_ipd  AND  B_ipd ) OR  C_ipd ) OR  D_ipd ) OR  E_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true),
	             4 => (E_ipd'last_event,tpd_E_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AO9_VITAL of AO9 is 
    for VITAL_ACT
    end for;
 end CFG_AO9_VITAL;



 ---- CELL AOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1 :  entity is TRUE;
 end AOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1_VITAL of AOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AOI1_VITAL;



 ---- CELL AOI1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1A :  entity is TRUE;
 end AOI1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1A_VITAL of AOI1A is 
    for VITAL_ACT
    end for;
 end CFG_AOI1A_VITAL;



 ---- CELL AOI1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1B :  entity is TRUE;
 end AOI1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1B_VITAL of AOI1B is 
    for VITAL_ACT
    end for;
 end CFG_AOI1B_VITAL;



 ---- CELL AOI1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1C :  entity is TRUE;
 end AOI1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1C_VITAL of AOI1C is 
    for VITAL_ACT
    end for;
 end CFG_AOI1C_VITAL;



 ---- CELL AOI1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI1D :  entity is TRUE;
 end AOI1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) OR  (NOT C_ipd) );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI1D_VITAL of AOI1D is 
    for VITAL_ACT
    end for;
 end CFG_AOI1D_VITAL;



 ---- CELL AOI2A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI2A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI2A :  entity is TRUE;
 end AOI2A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI2A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  B_ipd ) OR  C_ipd ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI2A_VITAL of AOI2A is 
    for VITAL_ACT
    end for;
 end CFG_AOI2A_VITAL;



 ---- CELL AOI2B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI2B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI2B :  entity is TRUE;
 end AOI2B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI2B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( (( (NOT A_ipd)  AND  B_ipd ) OR  (NOT C_ipd) ) OR  D_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI2B_VITAL of AOI2B is 
    for VITAL_ACT
    end for;
 end CFG_AOI2B_VITAL;



 ---- CELL AOI3A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI3A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI3A :  entity is TRUE;
 end AOI3A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI3A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := ((( A_ipd  OR  B_ipd ) OR  C_ipd ) AND ( A_ipd  OR  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI3A_VITAL of AOI3A is 
    for VITAL_ACT
    end for;
 end CFG_AOI3A_VITAL;



 ---- CELL AOI4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI4 :  entity is TRUE;
 end AOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR ( C_ipd  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI4_VITAL of AOI4 is 
    for VITAL_ACT
    end for;
 end CFG_AOI4_VITAL;



 ---- CELL AOI4A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI4A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		D		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI4A :  entity is TRUE;
 end AOI4A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI4A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	VitalWireDelay (D_ipd, D, tipd_D);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd, D_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) OR ( (NOT C_ipd)  AND  D_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true),
	             3 => (D_ipd'last_event,tpd_D_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI4A_VITAL of AOI4A is 
    for VITAL_ACT
    end for;
 end CFG_AOI4A_VITAL;



 ---- CELL AOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AOI5 :  entity is TRUE;
 end AOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT VitalMUX2(( (NOT A_ipd)  AND  B_ipd ),( A_ipd  AND  (NOT B_ipd) ), C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AOI5_VITAL of AOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AOI5_VITAL;



 ---- CELL AFCNTECP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AFCNTECP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of AFCNTECP1 :  entity is TRUE;
 end AFCNTECP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AFCNTECP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL UD_ipd  : STD_ULOGIC := 'X';
	SIGNAL FCI_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (UD_ipd, UD, tipd_UD);
	  VitalWireDelay (FCI_ipd, FCI, tipd_FCI);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (UD_ipd, FCI_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_UD_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_UD_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_FCI_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_FCI_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE NET_0_1	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);
	ALIAS FCO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;
	VARIABLE FCO_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_UD_CLK_negedge, 
	 TimingData		=> Tmkr_UD_CLK_negedge, 
	 TestSignal		=> UD_ipd,
	 TestSignalName		=> "UD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_UD_CLK_posedge_negedge,
	 SetupLow		=> tsetup_UD_CLK_negedge_negedge,
	 HoldHigh		=> thold_UD_CLK_posedge_negedge,
	 HoldLow		=> thold_UD_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_FCI_CLK_negedge, 
	 TimingData		=> Tmkr_FCI_CLK_negedge, 
	 TestSignal		=> FCI_ipd,
	 TestSignalName		=> "FCI",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_FCI_CLK_posedge_negedge,
	 SetupLow		=> tsetup_FCI_CLK_negedge_negedge,
	 HoldHigh		=> thold_FCI_CLK_posedge_negedge,
	 HoldLow		=> thold_FCI_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "AFCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_UD_CLK_negedge or 
	 Tviol_FCI_CLK_negedge or 
	 Tviol_PRE_CLK_negedge or Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, NET_0_1, E_delayed, PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
    --- combinatorial output logic. 
   FCO_zd := ((( Q_zd  AND  UD_ipd ) OR ( Q_zd  AND  FCI_ipd )) OR ( FCI_ipd  AND  UD_ipd ));
         --- now combinatorial logic input to the DFF 
   NET_0_1 := (( Q_zd  XOR  UD_ipd ) XOR  FCI_ipd );
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

	VitalPathDelay01 (
	 OutSignal => FCO,
	 GlitchData => FCO_GlitchData,
	 OutSignalName => "FCO",
	 OutTemp => FCO_zd,
	 Paths => (
	         0 => (UD_ipd'last_event, tpd_UD_FCO, true),
	         1 => (FCI_ipd'last_event, tpd_FCI_FCO, true),
		 2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		 3 => (CLR_ipd'last_event, tpd_CLR_Q, true),
	           4 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

configuration CFG_AFCNTECP1_VITAL of AFCNTECP1 is
   for VITAL_ACT
   end for;
end CFG_AFCNTECP1_VITAL;



 ---- CELL ARCNTECP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity ARCNTECP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of ARCNTECP1 :  entity is TRUE;
 end ARCNTECP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of ARCNTECP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL UD_ipd  : STD_ULOGIC := 'X';
	SIGNAL FCI_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (UD_ipd, UD, tipd_UD);
	  VitalWireDelay (FCI_ipd, FCI, tipd_FCI);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (UD_ipd, FCI_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_UD_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_UD_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_FCI_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_FCI_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE NET_0_1	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);
	ALIAS FCO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;
	VARIABLE FCO_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_UD_CLK_posedge,
	 TimingData		=> Tmkr_UD_CLK_posedge,
	 TestSignal		=> UD_ipd,
	 TestSignalName		=> "UD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_UD_CLK_posedge_posedge,
	 SetupLow		=> tsetup_UD_CLK_negedge_posedge,
	 HoldHigh		=> thold_UD_CLK_posedge_posedge,
	 HoldLow		=> thold_UD_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_FCI_CLK_posedge,
	 TimingData		=> Tmkr_FCI_CLK_posedge,
	 TestSignal		=> FCI_ipd,
	 TestSignalName		=> "FCI",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_FCI_CLK_posedge_posedge,
	 SetupLow		=> tsetup_FCI_CLK_negedge_posedge,
	 HoldHigh		=> thold_FCI_CLK_posedge_posedge,
	 HoldLow		=> thold_FCI_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "ARCNTECP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_UD_CLK_posedge or 
	 Tviol_FCI_CLK_posedge or 
	 Tviol_PRE_CLK_posedge or Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, NET_0_1, E_delayed, PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
    --- combinatorial output logic. 
   FCO_zd := ((( Q_zd  AND  UD_ipd ) OR ( Q_zd  AND  FCI_ipd )) OR ( FCI_ipd  AND  UD_ipd ));
         --- now combinatorial logic input to the DFF 
   NET_0_1 := (( Q_zd  XOR  UD_ipd ) XOR  FCI_ipd );
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

	VitalPathDelay01 (
	 OutSignal => FCO,
	 GlitchData => FCO_GlitchData,
	 OutSignalName => "FCO",
	 OutTemp => FCO_zd,
	 Paths => (
	         0 => (UD_ipd'last_event, tpd_UD_FCO, true),
	         1 => (FCI_ipd'last_event, tpd_FCI_FCO, true),
		 2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		 3 => (CLR_ipd'last_event, tpd_CLR_Q, true),
	           4 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

configuration CFG_ARCNTECP1_VITAL of ARCNTECP1 is
   for VITAL_ACT
   end for;
end CFG_ARCNTECP1_VITAL;



 ---- CELL AFCNTELDCP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AFCNTELDCP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_negedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of AFCNTELDCP1 :  entity is TRUE;
 end AFCNTELDCP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AFCNTELDCP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL LD_ipd  : STD_ULOGIC := 'X';
	SIGNAL UD_ipd  : STD_ULOGIC := 'X';
	SIGNAL FCI_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (LD_ipd, LD, tipd_LD);
	  VitalWireDelay (UD_ipd, UD, tipd_UD);
	  VitalWireDelay (FCI_ipd, FCI, tipd_FCI);
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LD_ipd, UD_ipd, FCI_ipd, D_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_LD_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_LD_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_UD_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_UD_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_FCI_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_FCI_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_D_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_negedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_negedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE NET_0_4	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);
	ALIAS FCO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;
	VARIABLE FCO_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_LD_CLK_negedge, 
	 TimingData		=> Tmkr_LD_CLK_negedge, 
	 TestSignal		=> LD_ipd,
	 TestSignalName		=> "LD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_LD_CLK_posedge_negedge,
	 SetupLow		=> tsetup_LD_CLK_negedge_negedge,
	 HoldHigh		=> thold_LD_CLK_posedge_negedge,
	 HoldLow		=> thold_LD_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_UD_CLK_negedge, 
	 TimingData		=> Tmkr_UD_CLK_negedge, 
	 TestSignal		=> UD_ipd,
	 TestSignalName		=> "UD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_UD_CLK_posedge_negedge,
	 SetupLow		=> tsetup_UD_CLK_negedge_negedge,
	 HoldHigh		=> thold_UD_CLK_posedge_negedge,
	 HoldLow		=> thold_UD_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_FCI_CLK_negedge, 
	 TimingData		=> Tmkr_FCI_CLK_negedge, 
	 TestSignal		=> FCI_ipd,
	 TestSignalName		=> "FCI",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_FCI_CLK_posedge_negedge,
	 SetupLow		=> tsetup_FCI_CLK_negedge_negedge,
	 HoldHigh		=> thold_FCI_CLK_posedge_negedge,
	 HoldLow		=> thold_FCI_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_negedge, 
	 TimingData		=> Tmkr_D_CLK_negedge, 
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_negedge,
	 SetupLow		=> tsetup_D_CLK_negedge_negedge,
	 HoldHigh		=> thold_D_CLK_posedge_negedge,
	 HoldLow		=> thold_D_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "/AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_negedge,
	 TimingData		=> Tmkr_E_CLK_negedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_negedge,
	 SetupLow		=> tsetup_E_CLK_negedge_negedge,
	 HoldHigh		=> thold_E_CLK_posedge_negedge,
	 HoldLow		=> thold_E_CLK_negedge_negedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_negedge,
	 TimingData		=> Tmkr_PRE_CLK_negedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_negedge,
	 Removal		=> thold_PRE_CLK_posedge_negedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_negedge,
	 TimingData             => Tmkr_CLR_CLK_negedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_negedge,
	 Removal               => thold_CLR_CLK_posedge_negedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'F',
	 HeaderMsg		=> InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_negedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "AFCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_LD_CLK_negedge or 
	 Tviol_UD_CLK_negedge or 
	 Tviol_FCI_CLK_negedge or Tviol_D_CLK_negedge or Tviol_PRE_CLK_negedge or Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_ipd, Q_zd, NET_0_4, E_delayed, PRE_ipd, CLK_delayed));
   Q_zd := Violation XOR Q_zd;
    --- combinatorial output logic. 
   FCO_zd := ((( Q_zd  AND  UD_ipd ) OR ( Q_zd  AND  FCI_ipd )) OR ( FCI_ipd  AND  UD_ipd ));
         --- now combinatorial logic input to the DFF 
   NET_0_4 :=  VitalMUX2((( Q_zd  XOR  UD_ipd ) XOR  FCI_ipd ), D_ipd , (NOT LD_ipd) );
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

	VitalPathDelay01 (
	 OutSignal => FCO,
	 GlitchData => FCO_GlitchData,
	 OutSignalName => "FCO",
	 OutTemp => FCO_zd,
	 Paths => (
	         0 => (UD_ipd'last_event, tpd_UD_FCO, true),
	         1 => (FCI_ipd'last_event, tpd_FCI_FCO, true),
		 2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		 3 => (CLR_ipd'last_event, tpd_CLR_Q, true),
	           4 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

configuration CFG_AFCNTELDCP1_VITAL of AFCNTELDCP1 is
   for VITAL_ACT
   end for;
end CFG_AFCNTELDCP1_VITAL;



 ---- CELL ARCNTELDCP1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity ARCNTELDCP1 is
    generic(
		TimingChecksOn: Boolean := True;
		InstancePath: STRING := "*";
		Xon: Boolean := False;
		MsgOn: Boolean := True;
		tpd_PRE_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLR_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_CLK_Q		:  VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_UD_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_FCI_FCO		:   VitalDelayType01 := (0.100 ns, 0.100 ns);
		tsetup_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_LD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_Q_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_UD_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_FCI_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_D_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tsetup_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_E_CLK_negedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_PRE_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		thold_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		trecovery_CLR_CLK_posedge_posedge		:   VitalDelayType := 0.000 ns;
		tpw_CLK_posedge :  VitalDelayType := 0.000 ns;
		tpw_CLK_negedge  :  VitalDelayType := 0.000 ns;
		tpw_PRE_negedge		:  VitalDelayType := 0.000 ns;
		tpw_CLR_negedge		:  VitalDelayType := 0.000 ns;
		tipd_PRE		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLR		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_LD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_UD		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_FCI		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D		:   VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_CLK		:    VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		CLR		:   in    STD_ULOGIC;
		PRE		:   in    STD_ULOGIC;
		E		:   in    STD_ULOGIC;
		CLK		:   in    STD_ULOGIC;
		LD		:  in    STD_ULOGIC;
		Q		:  out STD_ULOGIC;
		UD		:  in    STD_ULOGIC;
		FCI		:  in    STD_ULOGIC;
		D		:  in    STD_ULOGIC;
		FCO		:  out    STD_ULOGIC);

 attribute VITAL_LEVEL0 of ARCNTELDCP1 :  entity is TRUE;
 end ARCNTELDCP1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of ARCNTELDCP1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL LD_ipd  : STD_ULOGIC := 'X';
	SIGNAL UD_ipd  : STD_ULOGIC := 'X';
	SIGNAL FCI_ipd  : STD_ULOGIC := 'X';
	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL PRE_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLR_ipd  : STD_ULOGIC := 'X';
	SIGNAL CLK_ipd : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	  VitalWireDelay (LD_ipd, LD, tipd_LD);
	  VitalWireDelay (UD_ipd, UD, tipd_UD);
	  VitalWireDelay (FCI_ipd, FCI, tipd_FCI);
	  VitalWireDelay (D_ipd, D, tipd_D);
	  VitalWireDelay (PRE_ipd,PRE, tipd_PRE);
	  VitalWireDelay (CLR_ipd,CLR, tipd_CLR);
	  VitalWireDelay (E_ipd,E, tipd_E);
	  VitalWireDelay (CLK_ipd,CLK, tipd_CLK);
	end block;

   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (LD_ipd, UD_ipd, FCI_ipd, D_ipd, PRE_ipd,CLR_ipd,E_ipd,CLK_ipd)

	-- timing check results
	VARIABLE Tviol_LD_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_LD_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_UD_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_UD_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_FCI_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_FCI_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_D_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_D_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_E_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_E_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_PRE_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_PRE_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Tviol_CLR_CLK_posedge		: STD_ULOGIC := '0';
	VARIABLE Tmkr_CLR_CLK_posedge		: VitalTimingDataType := VitalTimingDataInit;
	VARIABLE Pviol_CLK	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLK	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_PRE	: STD_ULOGIC := '0';
	VARIABLE PInfo_PRE	: VitalPeriodDataType := VitalPeriodDataInit;
	VARIABLE Pviol_CLR	: STD_ULOGIC := '0';
	VARIABLE PInfo_CLR	: VitalPeriodDataType := VitalPeriodDataInit;

	-- functionality results
	VARIABLE Violation	: STD_ULOGIC := '0';
	VARIABLE PrevData_Q  : STD_LOGIC_VECTOR(0 to 6);
	VARIABLE E_delayed	: STD_ULOGIC := 'X';
	VARIABLE CLK_delayed	: STD_ULOGIC := 'X';
	VARIABLE NET_0_4	: STD_ULOGIC := 'X';
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS Q_zd : STD_LOGIC is Results(1);
	ALIAS FCO_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE Q_GlitchData  : VitalGlitchDataType;
	VARIABLE FCO_GlitchData  : VitalGlitchDataType;

   begin

   ------------------------
   --  Timing Check Section
   ------------------------
  if(TimingChecksOn) then
	VitalSetupHoldCheck (
	 Violation		=> Tviol_LD_CLK_posedge,
	 TimingData		=> Tmkr_LD_CLK_posedge,
	 TestSignal		=> LD_ipd,
	 TestSignalName		=> "LD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_LD_CLK_posedge_posedge,
	 SetupLow		=> tsetup_LD_CLK_negedge_posedge,
	 HoldHigh		=> thold_LD_CLK_posedge_posedge,
	 HoldLow		=> thold_LD_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_UD_CLK_posedge,
	 TimingData		=> Tmkr_UD_CLK_posedge,
	 TestSignal		=> UD_ipd,
	 TestSignalName		=> "UD",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_UD_CLK_posedge_posedge,
	 SetupLow		=> tsetup_UD_CLK_negedge_posedge,
	 HoldHigh		=> thold_UD_CLK_posedge_posedge,
	 HoldLow		=> thold_UD_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_FCI_CLK_posedge,
	 TimingData		=> Tmkr_FCI_CLK_posedge,
	 TestSignal		=> FCI_ipd,
	 TestSignalName		=> "FCI",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_FCI_CLK_posedge_posedge,
	 SetupLow		=> tsetup_FCI_CLK_negedge_posedge,
	 HoldHigh		=> thold_FCI_CLK_posedge_posedge,
	 HoldLow		=> thold_FCI_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_D_CLK_posedge,
	 TimingData		=> Tmkr_D_CLK_posedge,
	 TestSignal		=> D_ipd,
	 TestSignalName		=> "D",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName	        => "CLK",
	 RefDelay		=> 0 ns,
	 SetupHigh		=> tsetup_D_CLK_posedge_posedge,
	 SetupLow		=> tsetup_D_CLK_negedge_posedge,
	 HoldHigh		=> thold_D_CLK_posedge_posedge,
	 HoldLow		=> thold_D_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((CLR_ipd) AND (PRE_ipd) AND (NOT E_ipd) ) ) /= '0', 
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "/ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity    => WARNING);

	VitalSetupHoldCheck (
	 Violation		=> Tviol_E_CLK_posedge,
	 TimingData		=> Tmkr_E_CLK_posedge,
	 TestSignal		=> E_ipd,
	 TestSignalName		=> "E",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay 		=> 0 ns,
	 SetupHigh		=> tsetup_E_CLK_posedge_posedge,
	 SetupLow		=> tsetup_E_CLK_negedge_posedge,
	 HoldHigh		=> thold_E_CLK_posedge_posedge,
	 HoldLow		=> thold_E_CLK_negedge_posedge,
	 CheckEnabled		=>  TO_X01(((PRE_ipd) AND (CLR_ipd)) ) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck  (
	 Violation		=> Tviol_PRE_CLK_posedge,
	 TimingData		=> Tmkr_PRE_CLK_posedge,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 RefSignal		=> CLK_ipd,
	 RefSignalName		=> "CLK",
	 RefDelay		=> 0 ns,
	 Recovery		=> trecovery_PRE_CLK_posedge_posedge,
	 Removal		=> thold_PRE_CLK_posedge_posedge,
	 ActiveLow		 => TRUE,
	 CheckEnabled           =>  TO_X01((CLR_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity	=> WARNING);

	VitalRecoveryRemovalCheck (
	 Violation              => Tviol_CLR_CLK_posedge,
	 TimingData             => Tmkr_CLR_CLK_posedge,
	 TestSignal             => CLR_ipd,
	 TestSignalName         => "CLR",
	 TestDelay              => 0 ns,
	 RefSignal              => CLK_ipd,
	 RefSignalName          => "CLK",
	 RefDelay               => 0 ns,
	 Recovery              => trecovery_CLR_CLK_posedge_posedge,
	 Removal               => thold_CLR_CLK_posedge_posedge,
	 ActiveLow		=> TRUE,
	 CheckEnabled           =>      TO_X01((PRE_ipd) AND (NOT E_ipd)) /= '0',
	 RefTransition		=> 'R',
	 HeaderMsg		=> InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLK,
	 PeriodData		=> PInfo_CLK,
	 TestSignal		=> CLK_ipd,
	 TestSignalName		=> "CLK",
	 TestDelay		=> 0 ns,
	 Period 		=> 0 ns,
	 PulseWidthHigh		=> tpw_CLK_posedge,
	 CheckEnabled		=>		TO_X01(((PRE_ipd) AND (CLR_ipd) ) ) /= '0',
	 HeaderMsg		=> InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_CLR,
	 PeriodData             => PInfo_CLR,
	 TestSignal		=> CLR_ipd,
	 TestSignalName		=> "CLR",
	 TestDelay		=> 0 ns,
	 Period			=> 0 ns,
	 PulseWidthLow		=> tpw_CLR_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled           => TRUE,
	 HeaderMsg              => InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	VitalPeriodPulseCheck (
	 Violation		=> Pviol_PRE,
	 PeriodData		=> PInfo_PRE,
	 TestSignal		=> PRE_ipd,
	 TestSignalName		=> "PRE",
	 TestDelay		=> 0 ns,
	 Period		=> 0 ns,
	 PulseWidthLow => tpw_PRE_negedge,
	 PulseWidthHigh		=> 0 ns,
	 CheckEnabled		=> 		TO_X01(CLR_ipd) /='0',
	 HeaderMsg		=> InstancePath & "ARCNTELDCP1",
	 Xon		=> Xon,
	 MsgOn		=> MsgOn,
	 MsgSeverity		=> WARNING);

	end if;

	-------------------------
	--  Functionality Section
	-------------------------

	Violation := Tviol_LD_CLK_posedge or 
	 Tviol_UD_CLK_posedge or 
	 Tviol_FCI_CLK_posedge or Tviol_D_CLK_posedge or Tviol_PRE_CLK_posedge or Pviol_PRE or Pviol_CLR or Pviol_CLK;

  VitalStateTable(
   Result => Q_zd,
   PreviousDataIn => PrevData_Q,
   StateTable => DFEG_Q_tab,
   DataIn => (
             CLR_ipd, CLK_delayed, Q_zd, NET_0_4, E_delayed, PRE_ipd, CLK_ipd));
   Q_zd := Violation XOR Q_zd;
    --- combinatorial output logic. 
   FCO_zd := ((( Q_zd  AND  UD_ipd ) OR ( Q_zd  AND  FCI_ipd )) OR ( FCI_ipd  AND  UD_ipd ));
         --- now combinatorial logic input to the DFF 
   NET_0_4 :=  VitalMUX2((( Q_zd  XOR  UD_ipd ) XOR  FCI_ipd ), D_ipd , (NOT LD_ipd) );
   E_delayed := E_ipd;
   CLK_delayed := CLK_ipd;

	----------------------
	--  Path Delay Section
	----------------------
	VitalPathDelay01 (
	 OutSignal => Q,
	 GlitchData => Q_GlitchData,
	 OutSignalName => "Q",
	 OutTemp => Q_zd,
	 Paths => (0 => (CLK_ipd'last_event, tpd_CLK_Q, true),
	             1=> (PRE_ipd'last_event, tpd_PRE_Q, true),
	            2=> (CLR_ipd'last_event, tpd_CLR_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

	VitalPathDelay01 (
	 OutSignal => FCO,
	 GlitchData => FCO_GlitchData,
	 OutSignalName => "FCO",
	 OutTemp => FCO_zd,
	 Paths => (
	         0 => (UD_ipd'last_event, tpd_UD_FCO, true),
	         1 => (FCI_ipd'last_event, tpd_FCI_FCO, true),
		 2 => (PRE_ipd'last_event, tpd_PRE_Q, true),
		 3 => (CLR_ipd'last_event, tpd_CLR_Q, true),
	           4 => (CLK_ipd'last_event, tpd_CLK_Q, true)),
	 Mode => OnDetect,
	 Xon => Xon,
	 MsgOn => MsgOn,
	 MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

configuration CFG_ARCNTELDCP1_VITAL of ARCNTELDCP1 is
   for VITAL_ACT
   end for;
end CFG_ARCNTELDCP1_VITAL;



 ---- CELL AX1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1 :  entity is TRUE;
 end AX1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1_VITAL of AX1 is 
    for VITAL_ACT
    end for;
 end CFG_AX1_VITAL;



 ---- CELL AX1A ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1A is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1A :  entity is TRUE;
 end AX1A;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1A is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1A_VITAL of AX1A is 
    for VITAL_ACT
    end for;
 end CFG_AX1A_VITAL;



 ---- CELL AX1B ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1B is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1B :  entity is TRUE;
 end AX1B;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1B is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1B_VITAL of AX1B is 
    for VITAL_ACT
    end for;
 end CFG_AX1B_VITAL;



 ---- CELL AX1C ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1C is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1C :  entity is TRUE;
 end AX1C;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1C is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1C_VITAL of AX1C is 
    for VITAL_ACT
    end for;
 end CFG_AX1C_VITAL;



 ---- CELL AX1D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1D :  entity is TRUE;
 end AX1D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT A_ipd)  AND  (NOT B_ipd) ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1D_VITAL of AX1D is 
    for VITAL_ACT
    end for;
 end CFG_AX1D_VITAL;



 ---- CELL AX1E ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AX1E is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AX1E :  entity is TRUE;
 end AX1E;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AX1E is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( A_ipd  AND  B_ipd ) XOR  C_ipd );


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AX1E_VITAL of AX1E is 
    for VITAL_ACT
    end for;
 end CFG_AX1E_VITAL;



 ---- CELL AXO1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO1 :  entity is TRUE;
 end AXO1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO1_VITAL of AXO1 is 
    for VITAL_ACT
    end for;
 end CFG_AXO1_VITAL;



 ---- CELL AXO2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO2 :  entity is TRUE;
 end AXO2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO2_VITAL of AXO2 is 
    for VITAL_ACT
    end for;
 end CFG_AXO2_VITAL;



 ---- CELL AXO3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO3 :  entity is TRUE;
 end AXO3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO3_VITAL of AXO3 is 
    for VITAL_ACT
    end for;
 end CFG_AXO3_VITAL;



 ---- CELL AXO5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO5 :  entity is TRUE;
 end AXO5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO5_VITAL of AXO5 is 
    for VITAL_ACT
    end for;
 end CFG_AXO5_VITAL;



 ---- CELL AXO6 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO6 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO6 :  entity is TRUE;
 end AXO6;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO6 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO6_VITAL of AXO6 is 
    for VITAL_ACT
    end for;
 end CFG_AXO6_VITAL;



 ---- CELL AXO7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXO7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXO7 :  entity is TRUE;
 end AXO7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXO7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd := (( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXO7_VITAL of AXO7 is 
    for VITAL_ACT
    end for;
 end CFG_AXO7_VITAL;



 ---- CELL AXOI1 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI1 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI1 :  entity is TRUE;
 end AXOI1;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI1 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , A_ipd , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI1_VITAL of AXOI1 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI1_VITAL;



 ---- CELL AXOI2 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI2 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI2 :  entity is TRUE;
 end AXOI2;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI2 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  (NOT C_ipd) ) OR  VitalMUX2( C_ipd , (NOT A_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI2_VITAL of AXOI2 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI2_VITAL;



 ---- CELL AXOI3 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI3 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI3 :  entity is TRUE;
 end AXOI3;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI3 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI3_VITAL of AXOI3 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI3_VITAL;



 ---- CELL AXOI4 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI4 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI4 :  entity is TRUE;
 end AXOI4;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI4 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( A_ipd , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI4_VITAL of AXOI4 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI4_VITAL;



 ---- CELL AXOI5 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI5 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI5 :  entity is TRUE;
 end AXOI5;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI5 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( B_ipd  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , B_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI5_VITAL of AXOI5 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI5_VITAL;



 ---- CELL AXOI7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity AXOI7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_B_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_C_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_B		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_C		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		B		: in    STD_ULOGIC;
		C		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of AXOI7 :  entity is TRUE;
 end AXOI7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of AXOI7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';
	SIGNAL B_ipd  : STD_ULOGIC := 'X';
	SIGNAL C_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	VitalWireDelay (B_ipd, B, tipd_B);
	VitalWireDelay (C_ipd, C, tipd_C);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd, B_ipd, C_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  NOT ( ( (NOT B_ipd)  AND  C_ipd ) OR  VitalMUX2( (NOT A_ipd) , (NOT C_ipd) , (NOT B_ipd) ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true),
	             1 => (B_ipd'last_event,tpd_B_Y, true),
	             2 => (C_ipd'last_event,tpd_C_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_AXOI7_VITAL of AXOI7 is 
    for VITAL_ACT
    end for;
 end CFG_AXOI7_VITAL;



 ---- CELL BIBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF :  entity is TRUE;
 end BIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_VITAL of BIBUF is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_VITAL;



 ---- CELL BIBUF_S_8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_8 :  entity is TRUE;
 end BIBUF_S_8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_8_VITAL of BIBUF_S_8 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_8_VITAL;



 ---- CELL BIBUF_S_8D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_8D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_8D :  entity is TRUE;
 end BIBUF_S_8D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_8D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_8D_VITAL of BIBUF_S_8D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_8D_VITAL;



 ---- CELL BIBUF_S_8U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_8U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_8U :  entity is TRUE;
 end BIBUF_S_8U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_8U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_8U_VITAL of BIBUF_S_8U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_8U_VITAL;



 ---- CELL BIBUF_S_12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_12 :  entity is TRUE;
 end BIBUF_S_12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_12_VITAL of BIBUF_S_12 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_12_VITAL;



 ---- CELL BIBUF_S_12D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_12D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_12D :  entity is TRUE;
 end BIBUF_S_12D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_12D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_12D_VITAL of BIBUF_S_12D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_12D_VITAL;



 ---- CELL BIBUF_S_12U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_12U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_12U :  entity is TRUE;
 end BIBUF_S_12U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_12U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_12U_VITAL of BIBUF_S_12U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_12U_VITAL;



 ---- CELL BIBUF_S_16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_16 :  entity is TRUE;
 end BIBUF_S_16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_16_VITAL of BIBUF_S_16 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_16_VITAL;



 ---- CELL BIBUF_S_16D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_16D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_16D :  entity is TRUE;
 end BIBUF_S_16D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_16D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_16D_VITAL of BIBUF_S_16D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_16D_VITAL;



 ---- CELL BIBUF_S_16U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_16U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_16U :  entity is TRUE;
 end BIBUF_S_16U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_16U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_16U_VITAL of BIBUF_S_16U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_16U_VITAL;



 ---- CELL BIBUF_S_24 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_24 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_24 :  entity is TRUE;
 end BIBUF_S_24;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_24 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_24_VITAL of BIBUF_S_24 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_24_VITAL;



 ---- CELL BIBUF_S_24D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_24D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_24D :  entity is TRUE;
 end BIBUF_S_24D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_24D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_24D_VITAL of BIBUF_S_24D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_24D_VITAL;



 ---- CELL BIBUF_S_24U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_S_24U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_S_24U :  entity is TRUE;
 end BIBUF_S_24U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_S_24U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_S_24U_VITAL of BIBUF_S_24U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_S_24U_VITAL;



 ---- CELL BIBUF_F_8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8 :  entity is TRUE;
 end BIBUF_F_8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8_VITAL of BIBUF_F_8 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8_VITAL;



 ---- CELL BIBUF_F_8D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8D :  entity is TRUE;
 end BIBUF_F_8D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8D_VITAL of BIBUF_F_8D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8D_VITAL;



 ---- CELL BIBUF_F_8U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_8U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_8U :  entity is TRUE;
 end BIBUF_F_8U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_8U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_8U_VITAL of BIBUF_F_8U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_8U_VITAL;



 ---- CELL BIBUF_F_12 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12 :  entity is TRUE;
 end BIBUF_F_12;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12_VITAL of BIBUF_F_12 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12_VITAL;



 ---- CELL BIBUF_F_12D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12D :  entity is TRUE;
 end BIBUF_F_12D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12D_VITAL of BIBUF_F_12D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12D_VITAL;



 ---- CELL BIBUF_F_12U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_12U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_12U :  entity is TRUE;
 end BIBUF_F_12U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_12U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_12U_VITAL of BIBUF_F_12U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_12U_VITAL;



 ---- CELL BIBUF_F_16 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16 :  entity is TRUE;
 end BIBUF_F_16;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16_VITAL of BIBUF_F_16 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16_VITAL;



 ---- CELL BIBUF_F_16D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16D :  entity is TRUE;
 end BIBUF_F_16D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16D_VITAL of BIBUF_F_16D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16D_VITAL;



 ---- CELL BIBUF_F_16U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_16U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_16U :  entity is TRUE;
 end BIBUF_F_16U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_16U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_16U_VITAL of BIBUF_F_16U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_16U_VITAL;



 ---- CELL BIBUF_F_24 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24 :  entity is TRUE;
 end BIBUF_F_24;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24_VITAL of BIBUF_F_24 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24_VITAL;



 ---- CELL BIBUF_F_24D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24D :  entity is TRUE;
 end BIBUF_F_24D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24D_VITAL of BIBUF_F_24D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24D_VITAL;



 ---- CELL BIBUF_F_24U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_F_24U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_F_24U :  entity is TRUE;
 end BIBUF_F_24U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_F_24U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_F_24U_VITAL of BIBUF_F_24U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_F_24U_VITAL;



 ---- CELL BIBUF_LVCMOS25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25 :  entity is TRUE;
 end BIBUF_LVCMOS25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25_VITAL of BIBUF_LVCMOS25 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25_VITAL;



 ---- CELL BIBUF_LVCMOS25D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25D :  entity is TRUE;
 end BIBUF_LVCMOS25D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25D_VITAL of BIBUF_LVCMOS25D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25D_VITAL;



 ---- CELL BIBUF_LVCMOS25U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS25U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS25U :  entity is TRUE;
 end BIBUF_LVCMOS25U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS25U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS25U_VITAL of BIBUF_LVCMOS25U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS25U_VITAL;



 ---- CELL BIBUF_LVCMOS18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18 :  entity is TRUE;
 end BIBUF_LVCMOS18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18_VITAL of BIBUF_LVCMOS18 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18_VITAL;



 ---- CELL BIBUF_LVCMOS18D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18D :  entity is TRUE;
 end BIBUF_LVCMOS18D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18D_VITAL of BIBUF_LVCMOS18D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18D_VITAL;



 ---- CELL BIBUF_LVCMOS18U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS18U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS18U :  entity is TRUE;
 end BIBUF_LVCMOS18U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS18U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS18U_VITAL of BIBUF_LVCMOS18U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS18U_VITAL;



 ---- CELL BIBUF_LVCMOS15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15 :  entity is TRUE;
 end BIBUF_LVCMOS15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15_VITAL of BIBUF_LVCMOS15 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15_VITAL;



 ---- CELL BIBUF_LVCMOS15D ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15D is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15D :  entity is TRUE;
 end BIBUF_LVCMOS15D;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15D is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01LWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15D_VITAL of BIBUF_LVCMOS15D is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15D_VITAL;



 ---- CELL BIBUF_LVCMOS15U ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_LVCMOS15U is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_LVCMOS15U :  entity is TRUE;
 end BIBUF_LVCMOS15U;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_LVCMOS15U is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01HWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_LVCMOS15U_VITAL of BIBUF_LVCMOS15U is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_LVCMOS15U_VITAL;



 ---- CELL BIBUF_PCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_PCI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_PCI :  entity is TRUE;
 end BIBUF_PCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_PCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_PCI_VITAL of BIBUF_PCI is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_PCI_VITAL;



 ---- CELL BIBUF_PCIX ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_PCIX is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_PCIX :  entity is TRUE;
 end BIBUF_PCIX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_PCIX is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_PCIX_VITAL of BIBUF_PCIX is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_PCIX_VITAL;



 ---- CELL BIBUF_GTLP33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_GTLP33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_GTLP33 :  entity is TRUE;
 end BIBUF_GTLP33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_GTLP33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_GTLP33_VITAL of BIBUF_GTLP33 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_GTLP33_VITAL;



 ---- CELL BIBUF_GTLP25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BIBUF_GTLP25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
			tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D		: in    STD_ULOGIC;
		E		: in    STD_ULOGIC;
		PAD		: inout STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BIBUF_GTLP25 :  entity is TRUE;
 end BIBUF_GTLP25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BIBUF_GTLP25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BIBUF_GTLP25_VITAL of BIBUF_GTLP25 is 
    for VITAL_ACT
    end for;
 end CFG_BIBUF_GTLP25_VITAL;



 ---- CELL BUFA ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUFA is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUFA :  entity is TRUE;
 end BUFA;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BUFA is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUFA_VITAL of BUFA is 
    for VITAL_ACT
    end for;
 end CFG_BUFA_VITAL;



 ---- CELL BUFD ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity BUFD is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_A_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_A		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		A		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of BUFD :  entity is TRUE;
 end BUFD;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of BUFD is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL A_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (A_ipd, A, tipd_A);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (A_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(A_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (A_ipd'last_event,tpd_A_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_BUFD_VITAL of BUFD is 
    for VITAL_ACT
    end for;
 end CFG_BUFD_VITAL;


 ---- CELL CLKBIBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBIBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_PAD		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_E_Y			: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D			: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_E			: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: inout  STD_ULOGIC;
		D		: in     STD_ULOGIC;
		E		: in     STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBIBUF :  entity is TRUE;
 end CLKBIBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBIBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D_ipd  : STD_ULOGIC := 'X';
	SIGNAL E_ipd  : STD_ULOGIC := 'X';
	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D_ipd, D, tipd_D);
	VitalWireDelay (E_ipd, E, tipd_E);
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D_ipd, E_ipd, PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 2)  := (others => 'X');
	ALIAS PAD_zd : STD_LOGIC is Results(1);
	ALIAS Y_zd : STD_LOGIC is Results(2);

	-- output glitch detection variables
	VARIABLE PAD_GlitchData  : VitalGlitchDataType;
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        PAD_zd := VitalBUFIF0 (data => D_ipd,
                   enable =>(NOT E_ipd));
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

	  VitalPathDelay01Z (
	   OutSignal => PAD,
	   GlitchData => PAD_GlitchData,
	   OutSignalName => "PAD",
	   OutTemp => PAD_zd,
	   Paths => (
	             0 => (D_ipd'last_event,VitalExtendToFillDelay(tpd_D_PAD),true),
	             1 => (E_ipd'last_event,VitalExtendToFillDelay(tpd_E_PAD), true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING,
	  OutputMap => "UX01ZWLH-");

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D_ipd'last_event,tpd_D_Y, true),
	             1 => (E_ipd'last_event,tpd_E_Y, true),
	             2 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBIBUF_VITAL of CLKBIBUF is 
    for VITAL_ACT
    end for;
 end CFG_CLKBIBUF_VITAL;


 ---- CELL CLKBUF ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF :  entity is TRUE;
 end CLKBUF;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_VITAL of CLKBUF is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_VITAL;



 ---- CELL CLKBUF_LVCMOS25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_LVCMOS25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_LVCMOS25 :  entity is TRUE;
 end CLKBUF_LVCMOS25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_LVCMOS25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_LVCMOS25_VITAL of CLKBUF_LVCMOS25 is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_LVCMOS25_VITAL;



 ---- CELL CLKBUF_LVCMOS18 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_LVCMOS18 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_LVCMOS18 :  entity is TRUE;
 end CLKBUF_LVCMOS18;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_LVCMOS18 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_LVCMOS18_VITAL of CLKBUF_LVCMOS18 is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_LVCMOS18_VITAL;



 ---- CELL CLKBUF_LVCMOS15 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_LVCMOS15 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_LVCMOS15 :  entity is TRUE;
 end CLKBUF_LVCMOS15;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_LVCMOS15 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_LVCMOS15_VITAL of CLKBUF_LVCMOS15 is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_LVCMOS15_VITAL;



 ---- CELL CLKBUF_PCI ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_PCI is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_PCI :  entity is TRUE;
 end CLKBUF_PCI;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_PCI is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_PCI_VITAL of CLKBUF_PCI is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_PCI_VITAL;



 ---- CELL CLKBUF_PCIX ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_PCIX is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_PCIX :  entity is TRUE;
 end CLKBUF_PCIX;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_PCIX is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_PCIX_VITAL of CLKBUF_PCIX is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_PCIX_VITAL;



 ---- CELL CLKBUF_GTLP33 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_GTLP33 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_GTLP33 :  entity is TRUE;
 end CLKBUF_GTLP33;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_GTLP33 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_GTLP33_VITAL of CLKBUF_GTLP33 is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_GTLP33_VITAL;



 ---- CELL CLKBUF_GTLP25 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_GTLP25 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_GTLP25 :  entity is TRUE;
 end CLKBUF_GTLP25;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_GTLP25 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_GTLP25_VITAL of CLKBUF_GTLP25 is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_GTLP25_VITAL;



 ---- CELL CLKBUF_HSTL_I ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_HSTL_I is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_HSTL_I :  entity is TRUE;
 end CLKBUF_HSTL_I;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_HSTL_I is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_HSTL_I_VITAL of CLKBUF_HSTL_I is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_HSTL_I_VITAL;



 ---- CELL CLKBUF_SSTL3_I ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_SSTL3_I is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_SSTL3_I :  entity is TRUE;
 end CLKBUF_SSTL3_I;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_SSTL3_I is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_SSTL3_I_VITAL of CLKBUF_SSTL3_I is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_SSTL3_I_VITAL;



 ---- CELL CLKBUF_SSTL3_II ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_SSTL3_II is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_SSTL3_II :  entity is TRUE;
 end CLKBUF_SSTL3_II;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_SSTL3_II is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_SSTL3_II_VITAL of CLKBUF_SSTL3_II is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_SSTL3_II_VITAL;



 ---- CELL CLKBUF_SSTL2_I ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_SSTL2_I is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_SSTL2_I :  entity is TRUE;
 end CLKBUF_SSTL2_I;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_SSTL2_I is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_SSTL2_I_VITAL of CLKBUF_SSTL2_I is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_SSTL2_I_VITAL;



 ---- CELL CLKBUF_SSTL2_II ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CLKBUF_SSTL2_II is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_PAD_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_PAD		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		PAD		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CLKBUF_SSTL2_II :  entity is TRUE;
 end CLKBUF_SSTL2_II;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CLKBUF_SSTL2_II is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL PAD_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (PAD_ipd, PAD, tipd_PAD);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (PAD_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
        Y_zd :=TO_X01(PAD_ipd);


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (PAD_ipd'last_event,tpd_PAD_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CLKBUF_SSTL2_II_VITAL of CLKBUF_SSTL2_II is 
    for VITAL_ACT
    end for;
 end CFG_CLKBUF_SSTL2_II_VITAL;



 ---- CELL CM7 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CM7 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S0		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CM7 :  entity is TRUE;
 end CM7;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CM7 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S0_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S0_ipd, S0, tipd_S0);
	VitalWireDelay (D1_ipd, D1, tipd_D1);
	VitalWireDelay (S10_ipd, S10, tipd_S10);
	VitalWireDelay (S11_ipd, S11, tipd_S11);
	VitalWireDelay (D2_ipd, D2, tipd_D2);
	VitalWireDelay (D3_ipd, D3, tipd_D3);
	end block;

	--------------------
	--  BEHAVIOR SECTION
	--------------------
	VITALBehavior : process (D0_ipd, S0_ipd, D1_ipd, S10_ipd, S11_ipd, D2_ipd, D3_ipd)


	-- functionality results
	VARIABLE Results : STD_LOGIC_VECTOR(1 to 1)  := (others => 'X');
	ALIAS Y_zd : STD_LOGIC is Results(1);

	-- output glitch detection variables
	VARIABLE Y_GlitchData  : VitalGlitchDataType;

	begin

	   -------------------------
	   --  Functionality Section
	   -------------------------
       Y_zd :=  VitalMUX2( VitalMUX2( D0_ipd , D1_ipd , (NOT S0_ipd) ), VitalMUX2( D2_ipd , D3_ipd , (NOT S0_ipd) ), NOT (  S10_ipd  OR  S11_ipd ));


	   ----------------------
	   --  Path Delay Section
	   ----------------------

     VitalPathDelay01 (
	   OutSignal => Y,
	   GlitchData => Y_GlitchData,
	   OutSignalName => "Y",
	   OutTemp => Y_zd,
	   Paths => (
	             0 => (D0_ipd'last_event,tpd_D0_Y, true),
	             1 => (S0_ipd'last_event,tpd_S0_Y, true),
	             2 => (D1_ipd'last_event,tpd_D1_Y, true),
	             3 => (S10_ipd'last_event,tpd_S10_Y, true),
	             4 => (S11_ipd'last_event,tpd_S11_Y, true),
	             5 => (D2_ipd'last_event,tpd_D2_Y, true),
	             6 => (D3_ipd'last_event,tpd_D3_Y, true)),
	  Mode => OnDetect,
	  Xon => Xon,
	  MsgOn => MsgOn,
	  MsgSeverity => WARNING);

 end process;

end VITAL_ACT;

 configuration CFG_CM7_VITAL of CM7 is 
    for VITAL_ACT
    end for;
 end CFG_CM7_VITAL;



 ---- CELL CM8 ----
 library IEEE;
 use IEEE.STD_LOGIC_1164.all;
 library IEEE;
 use IEEE.VITAL_Timing.all;

 ---- entity declaration ----
 entity CM8 is
    generic(
		TimingChecksOn:Boolean := True;
		Xon: Boolean := False;
		InstancePath: STRING :="*";
		MsgOn: Boolean := True;
		tpd_D0_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S00_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S01_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D1_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S10_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_S11_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D2_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tpd_D3_Y		: VitalDelayType01 := (0.100 ns, 0.100 ns);
		tipd_D0		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S00		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S01		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D1		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S10		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_S11		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D2		: VitalDelayType01 := (0.000 ns, 0.000 ns);
		tipd_D3		: VitalDelayType01 := (0.000 ns, 0.000 ns));


    port(
		D0		: in    STD_ULOGIC;
		S00		: in    STD_ULOGIC;
		S01		: in    STD_ULOGIC;
		D1		: in    STD_ULOGIC;
		S10		: in    STD_ULOGIC;
		S11		: in    STD_ULOGIC;
		D2		: in    STD_ULOGIC;
		D3		: in    STD_ULOGIC;
		Y		: out    STD_ULOGIC);
 attribute VITAL_LEVEL0 of CM8 :  entity is TRUE;
 end CM8;

-- architecture body --
library IEEE;
use IEEE.VITAL_Primitives.all;
library axcelerator;
use axcelerator.VTABLES.all;

architecture VITAL_ACT of CM8 is
	attribute VITAL_LEVEL1 of VITAL_ACT : architecture is TRUE;

	SIGNAL D0_ipd  : STD_ULOGIC := 'X';
	SIGNAL S00_ipd  : STD_ULOGIC := 'X';
	SIGNAL S01_ipd  : STD_ULOGIC := 'X';
	SIGNAL D1_ipd  : STD_ULOGIC := 'X';
	SIGNAL S10_ipd  : STD_ULOGIC := 'X';
	SIGNAL S11_ipd  : STD_ULOGIC := 'X';
	SIGNAL D2_ipd  : STD_ULOGIC := 'X';
	SIGNAL D3_ipd  : STD_ULOGIC := 'X';

begin

	---------------------
	--  INPUT PATH DELAYs
	---------------------
	WireDelay : block
	begin
	VitalWireDelay (D0_ipd, D0, tipd_D0);
	VitalWireDelay (S00_ipd, S00, tipd_S00);
	VitalWireDelay (S01_ip