




















































































`include "../rtl/RISC/include/lxr_symbols.vh" 

module lmi_dcache_bus 
















( 
CLK, TMODE, RESET_D1_R_N, 



SEN, 

DISABLEC, INVALIDATE, 

MEMSEQUENTIAL, MEMZEROFIRST, MEMFULLWORD, 

EXT_DCREQRAM_R, DC_GNTRAM_R, 


DATAUPI, DC_DATAUPO, DATADOWNI, DC_DATADOWNO, 


DC_LBCOE, 

NEXTADDR, NEXTRDOP, NEXTWROP, NEXTBE, NEXTSX, DWORD_E, DS_VAL, DC_VAL, LACK, 

EXCP, 

X_HALT_R, 

DC_MISS_P, DC_MISS_R, DC_BAREMISS_R, DC_HALT_W_R, DC_HALT_M_R, 

DC_RPQUIETIFNBA, DC_RPQUIETIFB, DC_RPALGNIFNBNA, DC_RPALGNIFB, 



DC_TAGINDEX, DCR_TAGRD, DC_TAGWR, DCC_TAGMASK, 
DC_TAGWE, DC_TAGWEN, DC_TAGRE, DC_TAGREN, DC_TAGCS, DC_TAGCSN, 

DC_DATAINDEX, DCR_DATARD, DC_DATAWR, 
DC_DATAWE, DC_DATAWEN, DC_DATARE, DC_DATAREN, DC_DATACS, DC_DATACSN, 



DC_CSTWBUS 

); 







parameter DATA_INDEX_HI = `DC_ADDR_HI; 
parameter DATA_INDEX_LO = 2; 
parameter TAG_INDEX_HI = `DC_ADDR_HI; 
parameter TAG_INDEX_LO = `LINE_ADDR_HI+1; 
parameter TAG_STATE_HI = 32; 
parameter TAG_STATE_LO = `DC_ADDR_HI+1-`DC_TAG_EXTRA_SIZE; 
parameter TAG_MASK_HI = `DC_ADDR_HI; 
parameter TAG_MASK_LO = `DC_ADDR_HI+1-`DC_TAG_EXTRA_SIZE; 







input CLK; 
input TMODE; 

input RESET_D1_R_N; 

input SEN; 

input DISABLEC; 
input INVALIDATE; 

input MEMSEQUENTIAL; 
input MEMZEROFIRST; 
input MEMFULLWORD; 

input EXT_DCREQRAM_R; 
output DC_GNTRAM_R; 


input [31:0] DATAUPI; 
output [31:0] DC_DATAUPO; 
input [31:0] DATADOWNI; 
output [31:0] DC_DATADOWNO; 


output DC_LBCOE; 

input [31:0] NEXTADDR; 
input NEXTRDOP; 
input NEXTWROP; 
input [3:0] NEXTBE; 
input NEXTSX; 
input DWORD_E; 
input EXCP; 
input DS_VAL; 
output DC_VAL; 
input [1:0] LACK; 

output DC_MISS_P; 
output DC_MISS_R; 
output DC_BAREMISS_R; 

output [`HALT_DRV_RANGE] DC_HALT_W_R; 
output [`HALT_DRV_RANGE] DC_HALT_M_R; 
input [`HALT_SIG_RANGE] X_HALT_R; 

output DC_CSTWBUS; 
output DC_RPQUIETIFNBA; 
output DC_RPQUIETIFB; 
output DC_RPALGNIFNBNA; 
output DC_RPALGNIFB; 


output [TAG_INDEX_HI:TAG_INDEX_LO] DC_TAGINDEX; 
input [TAG_STATE_HI:TAG_STATE_LO] DCR_TAGRD; 
output [TAG_STATE_HI:TAG_STATE_LO] DC_TAGWR; 
output DC_TAGWE; 
output DC_TAGWEN; 
output DC_TAGRE; 
output DC_TAGREN; 
output DC_TAGCS; 
output DC_TAGCSN; 
input [TAG_MASK_HI:TAG_MASK_LO] DCC_TAGMASK; 

output [DATA_INDEX_HI:DATA_INDEX_LO] DC_DATAINDEX; 
input [31:0] DCR_DATARD; 
output [31:0] DC_DATAWR; 
output DC_DATAWE; 
output DC_DATAWEN; 
output DC_DATARE; 
output DC_DATAREN; 
output DC_DATACS; 
output DC_DATACSN; 











wire [31:0] DATAOUT; 
wire DATAOE; 


wire USEPROCIN; 


wire [31:0] DATAIN; 

lmi_dcache DCACHE 
( 

.CLK ( CLK ), 

.TMODE ( TMODE ), 
.RESET_D1_R_N ( RESET_D1_R_N ), 
.DISABLEC ( DISABLEC ), 
.INVALIDATE ( INVALIDATE ), 
.MEMSEQUENTIAL ( MEMSEQUENTIAL ), 
.MEMZEROFIRST ( MEMZEROFIRST ), 
.MEMFULLWORD ( MEMFULLWORD ), 
.EXT_DCREQRAM_R ( EXT_DCREQRAM_R), 
.DC_GNTRAM_R ( DC_GNTRAM_R ), 
.DATAIN ( DATAIN ), 
.DC_DATAOUT ( DATAOUT ), 
.DC_DATAOE ( DATAOE ), 
.DC_LBCOE ( DC_LBCOE ), 
.NEXTADDR ( NEXTADDR ), 
.NEXTRDOP ( NEXTRDOP ), 
.NEXTWROP ( NEXTWROP ), 
.NEXTBE ( NEXTBE ), 
.NEXTSX ( NEXTSX ), 
.DWORD_E ( DWORD_E ), 
.EXCP ( EXCP ), 
.DS_VAL ( DS_VAL ), 
.DC_VAL ( DC_VAL ), 
.LACK ( LACK ), 
.X_HALT_R ( X_HALT_R ), 
.DC_MISS_P ( DC_MISS_P ), 
.DC_MISS_R ( DC_MISS_R ), 
.DC_BAREMISS_R ( DC_BAREMISS_R ), 
.DC_HALT_W_R ( DC_HALT_W_R ), 
.DC_HALT_M_R ( DC_HALT_M_R ), 
.DC_CSTWBUS ( DC_CSTWBUS ), 
.DC_RPQUIETIFNBA( DC_RPQUIETIFNBA), 
.DC_RPQUIETIFB ( DC_RPQUIETIFB ), 
.DC_RPALGNIFNBNA( DC_RPALGNIFNBNA), 
.DC_RPALGNIFB ( DC_RPALGNIFB ), 

.DC_TAGINDEX ( DC_TAGINDEX ), 
.DCR_TAGRD ( DCR_TAGRD ), 
.DC_TAGWR ( DC_TAGWR ), 
.DC_TAGWE ( DC_TAGWE ), 
.DC_TAGWEN ( DC_TAGWEN ), 
.DC_TAGRE ( DC_TAGRE ), 
.DC_TAGREN ( DC_TAGREN ), 
.DC_TAGCS ( DC_TAGCS ), 
.DC_TAGCSN ( DC_TAGCSN ), 
.DCC_TAGMASK ( DCC_TAGMASK ), 
.DC_DATAINDEX ( DC_DATAINDEX ), 
.DCR_DATARD ( DCR_DATARD ), 
.DC_DATAWR ( DC_DATAWR ), 
.DC_DATAWE ( DC_DATAWE ), 
.DC_DATAWEN ( DC_DATAWEN ), 
.DC_DATARE ( DC_DATARE ), 
.DC_DATAREN ( DC_DATAREN ), 
.DC_DATACS ( DC_DATACS ), 
.DC_DATACSN ( DC_DATACSN ), 

.DC_USEPROCIN ( USEPROCIN ) 
); 

wire DATAOD = |({ LACK, X_HALT_R[`DW_HALT_W_INDEX], X_HALT_R[`DT_HALT_W_INDEX] }) & ~DC_HALT_W_R[0] & ~DC_HALT_M_R[0]; 



mux32 MUX_DATAC_UP 
( 
.OUT ( DC_DATAUPO ), 
.THRU ( DATAUPI ), 
.IN ( DATAOUT ), 
.EN1 ( DATAOE ), 
.DIS1 ( DATAOD ), 
.DIS2 ( SEN ) 
); 

mux32 MUX_DATAC_DOWN 
( 
.OUT ( DC_DATADOWNO ), 
.THRU ( DATADOWNI ), 
.IN ( DATAOUT ), 
.EN1 ( DATAOE ), 
.DIS1 ( DATAOD ), 
.DIS2 ( SEN ) 
); 

assign DATAIN = USEPROCIN ? DATADOWNI : DATAUPI; 






endmodule 






