



















































































module ejtag 




















( 

EJDI_DATA, EJDI_ADDR, EJDI_SELIBS, EJDI_SELIBRS, EJDI_SELDBS, 
EJDI_SELDBRS, EJDI_RW, EJ_STROBE, EJC_DCRMINT_R, EJC_DCRTM_R, 
EJC_DINT_R, EJC_ECRPCAS_R, EJC_ECRPROBEEN_R, EJC_PCTRON_R, 
EJC_ECRPRRST_R, JTAG_ESCANOUT, EJT_DCLK, EJT_DREN_R, EJPM_BREAKHIT_R, 
EJPM_TRACEHIT_R, EJ_LBCUMBILICAL, 

RESET_DIS, SEN, CORE_CLOCK, CORE_DOZE, CORE_HALT, CORE_RUN, 
JPT_DBM2PCSTSET_P, EJDM_DATA, EJIM_DATA, CFG_EJTNMINUS1, 
CFG_EJTMLOG2, CFG_EJTBIT0M16, JTAG_CLOCK, JTAG_CAPTURE, JTAG_ESCANIN, 
JTAG_IR, JTAG_RUNTEST, JTAG_SHIFT, JTAG_UPDATE, JTAG_DINT, 
RESET_D1_JR_N, RESET_D1_R_N, RESET_PWRON_N, EJ_DIS, TMODE, 
LBC_EJUMBILICAL 
); 


`include "../rtl/RISC/include/lxr_symbols.vh" 











input RESET_DIS; 
input SEN; 

input CORE_CLOCK; 
input CORE_DOZE; 
input CORE_HALT; 
input CORE_RUN; 
input JPT_DBM2PCSTSET_P; 

input [31:0] EJDM_DATA; 
input [31:0] EJIM_DATA; 
input [1:0] CFG_EJTNMINUS1; 
input [1:0] CFG_EJTMLOG2; 
input CFG_EJTBIT0M16; 

input JTAG_CLOCK; 
input JTAG_CAPTURE; 
input JTAG_ESCANIN; 
input [4:0] JTAG_IR; 
input JTAG_RUNTEST; 
input JTAG_SHIFT; 
input JTAG_UPDATE; 
input JTAG_DINT; 

input RESET_D1_JR_N; 
input RESET_D1_R_N; 
input RESET_PWRON_N; 
input EJ_DIS; 
input TMODE; 

output [31:0] EJDI_DATA; 
output [7:2] EJDI_ADDR; 
output EJDI_SELIBS; 
output EJDI_SELIBRS; 
output EJDI_SELDBS; 
output EJDI_SELDBRS; 
output EJDI_RW; 
output EJ_STROBE; 

output EJC_DCRMINT_R; 
output EJC_DCRTM_R; 
output EJC_DINT_R; 
output EJC_ECRPCAS_R; 
output EJC_ECRPROBEEN_R; 




output EJC_PCTRON_R; 

output EJC_ECRPRRST_R; 


output JTAG_ESCANOUT; 
output EJT_DCLK; 
output EJT_DREN_R; 
output EJPM_BREAKHIT_R; 
output EJPM_TRACEHIT_R; 


output [`EJ_LBCUMBILICAL_WIDTH-1:0] EJ_LBCUMBILICAL; 
input [`LBC_EJUMBILICAL_WIDTH-1:0] LBC_EJUMBILICAL; 





wire [31:0] EJC_CTL; 
wire [31:0] EJC_DEBUGCTL; 
wire EJC_DMAACC; 
wire EJC_DMAINC; 
wire [31:0] EJDD_ADDR; 
wire [31:0] EJDD_CAPDATA; 
wire [31:0] EJDD_DATA; 
wire EJDI_SELDBG; 
wire EJDI_SELDCR; 
wire EJDI_SELPBRS; 
wire EJDI_SELPBS; 
wire EJDI_SELPROBE; 
wire [31:0] EJPM_DATA; 
wire [31:0] EJSN_ADDR; 
wire [31:0] EJSN_CTL; 
wire [31:0] EJSN_DATA; 
wire EJSN_PCTRACEON; 
wire EJSN_UPDATEADDR; 
wire EJSN_UPDATECTL; 
wire EJSN_UPDATEDATA; 



wire JTAG_CLRIR; 




wire [31:0] LBC_MADDR = LBC_EJUMBILICAL [(32*1)-1:32*(1-1)]; 
wire [31:0] LBC_MDATA = LBC_EJUMBILICAL [(32*2)-1:32*(2-1)]; 
wire [31:0] LBC_EJDATA = LBC_EJUMBILICAL [(32*3)-1:32*(3-1)]; 
wire LBC_MRW = LBC_EJUMBILICAL [(32*3)+0]; 
wire LBC_MEJDEST = LBC_EJUMBILICAL [(32*3)+1]; 
wire LBC_EVAL = LBC_EJUMBILICAL [(32*3)+2]; 
wire LBC_MTOGGLE = LBC_EJUMBILICAL [(32*3)+3]; 

wire LBC_MID = LBC_EJUMBILICAL [(32*3)+4]; 
wire LBC_MUC = LBC_EJUMBILICAL [(32*3)+5]; 













wire NC_FOO = SEN; 




wire [31:0] EJ_SLAVEDATA; 
wire EJ_DMARW; 
wire [1:0] EJ_DMASZ; 
wire EJ_DMAREQ; 
assign EJ_LBCUMBILICAL [(32*1)-1:32*(1-1)] = EJDD_ADDR [31:0]; 
assign EJ_LBCUMBILICAL [(32*2)-1:32*(2-1)] = EJDD_DATA [31:0]; 
assign EJ_LBCUMBILICAL [(32*3)-1:32*(3-1)] = EJ_SLAVEDATA [31:0]; 
assign EJ_LBCUMBILICAL [(32*3)+0] = EJ_DMAREQ; 
assign EJ_LBCUMBILICAL [(32*3)+1] = EJ_DMARW; 
assign EJ_LBCUMBILICAL [(32*3)+3:(32*3)+2] = EJ_DMASZ; 
assign EJ_LBCUMBILICAL [(32*3)+4] = EJ_STROBE; 











ejtag_datain datain 
( 

.EJDI_ADDR (EJDI_ADDR[7:2]), 
.EJDI_DATA (EJDI_DATA[31:0]), 
.EJDI_RW (EJDI_RW), 
.EJDI_SELDCR (EJDI_SELDCR), 
.EJDI_SELIBS (EJDI_SELIBS), 
.EJDI_SELDBS (EJDI_SELDBS), 
.EJDI_SELPBS (EJDI_SELPBS), 
.EJDI_SELIBRS (EJDI_SELIBRS), 
.EJDI_SELDBRS (EJDI_SELDBRS), 
.EJDI_SELPBRS (EJDI_SELPBRS), 
.EJDI_SELDBG (EJDI_SELDBG), 
.EJDI_SELPROBE (EJDI_SELPROBE), 

.LBC_MDATA (LBC_MDATA[31:0]), 
.LBC_MADDR (LBC_MADDR[31:0]), 
.LBC_MEJDEST (LBC_MEJDEST), 
.LBC_MRW (LBC_MRW)); 






ejtag_dataout dataout 
( 

.EJDO_DATA (EJ_SLAVEDATA[31:0]), 

.EJSN_DATA (EJSN_DATA[31:0]), 
.EJPM_DATA (EJPM_DATA[31:0]), 
.EJDM_DATA (EJDM_DATA[31:0]), 
.EJIM_DATA (EJIM_DATA[31:0]), 
.EJC_DEBUGCTL (EJC_DEBUGCTL[31:0]), 
.EJDI_SELDCR (EJDI_SELDCR), 
.EJDI_SELIBS (EJDI_SELIBS), 
.EJDI_SELDBS (EJDI_SELDBS), 
.EJDI_SELPBS (EJDI_SELPBS), 
.EJDI_SELIBRS (EJDI_SELIBRS), 
.EJDI_SELDBRS (EJDI_SELDBRS), 
.EJDI_SELPBRS (EJDI_SELPBRS), 
.EJDI_SELPROBE (EJDI_SELPROBE), 
.EJC_DMAACC (EJC_DMAACC), 
.RESET_DIS (RESET_DIS), 
.CORE_CLOCK (CORE_CLOCK), 
.RESET_D1_R_N (RESET_D1_R_N)); 








ejtag_dmadata dmadata 
( 

.EJDD_DATA (EJDD_DATA[31:0]), 
.EJDD_ADDR (EJDD_ADDR[31:0]), 
.EJDD_CAPDATA (EJDD_CAPDATA[31:0]), 

.EJSN_DATA (EJSN_DATA[31:0]), 
.EJSN_ADDR (EJSN_ADDR[31:0]), 
.EJSN_UPDATEDATA (EJSN_UPDATEDATA), 
.EJSN_UPDATEADDR (EJSN_UPDATEADDR), 
.EJSN_UPDATECTL (EJSN_UPDATECTL), 
.EJC_DMAACC (EJC_DMAACC), 
.EJC_DMAINC (EJC_DMAINC), 
.JTAG_CLOCK (JTAG_CLOCK), 
.RESET_D1_JR_N (RESET_D1_JR_N), 
.CORE_CLOCK (CORE_CLOCK), 
.RESET_D1_R_N (RESET_D1_R_N), 
.TMODE (TMODE), 
.LBC_EJDATA (LBC_EJDATA[31:0]), 
.LBC_EVAL (LBC_EVAL)); 









ejtag_control control 
( 

.EJC_CTL (EJC_CTL[31:0]), 
.EJC_DEBUGCTL (EJC_DEBUGCTL[31:0]), 
.EJC_DMASTART (EJ_DMAREQ), 
.EJC_DMAREAD (EJ_DMARW), 
.EJC_DMASIZE (EJ_DMASZ[1:0]), 
.EJC_DMAINC (EJC_DMAINC), 
.EJC_DMAACC (EJC_DMAACC), 
.EJC_DINT_R (EJC_DINT_R), 
.EJC_ECRPROBEEN_R (EJC_ECRPROBEEN_R), 
.EJC_ECRPRRST_R (EJC_ECRPRRST_R), 
.EJC_ECRPCAS_R (EJC_ECRPCAS_R), 
.EJC_STROBE (EJ_STROBE), 
.EJC_DCRTM_R (EJC_DCRTM_R), 
.EJC_DCRMINT_R (EJC_DCRMINT_R), 
.EJC_PCTRON_R (EJC_PCTRON_R), 
.JTAG_CLRIR (JTAG_CLRIR), 

.EJSN_CTL (EJSN_CTL[31:0]), 
.EJSN_UPDATECTL (EJSN_UPDATECTL), 
.LBC_MDATA (LBC_MDATA[31:0]), 
.EJDI_SELDCR (EJDI_SELDCR), 
.EJDI_SELDBG (EJDI_SELDBG), 
.LBC_MRW (LBC_MRW), 
.LBC_MTOGGLE (LBC_MTOGGLE), 
.LBC_EVAL (LBC_EVAL), 
.CORE_RUN (CORE_RUN), 
.CORE_DOZE (CORE_DOZE), 
.CORE_HALT (CORE_HALT), 
.EJDI_SELPROBE (EJDI_SELPROBE), 
.EJSN_PCTRACEON (EJSN_PCTRACEON), 
.JTAG_DINT (JTAG_DINT), 
.EJ_DIS (EJ_DIS), 
.JTAG_CLOCK (JTAG_CLOCK), 
.CORE_CLOCK (CORE_CLOCK), 
.JPT_DBM2PCSTSET_P (JPT_DBM2PCSTSET_P), 
.RESET_D1_JR_N (RESET_D1_JR_N), 
.RESET_D1_R_N (RESET_D1_R_N), 
.RESET_PWRON_N (RESET_PWRON_N), 
.TMODE (TMODE)); 







ejtag_scan scan 
( 

.JTAG_ESCANOUT (JTAG_ESCANOUT), 
.EJSN_DATA (EJSN_DATA[31:0]), 
.EJSN_ADDR (EJSN_ADDR[31:0]), 
.EJSN_CTL (EJSN_CTL[31:0]), 
.EJSN_UPDATEDATA (EJSN_UPDATEDATA), 
.EJSN_UPDATEADDR (EJSN_UPDATEADDR), 
.EJSN_UPDATECTL (EJSN_UPDATECTL), 
.EJSN_PCTRACEON (EJSN_PCTRACEON), 

.JTAG_IR (JTAG_IR[4:0]), 
.JTAG_ESCANIN (JTAG_ESCANIN), 
.JTAG_CAPTURE (JTAG_CAPTURE), 
.JTAG_UPDATE (JTAG_UPDATE), 
.JTAG_SHIFT (JTAG_SHIFT), 
.JTAG_RUNTEST (JTAG_RUNTEST), 
.LBC_MDATA (LBC_MDATA[31:0]), 
.LBC_MADDR (LBC_MADDR[31:0]), 
.EJDD_CAPDATA (EJDD_CAPDATA[31:0]), 
.EJDD_ADDR (EJDD_ADDR[31:0]), 
.EJC_CTL (EJC_CTL[31:0]), 
.EJ_DIS (EJ_DIS), 
.CFG_EJTNMINUS1 (CFG_EJTNMINUS1[1:0]), 
.CFG_EJTMLOG2 (CFG_EJTMLOG2[1:0]), 
.CFG_EJTBIT0M16 (CFG_EJTBIT0M16), 
.JTAG_CLOCK (JTAG_CLOCK), 
.RESET_D1_JR_N (RESET_D1_JR_N), 
.TMODE (TMODE)); 



wire CORE_CLOCK_N = ~CORE_CLOCK; 
wire CORE_CLOCKDELAYED = CORE_CLOCK; 



ejtag_dclk dclk 
( 

.EJT_DREN_R (EJT_DREN_R), 
.EJT_DCLK (EJT_DCLK), 

.CLK (CORE_CLOCK), 

.CLK_N (CORE_CLOCK_N), 

.CLKDELAYED (CORE_CLOCKDELAYED), 
.RESET_D1_R_N (RESET_D1_R_N), 
.RESET_DIS (RESET_DIS), 
.CFG_EJTNMINUS1 (CFG_EJTNMINUS1[1:0])); 


ejtag_pmatch pmatch 
( 

.EJPM_DATA (EJPM_DATA[31:0]), 
.EJPM_TRACEHIT_R (EJPM_TRACEHIT_R), 
.EJPM_BREAKHIT_R (EJPM_BREAKHIT_R), 

.EJDI_SELPBS (EJDI_SELPBS), 
.EJDI_SELPBRS (EJDI_SELPBRS), 
.LBC_MADDR (LBC_MADDR[31:0]), 
.LBC_MDATA (LBC_MDATA[31:0]), 
.LBC_MRW (LBC_MRW), 
.LBC_MUC (LBC_MUC), 
.LBC_MID (LBC_MID), 
.LBC_MTOGGLE (LBC_MTOGGLE), 
.EJ_STROBE (EJ_STROBE), 
.CORE_CLOCK (CORE_CLOCK), 
.RESET_D1_R_N (RESET_D1_R_N), 
.RESET_DIS (RESET_DIS)); 


endmodule 

