



















































































`include "../rtl/RISC/include/lxr_symbols.vh" 
`include "../rtl/RISC/include/core_symbols.vh" 

module core 






















( 

SYSCLK, RESET1N, 

CP0_INSTM32_S_R_N, 

SEN, TMODE, 
CFG_INSTM16EN, 


CFG_EJTMLOG2, 
CFG_EJTBIT0M16, 
EJT_DREN_R, 
EJC_DINT_R, 
EJIM_BREAKHIT_S, 
EJIM_TRACEHIT_S, 
EJDM_BREAKHIT_W, 
EJDM_TRACEHIT_W, 
EJPM_BREAKHIT_R, 
EJPM_TRACEHIT_R, 
EJC_ECRPROBEEN_R, 
EJC_DCRMINT_R, 
EJC_ECRPCAS_R, 
EJC_DCRTM_R, 
EJC_PCTRON_R, 

JPT_PCST_DR, 
JPT_TPC_DR, 
JPT_DBM2PCSTSET_P, 
CP0_JCTRLJRST_R, 
CP0_JCTRLDM_I_R, 
CP0_IEJORDM_I, 
CP0_JCTRLDM_M_R, 
CP0_DBRKSETIFDMBH, 
CP0_DBREAKCLR, 
CP0_JXCPN1STIFDMBH_M_P, 
CP0_JXCPN1STIFNOTDMBH_M_P, 
CP0_DDBXIFDMBH_M_P, 
CP0_DDBXUNCOND_M_P, 
CP0_DIBIFNOTDMBH_M_P, 

INTREQN, CE0HOLD, CE1HOLD, HLREGHOLD, 

CE0_RES_E, CE0_SEL_E_R, 
CE1_RES_E, CE1_SEL_E_R, 
CEI_CE1OP_S_R, 
CEI_CE0OP_S_R, 
CEI_INSTM32_S_R_N, 
CEI_CE0AOP_E_R, CEI_CE0BOP_E_R, 
CEI_CE1AOP_E_R, CEI_CE1BOP_E_R, 
CEI_CEHLW_AOP_E_R, 
RALU_CE0OP_S_R, RALU_INSTM32_S_R_N, 

CP0_XCPN_M, 
CEI_XCPN_M_C0, 
CEI_XCPN_M_C1, 

CP0_IADDR_I_P, CP0_INULL_I, INST_I, 

IVALC, IVALW, IVALR, 
IMISSC, IMISSW, IMISSR, 

DVALC, DVALW, DVALR, 
DMISSC, DMISSW, DMISSR, 

RALU_DADDR_E, 

RALU_DREAD_E_R, RALU_DSIGN_E_R, RALU_DWRITE_E_R, 

X_HALT_R, 

JPT_HALT_M_R, 

RALU_HALT_E_R, 


DBUSMUPIN, RALU_ADATAREG_M_R, 


RALU_DBYEN_E, RALU_DWORD_E, 

CI1_COND, CI2_COND, CI3_COND, 

CP0_SLEEP_M_R, CP0_IM_W_R, 

CP0_CCNTL_W_R 

); 


input SYSCLK; 
input RESET1N; 



input TMODE; 
input SEN; 



input CFG_INSTM16EN; 


input [31:0] CE0_RES_E; 
input CE0_SEL_E_R; 
input [31:0] CE1_RES_E; 
input CE1_SEL_E_R; 
output [11:0] CEI_CE1OP_S_R; 
output [11:0] CEI_CE0OP_S_R; 
output CEI_INSTM32_S_R_N; 
output [11:0] RALU_CE0OP_S_R; 
output RALU_INSTM32_S_R_N; 

output [31:0] CEI_CE0AOP_E_R; 
output [31:0] CEI_CE0BOP_E_R; 
output [31:0] CEI_CE1AOP_E_R; 
output [31:0] CEI_CE1BOP_E_R; 
output [31:0] CEI_CEHLW_AOP_E_R; 

output HLREGHOLD; 
output CE0HOLD; 
output CE1HOLD; 


output CP0_INULL_I; 
output [31:0] CP0_IADDR_I_P; 
input [31:0] INST_I; 


output [31:0] RALU_DADDR_E; 
output RALU_DREAD_E_R; 
output RALU_DSIGN_E_R; 
output RALU_DWRITE_E_R; 

output [3:0] RALU_DBYEN_E; 
output RALU_DWORD_E; 


input [31:0] DBUSMUPIN; 
output [31:0] RALU_ADATAREG_M_R; 



input [5:0] INTREQN; 
input CI1_COND; 
input CI2_COND; 
input CI3_COND; 

output CP0_XCPN_M; 
output CEI_XCPN_M_C0; 
output CEI_XCPN_M_C1; 

output CP0_INSTM32_S_R_N; 

output CP0_SLEEP_M_R; 
output [7:0] CP0_IM_W_R; 

output [7:0] CP0_CCNTL_W_R; 

output [`HALT_DRV_RANGE] RALU_HALT_E_R; 










input [`HALT_SIG_RANGE] X_HALT_R; 

output [`HALT_DRV_RANGE] JPT_HALT_M_R; 

input IVALC; 
input IVALW; 
input IVALR; 
input IMISSC; 
input IMISSW; 
input IMISSR; 
input DVALC; 
input DVALW; 
input DVALR; 
input DMISSC; 
input DMISSW; 
input DMISSR; 

input [1:0] CFG_EJTMLOG2; 
input CFG_EJTBIT0M16; 
input EJT_DREN_R; 
input EJC_DINT_R; 
input EJIM_BREAKHIT_S; 
input EJIM_TRACEHIT_S; 
input EJDM_BREAKHIT_W; 
input EJDM_TRACEHIT_W; 
input EJPM_BREAKHIT_R; 
input EJPM_TRACEHIT_R; 
input EJC_ECRPROBEEN_R; 
input EJC_DCRMINT_R; 
input EJC_ECRPCAS_R; 
input EJC_DCRTM_R; 
input EJC_PCTRON_R; 

output [11:0] JPT_PCST_DR; 
output [8:1] JPT_TPC_DR; 
output JPT_DBM2PCSTSET_P; 
output CP0_JCTRLJRST_R; 
output CP0_JCTRLDM_I_R; 
output CP0_JCTRLDM_M_R; 
output CP0_IEJORDM_I; 
output CP0_DBRKSETIFDMBH; 
output CP0_DBREAKCLR; 
output CP0_JXCPN1STIFDMBH_M_P; 
output CP0_JXCPN1STIFNOTDMBH_M_P; 
output CP0_DDBXIFDMBH_M_P; 
output CP0_DDBXUNCOND_M_P; 
output CP0_DIBIFNOTDMBH_M_P; 

wire CLMI_JPTHOLD; 

wire CLMI_RHOLD; 
wire RLSHOLD; 





wire RALU_RDBDRIVER_R; 
wire CP0_CDBUSOE_R; 



wire [31:0] CP0_IADDR_I_P; 
wire CP0_M16IADDRB1_I; 

wire RALU_V_E; 
wire RALU_Z_E; 

wire [31:0] CP0_LINK_E_R; 
wire [31:0] CP0_PCREL_S; 
wire RALU_DADALERR_E; 

wire [31:0] RALU_ADATAREG_M_R; 

wire [31:0] RALU_CINA_E_R; 
wire [31:0] RALU_CINBI_E_R; 

wire [11:0] RALU_CE1OP_S_R; 
wire [11:0] RALU_CE0OP_S_R; 
wire RALU_INSTM32_S_R_N; 

wire [31:0] CP0_CDBUS_M_R; 

wire RALU_DREAD_E_R_C; 
wire RALU_DWRITE_E_R_C; 

wire [31:0] RALU_JRA_E_R; 

wire CLMI_DBUSDIS; 

wire [`CLMI_SEL_INST_HI:0] CLMI_SELINST_S_P; 
wire Dload; 
wire CP0_INSTM32_S_R_C1_N; 
wire CP0_INSTM32_I_R_C1_N; 

wire CP0_XCPN_M_C1; 


wire NC_FOO2 = CP0_INSTM32_S_R_C1_N; 




wire NC_FOO1 = RALU_RDBDRIVER_R; 




cop0 COP01 
( 

.SYSCLK (SYSCLK), 
.RESET1N (RESET1N), 
.TMODE (TMODE), 
.SEN (SEN), 
.CFG_INSTM16EN (CFG_INSTM16EN), 


.CFG_EJTMLOG2 (CFG_EJTMLOG2), 
.CFG_EJTBIT0M16 (CFG_EJTBIT0M16), 
.EJT_DREN_R (EJT_DREN_R), 
.EJC_DINT_R (EJC_DINT_R), 
.EJIM_BREAKHIT_S (EJIM_BREAKHIT_S), 
.EJIM_TRACEHIT_S (EJIM_TRACEHIT_S), 
.EJDM_BREAKHIT_W (EJDM_BREAKHIT_W), 
.EJDM_TRACEHIT_W (EJDM_TRACEHIT_W), 
.EJPM_BREAKHIT_R (EJPM_BREAKHIT_R), 
.EJPM_TRACEHIT_R (EJPM_TRACEHIT_R), 
.EJC_ECRPROBEEN_R (EJC_ECRPROBEEN_R), 
.EJC_DCRMINT_R (EJC_DCRMINT_R), 
.EJC_ECRPCAS_R (EJC_ECRPCAS_R), 
.EJC_DCRTM_R (EJC_DCRTM_R), 
.EJC_PCTRON_R (EJC_PCTRON_R), 
.CLMI_JPTHOLD (CLMI_JPTHOLD), 

.JPT_PCST_DR (JPT_PCST_DR), 
.JPT_TPC_DR (JPT_TPC_DR), 
.JPT_HALT_M_R (JPT_HALT_M_R), 
.JPT_DBM2PCSTSET_P (JPT_DBM2PCSTSET_P), 
.CP0_JCTRLJRST_R (CP0_JCTRLJRST_R), 
.CP0_JCTRLDM_I_R (CP0_JCTRLDM_I_R), 
.CP0_IEJORDM_I (CP0_IEJORDM_I), 
.CP0_JCTRLDM_M_R (CP0_JCTRLDM_M_R), 
.CP0_JXCPN1STIFDMBH_M_P (CP0_JXCPN1STIFDMBH_M_P), 
.CP0_JXCPN1STIFNOTDMBH_M_P (CP0_JXCPN1STIFNOTDMBH_M_P), 
.CP0_DIBIFNOTDMBH_M_P (CP0_DIBIFNOTDMBH_M_P), 
.CP0_DBREAKCLR (CP0_DBREAKCLR), 
.CP0_DBRKSETIFDMBH (CP0_DBRKSETIFDMBH), 
.CP0_DDBXIFDMBH_M_P (CP0_DDBXIFDMBH_M_P), 
.CP0_DDBXUNCOND_M_P (CP0_DDBXUNCOND_M_P), 

.CP0_INSTM32_S_R_N (CP0_INSTM32_S_R_N), 
.CP0_INSTM32_S_R_C1_N (CP0_INSTM32_S_R_C1_N), 
.CP0_INSTM32_I_R_C1_N (CP0_INSTM32_I_R_C1_N), 
.CP0_M16IADDRB1_I (CP0_M16IADDRB1_I), 

.CP0_XCPN_M_C0 (CP0_XCPN_M), 
.CP0_XCPN_M_C1 (CP0_XCPN_M_C1), 
.CEI_XCPN_M_C0 (CEI_XCPN_M_C0), 
.CEI_XCPN_M_C1 (CEI_XCPN_M_C1), 

.INST_I (INST_I), 
.CP0_INULL_I (CP0_INULL_I), 
.CP0_IADDR_I_P (CP0_IADDR_I_P), 
.RALU_JRA_E_R (RALU_JRA_E_R), 
.INTREQN (INTREQN), 
.RALU_V_E (RALU_V_E), 
.RALU_Z_E (RALU_Z_E), 
.CI1_COND (CI1_COND), 
.CI2_COND (CI2_COND), 
.CI3_COND (CI3_COND), 
.CE0_SEL_E_R (CE0_SEL_E_R), 
.CE1_SEL_E_R (CE1_SEL_E_R), 
.CP0_LINK_E_R (CP0_LINK_E_R), 
.CP0_PCREL_S (CP0_PCREL_S), 
.RALU_DADDR_E (RALU_DADDR_E), 
.RALU_DADALERR_E(RALU_DADALERR_E), 
.RALU_DREAD_E_R (RALU_DREAD_E_R_C), 
.RALU_DWRITE_E_R(RALU_DWRITE_E_R_C), 
.CP0_CCNTL_W_R (CP0_CCNTL_W_R), 
.CP0_CDBUS_M_R (CP0_CDBUS_M_R), 
.CP0_CDBUSOE_R (CP0_CDBUSOE_R), 
.RALU_ADATAREG_M_R (RALU_ADATAREG_M_R), 
.CLMI_SELINST_S_P (CLMI_SELINST_S_P), 
.CLMI_RHOLD (CLMI_RHOLD), 
.CP0_SLEEP_M_R (CP0_SLEEP_M_R), 
.CP0_IM_W_R (CP0_IM_W_R) 
); 




ralu RALU1 
( 



.SYSCLK (SYSCLK), 
.RESET1_N (RESET1N), 
.CP0_INSTM32_I_R_C1_N (CP0_INSTM32_I_R_C1_N), 
.CP0_M16IADDRB1_I (CP0_M16IADDRB1_I), 
.CP0_XCPN_M_C1 (CP0_XCPN_M_C1), 
.CLMI_RHOLD (CLMI_RHOLD), 
.DLOAD (Dload), 
.RLSHOLD (RLSHOLD), 
.INST_I (INST_I), 

.DBUSMUPIN (DBUSMUPIN), 
.CP0_CDBUS_M_R (CP0_CDBUS_M_R), 
.CP0_CDBUSOE_R (CP0_CDBUSOE_R), 
.CLMI_DBUSDIS (CLMI_DBUSDIS), 

.CE0_RES_E (CE0_RES_E), 
.CE0_SEL_E_R (CE0_SEL_E_R), 
.CE1_RES_E (CE1_RES_E), 
.CE1_SEL_E_R (CE1_SEL_E_R), 
.CP0_LINK_E_R (CP0_LINK_E_R), 
.CP0_PCREL_S (CP0_PCREL_S), 
.CLMI_SELINST_S_P (CLMI_SELINST_S_P), 


.RALU_DADDR_E (RALU_DADDR_E), 
.RALU_DREAD_E_R_C (RALU_DREAD_E_R_C), 
.RALU_DWRITE_E_R_C (RALU_DWRITE_E_R_C), 
.RALU_DREAD_E_R (RALU_DREAD_E_R), 
.RALU_DSIGN_E_R (RALU_DSIGN_E_R), 
.RALU_DWRITE_E_R (RALU_DWRITE_E_R), 
.RALU_DBYEN_E (RALU_DBYEN_E), 
.RALU_DWORD_E (RALU_DWORD_E), 
.RALU_DADALERR_E (RALU_DADALERR_E), 

.RALU_ADATAREG_M_R (RALU_ADATAREG_M_R), 
.RALU_RDBDRIVER_R (RALU_RDBDRIVER_R), 
.RALU_V_E (RALU_V_E), 
.RALU_Z_E (RALU_Z_E), 

.RALU_JRA_E_R (RALU_JRA_E_R), 
.RALU_CINA_E_R (RALU_CINA_E_R), 
.RALU_CINBI_E_R (RALU_CINBI_E_R), 

.RALU_HALT_E_R (RALU_HALT_E_R), 


.RALU_CE1OP_S_R (RALU_CE1OP_S_R), 
.RALU_CE0OP_S_R (RALU_CE0OP_S_R), 
.RALU_INSTM32_S_R_N (RALU_INSTM32_S_R_N), 


.TMODE (TMODE), 
.SEN (SEN) 
); 


ce_buf CE_BUF1 
( 


.RALU_CINA_E_R (RALU_CINA_E_R), 
.RALU_CINBI_E_R (RALU_CINBI_E_R), 

.CEI_CE0AOP_E_R (CEI_CE0AOP_E_R), 
.CEI_CE0BOP_E_R (CEI_CE0BOP_E_R), 

.CEI_CE1AOP_E_R (CEI_CE1AOP_E_R), 
.CEI_CE1BOP_E_R (CEI_CE1BOP_E_R), 

.CEI_CEHLW_AOP_E_R (CEI_CEHLW_AOP_E_R), 

.RALU_CE1OP_S_R (RALU_CE1OP_S_R), 
.RALU_CE0OP_S_R (RALU_CE0OP_S_R), 
.RALU_INSTM32_S_R_N (RALU_INSTM32_S_R_N), 

.CEI_CE1OP_S_R (CEI_CE1OP_S_R), 
.CEI_CE0OP_S_R (CEI_CE0OP_S_R), 
.CEI_INSTM32_S_R_N (CEI_INSTM32_S_R_N) 
); 

core_lmi lmi 
( 
.SYSCLK (SYSCLK ), 
.TMODE (TMODE ), 
.SEN (SEN ), 
.RESET_D1_R_N (RESET1N ), 
.ISTALLIF (CP0_INULL_I ), 
.X_HALT_R (X_HALT_R ), 
.CLMI_JPTHOLD (CLMI_JPTHOLD), 
.CLMI_HLREGHOLD (HLREGHOLD ), 
.CLMI_CE0HOLD (CE0HOLD ), 
.CLMI_CE1HOLD (CE1HOLD ), 
.CLMI_RHOLD (CLMI_RHOLD ), 
.CLMI_RLSHOLD (RLSHOLD ), 
.CLMI_DLOAD (Dload ), 
.IC_VAL_S (IVALC ), 
.IW_VAL_S (IVALW ), 
.IR_VAL_S (IVALR ), 
.IC_MISS_S_R (IMISSC ), 
.IW_MISS_S_R (IMISSW ), 
.IR_MISS_S_R (IMISSR ), 
.DC_VAL_W (DVALC ), 
.DW_VAL_W (DVALW ), 
.DR_VAL_W (DVALR ), 
.DC_MISS_W_R (DMISSC ), 
.DW_MISS_W_R (DMISSW ), 
.DR_MISS_W_R (DMISSR ), 
.CLMI_DBUSDIS (CLMI_DBUSDIS ), 
.CLMI_SEL_INSTSF_P (CLMI_SELINST_S_P) 
); 



endmodule 



