
`define del 1
`include "../rtl/DSP/include/x_def.v"

module DLPN (/* IN  */ L, 
             /* OUT */ PB, Pa);
             
input  [13:0] L;
output [13:0] PB, Pa;

reg [13:0] Lp, Ln;
reg Sb;

always @( L )
begin
   casex( L )
   14'b1????????????? : Lp[13:0] = 14'b11111111111111;
   14'b01???????????? : Lp[13:0] = 14'b01111111111111;
   14'b001??????????? : Lp[13:0] = 14'b00111111111111;
   14'b0001?????????? : Lp[13:0] = 14'b00011111111111;
   14'b00001????????? : Lp[13:0] = 14'b00001111111111;
   14'b000001???????? : Lp[13:0] = 14'b00000111111111;
   14'b0000001??????? : Lp[13:0] = 14'b00000011111111;
   14'b00000001?????? : Lp[13:0] = 14'b00000001111111;
   14'b000000001????? : Lp[13:0] = 14'b00000000111111;
   14'b0000000001???? : Lp[13:0] = 14'b00000000011111;
   14'b00000000001??? : Lp[13:0] = 14'b00000000001111;
   14'b000000000001?? : Lp[13:0] = 14'b00000000000111;
   14'b0000000000001? : Lp[13:0] = 14'b00000000000011;
   14'b00000000000001 : Lp[13:0] = 14'b00000000000001;
   14'b00000000000000 : Lp[13:0] = 14'b00000000000000;
   endcase
end

always @( L )
begin
   casex( L )
   14'b?????????????1 : Ln[13:0] = 14'b11111111111111;
   14'b????????????10 : Ln[13:0] = 14'b11111111111110;
   14'b???????????100 : Ln[13:0] = 14'b11111111111100;
   14'b??????????1000 : Ln[13:0] = 14'b11111111111000;
   14'b?????????10000 : Ln[13:0] = 14'b11111111110000;
   14'b????????100000 : Ln[13:0] = 14'b11111111100000;
   14'b???????1000000 : Ln[13:0] = 14'b11111111000000;
   14'b??????10000000 : Ln[13:0] = 14'b11111110000000;
   14'b?????100000000 : Ln[13:0] = 14'b11111100000000;
   14'b????1000000000 : Ln[13:0] = 14'b11111000000000;
   14'b???10000000000 : Ln[13:0] = 14'b11110000000000;
   14'b??100000000000 : Ln[13:0] = 14'b11100000000000;
   14'b?1000000000000 : Ln[13:0] = 14'b11000000000000;
   14'b10000000000000 : Ln[13:0] = 14'b10000000000000;
   14'b00000000000000 : Ln[13:0] = 14'b00000000000000;
   endcase
end
                   
always @( L )
begin
   case( L )
   14'b00000000000000 : Sb = 0;
   14'b00000000000001 : Sb = 0;
   14'b00000000000010 : Sb = 0;
   14'b00000000000100 : Sb = 0;
   14'b00000000001000 : Sb = 0;
   14'b00000000010000 : Sb = 0;
   14'b00000000100000 : Sb = 0;
   14'b00000001000000 : Sb = 0;
   14'b00000010000000 : Sb = 0;
   14'b00000100000000 : Sb = 0;
   14'b00001000000000 : Sb = 0;
   14'b00010000000000 : Sb = 0;
   14'b00100000000000 : Sb = 0;
   14'b01000000000000 : Sb = 0;
   14'b10000000000000 : Sb = 0;
             default  : Sb = 1;
   endcase
end

//
//
assign #`da PB[13:0] = Sb ? ~Lp[13:0] :  Ln[13:0];
assign #`da Pa[13:0] = Sb ?  Lp[13:0] : ~Ln[13:0];             
                                    
endmodule                                     
